
 /************************************************************************
* FILE:           tunmstr_antdiag_Debounce.h
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    This class will handle source change logic functionalty.
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author							| Modification
* 25/05/2012| ECV4 ( RBEI ) Priya Prabhuswamy  | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
 *************************************************************************/
#ifndef tunmstr_antdiag_Debounce_H
#define tunmstr_antdiag_Debounce_H

#ifndef _TUNMSTR_ANTDIAG_DEFINES_H
#include "tunmstr_antdiag_Defines.h"
#endif
/*--------------------------------*/
/* class tunmstr_antdiag_Debounce definition */
/*--------------------------------*/
class tunmstr_antdiag_Manager;
class tunmstr_DiagLogClientHandler;
class tunmstr_antdiag_i2cHandler;
class tunmstr_MsgFromHMI;
class tunmstr_antdiag_Measure;
class clConfigInterface;
class tunmstr_antdiag_Debounce
{
private:
	tunmstr_antdiag_Manager*     m_potunmstr_antdiag_Manager;
	tunmstr_DiagLogClientHandler*	m_potunmstr_DiagLogClientHandler;
	tunmstr_antdiag_i2cHandler*		m_potunmstr_antdiag_i2cHandler;
	tunmstr_MsgFromHMI*	m_potunmstr_MsgFromHMI;
	tunmstr_antdiag_Measure*		m_potunmstr_antdiag_Measure;
	clConfigInterface* 				m_poclConfigInterface;

	//Counter
	tU8 m_u8ShortCounter[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8 m_u8OpenCounter[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8	m_u8CloseCounter[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8 m_u8OpenToAmpCounter[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	//Antenna Current
	tFloat	m_fAntennacurrent[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8 m_u8ShortWaitOverCounter[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	
	tU8 m_u8AntennaStatus[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	
    //For Current Range
    tU8 m_u8OpenCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
    tU8 m_u8OpenClearCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];

	tU8 m_u8Open2AmpCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8 m_u8Open2AmpClr_LwCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8 m_u8Open2AmpClr_HgCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];

    tU8 m_u8ShortCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
    tU8 m_u8ShortClearCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];

	//No Monitor Cycel
	tU8 m_u8NoOfMon_Cycle[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	//Short Ckt Wait
	tU8 m_u8ShortCkt_Wait[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];

	//OutPutVoltage and WarningCurrent for each antenna to configure the Antenna diag IC register
	tU8 m_u8AntennaOutPutVg[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tU8 m_u8AntennaWarningCur[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];


public:
	tunmstr_antdiag_Debounce();
	virtual ~tunmstr_antdiag_Debounce( );
	
	tVoid vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager );
	tVoid vSet_tunmstr_DiagLogClientHandler_Ptr( tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler );
	tVoid vSet_tunmstr_antdiag_i2cHandler(tunmstr_antdiag_i2cHandler* Ptunmstr_antdiag_i2cHandler);
	tVoid vSet_tunmstr_MsgFromHMI_Ptr(tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI);
	tVoid vSet_tunmstr_antdiag_Measure_Ptr( tunmstr_antdiag_Measure* potunmstr_antdiag_Measure );
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

	tVoid vClearAllAntennaStatus();
	
	tVoid vHandlePrevAntStateOpen2Amp(tU8 u8index,tFloat fCurrent);
	tVoid vHandlePrevAntennaStateShort(tU8 u8index,tFloat fCurrent);
	tVoid vHandlePrevAntennaStateOkorUnk(tU8 u8index,tFloat fCurrent);
	tVoid vHandlePrevAntennaStateOpen(tU8 u8index,tFloat fCurrent);
	
	tVoid vHandleAntennaCurrent(tenAntDiagClients enAntDiagClient,tFloat fCurrent);
	tVoid vHandleNewAntennaState(tenAntDiagClients enAntDiagClient,tFloat fCurrent);
	tVoid vHandleAntennaStateShort(tenAntDiagClients enAntDiagClient);

	tU8 u8GetAntennaStatus(tenAntDiagClients enAntDiagClient)const;
	tU8 u8GetShortCurrent(tU8 u8Client);//
	tU8 u8GetOpenCurrent(tU8 u8Client);
	tU8 u8GetWarningCurrent(tU8 u8Client);
	tU8 u8GetOutputVg(tU8 u8Client);
	tU8 u8GetShortCkt_WaitOverTime(tenAntDiagClients enAntDiagClient);
	tU8 u8GetOpen2AmpCurrent(tenAntDiagClients enAntDiagClient);
	tU8 u8GetShortCktWaitOverCounterValue(tenAntDiagClients enAntDiagClient);
	tU8 u8GetWaringCurrent(tenAntDiagClients enAntDiagClient);
	tFloat fGetAntennaCurrent(tU8 u8Client)const;// current read from ADC/Reg

	tBool IsShortCktTimeOver(tenAntDiagClients enAntDiagClient);
	tBool IsCounterReachMaxLmt(tenAntDiagClients enAntDiagClient);
	
	tVoid vIncrementShortCktWaitOverCounter(tenAntDiagClients enAntDiagClient);
	tVoid vSendPendingAntennaStateRequest(tenAntDiagClients enAntDiagClient,tFloat fCurrent);
	
	tVoid vClearShortWaitOverCounter(tenCMExtPowerSupplyType enCMExtPowerSupplyType);
	tVoid vClearCounter(tenAntDiagClients enAntDiagClient);
	tVoid vClearAntennaState(tenAntDiagClients enAntDiagClient);
	tVoid vClearAllInternalState();
	tVoid vUpdateAntennaParam_FromKDS(tunerVector<tU8> &AntennaPar);
	tVoid vUpdateAntennaStatus(tenAntDiagClients enAntDiagClient,tU8 u8AntennState );
	

};
#endif // tunmstr_antdiag_Debounce_H
