/**************************************************************************//**
* \file     startup_server.cpp
*
*           Helper file to avoid repetition of the defines before the actual
*           FI include.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

// --- include osal which defines OSAL_CONF
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#if (OSAL_CONF == OSAL_WINNT)
// --- use AIL to return a startup interface to serve cca_server product 
// in windows bench cca_server will call this function for instatiation 
// of the application.
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         

/* +++ include here your implemenatation of the ail_tclAppInterface */
#include "fc_tpegMain.h"

// --- create one of the server and return the pointer to its instance
ail_tclAppInterface* createCcaServer() {
  
   ail_tclAppInterface* app = fc_tpeg_tclMain::theServer();

   return app;
}

/* ---
This function calls for the application id defined in
x:\di_frameworks\components\cca\ccaservice.h
to identify the application aganist LPX Simulator (OSAL-Bench SPM implementation)
*/
tU16 u16GetMyAppId() {
   return CCA_C_U16_APP_FC_TPEG;
}


#endif
