/**************************************************************************//**
* \file     clTpeg_TunerControl.cpp
*
*           clTpeg_TunerControl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "interface/clTpeg_TunerControl.h"
#include "interface/clTpeg_Tuner_ImpInterface.h"

static clTpeg_Tuner_ImpInterface* m_poTunerImpl = NULL;
static clTpeg_Tuner_ImpInterface* m_poDABTunerImpl = NULL;
static clTpeg_Tuner_ImpInterface* m_poAMFMTunerImpl = NULL;
static clTpeg_Tuner_ImpInterface* m_poSXMTunerImpl = NULL;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_TunerControl::~clTpeg_TunerControl()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_TunerControl::clTpeg_TunerControl()
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSetTunerImpl(clTpeg_Tuner_ImpInterface* poTunerImpl)
{
   m_poTunerImpl = poTunerImpl;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSetDABTunerImpl(clTpeg_Tuner_ImpInterface* poTunerImpl)
{
   m_poDABTunerImpl = poTunerImpl;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSetAMFMTunerImpl(clTpeg_Tuner_ImpInterface* poTunerImpl)
{
   m_poAMFMTunerImpl = poTunerImpl;
}


/**************************************************************************//**
*
******************************************************************************/

tVoid clTpeg_TunerControl::vSetSXMTunerImpl(clTpeg_Tuner_ImpInterface* poTunerImpl)
{
   m_poSXMTunerImpl = poTunerImpl;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSetRDBIDListToTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   vSendWishListToDabTuner(ListOfRdbIds);
   vSendWishListToAMFMTuner(ListOfRdbIds);
   vSendWishListToSXMTuner(ListOfRdbIds);
   vSetWishList(ListOfRdbIds);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSendWishListToDabTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   if (NULL != m_poDABTunerImpl)
   {
      m_poDABTunerImpl->vSetRDBIDListToTuner(ListOfRdbIds);
   }
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSetWishList(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   if (NULL != m_poTunerImpl)
   {
      m_poTunerImpl->vSetRDBIDListToTuner(ListOfRdbIds);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSendWishListToAMFMTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   if (NULL != m_poAMFMTunerImpl)
   {
      m_poAMFMTunerImpl->vSetRDBIDListToTuner(ListOfRdbIds);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSendWishListToSXMTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   if (NULL != m_poSXMTunerImpl)
   {
      m_poSXMTunerImpl->vSetRDBIDListToTuner(ListOfRdbIds);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TunerControl::vSetTpegChannel(std::string oTpegUriChn, tBool bOnOff)
{
   if (NULL != m_poDABTunerImpl)
   {
      m_poDABTunerImpl->vSetTpegChannel(oTpegUriChn, bOnOff);
   }
}
