/**************************************************************************//**
* \file     fc_tpegMain.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#ifndef fc_tpegMain_h
#define fc_tpegMain_h


#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"


#include <string>
#include <map>
#include <set>



#include "fc_tpeg_trace.h"


#define TPEG_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }
#define TPEG_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }


class ahl_tclBaseOneThreadApp;
class fc_tpeg_tclMain;
class fc_tpeg_tclServiceHdlTmcTuner;
class clTpeg_TMCConfiguration;
class clTpeg_TpegConfiguration;
class clTpeg_CommonCapability;
class clTpeg_Property_RdbIdActualList;
class clTpeg_TunerControl;
class clTpeg_KDSConfiguration;

#ifdef VARIANT_S_FTR_ENABLE_TMC
class fc_tpeg_tclClientHdlAmFmTuner;
class fc_tpeg_tclClientHdlSxmTuner;
#endif 

#ifdef VARIANT_S_FTR_ENABLE_TPEG
class fc_tpeg_tclClientHdlDabTuner;
class fc_tpeg_tclServiceHdlTpeg;
class clTpeg_PreDecoderInterface;
class clTpeg_Uri;
class clTpeg_PersistentData;
#endif


class fc_tpeg_tclMain : public ahl_tclBaseOneThreadApp 
#if (OSAL_OS == OSAL_WINNT)
   , public ail_tclAppInterface
#endif
{
   public:
      static fc_tpeg_tclMain* theServer();    
      fc_tpeg_tclMain(tVoid);
      virtual ~fc_tpeg_tclMain(tVoid);
      fc_tpeg_tclMain& operator= (const fc_tpeg_tclMain &oApp);
      fc_tpeg_tclMain(const fc_tpeg_tclMain &oApp); 
      virtual tBool bOnInit();
      virtual tVoid vOnApplicationClose();
      virtual tVoid vOnLoadSettings();
      virtual tVoid vOnSaveSettings();
      virtual tVoid vOnTimer(tU16 nTimerId);
      using ahl_tclBaseOneThreadApp::vOnLoopback;
      virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   private:
      tVoid vTracePlugIn(tVoid);
      tVoid vTraceUnplug(tVoid);
      static tVoid vTrace_Rx(const tUChar* puchData);
      tBool bCreateCommonObjects();
      tBool bCreateTmcObjects();
      tBool bCreateTpegObjects();

      fc_tpeg_tclServiceHdlTmcTuner*  _poTmcTunerServer;
      clTpeg_TMCConfiguration * _poTMCConfiguration ;
      clTpeg_TpegConfiguration * _poTpegConfiguration;
      clTpeg_CommonCapability * _poCommonCapability ;
      clTpeg_Property_RdbIdActualList * _poRdbIdActualList;
      clTpeg_TunerControl *tunerControl;
      clTpeg_KDSConfiguration* _poKDSConfiguration;

#ifdef VARIANT_S_FTR_ENABLE_TMC
      fc_tpeg_tclClientHdlAmFmTuner*  _poAmFmTunerClient;
      fc_tpeg_tclClientHdlSxmTuner*  _poSxmTunerClient;
#endif

#ifdef VARIANT_S_FTR_ENABLE_TPEG
      fc_tpeg_tclClientHdlDabTuner*   _poDabTunerClient;
      fc_tpeg_tclServiceHdlTpeg*  _poTpegServer;
      clTpeg_PreDecoderInterface* _poPreDecoderInterface;
      clTpeg_Uri* _poUri;
      clTpeg_PersistentData* _poPersistentData;
#endif

      static fc_tpeg_tclMain*   _poMainAppInstance;

public:
      static tVoid vShowSupportedClientHandlers(tU8 uBegin = 0, tU8 uEnd = 255);
}; 

#endif // fc_tpegMain_h

