/**************************************************************************//**
* \file     clTpeg_TpegConfiguration.cpp
*
*           clTpeg_TpegConfiguration method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "TpegApplication/clTpeg_TpegConfiguration.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"

/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_TpegConfiguration::clTpeg_TpegConfiguration():
      _u32Timer_Group8AMsg(1000),
      _u32CounterTpegMsgIn(0),
      _u32CounterTpegMsgOut(0)
{
   vInitConfig();
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_TpegConfiguration::~clTpeg_TpegConfiguration()
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_TpegConfiguration::vInitConfig()
{
   vInitTpegCapability();
   vInitSupportedTpegApplications();
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_TpegConfiguration::vInitTpegCapability()
{
   vSetTimer_Group8AMsgSend(1000);
   m_aTpegCapability[enTpegCapability_idx_Reserved] = 0;
   m_aTpegCapability[enTpegCapability_idx_MaxNmbOfTuners] = 3;
   m_aTpegCapability[enTpegCapability_idx_TunerRoundRobin] = 0;
   m_aTpegCapability[enTpegCapability_idx_ProgramServiceName] = 16;
   m_aTpegCapability[enTpegCapability_idx_ServiceProviderName] = 16;
   m_aTpegCapability[enTpegCapability_idx_MessageDataAmount] = 100;
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_TpegConfiguration::vInitSupportedTpegApplications()
{
   std::vector<tU8> applicationVersionsSupported;
   applicationVersionsSupported.push_back(3); // Major version for most of the applications supported.
   SupportedMajorVersions[fi_tcl_e8_TpegApplication::FI_EN_SNI] = applicationVersionsSupported;
   SupportedMajorVersions[fi_tcl_e8_TpegApplication::FI_EN_TEC] = applicationVersionsSupported;
   SupportedMajorVersions[fi_tcl_e8_TpegApplication::FI_EN_TFP] = applicationVersionsSupported;
}


/**************************************************************************//**
* 
******************************************************************************/
std::vector<tU8> clTpeg_TpegConfiguration::oGetSupportedApplicationVersions(tU8 u8ApplicationId)
{
   std::map<tU8, std::vector<tU8> >::iterator iter = SupportedMajorVersions.find(u8ApplicationId);
   if (iter != SupportedMajorVersions.end())
   {
      return iter->second;
   }
   std::vector<tU8> EmptyList;
   return EmptyList;
}

/**************************************************************************//**
* 
******************************************************************************/
tBool clTpeg_TpegConfiguration::bIsApplicationInList(tU8 u8ApplicationId)
{
   std::map<tU8, std::vector<tU8> >::iterator iter = SupportedMajorVersions.find(u8ApplicationId);
   if (iter != SupportedMajorVersions.end())
   {
      return TRUE;
   }
   return FALSE;
}


/**************************************************************************//**
* 
******************************************************************************/
tU8 clTpeg_TpegConfiguration::u8GetCapability(tU8 u8CapabilityIndex)
{
   std::map<tU8, tU8 >::iterator iter = m_aTpegCapability.find(u8CapabilityIndex);
   if (iter != m_aTpegCapability.end())
   {
      return iter->second;
   }
   return 0;
}

/**************************************************************************//**
* 
******************************************************************************/
tBool clTpeg_TpegConfiguration::bIsCapabilityInList(tU8 u8CapabilityIndex)
{
   std::map<tU8, tU8 >::iterator iter = m_aTpegCapability.find(u8CapabilityIndex);
   if (iter != m_aTpegCapability.end())
   {
      return TRUE;
   }
   return FALSE;
}

