/**************************************************************************//**
* \file     clTpeg_TMCConfiguration.cpp
*
*           clTpeg_TMCConfiguration method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "TpegApplication/clTpeg_TMCConfiguration.h"
#include "fc_tpeg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_SERVER_TMCTUNER
#include "trcGenProj/Header/clTpeg_TMCConfiguration.cpp.trc.h"
#endif

/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_TMCConfiguration::clTpeg_TMCConfiguration():
      _u32Timer_Group8AMsg(1000),
      _u32CounterTmcMsgIn(0),
      _u32CounterTmcMsgOut(0)
{
    vInitConfig();
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_TMCConfiguration::~clTpeg_TMCConfiguration()
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_TMCConfiguration::vInitConfig()
{
   vSetTimer_Group8AMsgSend(1000);
   m_aTmcCapability[enTmcCapability_idx_Reserved] = 0;
   m_aTmcCapability[enTmcCapability_idx_EncryptedTmc] = 1;
   m_aTmcCapability[enTmcCapability_idx_MaxNmbOfTuners] = 3;
   m_aTmcCapability[enTmcCapability_idx_TunerRoundRobin] = 0;
   m_aTmcCapability[enTmcCapability_idx_ProgramServiceName] = 16;
   m_aTmcCapability[enTmcCapability_idx_ServiceProviderName] = 16;
   m_aTmcCapability[enTmcCapability_idx_MGMDecoding] = 0;
   m_aTmcCapability[enTmcCapability_idx_MaxNmbRdbIds] = 20;
   m_aTmcCapability[enTmcCapability_idx_MessageDataAmount] = 100;
   m_aTmcCapability[enTmcCapability_idx_PriorisedRdbIdList] = 0;
   m_aTmcCapability[enTmcCapability_idx_BSASupported] = 0;
   m_aTmcCapability[enTmcCapability_idx_DuplicationResendCycle] = 0;
   m_aTmcCapability[enTmcCapability_idx_UserSelectedTmcStation] = 0;
}
