/**************************************************************************//**
* \file     clTpeg_KDSConfiguration.cpp
*
*           clTpeg_KDSConfiguration method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "CcaServiceHdl/fc_tpeg_tclServiceHdlTmcTuner.h"
#include "TpegApplication/clTpeg_KDSConfiguration.h"
#include "datatypes/tString.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"


#define KDS_GENERIC_TUNER_PARAMETER_LENGTH			417
#define KDS_GENERIC_TUNER_PARAMETER_START_POINT_1	0x0420
#define KDS_GENERIC_TUNER_PARAMETER_READ_LEN_1		230
#define KDS_GENERIC_TUNER_PARAMETER_IDX_TMCSERVER1	93
#define TMCSERVER1XM_BIT							2


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_KDSConfiguration::clTpeg_KDSConfiguration()
{
	u8TMCServer1	= 0x01;
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_KDSConfiguration::~clTpeg_KDSConfiguration()
{
}


/**************************************************************************//**
*
******************************************************************************/
tU8 clTpeg_KDSConfiguration::u8ReadFMConfiguration()
{
	return 0;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_KDSConfiguration::vTriggerServiceStateChange(tBool/* bEnableService*/)
{

}
/**************************************************************************//**
*
******************************************************************************/
tBool clTpeg_KDSConfiguration::bIsSXMTMCServer()
{
	vReadKDSGenericTunerParameterSet();

	return u8TMCServer1 & (1 << TMCSERVER1XM_BIT);

}

/*************************************************************************
 *
 *************************************************************************/
tVoid clTpeg_KDSConfiguration::vReadKDSGenericTunerParameterSet()
{
	tS32 s32KdsReadReturnValue = OSAL_ERROR;

	tU8 pu8Data[KDS_GENERIC_TUNER_PARAMETER_LENGTH];

	OSAL_tIODescriptor IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);

	if( OSAL_ERROR == IOKdsHandle )
	{
		return;
	}

	s32KdsReadReturnValue = s32ReadKDS(IOKdsHandle,pu8Data,KDS_GENERIC_TUNER_PARAMETER_START_POINT_1,\
	KDS_GENERIC_TUNER_PARAMETER_READ_LEN_1);

	OSAL_s32IOClose(IOKdsHandle);

	if(s32KdsReadReturnValue != OSAL_ERROR)
	{
		vParse(pu8Data,KDS_GENERIC_TUNER_PARAMETER_LENGTH);
	}


}

/*************************************************************************
*
*************************************************************************/
tS32 clTpeg_KDSConfiguration::s32ReadKDS(OSAL_tIODescriptor IOKdsHandle, tU8* u8Buf, tU16 u16KdsKey, tU16 u16Len) const
{
	tsKDSEntry sKDS_EntryData;

	sKDS_EntryData.u16Entry = u16KdsKey;
	sKDS_EntryData.u16EntryLength = u16Len;
	sKDS_EntryData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
	sKDS_EntryData.au8EntryData[0] = 0;

	tS32 s32RetVal = OSAL_s32IORead(IOKdsHandle,(tS8*)&sKDS_EntryData,\
				sizeof(sKDS_EntryData));

    if (OSAL_ERROR != s32RetVal) {
          (tVoid)tunerCopy((&sKDS_EntryData.au8EntryData[0]), (&(sKDS_EntryData.au8EntryData[0])+ u16Len), u8Buf );
       }


	return s32RetVal;
}


/*************************************************************************
*
*************************************************************************/
tVoid clTpeg_KDSConfiguration::vParse( tU8* pu8KdsBuffer, tU32 u32Length)
{
	  if( u32Length < KDS_GENERIC_TUNER_PARAMETER_LENGTH)
	  {
		  u8TMCServer1	= 0x01;
	  }
	  else
	  {
		  u8TMCServer1	= pu8KdsBuffer[ KDS_GENERIC_TUNER_PARAMETER_IDX_TMCSERVER1];
	  }

}
