/**************************************************************************//**
* \file     clTpeg_CommonCapability.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#ifndef clTpeg_CommonCapability_h
#define clTpeg_CommonCapability_h


#include "fc_tpeg_types.h"
#include <map>


typedef enum
{
  enCommonCapability_idx_Reserved = 0,
  enCommonCapability_idx_MaxNmbRdbIds = 7,
  enCommonCapability_idx_PriorisedRdbIdList = 9,
  enCommonCapability_max
} tenCommonCapability;

struct trCommonCapabilityElem {
           trCommonCapabilityElem():
               enCommonCapability(enCommonCapability_idx_Reserved),
               u8Value(0)
           {}
           tenCommonCapability enCommonCapability;
           tU8  u8Value;
   };


class clTpeg_CommonCapability
{
public:
    clTpeg_CommonCapability( );
    virtual ~clTpeg_CommonCapability( );
    tVoid vSetMaxNmbRdbIds(tU8 u8MaxNmbRdbIds) {m_aCommonCapability[enCommonCapability_idx_MaxNmbRdbIds] = u8MaxNmbRdbIds;};
    tVoid vSetPriorisedRDBIdList(tBool bPriorisedRDBIdList) {m_aCommonCapability[enCommonCapability_idx_PriorisedRdbIdList] = bPriorisedRDBIdList;};
    tU8   u8GetMaxNmbRdbIds() { return (tU8)m_aCommonCapability[enCommonCapability_idx_MaxNmbRdbIds];};
    tBool bGetPriorisedRDBIdList() { return (tBool)m_aCommonCapability[enCommonCapability_idx_PriorisedRdbIdList];};
    tVoid vSetTimer_Group8AMsgSend( tU32 u32Time ) { _u32Timer_Group8AMsg = u32Time;};
    tU32  u32GetTimer_Group8AMsgSend() { return _u32Timer_Group8AMsg;};
    tU8 u8GetCapability(tU8 u8CapabilityIndex);
    tBool bIsCapabilityInList(tU8 u8CapabilityIndex);

protected:
    tU8 u8GetCommonCapability(tU8 u8Index) { return m_aCommonCapability[u8Index]; };
    tVoid vInitConfiguration() { vInitConfig(); };

private:
    tVoid vInitConfig();
    std::map<tU8, tU8 > m_aCommonCapability;
    tU32 _u32Timer_Group8AMsg;
    tU32 _u32CounterCommonMsgIn;
    tU32 _u32CounterCommonMsgOut;
};

#endif // clTpeg_CommonCapability_h
