/**************************************************************************//**
* \file     clTpeg_CommonCapability.cpp
*
*           clTpeg_CommonCapability method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "TpegApplication/clTpeg_CommonCapability.h"

/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_CommonCapability::clTpeg_CommonCapability():
      _u32Timer_Group8AMsg(1000),
      _u32CounterCommonMsgIn(0),
      _u32CounterCommonMsgOut(0)
{
   vInitConfig();
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_CommonCapability::~clTpeg_CommonCapability()
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_CommonCapability::vInitConfig()
{
   vSetTimer_Group8AMsgSend(1000);
   m_aCommonCapability[enCommonCapability_idx_Reserved] = 0;
   m_aCommonCapability[enCommonCapability_idx_MaxNmbRdbIds] = 20;
   m_aCommonCapability[enCommonCapability_idx_PriorisedRdbIdList] = 0;
}


/**************************************************************************//**
* 
******************************************************************************/
tU8 clTpeg_CommonCapability::u8GetCapability(tU8 u8CapabilityIndex)
{
   std::map<tU8, tU8 >::iterator iter = m_aCommonCapability.find(u8CapabilityIndex);
   if (iter != m_aCommonCapability.end())
   {
      return iter->second;
   }
   return 0;
}

/**************************************************************************//**
* 
******************************************************************************/
tBool clTpeg_CommonCapability::bIsCapabilityInList(tU8 u8CapabilityIndex)
{
   std::map<tU8, tU8 >::iterator iter = m_aCommonCapability.find(u8CapabilityIndex);
   if (iter != m_aCommonCapability.end())
   {
      return true;
   }
   return false;
}
