/**************************************************************************//**
* \file     clTpeg_Method_SwitchOnOff.cpp
*
*           clTpeg_Method_SwitchOnOff method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Method_SwitchOnOff.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "CcaApp/clCCAhandler.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Method_SwitchOnOff::~clTpeg_Method_SwitchOnOff()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Method_SwitchOnOff::clTpeg_Method_SwitchOnOff(clCCAhandler* poCCAhandler)
   : clServerMethod(TMCTUNERFI_C_U16_SWITCHONOFF, poCCAhandler)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SwitchOnOff::vMethodStart(amt_tclServiceData* /*poInMessage */)
{
   tmctunerfi_tclMsgSwitchOnOffMethodStart oMessage;
   if (oMessage.TmcOnOff)
   {
      vAllowMessagesToTIMA();
   }
   else
   {
      vBlockMessagesToTIMA();
   }
   tmctunerfi_tclMsgSwitchOnOffMethodResult oResult;
   oResult.Success = TRUE;
   vSendMethodResult(oResult);
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SwitchOnOff::vAllowMessagesToTIMA()
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SwitchOnOff::vBlockMessagesToTIMA()
{
}
