/**************************************************************************//**
* \file     clTpeg_Method_ExchangeTMCCapabilities.cpp
*
*           clTpeg_Method_ExchangeTMCCapabilities method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Method_ExchangeTMCCapabilities.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "TpegApplication/clTpeg_TMCConfiguration.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_SERVER_TMCTUNER
#include "trcGenProj/Header/clTpeg_Method_ExchangeTMCCapabilities.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Method_ExchangeTMCCapabilities::~clTpeg_Method_ExchangeTMCCapabilities()
{
   m_poTMCConfiguration = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Method_ExchangeTMCCapabilities::clTpeg_Method_ExchangeTMCCapabilities(clCCAhandler* poCCAhandler,  clTpeg_TMCConfiguration *poTMCConfiguration)
   : clServerMethod(TMCTUNERFI_C_U16_EXCHANGETMCCAPABILITIES, poCCAhandler),
   m_poTMCConfiguration(poTMCConfiguration)
{
	if(NULL != m_poTMCConfiguration)
	m_poTMCConfiguration->vInitConfig();
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_ExchangeTMCCapabilities::vMethodStart(amt_tclServiceData* /*poInMessage */)
{
   if(m_poTMCConfiguration !=NULL)
   {
   std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > oListOfTmcCapabilities;
   for ( tU8 u8Count = 0 ; u8Count  < enTmcCapability_max ; u8Count++ )
   {
      fi_tcl_TmcCapability oElem;
      oElem.TMCCapabilityId.enType = (fi_tcl_e8_TmcCapability::tenType)u8Count;
      oElem.Value = m_poTMCConfiguration->u8GetCapability(u8Count);
      ETG_TRACE_USR4(("vUpdateExchangeTmcCapabilitiesMStart() TPEG TMCCapabilityId.  %d   Val %d", oElem.TMCCapabilityId.enType, oElem.Value));
      oListOfTmcCapabilities.push_back(oElem);
   }
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult oResult;
   oResult.ListOfTmcCapabilities = oListOfTmcCapabilities;
   vSendMethodResult(oResult);
}
}
