/**************************************************************************//**
* \file     clTpeg_Property_TrafficTMCInfo.cpp
*
*           
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "SXMTuner/clTpeg_Property_TrafficTMCInfo.h"
#include "SXMTuner/tpeg_sxmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_TRAFFICTUNER
#include "trcGenProj/Header/clTpeg_Property_TrafficTMCInfo.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_TrafficTMCInfo::~clTpeg_Property_TrafficTMCInfo()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_TrafficTMCInfo::clTpeg_Property_TrafficTMCInfo(
   clCCAhandler* poCCAhandler
   )
   : clClientProperty(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCINFO, poCCAhandler)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TrafficTMCInfo::vStatus(amt_tclServiceData* poInMsg)
{
   if(m_poCCAhandler == NULL)
   {
	   return;
   }
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus oMessage;
   m_poCCAhandler->vGetDataFromAmt(poInMsg, oMessage);
   ETG_TRACE_USR4(("clTpeg_Property_TrafficTMCInfo:: vStatus entered with bTMCAvailableFlag = 0x%x.", oMessage.bTMCAvailableFlag))
}

