/**************************************************************************//**
* \file     clTpeg_Property_TrafficTMCData.h
*
*           TS FC Service Message handler functions
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTpeg_Property_TrafficTMCData_h
#define clTpeg_Property_TrafficTMCData_h


#include "CcaApp/clClientProperty.h"
#include "SXMTuner/tpeg_sxmTunerService_fi.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"


class clTpeg_Property_TMCData;


class clTpeg_Property_TrafficTMCData : public clClientProperty
{
   public:
      clTpeg_Property_TrafficTMCData(clCCAhandler* poCCAhandler, clTpeg_Property_TMCData* poTMCData);
      virtual ~clTpeg_Property_TrafficTMCData();
      tVoid vSendTMCDataToTIMA(std::vector<midw_fi_tcl_e16_TrafficInfo, std::allocator<midw_fi_tcl_e16_TrafficInfo> > &ListOfTrafficInfo);

      virtual tVoid vStatus(amt_tclServiceData* poInMsg);

   private:
      std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > oGetTrafficInfo(std::vector<midw_fi_tcl_e16_TrafficInfo, std::allocator<midw_fi_tcl_e16_TrafficInfo> > &ListOfTrafficInfo);

      clTpeg_Property_TMCData *m_poTMCData;

   protected:
      std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > uTestoGetTrafficInfo(std::vector<midw_fi_tcl_e16_TrafficInfo, std::allocator<midw_fi_tcl_e16_TrafficInfo> > &ListOfTrafficInfo);

};

#endif
