/**************************************************************************//**
* \file     clTpeg_Method_TrafficSetRDBID.cpp
*
*           clTpeg_Method_TrafficSetRDBID method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "SXMTuner/clTpeg_Method_TrafficSetRDBID.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_TRAFFICTUNER
#include "trcGenProj/Header/clTpeg_Method_TrafficSetRDBID.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Method_TrafficSetRDBID::~clTpeg_Method_TrafficSetRDBID()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Method_TrafficSetRDBID::clTpeg_Method_TrafficSetRDBID(clCCAhandler* poCCAhandler)
   : clClientMethod(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_S_SETRDBID, poCCAhandler)
{
   m_oMessage.TunRDBID_Value.clear();
   m_oMessage.u8NumOfRDBID = 0;
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_TrafficSetRDBID::vMethodResult(amt_tclServiceData* /*poInMessage*/ )
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_TrafficSetRDBID::vSetRDBIDListToTuner(std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > &oRdbidList)
{
   if(!oRdbidList.empty())
   {
	   m_oMessage.TunRDBID_Value = oRdbidList;
	   m_oMessage.u8NumOfRDBID = (tU8)oRdbidList.size();
	   vMethodStart(m_oMessage);
   }
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_TrafficSetRDBID::vOnNewServiceState(tBool bIsServiceAvailable) 
{
   if(bIsServiceAvailable == TRUE && m_oMessage.TunRDBID_Value.size())
   {
      ETG_TRACE_USR4(("clTpeg_Method_TrafficSetRDBID:: vOnNewServiceState  Sending methodstart on service availability "))
      vMethodStart(m_oMessage);
   }
}
