/**************************************************************************//**
* \file     fc_tpeg_tclClientHdlAmFmTuner.cpp
*
*           CCA Client Handler based on ahl_tclBaseOneThreadClientHandler
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "fc_tpeg_tclClientHdlAmFmTuner.h"
#include "AMFMTuner/tpeg_amfmTunerService_fi.h"
#include "AMFMTuner/clTpeg_Method_SetRDBID.h"
#include "fc_tpeg_trace.h"
#include "fc_tpeg_types.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_AMFMTUNER
#include "trcGenProj/Header/fc_tpeg_tclClientHdlAmFmTuner.cpp.trc.h"
#endif


/**************************************************************************//**
* Defines
******************************************************************************/
#define AMFMTUNER_SERVICE_ID              264
#define AMFMTUNER_FI_MAJOR_VERSION        3
#define AMFMTUNER_FI_MINOR_VERSION        0


/****************************************************************************
* Message Map
******************************************************************************/
#if __GNUC__>5
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wshift-negative-value"
#endif //__GNUC__>5
BEGIN_MSG_MAP(fc_tpeg_tclClientHdlAmFmTuner, ahl_tclBaseWork)
   ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_RDBID, vHandleAllMessages )
   ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TMC, vHandleAllMessages )
   ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_RDBIDACTUALLIST, vHandleAllMessages )
   //ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_TMC_INFO, vHandleAllMessages )
END_MSG_MAP()
#if __GNUC__>5
# pragma GCC diagnostic pop
#endif //__GNUC__>5

/**************************************************************************//**
* Constructor
******************************************************************************/
fc_tpeg_tclClientHdlAmFmTuner::fc_tpeg_tclClientHdlAmFmTuner(ahl_tclBaseOneThreadApp* poMainAppl) : 
clCCAhandler(poMainAppl, AMFMTUNER_SERVICE_ID, AMFMTUNER_FI_MAJOR_VERSION, AMFMTUNER_FI_MINOR_VERSION, CCA_C_U16_APP_TUNER),
ahl_tclBaseOneThreadClientHandler(poMainAppl, AMFMTUNER_SERVICE_ID, AMFMTUNER_FI_MAJOR_VERSION, AMFMTUNER_FI_MINOR_VERSION)
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlAmFmTuner() entered."));
}
/****************************************************************************
* Destructor
******************************************************************************/
fc_tpeg_tclClientHdlAmFmTuner::~fc_tpeg_tclClientHdlAmFmTuner(tVoid)
{
   ETG_TRACE_USR4(("~fc_tpeg_tclClientHdlAmFmTuner() entered."));
}


/**************************************************************************//**
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
******************************************************************************/
tVoid fc_tpeg_tclClientHdlAmFmTuner::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlAmFmTuner:: vOnServiceAvailable entered."))
   clCCAhandler::vSetRegisterId(ahl_tclBaseOneThreadClientHandler::u16GetRegID());
   clCCAhandler::bRegisterForAllFID();
   vNotifyServiceStateChange();
}


/**************************************************************************//**
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
******************************************************************************/
tVoid fc_tpeg_tclClientHdlAmFmTuner::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlAmFmTuner:: vOnServiceUnavailable entered."))
   clCCAhandler::vSetRegisterId(0);
}


/**************************************************************************//**
* Common Handler for All Messages
******************************************************************************/
tVoid fc_tpeg_tclClientHdlAmFmTuner::vHandleAllMessages(amt_tclServiceData* poInMsg)
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlAmFmTuner:: vHandleMessage entered."))
   clCCAhandler::vHandleMessage(poInMsg);
}


/**************************************************************************//**
* Overrides method vProcessTimer.
******************************************************************************/
tVoid fc_tpeg_tclClientHdlAmFmTuner::vProcessTimer(tU16 /*u16TimerId */) const
{
   if (TRUE == bIfServiceAvailable())
   {
      // Create message for used service.
   }
}


/**************************************************************************//**
* Currently only the method pclTpeg_Method_SetRDBID has to remember changes
* If required later, this logic will be modified for all classes.
******************************************************************************/
tVoid fc_tpeg_tclClientHdlAmFmTuner::vNotifyServiceStateChange()
{
   clTpeg_Method_SetRDBID *pclTpeg_Method_SetRDBID =
              dynamic_cast <clTpeg_Method_SetRDBID*>(poGetFunction(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_RDBID));
   if (NULL != pclTpeg_Method_SetRDBID)
   {
      pclTpeg_Method_SetRDBID->vOnNewServiceState(bIfServiceAvailable());
   }
}
