/************************************************************************
* FILE:         clIFiPropRegHelper.h
* PROJECT:      Ford
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: helper-interface to manage all registered/unregistered
*              properties of HSI handler
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
*************************************************************************/


#ifndef CLIFIPROPREGHELPER_H
#define CLIFIPROPREGHELPER_H


#include <vector>


class clFiPropRegHelper;

#define MAX_SIZE_OF_PROPERTIES    30

class clIFiPropRegHelper 
{
private:

    struct sFiPropRegHelper{ 
        clFiPropRegHelper* poFi;
        tBool bUsePort;

        sFiPropRegHelper(): poFi(NULL),bUsePort(FALSE)
        {};
    };
   /**
    * vector of clFiPropRegHelper-objects to manage all handler informations 
    */
   std::vector<sFiPropRegHelper*>oFiPropRegHelper;

   /**
    * this method creates a Prop-Reg-helper object
    */
   tVoid* pclCreatePropHelperElem( tVoid );

   sFiPropRegHelper* m_pclHelper;

public:
   

   /**
    * destructor 
    */
   virtual ~clIFiPropRegHelper();      

   /**
    * default constructor 
    */
   clIFiPropRegHelper();

   /**
    * this helpermethod is called from the HSIlhandler to add 
    * the function-ID which should be supported by the helper-class. 
    */
   virtual tBool bAddFunctionID(tU16 u16FunctionID, tBool bUsePort = FALSE);

   /**
    * this helpermethod gets the next functionID which
    * should be registered. 
    */
#ifdef VARIANT_S_FTR_ENABLE_LOOPED_FID_REGISTRATION
   virtual tU16 u16GetFunctionIDToRegister(tBool* bUsePort = NULL);
#else
   virtual tU16 u16GetFunctionIDToRegister(tU32 u32Idx, tBool* bUsePort = NULL);
#endif

   /**
    * this helpermethod resets all registrations. 
    */
   virtual tVoid vClearAllRegistration(tVoid);

   /**
    * set the return value of register for property
    */
   virtual tVoid vSetRetValForRegister( tU16 u16FunctionID, tBool bRetVal );

   /**
    * gets information if there are properties not registered
    */
   virtual tBool bAreAllPropertiesRegistered( );

  /**
    * this helpermethod is called from the HSI_handler to inform
    * how the response from the upreg was.
    */
   virtual tVoid vAddResponseForFctID(tU16 u16FunctionID, tBool bResponse);

   /**
    * gets information if all responses of registered properties were succeeded
    */
   virtual tBool bAreAllRegsFinished( );
   
   /**
    * get the number of fids that needs to be registered
    */   
   tU32 getFidToRegisterCount()const;

};
#endif //CLIFIPROPREGHELPER_H
