/************************************************************************
* FILE:         clFiPropRegHelper.cpp
* PROJECT:      Ford HSRNS
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Data of a Function ID registration
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
*************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "CcaApp/clFiPropRegHelper.h"

/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::clFiPropRegHelper()
* 
* DESCRIPTION: constructor, creates object clFiPropRegHelper - object
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
clFiPropRegHelper::clFiPropRegHelper():
   m_u16FunctionID(0),m_bIsRegSucceeded(FALSE),m_bRegisterDone(FALSE),
   m_bUpRegOK(FALSE)
{
}

/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::~clFiPropRegHelper()
* 
* DESCRIPTION: destructor, deletes all framework objects
*
* PARAMETER:   none 
*
* RETURNVALUE: none
*
*************************************************************************/
clFiPropRegHelper::~clFiPropRegHelper()
{
   m_u16FunctionID    = 0;
   m_bIsRegSucceeded  = FALSE;
   m_bRegisterDone    = FALSE;
   m_bUpRegOK         = FALSE;
}



/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::vSetFunctionID(tChar* szFiName)
* 
* DESCRIPTION: sets the name of the FI
*
* PARAMETER:   tU32 u32FunctionID
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid clFiPropRegHelper::vSetFunctionID(tU16 u16FunctionID)
{
   m_u16FunctionID = u16FunctionID;
}

/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::u32SetFiPointer(tVoid)
* 
* DESCRIPTION: helperfunction to get the FunctionID
*
* PARAMETER:   tVoid
*
* RETURNVALUE: tU32
*
*************************************************************************/
tU16 clFiPropRegHelper::u16GetFunctionID(tVoid)
{
   return m_u16FunctionID;
}


/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::vSetRetVal( )
* 
* DESCRIPTION: helperfunction to set the return value of the 
*              register for the property
*
* PARAMETER:   tBool bRetVal
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid clFiPropRegHelper::vSetRetVal( tBool bRetVal )
{
   m_bIsRegSucceeded = bRetVal;
}


/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::bGetRetVal()
* 
* DESCRIPTION: helperfunction to get the return value of the 
*              register for the property
*
* PARAMETER:   tVoid
*
* RETURNVALUE: tBool
*
*************************************************************************/
tBool clFiPropRegHelper::bGetRetVal( tVoid )
{
   return m_bIsRegSucceeded;
}


/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::vSetRegisterDone( )
* 
* DESCRIPTION: helperfunction to set a flag that registration was triggered
*
* PARAMETER:   tBool bRetVal
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid clFiPropRegHelper::vSetRegisterDone( tBool bRetVal )
{
   m_bRegisterDone = bRetVal;
}


/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::bIsRegisterDone()
* 
* DESCRIPTION: helperfunction to get information if registration
*              was done
*
* PARAMETER:   tVoid
*
* RETURNVALUE: tBool
*
*************************************************************************/
tBool clFiPropRegHelper::bIsRegisterDone( tVoid )
{
   return m_bRegisterDone;
}

/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::vSetUpRegResponse( )
* 
* DESCRIPTION: helperfunction to set a flag for response of 
*              registration/UpReg
*
* PARAMETER:   tBool bRetVal
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid clFiPropRegHelper::vSetUpRegResponse( tBool bRetVal )
{
   m_bUpRegOK = bRetVal;
}


/*************************************************************************
*
* FUNCTION:    clFiPropRegHelper::bIsRegisterDone()
* 
* DESCRIPTION: helperfunction to get information if registration/UpReg 
*              response was successful
*
* PARAMETER:   tVoid
*
* RETURNVALUE: tBool
*
*************************************************************************/
tBool clFiPropRegHelper::bIsUpRegValid( tVoid )
{
   return m_bUpRegOK;
}


