/**************************************************************************//**
* \file     clTpeg_Property_TunGetDataTMC.cpp
*
*           
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "AMFMTuner/clTpeg_Property_TunGetDataTMC.h"
#include "TMCTuner/clTpeg_Property_TMCData.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_AMFMTUNER
#include "trcGenProj/Header/clTpeg_Property_TunGetDataTMC.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_TunGetDataTMC::~clTpeg_Property_TunGetDataTMC()
{
   m_poTMCData = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_TunGetDataTMC::clTpeg_Property_TunGetDataTMC(
   clCCAhandler* poCCAhandler, clTpeg_Property_TMCData* poTMCData
   )
   : clClientProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TMC, poCCAhandler),
   m_poTMCData(poTMCData)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunGetDataTMC::vStatus(amt_tclServiceData* poInMsg)
{
   if(m_poCCAhandler!=NULL)
   {
      midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus oMessage;
      m_poCCAhandler->vGetDataFromAmt(poInMsg, oMessage);
      ETG_TRACE_USR4(("clTpeg_Property_TunGetDataTMC:: vStatus entered. with list size: 0x%x", oMessage.ListOfTrafficInfo.size()))
      vSendTMCDataToTIMA(oMessage.ListOfTrafficInfo);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunGetDataTMC::vSendTMCDataToTIMA(std::vector<midw_fi_tcl_TrafficInfo, std::allocator<midw_fi_tcl_TrafficInfo> > &ListOfTrafficInfo)
{
   if(m_poTMCData!=NULL)
   {
      std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > oTrafficInfoList;
      oTrafficInfoList = oGetTrafficInfo(ListOfTrafficInfo);
      m_poTMCData->vOnNewTrafficData(oTrafficInfoList);
   }

}


/**************************************************************************//**
*
******************************************************************************/
std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > clTpeg_Property_TunGetDataTMC::oGetTrafficInfo(std::vector<midw_fi_tcl_TrafficInfo, std::allocator<midw_fi_tcl_TrafficInfo> > &ListOfTrafficInfo)
{
   std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > oTrafficInfoList;
   if (ListOfTrafficInfo.size())
   {
      for (tU8 u8Index = 0; u8Index < ListOfTrafficInfo.size(); u8Index++)
      {
         fi_tcl_TrafficInfo oTrafficInfo;
         oTrafficInfo.RDBId.TMCCountryCode = ListOfTrafficInfo[u8Index].RDBId.TMCCountryCode;
         oTrafficInfo.RDBId.TableNo=ListOfTrafficInfo[u8Index].RDBId.TableNo;
         oTrafficInfo.RDBId.BSA =0;
         oTrafficInfo.RDBId.TmcService.ServiceID= ListOfTrafficInfo[u8Index].RDBId.ServiceID;
         oTrafficInfo.RDBId.TmcService.Encrypted = ListOfTrafficInfo[u8Index].RDBId.Encrypted;
         oTrafficInfo.RDBId.MsgType.enType = fi_tcl_e8_MessageType::FI_EN_TMC;
         oTrafficInfo.ECC =ListOfTrafficInfo[u8Index].ECC; // ECC
         oTrafficInfo.ApplicationId.enType = fi_tcl_e16_TmcApplicationId::FI_EN_TMCDATA;
         oTrafficInfo.ListOf8AData = ListOfTrafficInfo[u8Index].ListOf8AData;
         oTrafficInfo.ProgramID = ListOfTrafficInfo[u8Index].ProgramID;
         oTrafficInfo.Encryption.Encrypted =ListOfTrafficInfo[u8Index].Encryption.Encrypted;
         oTrafficInfo.Encryption.Encid = ListOfTrafficInfo[u8Index].Encryption.Encid;
         oTrafficInfo.Encryption.TestBits = ListOfTrafficInfo[u8Index].Encryption.TestBits;
         oTrafficInfo.MsgSource.MediumTypeId.enType = (fi_tcl_e8_TmcMediumType::tenType)ListOfTrafficInfo[u8Index].MsgSource.MediumTypeId.enType;
         oTrafficInfo.MsgSource.Number = ListOfTrafficInfo[u8Index].MsgSource.Number;
         oTrafficInfo.ProgramServiceName= ListOfTrafficInfo[u8Index].ProgramServiceName.szValue;
         oTrafficInfo.ServiceProviderName= ListOfTrafficInfo[u8Index].ServiceProviderName.szValue;
         oTrafficInfoList.push_back( oTrafficInfo);
      }
   }
   return oTrafficInfoList;
}

