/************************************************************************
 * FILE:        clTmcTuner_TMCTunerControl.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_TMCTunerControl.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef clTmcTuner_TMCTunerControl_h
#define clTmcTuner_TMCTunerControl_h
#include "ADRMsg/ADRMsg_if.h"

class clTmcTuner_HMI_ImpInterface;
class clTmcTuner_TunerApp_ImpInterface;

class clTmcTuner_TMCTunerControl
{
   public:
        virtual ~clTmcTuner_TMCTunerControl();
        clTmcTuner_TMCTunerControl();
        static void vSetAudioFGBGImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetGetStaticListImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetPresetListSetActiveImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetDRMTestModeImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetDemodulationImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetAtPiSearchImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetSelectAudioProgramImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetHDFirmwareInfoImpl(clTmcTuner_TunerApp_ImpInterface* poImpl);
        static void vSetDRMRadiotextImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetMethodGetConfigListImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetConfigSectionsImpl(clTmcTuner_TunerApp_ImpInterface* poImpl);
        static void vSetPropertyGetConfigListImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetMethodConfiglistUpdateLandImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetUpdateLandscapeProgressImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetMuteRequestImpl(clTmcTuner_HMI_ImpInterface*  poImpl);
        static void vSetAudioMuteRequestImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetMethodSelectConfiglistElementImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetATPIImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetATFrequencyImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetStationListSelectionImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetATSeekImpl(clTmcTuner_HMI_ImpInterface* poImpl);
		static void vSetAudioSplitModeImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetHDSectionParameterImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetGetConfigurationInfoImpl(clTmcTuner_TunerApp_ImpInterface* poImpl);
        static void vSetAdditionalVersionInfoImpl(clTmcTuner_TunerApp_ImpInterface* poImpl);
        static void vSetCalibrationDataImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetEnhancedTestModeImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetCMSetUserOptionsImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetCMCopyUserContentImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetPresetListContentUpdateImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnNewTunerFGBGStatus(unsigned char AudioSource);
        void vOnATPresetListSetActiveResult();
        void vOnCMATPresetList_XX_Status(clCMATPresetList_XX &oData,unsigned short u16FunctionId);
        void vOnNewDRMTestModeStatus(clCMDrmTestModeStatus &oData);
        // static void vSetDemodulationImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnNewDemodulationStatus(const unsigned char &u8DemodulationSwitch);
        void vOnNewAtPiSearchStatus(const unsigned char &u8PiSearchStatus);
        void vOnNewATHDAudioProgramStatus(const unsigned char &u8HDAudioProgram);
        static void vSetHDTestModeImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnNewATHDTestModeStatus(clCMHDTestModeStatus &oHDTestModeData,unsigned char u8PhysicalTuner,unsigned char u8TransitionCount);
        void vOnNewHDFirmwareInfoStatus(const char* poU8Firmwareinfo );
        static void vSetATHDLongNameImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnNewATHDLongNameStatus(const unsigned int u32HDStationId,const unsigned char u8HDAudioProgram,const tunerString sATHDLongName);
        static void vSetATHDImageFileUpdateImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnNewATHDImageFileUpdateStatus(clCMATHDImageFileUpdateStatus &oImageFileData);
        void vOnCM_DRMCurrentRadiotextStatus(tunerString sDRMCurrentRadioText);
        void vOnCM_StationListConfigResult(unsigned char u8ListId,unsigned char u8NumberOfStations);
        void vOnCM_StationListStatus(clCMStationsListStatus &oData);
        void vOnCM_UpdateLandscapeResult();
        void vOnCopyUserContentResult();
        void vOnPresetListContentUpdateResult(unsigned char u8Result);
        void vOnCM_UpdateLandscapeError();
        void vOnNewSetConfigSectionsResult(unsigned char u8Result);
        void vOnCM_UpdateLandscapeProgressStatus(unsigned char u8ScannedFrequenciesRatio);
        void vOnATPIError(clCMError &oData);
        void vOnATSeekError(clCMError &oData);
        void vOnATFrequencyError(clCMError &oData);
        void vOnStationListSelectionError(clCMError &oData);
        void vSendMuteDemuteRequestStatus(bool bMuteState, bool bInterrupt);
        void vOnNewATSeekStatus(unsigned char u8SeekState);
        void vOnNewAdditionalVersionInfoStatus(unsigned char u8FirstVersionDigit, unsigned char u8SecondVersionDigit, unsigned char u8ThirdVersionDigit);
        void vOnUpdateLandscapeError(clCMError &oData);
        void vOnNewGetConfigurationInfoStatus(tunerString sVersioninfo , unsigned int u32CRC);
		void vOnNewAudioSplitModeStatus(char s8ParameterValue);
        void vOnNewHDSectionParameterStatus(unsigned short u16ParameterID, char s8ParameterValue);
        void vOnCalibrationStatus(clCMCalibrationDataStatus &oCalibrationData);
        void vOnEnhancedTestModeStatus(unsigned char u8PhysicalTuner, clCMEnhancedTestModeStatus &oEnhancedTestModeData);
        void vOnNewCMSetUserOptionsStatus(unsigned char u8UserId, unsigned int u32UserOptions);
        void vOnCM_SetUserOptionsError(clCMError &oData);
        void vOnCM_CopyUserContentError(clCMError &oData);
        void vOnCM_PresetListContentUpdateError();
        static void vSetPropertySurviellanceListUpdateImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        static void vSetPropertyListUpdateNotificationImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnCM_ChangeOfSurveilledStationsStatus();
        static void vSetPropertyDARCDataImpl(clTmcTuner_HMI_ImpInterface* poImpl);
        void vOnCM_DARCDataStatus(clCMDARCGetDataStatus &oDARCDataStatus);
		void vOnNewDemodulationError(clCMError &oData);
		static void vSetChangeLsmImpl(clTmcTuner_HMI_ImpInterface* poImpl);
		void vOnChangeLsmError();
		void vOnChangeLsmStatus() ;
};

#endif
