/************************************************************************
 * FILE:         midwTunerToAdr3Map.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  midwTunerToAdr3Map.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef MIDWTUNERTOADR3MAP_h
#define MIDWTUNERTOADR3MAP_h

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include "datatypes/tVector.h"
#include "datatypes/tunerDatatypes.h"
#include "tun_MsgToADR.h"
#include "tun_defines.h"
#include <list>

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_if.h"

#define SET_ZEROTH_BIT 0x01
#define RIGHT_SHIFT_BY_ONE_BIT 2
#define KDSPRESETLISTMAPPING (((u32PresetlistMapping & 0xFF000000)>>24)|((u32PresetlistMapping & 0x00FF0000)>>8)|((u32PresetlistMapping & 0x0000FF00)<<8)|((u32PresetlistMapping & 0x000000FF)<<24))

struct stMidwTunerToAdr3Map
{
	unsigned int u32KDSdata;
	midw_fi_tcl_e8_Tun_ListID::tenType midwTunerPresetListID;
	unsigned short adr3PresetListID;
	unsigned char tunerBand;
};
struct stMidwTunerStatioListToAdr3StationListMap
{
	midw_fi_tcl_e8_Tun_ConfigListID::tenType midwTunerConfigListID;
	unsigned int  enoStationListBandBit;
	unsigned char  adr3StationListID;
};
unsigned short U16GetADR3PresetListID(midw_fi_tcl_e8_Tun_ListID::tenType midwTunerPresetListID);
unsigned short U16GetADR3PresetListID(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand);
unsigned char U8GetTunerBand(midw_fi_tcl_e8_Tun_ListID::tenType midwTunerPresetListID);
midw_fi_tcl_e8_Tun_ListID::tenType oGetADR3ToMidwTunerPresetListID(unsigned short adr3PresetListID);
tuner::common::enStationListBandBit enGetADR3StationListBandBit(midw_fi_tcl_e8_Tun_ConfigListID::tenType midwTunerConfigListID);\
midw_fi_tcl_e8_Tun_ListID::tenType oGetMidwTunerBandToPresetListID(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand);
unsigned char U8GetADR3StationListID(midw_fi_tcl_e8_Tun_ConfigListID::tenType midwTunerStationListID);
midw_fi_tcl_e8_Tun_ConfigListID::tenType oGetADR3ToMidwTunerStationListIDunsigned (short adr3StationListID);
unsigned char oGetADR3ToMidwTunerBand(unsigned short adr3PresetListID);
void vSetMidwTunerToAdr3Map(tU32 u32InitialAutoStoreListId);
void vSetMidwTunerToAdr3MapPSA();
std::list<unsigned short> vGetADRPresetlistID();
#endif
