/************************************************************************
 * FILE:        midwTunerToAdr3Map.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of midwTunerToAdr3Map.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "midwTunerToAdr3Map.h"
#include "ADRMsg/ADRMsgDefines.h"
#include "datatypes/tunerDatatypes.h"
using namespace tuner::common;
static stMidwTunerToAdr3Map astMidwTunerToAdr3Map[] =
{
	#define TUNER_MIDW_ADR3_MAP(KDSdata, midwPresetListID, adr3PresetListID, tunerBand)                  { KDSdata, midwPresetListID, adr3PresetListID, tunerBand},
	#include "midwTunerToAdr3Map.dat"
	#undef TUNER_MIDW_ADR3_MAP
};
static const stMidwTunerStatioListToAdr3StationListMap astMidwTunerStatioListToAdr3StationListMap[] =
{
	#define MIDWTUNER_ADR3_STATIONLIST_MAP(configListID, StationListBandBit,adr3StationListID)                  { configListID, StationListBandBit,adr3StationListID},
	#include "midwTunerToAdr3Map.dat"
	#undef MIDWTUNER_ADR3_STATIONLIST_MAP

};
/*****************************************************************************
*
******************************************************************************/
unsigned short U16GetADR3PresetListID(midw_fi_tcl_e8_Tun_ListID::tenType midwTunerPresetListID)
{
   const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
   for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
   {
	   if (astMidwTunerToAdr3Map[u32Index].midwTunerPresetListID == midwTunerPresetListID)
      {
		   return astMidwTunerToAdr3Map[u32Index].adr3PresetListID;
      }
   }
   return ADR_MSG_FID_INVALID;
}
unsigned short U16GetADR3PresetListID(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand)
{
   bool flag = false;
   const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
   for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
   {
   if((astMidwTunerToAdr3Map[u32Index].midwTunerPresetListID == midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1) && (astMidwTunerToAdr3Map[u32Index].adr3PresetListID == ADR_MSG_FID_CM_ATPRESETLIST_00))
   {
	  flag = true;
   }
   }
   
   for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
   {
	  if (astMidwTunerToAdr3Map[u32Index].tunerBand == midwTunerBand)
      {
		   if((astMidwTunerToAdr3Map[u32Index].adr3PresetListID == ADR_MSG_FID_INVALID_PRESETLIST) && flag == true)
		   {
			astMidwTunerToAdr3Map[u32Index].adr3PresetListID = ADR_MSG_FID_CM_ATPRESETLIST_00;
		   }
		   return astMidwTunerToAdr3Map[u32Index].adr3PresetListID;
      }
   }
   return ADR_MSG_FID_INVALID;
}
/*****************************************************************************
*
******************************************************************************/
unsigned char U8GetTunerBand(midw_fi_tcl_e8_Tun_ListID::tenType midwTunerPresetListID)
{
   const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
   for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
   {
      if (astMidwTunerToAdr3Map[u32Index].midwTunerPresetListID == midwTunerPresetListID)
      {
         return astMidwTunerToAdr3Map[u32Index].tunerBand;
      }
   }
   return tuner::common::BANDNONE;
}
/*****************************************************************************
*
******************************************************************************/
midw_fi_tcl_e8_Tun_ListID::tenType oGetADR3ToMidwTunerPresetListID(unsigned short adr3PresetListID)
{
	const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
	for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
	{
	  if (astMidwTunerToAdr3Map[u32Index].adr3PresetListID == adr3PresetListID)
	  {
		 return astMidwTunerToAdr3Map[u32Index].midwTunerPresetListID;
	  }
	}
	return midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_NONE;
}
unsigned char oGetADR3ToMidwTunerBand(unsigned short adr3PresetListID)
{
	const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
	for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
	{
	  if (astMidwTunerToAdr3Map[u32Index].adr3PresetListID == adr3PresetListID)
	  {
		 return astMidwTunerToAdr3Map[u32Index].tunerBand;
	  }
	}
	return midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
}
midw_fi_tcl_e8_Tun_ListID::tenType oGetMidwTunerBandToPresetListID(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand)
{
	const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
	for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
	{
	  if (astMidwTunerToAdr3Map[u32Index].tunerBand == midwTunerBand)
	  {
		  return astMidwTunerToAdr3Map[u32Index].midwTunerPresetListID;
	  }
	}
	return midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_NONE;
}
/*****************************************************************************
*
******************************************************************************/
tuner::common::enStationListBandBit enGetADR3StationListBandBit(midw_fi_tcl_e8_Tun_ConfigListID::tenType midwTunerConfigListID)
{
   const int configListID = sizeof astMidwTunerStatioListToAdr3StationListMap / sizeof(stMidwTunerStatioListToAdr3StationListMap);
   for (int u32Index = 0; u32Index < configListID; u32Index++)
   {
	   if (astMidwTunerStatioListToAdr3StationListMap[u32Index].midwTunerConfigListID == midwTunerConfigListID)
      {
         return (tuner::common::enStationListBandBit)astMidwTunerStatioListToAdr3StationListMap[u32Index].enoStationListBandBit;
      }
   }
   return tuner::common::BANDBIT_NONE;
}
/*****************************************************************************
*
******************************************************************************/
unsigned char U8GetADR3StationListID(midw_fi_tcl_e8_Tun_ConfigListID::tenType midwTunerConfigListID)
{
	   const int numberofStationListID = sizeof astMidwTunerStatioListToAdr3StationListMap / sizeof(stMidwTunerStatioListToAdr3StationListMap);
	   for (int u32Index = 0; u32Index < numberofStationListID; u32Index++)
	   {
		   if (astMidwTunerStatioListToAdr3StationListMap[u32Index].midwTunerConfigListID == midwTunerConfigListID)
	      {
			   return astMidwTunerStatioListToAdr3StationListMap[u32Index].adr3StationListID;
	      }
	   }
	   return tuner::common::NONE_STATIONLISTID;
}
/*****************************************************************************
*
******************************************************************************/
midw_fi_tcl_e8_Tun_ConfigListID::tenType oGetADR3ToMidwTunerStationListIDunsigned (short adr3StationListID)
{
	   const int numberofStationListID = sizeof astMidwTunerStatioListToAdr3StationListMap / sizeof(stMidwTunerStatioListToAdr3StationListMap);
	   for (int u32Index = 0; u32Index < numberofStationListID; u32Index++)
	   {
		   if (astMidwTunerStatioListToAdr3StationListMap[u32Index].adr3StationListID == adr3StationListID)
	      {
			   return (midw_fi_tcl_e8_Tun_ConfigListID::tenType)astMidwTunerStatioListToAdr3StationListMap[u32Index].adr3StationListID;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE;
}
/*****************************************************************************
*
******************************************************************************/
void vSetMidwTunerToAdr3Map(tU32 u32PresetlistMapping)
{
	const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
	tU32 u32PresetListID = ADR_MSG_FID_CM_ATPRESETLIST_00;
	tU32 u32Mask = SET_ZEROTH_BIT;

	for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
	{
		while(u32Mask <= KDS_BIT_31)
		{
			if(astMidwTunerToAdr3Map[u32Index].u32KDSdata == u32Mask)
			{
				if(KDSPRESETLISTMAPPING & u32Mask)
				{
					astMidwTunerToAdr3Map[u32Index].adr3PresetListID = (unsigned short)u32PresetListID;
					u32PresetListID++;
					u32Mask=(u32Mask*RIGHT_SHIFT_BY_ONE_BIT);
				}

				break;
			}
			else
			{
				u32Mask=(u32Mask*RIGHT_SHIFT_BY_ONE_BIT);
			}
		}
	}
}
/*****************************************************************************
*
******************************************************************************/
void vSetMidwTunerToAdr3MapPSA()
{

	const int numberofPresetListID = sizeof astMidwTunerToAdr3Map / sizeof(stMidwTunerToAdr3Map);
	tU32 u32PresetListID = ADR_MSG_FID_CM_ATPRESETLIST_00;

	for (int u32Index = 0; u32Index < numberofPresetListID; u32Index++)
	{
		if(astMidwTunerToAdr3Map[u32Index].midwTunerPresetListID == midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1)
		{
			astMidwTunerToAdr3Map[u32Index].adr3PresetListID = (unsigned short)u32PresetListID;
			astMidwTunerToAdr3Map[u32Index].tunerBand = tuner::common::BANDCB1;
		}
	}
}
