/************************************************************************
 * FILE:        clTmcTuner_SetConfigSections.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_SetConfigSections.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   31-Jul-2015         vnd4kor
				
 *************************************************************************/


#include "TunerApp/clTmcTuner_SetConfigSections.h"
#include "Aars/clAars_SetConfigSections.h"
#include "tun_Config.h"
#include "tun_Utility.h"
#include "tun_defines.h"
#include "tun_MsgToADR.h"
#include "kdsconfig/clConfigInterface.h"

#include "ADRMsg/clByteConverter.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTmcTuner_SetConfigSections.cpp.trc.h"
#endif


#define NUMBER_OF_BYTES_OF_VERSIONINFO 16
#define NUMBER_OF_RFU_BYTES 8

clTmcTuner_SetConfigSections::clTmcTuner_SetConfigSections(clAars_SetConfigSections* poclAars_SetConfigSections, tun_Config* potun_Config, tun_Utility* potun_Utility, clConfigInterface* poclConfigInterface) :
m_u16NumberOfBytes(0),
m_poclAars_SetConfigSections(poclAars_SetConfigSections),
m_u8Result(0),
m_potun_Config(potun_Config),
m_potun_Utility(potun_Utility),
m_poclConfigInterface(poclConfigInterface)
{
}

clTmcTuner_SetConfigSections::~clTmcTuner_SetConfigSections()
{
	m_poclAars_SetConfigSections = 0;
	m_potun_Config = 0;
	m_potun_Utility = 0;
	m_poclConfigInterface = 0;
}

void clTmcTuner_SetConfigSections::vConstructConfigSections()
{	
	m_payload.clear();
		
	vCall(&clTmcTuner_SetConfigSections::vInsertConfigSectionToPayload);

	m_u16NumberOfBytes = (unsigned short)m_payload.size();
	ETG_TRACE_USR2(( " clTmcTuner_SetConfigSections::vConstructConfigSections() -> Payload Constructed : Size () =  %d",m_payload.size()));
		
}

void clTmcTuner_SetConfigSections::vSendSetConfigSections(unsigned char u8Action, unsigned int* pu32Crc,unsigned char* pu8HWCrc)
{
	if(bIsActionCalculateCRC(u8Action))
	{
		vSetVersionId();
		vConstructConfigSections();
		vCalculateCRC(pu32Crc,pu8HWCrc);
		
	}
	else if( bIsActionSetConfiguation(u8Action))
	{
		vCall(&clTmcTuner_SetConfigSections::vTraceConfigSection);
		m_poclAars_SetConfigSections->vSetConfigSections(m_u16NumberOfBytes,m_sVesrinInfo,m_payload);
	}

}

bool clTmcTuner_SetConfigSections::bIsActionCalculateCRC(unsigned char& u8Action)
{
	return ((u8Action & (unsigned char)enTraceSetConfiguration_CalculateCRCOnly) == enTraceSetConfiguration_CalculateCRCOnly ) ? true : false;
}

bool clTmcTuner_SetConfigSections::bIsActionSetConfiguation(unsigned char& u8Action)
{
	return ((u8Action & (unsigned char)enTraceSetConfiguration_Send) == enTraceSetConfiguration_Send ) ? true : false;
}

void clTmcTuner_SetConfigSections::vCalculateCRC(unsigned int* pu32Crc ,unsigned char* pu8HWCrc)
{
	if( pu32Crc == NULL || m_potun_Utility == NULL || pu8HWCrc == NULL )
	{
		ETG_TRACE_USR2(( " clTmcTuner_SetConfigSections::vCalculateCRC() -> pu32Crc || pu8HWCrc || m_potun_Utility = NULL"));
		return;
	}

	tunerVector<unsigned char> oConfigData;
	vBuildSetConfigSectionsPayload(oConfigData);

	*pu32Crc = m_potun_Utility->u32CalculateCRC32( &oConfigData[0], (unsigned int) oConfigData.size());
	*pu8HWCrc = m_oHardwareRelatedConfiguration.u8GetPhysicalTunerConfigurationId();
	ETG_TRACE_USR2(( " clTmcTuner_SetConfigSections::vCalculateCRC() -> u32CRC=0x%08X , u8HWCRC=0x%02X",*pu32Crc,*pu8HWCrc));
	
}

void clTmcTuner_SetConfigSections::vSetVersionId()
{
	char sKDSVersionId[ TUN_CONFIG_VERSIONID_LEN];
	m_poclConfigInterface->vGetVersionID( sKDSVersionId);
	m_sVesrinInfo.assign(sKDSVersionId,TUN_CONFIG_VERSIONID_LEN);
	m_sVesrinInfo.insert(sizeof( sKDSVersionId),NUMBER_OF_BYTES_OF_VERSIONINFO-sizeof( sKDSVersionId),(unsigned char)0xaa);	
	ETG_TRACE_USR2(( " clTmcTuner_SetConfigSections::vSetVersionId() -> %s",m_sVesrinInfo.c_str()));
}

unsigned short clTmcTuner_SetConfigSections::u16GetNumberOfBytes()
{
	return m_u16NumberOfBytes;
}

void clTmcTuner_SetConfigSections::vOnNewSetConfigSectionsResult(unsigned char u8Result)
{
	m_u8Result = u8Result;
}


void clTmcTuner_SetConfigSections::vBuildSetConfigSectionsPayload(tunerVector<unsigned char>& oConfigData)
{
	for(unsigned char i=0;i < NUMBER_OF_RFU_BYTES; i++)
	{
		oConfigData.push_back(0);
	}

	char *pStr = const_cast<char *>(m_sVesrinInfo.c_str());

	if(m_sVesrinInfo.size() < NUMBER_OF_BYTES_OF_VERSIONINFO)
	{
		unsigned char u8index=0;
		for(; u8index < (int)m_sVesrinInfo.size(); u8index++)
		{
			oConfigData.push_back(pStr[u8index]);
		}
		for(; u8index < NUMBER_OF_BYTES_OF_VERSIONINFO; u8index++)
		{
			oConfigData.push_back((unsigned char)0xaa);
		}
	}
	else
	{
		vAddString(oConfigData, (unsigned char *)pStr, NUMBER_OF_BYTES_OF_VERSIONINFO);
	}
	vAddShort(oConfigData, m_u16NumberOfBytes);
	oConfigData.insert(oConfigData.end(), m_payload.begin(), m_payload.begin() + m_u16NumberOfBytes);
}


void clTmcTuner_SetConfigSections::vInsertConfigSectionToPayload(clBaseConfigSection* pConfigSection)
{
	if( pConfigSection == NULL )
	{
		ETG_TRACE_USR2(( " clTmcTuner_SetConfigSections::vInsertConfigSectionToPayload() -> pConfigSection = NULL"));
		return;
	}
	
	pConfigSection->vSetParameters(m_potun_Config, m_poclConfigInterface);
	pConfigSection->vSerialize();
	m_payload.insert(m_payload.end(), pConfigSection->m_payload.begin(), pConfigSection->m_payload.end());
}

void clTmcTuner_SetConfigSections::vTraceConfigSection(clBaseConfigSection* pConfigSection)
{
	if( pConfigSection == NULL )
	{
		ETG_TRACE_USR2(( " clTmcTuner_SetConfigSections::vTraceConfigSection() -> pConfigSection = NULL"));
		return;
	}
	pConfigSection->vTrace();
}

void clTmcTuner_SetConfigSections::vCall(void ((clTmcTuner_SetConfigSections::*pfunctionPointer)(clBaseConfigSection* )))
{
	(this->*pfunctionPointer)(&m_oTuningBehaviourConfiguration);
	(this->*pfunctionPointer)(&m_oclATStationInfoConfiguration);
	(this->*pfunctionPointer)(&m_oTimerConfiguration);
	(this->*pfunctionPointer)(&m_oReceptionBehaviourConfiguration);
	(this->*pfunctionPointer)(&m_oBandSetupConfiguration);
	(this->*pfunctionPointer)(&m_oUserSettingConfiguration);
	(this->*pfunctionPointer)(&m_oAMFMParameterConfiguration);
	(this->*pfunctionPointer)(&m_oRDSParameterConfiguration);
	(this->*pfunctionPointer)(&m_oTestmodeAndAFListConfiguration);
	(this->*pfunctionPointer)(&m_oStationListConfiguration);
	if(bIsConfigurationRequired(enHDParameterConfiguration))
	{
		(this->*pfunctionPointer)(&m_oHDParameterConfiguration);
	}
#ifdef VARIANT_S_FTR_ENABLE_DRM
	if(bIsConfigurationRequired(enDRMParameterConfiguration))
	{
		(this->*pfunctionPointer)(&m_oDRMParameterConfiguration);
	}
#endif
	(this->*pfunctionPointer)(&m_oPresetListConfiguration);
	(this->*pfunctionPointer)(&m_oHardwareRelatedConfiguration);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	(this->*pfunctionPointer)(&m_oAnnouncementConfiguration);
#endif
	(this->*pfunctionPointer)(&m_oEndOfConfiguration);
}


bool clTmcTuner_SetConfigSections::bIsConfigurationRequired(enConfigSectionID enSectionID)
{
	bool bReturnValue = false;

	if(m_potun_Config == NULL || m_poclConfigInterface == NULL )
	{
		return bReturnValue;
	}
	
	switch(enSectionID)
	{
	case enHDParameterConfiguration:
		bReturnValue = m_poclConfigInterface->u32GetConfigData("HDSupported");
		break;
	case enDRMParameterConfiguration:
		bReturnValue = m_poclConfigInterface->u32GetConfigData("DRMSupported");
		break;
	default :
		break;
	}

	if(!bReturnValue)
	{
		ETG_TRACE_USR2(( "clTmcTuner_SetConfigSections::vTrace() \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* NOT CONFIGURED AS IT IS NOT MOUNTED *\n************************************",enSectionID));
	}

	return bReturnValue;
}
