/************************************************************************
 * FILE:       clTmcTuner_HDFirwareInfo_Update.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_HDFirwareInfo_Update.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
 *************************************************************************/


#include "TunerApp/clTmcTuner_HDFirwareInfo_Update.h"
#include "string.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTmcTuner_HDFirwareInfo_Update.cpp.trc.h"
#endif

#define ADR_HD_FIRMWAREINFO_LENGTH 36

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_HDFirwareInfo_Update::~clTmcTuner_HDFirwareInfo_Update()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_HDFirwareInfo_Update::clTmcTuner_HDFirwareInfo_Update()
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_HDFirwareInfo_Update::vWriteToDP(const char* pu8Firmwareinfo)
{
	ETG_TRACE_USR2(( "clTmcTuner_HDFirwareInfo_Update::vWriteToDP() , HDFirmwareVersion changed [%s]", pu8Firmwareinfo));
	m_oAdrHDFirmwareVersion.vSetData( const_cast<char*>(pu8Firmwareinfo), (tU16)(strlen( pu8Firmwareinfo) + 1));
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_HDFirwareInfo_Update::vOnNewHDFirmwareInfoStatus(const char* pu8Firmwareinfo )
{
	if( pu8Firmwareinfo == NULL )
	{
		NORMAL_M_ASSERT( pu8Firmwareinfo != NULL ); 
		return;
	}
   
   if(bIsFirmwareinfoChanged(pu8Firmwareinfo))
   {
		vWriteToDP(pu8Firmwareinfo);
   }
}

bool clTmcTuner_HDFirwareInfo_Update::bIsFirmwareinfoChanged(const char* pu8Firmwareinfo)
{
	char sAdrHDFirmwareVer[ADR_HD_FIRMWAREINFO_LENGTH + 1] = {0};

	m_oAdrHDFirmwareVersion.u8GetData(sAdrHDFirmwareVer , ADR_HD_FIRMWAREINFO_LENGTH+1);
	ETG_TRACE_USR2(( "clTmcTuner_HDFirwareInfo_Update::bIsFirmwareinfoChanged() , DP::sAdrHDFirmwareVer : %s ", sAdrHDFirmwareVer));
	ETG_TRACE_USR2(( "clTmcTuner_HDFirwareInfo_Update::bIsFirmwareinfoChanged() , ReceivedFromADR = %s ",pu8Firmwareinfo));

	if(strcmp(const_cast<char*>(pu8Firmwareinfo) , sAdrHDFirmwareVer))
	{
		return true;
	}

	return false;
}





