/************************************************************************
 * FILE:        clTmcTuner_GetConfigurationInfoStatus.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_GetConfigurationInfoStatus.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef clTmcTuner_GetConfigurationInfoStatus_h
#define clTmcTuner_GetConfigurationInfoStatus_h

#include "interface/clTmcTuner_TunerApp_ImpInterface.h"
#include "TunerApp/ADRConfiguration/clUserSettingConfiguration.h"
#include "Header/tun_MsgToADR.h"
#include "Header/tun_main.h"
#include "kdsconfig/clConfigInterface.h"

#include "datatypes/tString.h"

#define ADR_CONFIGVERSIONINFO_LENGTH	16

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
	#define DP_S_IMPORT_INTERFACE_FI
	#include "dp_tuner_if.h"
	#include "dp_generic_if.h"
#else
	#include"diaglib_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

class tun_MsgToAdr;
class tuner_tclApp;
class clConfigInterface;

class clTmcTuner_GetConfigurationInfoStatus: public clTmcTuner_TunerApp_ImpInterface, public clByteConverter
{
private:

	tun_MsgToADR* m_potun_MsgToAdr;
	tuner_tclApp* m_poGWMain;
	clConfigInterface* m_poclConfigInterface;

	dp_tclTmcTunerDPKDSConfigCRC  m_oKDSConfigCRC; // KDS datapool
	dp_tclTmcTunerDPAdrConfigCRC m_oAdrConfigCRC;; //ADR datapool


public:
	clTmcTuner_GetConfigurationInfoStatus(tun_MsgToADR* potun_MsgToAdr, tuner_tclApp* poGWMain, clConfigInterface* poclConfigInterface);
	virtual ~clTmcTuner_GetConfigurationInfoStatus();
	void vOnNewGetConfigurationInfoStatus(tunerString sVersioninfo , unsigned int u32CRC);
	bool bIsStoredCRCAndCurrentCRCEqual(tU32 u32TargetCRC,tU32 u32DatapoolAdrCRC,tU32 u32CalculatedCRC,tU32 u32DatapoolKdsCrc);
	bool bIsConfigurationDone();
	unsigned int u32CalculateCRC();
	void vDoConfiguration();
	void vDoNotification();
	void vWriteCRCToDp(tU32 u32TargetCRC,tU32 u32CalculatedCRC,tunerString sVersioninfo);
	void vPrintCRC(tU32 u32TargetCRC,tU32 u32DatapoolAdrCRC,tU32 u32CalculatedCRC,tU32 u32DatapoolKdsCRC);
	void vWriteToRegistry(tU32 u32TargetCRC);

};

#endif
