/************************************************************************
 * FILE:        clTmcTuner_GetConfigurationInfoStatus.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_GetConfigurationInfoStatus.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "TunerApp/clTmcTuner_GetConfigurationInfoStatus.h"
#include "tun_Utility.h"
#include "tun_defines.h"
#include "tun_MsgToADR.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTmcTuner_GetConfigurationInfoStatus.cpp.trc.h"
#endif

#define BAND_FM 0
#define BAND_MW 2
#define DRM 20

clTmcTuner_GetConfigurationInfoStatus::clTmcTuner_GetConfigurationInfoStatus(tun_MsgToADR* potun_MsgToAdr, tuner_tclApp* poGWMain, clConfigInterface* poclConfigInterface) :
m_potun_MsgToAdr(potun_MsgToAdr)
,m_poGWMain(poGWMain)
,m_poclConfigInterface(poclConfigInterface)
{
}

clTmcTuner_GetConfigurationInfoStatus::~clTmcTuner_GetConfigurationInfoStatus()
{
	m_potun_MsgToAdr = 0;
	m_poGWMain = 0;
	m_poclConfigInterface = 0;
}

void clTmcTuner_GetConfigurationInfoStatus::vOnNewGetConfigurationInfoStatus(tunerString sVersioninfo , unsigned int u32CRC)
{
	  TUN_ASSERT_RETURN( m_potun_MsgToAdr  != NULL || m_poGWMain  != NULL || m_poclConfigInterface != NULL);

	  ETG_TRACE_USR2(( " VersionInfo : %s ", sVersioninfo.c_str() ));
	  tU32 u32DatapoolAdrCRC    = m_oAdrConfigCRC.tGetData();
	  tU32 u32DatapoolKdsCRC    = m_oKDSConfigCRC.tGetData();
	  tU32 u32CalculatedCRC = u32CalculateCRC();
	  tU32 u32TargetCRC     = u32CRC;

	  vWriteToRegistry(u32TargetCRC);

	  if( !bIsConfigurationDone())
	  {
		  vPrintCRC(u32TargetCRC,u32DatapoolAdrCRC,u32CalculatedCRC,u32DatapoolKdsCRC);
		  if( bIsStoredCRCAndCurrentCRCEqual(u32TargetCRC,u32DatapoolAdrCRC,u32CalculatedCRC,u32DatapoolKdsCRC) )
		  	  {
			    // at band
			  m_potun_MsgToAdr->vGetBandDetails(BAND_FM);
			  m_potun_MsgToAdr->vGetBandDetails(BAND_MW);
			  if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
			  {
				  m_potun_MsgToAdr->vGetBandDetails(DRM);
			  }
			  m_potun_MsgToAdr->vOnServiceAvailable();
			  m_poGWMain->VSetTime_ForDoNotfication_1secTimer(1000);
		  	  }

		  else
		  	  {
				 dp_tclTmcTunerDPConfigVersion oTunerDPConfigVersion;
				 char sPreviousVersioninfo[ADR_CONFIGVERSIONINFO_LENGTH] = {0};
				 oTunerDPConfigVersion.s32GetData(sPreviousVersioninfo , ADR_CONFIGVERSIONINFO_LENGTH);
				 ETG_TRACE_ERRMEM(( "Current  ADR Version Info ::%s ", sVersioninfo.c_str()));
				 ETG_TRACE_ERRMEM(( "Previous ADR Version Info ::%s ", sPreviousVersioninfo));
				 ETG_TRACE_ERRMEM(( "Current KDS CRC = 0x%08X Previous stored KDS CRC = 0x%08X Current ADR CRC = 0x%08X Previous stored ADR CRC  = 0x%08X",
				 u32CalculatedCRC,u32DatapoolKdsCRC,u32TargetCRC,u32DatapoolAdrCRC));
				 vDoConfiguration();
		  	  }
	  }

	  else  /* m_bReadCheckSumAfterConfig == TRUE */
	  {
		  vWriteCRCToDp(u32TargetCRC,u32CalculatedCRC,sVersioninfo);
  		  m_potun_MsgToAdr->vGetBandDetails(BAND_FM);
		  m_potun_MsgToAdr->vGetBandDetails(BAND_MW);
		  if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
		  {
			  m_potun_MsgToAdr->vGetBandDetails(DRM);
		  }
	  }
}




bool clTmcTuner_GetConfigurationInfoStatus::bIsStoredCRCAndCurrentCRCEqual(tU32 u32TargetCRC,tU32 u32DatapoolAdrCRC,tU32 u32CalculatedCRC,tU32 u32DatapoolKdsCRC)
{
		
		  bool bValue = true;
		  if((u32TargetCRC == 0) || (u32TargetCRC != u32DatapoolAdrCRC) || (u32CalculatedCRC != u32DatapoolKdsCRC))
		  {
			  bValue = false;
		  }

		  return bValue;
}

bool clTmcTuner_GetConfigurationInfoStatus::bIsConfigurationDone()
{
	if(m_potun_MsgToAdr  == NULL)
	{
	NORMAL_M_ASSERT (m_potun_MsgToAdr != NULL);
	return false;
	}
	bool bReadCheckSumAfterConfig = m_potun_MsgToAdr->bGetValue_m_bReadCheckSumAfterConfig();
	ETG_TRACE_USR2(( " clTmcTuner_GetConfigurationInfoStatus::bIsConfigurationDone -> , Is Configuration done = 0x%02x"
	                      ,bReadCheckSumAfterConfig
	                    ));

	return bReadCheckSumAfterConfig;
}

unsigned int clTmcTuner_GetConfigurationInfoStatus::u32CalculateCRC()
{
	if(m_potun_MsgToAdr  == NULL)
	{
	NORMAL_M_ASSERT (m_potun_MsgToAdr != NULL);
	return 0;
	}
	tU32 u32CalculatedCRC;
	m_potun_MsgToAdr->bSendCM_SetConfiguration( enTraceSetConfiguration_CalculateCRCOnly, &u32CalculatedCRC);
	return u32CalculatedCRC;
	
}

void clTmcTuner_GetConfigurationInfoStatus::vDoConfiguration()
{
	TUN_ASSERT_RETURN( m_potun_MsgToAdr  != NULL);
    /*========================================================================
     * Wrong check sum: a configuration is required
	 * send configuration to ADR and do notification afterwarts
	 *----------------------------------------------------------------------*/
	ETG_TRACE_COMP(( " clTmcTuner_GetConfigurationInfoStatus::vDoConfiguration() -> Do ADR configuration.\n"
   " ****************************************************************************************\n"
	" * Update ADR configuration\n"
   " ****************************************************************************************"
	));

	m_potun_MsgToAdr->bSendCM_SetConfiguration( enTraceSetConfiguration_SendAndTracePlain, OSAL_NULL);
}

void clTmcTuner_GetConfigurationInfoStatus::vDoNotification()
{
	TUN_ASSERT_RETURN( m_potun_MsgToAdr  != NULL);
	  /*========================================================================
	   * ADR configuration is OK, do notification
	   *----------------------------------------------------------------------*/
		ETG_TRACE_COMP(( " clTmcTuner_GetConfigurationInfoStatus::vDoNotification() -> ADR configuration is OK, do notification.\n"
					" ****************************************************************************************\n"
					" * Current ADR3 configuration is OK, no update reqired\n"
					" ****************************************************************************************"
					  ));

	#if defined(VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC)
			  m_potun_MsgToAdr->vGetUser();
			//m_potun_MsgToAdr->vStartupSetUserReq();

	#else
			m_potun_MsgToAdr->vDoNotification();
	#endif
}

void clTmcTuner_GetConfigurationInfoStatus::vWriteCRCToDp(tU32 u32TargetCRC,tU32 u32CalculatedCRC,tunerString sVersioninfo)
{
	TUN_ASSERT_RETURN( m_potun_MsgToAdr  != NULL);
	/*========================================================================
		     * save the new check sum to Datapool
		     *----------------------------------------------------------------------*/
			  m_potun_MsgToAdr->vSetValue_m_bReadCheckSumAfterConfig(FALSE);


		      m_oAdrConfigCRC.vSetData( u32TargetCRC);
		      m_oKDSConfigCRC.vSetData( u32CalculatedCRC);
			  dp_tclTmcTunerDPConfigVersion oTunerDPConfigVersion;
			  char versioninfo[ADR_CONFIGVERSIONINFO_LENGTH+1] ={0};
			  strncpy(versioninfo,sVersioninfo.c_str(),ADR_CONFIGVERSIONINFO_LENGTH);
			  versioninfo[ADR_CONFIGVERSIONINFO_LENGTH] = '\0';
			  oTunerDPConfigVersion.s32SetData(versioninfo);
		      vPrintCRC(u32TargetCRC,m_oAdrConfigCRC.tGetData(),u32CalculatedCRC,m_oKDSConfigCRC.tGetData());
}

void clTmcTuner_GetConfigurationInfoStatus::vWriteToRegistry(tU32 u32TargetCRC)
{
			
			dp_tclregVersionsAdrConfigCRC oAdrConfigCRC;

			if(oAdrConfigCRC.tGetData() != u32TargetCRC)
			{
			oAdrConfigCRC.vSetData( u32TargetCRC);
			}
}

void clTmcTuner_GetConfigurationInfoStatus::vPrintCRC(tU32 u32TargetCRC,tU32 u32DatapoolAdrCRC,tU32 u32CalculatedCRC,tU32 u32DatapoolKdsCRC)
{
	
if( etg_bIsTraceActiveShort(((0xFFFFu & (tU16)TUN_TRACE_CLASS_MSGTOADR) << 16) | (tU16)TR_LEVEL_USER_2) == TRUE)
	     {
	  	   ETG_TRACE_USR2(( "\n***********************************************************************************"
	  						 "\n*******************************CRC Info********************************************\n*"
	  						"KDS \t\t Calculated CRC = 0x%08X\t\t Datapool CRC = 0x%08X\n*ADR \t\t    Target CRC = 0x%08X\t\t Datapool CRC = 0x%08X\n*"
	  						"**********************************************************************************",u32CalculatedCRC,u32DatapoolKdsCRC,u32TargetCRC,u32DatapoolAdrCRC));
	     };
}
