/************************************************************************
 * FILE:        tunerMute.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of tunerMute.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "tunerMute.h"

using namespace Mute::MuteHandling;

static const stTunerMuteActive aTunerMuteActive[] =
{
   #define MUTE_ACTIVATE(muteTuningAction, IsEnabled, IsInterrupt, priority, ADRFktId)                  { muteTuningAction, IsEnabled, IsInterrupt, priority, ADRFktId},
   #include "tunerMute.dat"
   #undef MUTE_ACTIVATE
};


bool bIsMuteActionEnabled(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	const int muteSize = sizeof aTunerMuteActive / sizeof(stTunerMuteActive);
	for (int u32Index = 0; u32Index < muteSize; u32Index++)
	{
		if (aTunerMuteActive[u32Index].muteTuningAction == muteTuningAction)
		{
		    return aTunerMuteActive[u32Index].IsEnabled;
		}
	}
	return false;
}

bool bIsMuteActionInterruptable(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	const int muteSize = sizeof aTunerMuteActive / sizeof(stTunerMuteActive);
	for (int u32Index = 0; u32Index < muteSize; u32Index++)
	{
		if (aTunerMuteActive[u32Index].muteTuningAction == muteTuningAction)
		{
		    return aTunerMuteActive[u32Index].IsInterrupt;
		}
	}
	return false;
}

short getMuteActionPriority(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	const int muteSize = sizeof aTunerMuteActive / sizeof(stTunerMuteActive);
	for (int u32Index = 0; u32Index < muteSize; u32Index++)
	{
		if (aTunerMuteActive[u32Index].muteTuningAction == muteTuningAction)
		{
		    return aTunerMuteActive[u32Index].priority;
		}
	}
	return -1;
}

Mute::MuteHandling::enMuteTuningAction getMuteActionIDForADRFktId(unsigned short u16FktId)
{
	const int muteSize = sizeof aTunerMuteActive / sizeof(stTunerMuteActive);
	for (int u32Index = 0; u32Index < muteSize; u32Index++)
	{
		if (aTunerMuteActive[u32Index].ADRFktId == u16FktId)
		{
		    return aTunerMuteActive[u32Index].muteTuningAction;
		}
	}
	return Mute::MuteHandling::NONE;
}

bool bIsMuteFunction(unsigned short u16FktId)
{
	const int muteSize = sizeof aTunerMuteActive / sizeof(stTunerMuteActive);
	for (int u32Index = 0; u32Index < muteSize; u32Index++)
	{
		if (aTunerMuteActive[u32Index].ADRFktId == u16FktId)
		{
		    return true;
		}
	}
	return false;
}