/************************************************************************
 * FILE:        clMuteRequest.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clMuteRequest.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef clMuteInterface_h_
#define clMuteInterface_h_

#include "MuteHandling/muteDatatype.h"

namespace Mute
{
	class clMuteInterface
	{
	public:
		clMuteInterface() {}
		virtual ~clMuteInterface() {}
		virtual void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction TuningAction) = 0;
		virtual void vProcessTunerAction() = 0;
		virtual void vOnAudioMuteRequest() = 0;
		virtual void vOnDemuteSendMethodResult() = 0;
		virtual void vOnTunerStateIdle() = 0;
		virtual void vClearStoredRequest() = 0;
	};
}

#endif
