/************************************************************************
 * FILE:        muteDatatype.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of muteDatatype.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef muteDatatype_h
#define muteDatatype_h

namespace Mute
{
	namespace MuteHandling
	{
		enum enMuteTuningAction
		{
			#define MUTE_TUNINGACTION(muteTuningAction) muteTuningAction,
			#include "muteDatatype.dat"
			#undef MUTE_TUNINGACTION
			MUTETUNINGACTION_UNKNOWN
		};

		enum enMuteAction
		{
			#define MUTE_ACTION(muteAction) muteAction,
			#include "muteDatatype.dat"
			#undef MUTE_ACTION
			MUTEACTION_UNKNOWN
		};

		enum enMuteState
		{
			#define MUTE_STATE(muteState) muteState,
			#include "muteDatatype.dat"
			#undef MUTE_STATE
			MUTESTATE_UNKNOWN
		};

		enum enMuteInterrupt
		{
			#define MUTE_INTERRUPT(muteInterrupt) muteInterrupt,
			#include "muteDatatype.dat"
			#undef MUTE_INTERRUPT
			MUTEINTERRUPT_UNKNOWN
		};

		enum enADRFktID
		{
			#define MUTE_ADRFKTID(adrFktID) adrFktID,
			#include "muteDatatype.dat"
			#undef MUTE_ADRFKTID
			MUTE_ADRFKTID_UNKNOWN
		};

		enum enMuteRequestState
		{
			PENDING,
			ACKNOWLEDGED,
			MUTE_REQUEST_STATE_UNKNOWN
		};
	
		class clEnumMuteTuningAction
		{
		public:
			Mute::MuteHandling::enMuteTuningAction MuteTuningActionType;
			Mute::MuteHandling::enMuteState MuteState;
			Mute::MuteHandling::enMuteRequestState MuteRequestState;
			clEnumMuteTuningAction() { MuteTuningActionType = Mute::MuteHandling::NONE; MuteState = Mute::MuteHandling::MUTESTATE_UNKNOWN; MuteRequestState = Mute::MuteHandling::MUTE_REQUEST_STATE_UNKNOWN; }
			~clEnumMuteTuningAction() { }
			void vClearMuteActionState() { MuteTuningActionType = Mute::MuteHandling::NONE; MuteState = Mute::MuteHandling::MUTESTATE_UNKNOWN; MuteRequestState = Mute::MuteHandling::MUTE_REQUEST_STATE_UNKNOWN; }
			bool bIsMuteRequestPending() { return (MuteRequestState == Mute::MuteHandling::PENDING) ? true : false ; }
		};
	}
	
}

#endif
