/************************************************************************
 * FILE:        clMuteImpl.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clMuteImpl.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef clMuteImpl_h_
#define clMuteImpl_h_

#include "muteDatatype.h"
#include "clMuteControl.h"


namespace Mute
{
	namespace MuteHandling
	{
		class clMuteImpl
		{
		public:
			virtual ~clMuteImpl();
			static clMuteImpl* instance();
			static clMuteImpl* m_poTunerControl;
			void vInit();
			void vDeInit();
			void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction);
			void vOnAudioMuteRequest();
			void vOnNewMuteState(Mute::MuteHandling::enMuteState muteState);
			void vOnTuningActionError(Mute::MuteHandling::enMuteTuningAction enErrorAction);
			Mute::MuteHandling::enMuteTuningAction getCurrentMuteTuningAction();
			Mute::MuteHandling::enMuteTuningAction getNextMuteTuningAction();
		private:
			clMuteImpl();
			Mute::MuteHandling::clMuteControl* muteControl;
		};
	}
}

#endif
