/************************************************************************
 * FILE:        clMuteImpl.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clMuteImpl.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "clMuteImpl.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "clMuteControl.h"

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MUTE_HANDLER
#include "trcGenProj/Header/clMuteImpl.cpp.trc.h"
#endif

using namespace Mute::MuteHandling;

clMuteImpl* clMuteImpl::m_poTunerControl = NULL;

clMuteImpl::clMuteImpl() : muteControl(0) {
	vInit();
}

clMuteImpl::~clMuteImpl() {
	vDeInit();
}

clMuteImpl* clMuteImpl::instance()
{
	if (m_poTunerControl == 0)
	{
		m_poTunerControl = new clMuteImpl();
	}
	return m_poTunerControl;
}

void clMuteImpl::vInit()
{
	ETG_TRACE_USR4(("clMuteImpl::vInit()"));
	muteControl = clMuteControl::instance();
}

void clMuteImpl::vDeInit()
{
	ETG_TRACE_USR4(("clMuteImpl::vDeInit()"));
	muteControl = 0;
}

void clMuteImpl::vOnTuningActionError(Mute::MuteHandling::enMuteTuningAction enErrorAction)
{
    if(muteControl != 0)
    {
        muteControl->vOnTuningActionError(enErrorAction);
    }
}

void clMuteImpl::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	if(muteControl != 0)
	{
		muteControl->vOnNewMuteTunerAction(muteTuningAction);
	}
}

void clMuteImpl::vOnNewMuteState(Mute::MuteHandling::enMuteState muteState)
{
	if(muteControl != 0)
	{
		muteControl->vOnNewMuteState(muteState);
	}
}

void clMuteImpl::vOnAudioMuteRequest()
{
	if(muteControl != 0)
	{
		muteControl->vOnAudioMuteRequest();
		muteControl->vProcessTunerAction(muteControl->getCurrentMuteTuningAction());
	}
}

Mute::MuteHandling::enMuteTuningAction clMuteImpl::getCurrentMuteTuningAction()
{
	if(muteControl != 0)
	{
		return muteControl->getCurrentMuteTuningAction();
	}
	else
	{
		return Mute::MuteHandling::MUTETUNINGACTION_UNKNOWN;
	}
}

Mute::MuteHandling::enMuteTuningAction clMuteImpl::getNextMuteTuningAction()
{
	if(muteControl != 0)
	{
		return muteControl->getNextMuteTuningAction();
	}
	else
	{
		return Mute::MuteHandling::MUTETUNINGACTION_UNKNOWN;
	}
}
