/************************************************************************
 * FILE:        clMuteControl.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clMuteControl.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef clMuteControl_h_
#define clMuteControl_h_

#include "datatypes/tMap.h"
#include "../clMuteInterface.h"
#include "../config/tunerMute.h"

namespace Mute
{
	class clMuteInterface;

	namespace MuteHandling
	{
		class clMuteControl
		{
		public:

			virtual ~clMuteControl();
			static clMuteControl* instance();
			static clMuteControl* m_poMuteControl;

			void vSetMuteTunerImpl(Mute::MuteHandling::enMuteTuningAction muteAction, Mute::clMuteInterface* poImpl);

			void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
			void vProcessTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
			void vProcessMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
			void vOnNewMuteState(Mute::MuteHandling::enMuteState muteState);
			void vSendMuteDemuteRequest(Mute::MuteHandling::enMuteState muteState, bool bInterrupt);
			Mute::MuteHandling::enMuteTuningAction getCurrentMuteTuningAction();
			Mute::MuteHandling::enMuteTuningAction getNextMuteTuningAction();
			void vSendMethodResult(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
			void vOnTuningActionError(Mute::MuteHandling::enMuteTuningAction enErrorAction);
			void vClearStates();
			void vOnAudioMuteRequest();

		private:
			clMuteControl() {}
			Mute::MuteHandling::clEnumMuteTuningAction oCurrentMuteAction;
			Mute::MuteHandling::clEnumMuteTuningAction oNextMuteAction;
			tunerMap<Mute::MuteHandling::enMuteTuningAction, Mute::clMuteInterface*> TunerMuteMap;
			void vHandleNextTuningAction();
			void vCompleteCurrentTuningAction(Mute::MuteHandling::enMuteState muteState, bool bInterrupt);
			bool bIsTuningActionPending();
			bool bIsCurrentAction(Mute::MuteHandling::enMuteTuningAction enErrorAction);
			bool bIsTunerInMuteState();
			bool bIsMuteRequestPending();

		};
	}
}

#endif
