/************************************************************************
 * FILE:          clUserSettingConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clAMFMParameterConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   4-Aug-2015			vnd4kor
				
 *************************************************************************/


#ifndef clUserSettingConfiguration_h
#define clUserSettingConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;


class clUserSettingConfiguration : public clBaseConfigSection 
{

private:
	unsigned char m_u8TPForAudioTuner1;
	unsigned char m_u8TPForAudioTuner2;
	unsigned char m_u8AFBestForAudioTuner1;
	unsigned char m_u8AFBestForAudioTuner2;
	unsigned char m_u8DDAForAudioTuner1;
	unsigned char m_u8DDAForAudioTuner2;
	unsigned char m_u8RDSForAudioTuner1;
	unsigned char m_u8RDSForAudioTuner2;
	unsigned char m_u8StationNameFixForAudioTuner1;
	unsigned char m_u8StationNameFixForAudioTuner2;
	unsigned char m_u8StereoForAudioTuner1;
	unsigned char m_u8StereoForAudioTuner2;
	unsigned char m_u8REGForAudioTuner1;
	unsigned char m_u8REGForAudioTuner2;
	unsigned char m_u8PTY31ForAudioTuner1;
	unsigned char m_u8PTY31ForAudioTuner2;
	unsigned char m_u8DDSForAudioTuner1;
	unsigned char m_u8DDSForAudioTuner2;
	unsigned char m_u8DMQForAudioTuner1;
	unsigned char m_u8DMQForAudioTuner2;
	unsigned char m_u8DemodulationSwitchForAudioTuner1;
	unsigned char m_u8DemodulationSwitchForAudioTuner2;

		
public:
	/**
	 * Constructor
	 */
	clUserSettingConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clUserSettingConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif