/************************************************************************
 * FILE:          clUserSettingConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clUserSettingConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   4-Aug-2015			vnd4kor
				
 *************************************************************************/



#include "TunerApp/ADRConfiguration/clUserSettingConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clUserSettingConfiguration.cpp.trc.h"
#endif


clUserSettingConfiguration::clUserSettingConfiguration() :clBaseConfigSection(enUserSettingConfiguration)
,m_u8TPForAudioTuner1(0)
,m_u8TPForAudioTuner2(0)
,m_u8AFBestForAudioTuner1(0)
,m_u8AFBestForAudioTuner2(0)
,m_u8DDAForAudioTuner1(0)
,m_u8DDAForAudioTuner2(0)
,m_u8RDSForAudioTuner1(0)
,m_u8RDSForAudioTuner2(0)
,m_u8StationNameFixForAudioTuner1(0)
,m_u8StationNameFixForAudioTuner2(0)
,m_u8StereoForAudioTuner1(0)
,m_u8StereoForAudioTuner2(0)
,m_u8REGForAudioTuner1(0)
,m_u8REGForAudioTuner2(0)
,m_u8PTY31ForAudioTuner1(0)
,m_u8PTY31ForAudioTuner2(0)
,m_u8DDSForAudioTuner1(0)
,m_u8DDSForAudioTuner2(0)
,m_u8DMQForAudioTuner1(0)
,m_u8DMQForAudioTuner2(0)
,m_u8DemodulationSwitchForAudioTuner1(0)
,m_u8DemodulationSwitchForAudioTuner2(0)
{
}

clUserSettingConfiguration::~clUserSettingConfiguration()
{
}

void clUserSettingConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8TPForAudioTuner1);
	m_payload.push_back(m_u8TPForAudioTuner2);
	m_payload.push_back(m_u8AFBestForAudioTuner1);
	m_payload.push_back(m_u8AFBestForAudioTuner2);
	m_payload.push_back(m_u8DDAForAudioTuner1);
	m_payload.push_back(m_u8DDAForAudioTuner2);
	m_payload.push_back(m_u8RDSForAudioTuner1);
	m_payload.push_back(m_u8RDSForAudioTuner2);
	m_payload.push_back(m_u8StationNameFixForAudioTuner1);
	m_payload.push_back(m_u8StationNameFixForAudioTuner2);
	m_payload.push_back(m_u8StereoForAudioTuner1);
	m_payload.push_back(m_u8StereoForAudioTuner2);
	m_payload.push_back(m_u8REGForAudioTuner1);
	m_payload.push_back(m_u8REGForAudioTuner2);
	m_payload.push_back(m_u8PTY31ForAudioTuner1);
	m_payload.push_back(m_u8PTY31ForAudioTuner2);
	m_payload.push_back(m_u8DDSForAudioTuner1);
	m_payload.push_back(m_u8DDSForAudioTuner2);
	m_payload.push_back(m_u8DMQForAudioTuner1);
	m_payload.push_back(m_u8DMQForAudioTuner2);
	m_payload.push_back(m_u8DemodulationSwitchForAudioTuner1);
	m_payload.push_back(m_u8DemodulationSwitchForAudioTuner2);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clUserSettingConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8TPForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("TPSwitchAudioTuner1");
	m_u8TPForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("TPSwitchAudioTuner2");
	m_u8AFBestForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("AFSwitchAudioTuner1");
	m_u8AFBestForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("AFSwitchAudioTuner2");
	m_u8DDAForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("DDASwitchAudioTuner1");
	m_u8DDAForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("DDASwitchAudioTuner2");

	
	m_u8RDSForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("RDSSwitchAudioTuner1"); 
	m_u8RDSForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("RDSSwitchAudioTuner1"); 
	m_u8StationNameFixForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("PSFIXSwitchAudioTuner1");
	m_u8StationNameFixForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("PSFIXSwitchAudioTuner2");
	m_u8StereoForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("StereoSwitchAudioTuner1");
	m_u8StereoForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("StereoSwitchAudioTuner1");

	m_u8REGForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("REGSwitchAudioTuner1");
	m_u8REGForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("REGSwitchAudioTuner2");
	m_u8PTY31ForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("PTY31SwitchAudioTuner1");
	m_u8PTY31ForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("PTY31SwitchAudioTuner2");
	m_u8DDSForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("DDSSwitchAudioTuner1");
	m_u8DDSForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("DDSSwitchAudioTuner2");
	m_u8DMQForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("DMQSwitchAudioTuner1");
	m_u8DMQForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("DMQSwitchAudioTuner2");
	m_u8DemodulationSwitchForAudioTuner1 = (tU8)poclConfigInterface->u32GetConfigData("DemodulationSwitchAudioTuner1");
	m_u8DemodulationSwitchForAudioTuner2 = (tU8)poclConfigInterface->u32GetConfigData("DemodulationSwitchAudioTuner2");
}

tunerVector<unsigned char> clUserSettingConfiguration::oGetPayload()
{
	return m_payload;
}

short clUserSettingConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clUserSettingConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clUserSettingConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));
	
	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 2 -> \n m_u8TPForAudioTuner1 = 0x%02X \n m_u8TPForAudioTuner2 = 0x%02X \n "\
		"m_u8AFBestForAudioTuner1 = 0x%02X \n m_u8AFBestForAudioTuner2 = 0x%02X ",\
		m_u8TPForAudioTuner1,m_u8TPForAudioTuner2,m_u8AFBestForAudioTuner1,m_u8AFBestForAudioTuner2));
	
	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 3 -> \n m_u8DDAForAudioTuner1 = 0x%02X \n m_u8DDAForAudioTuner2 = 0x%02X \n "\
		"m_u8RDSForAudioTuner1 = 0x%02X \n m_u8RDSForAudioTuner2 = 0x%02X ",\
		m_u8DDAForAudioTuner1,m_u8DDAForAudioTuner2,m_u8RDSForAudioTuner1,m_u8RDSForAudioTuner2));
	
	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 4 -> \n m_u8StationNameFixForAudioTuner1 = 0x%02X \n m_u8StationNameFixForAudioTuner2 = 0x%02X \n "\
		"m_u8StereoForAudioTuner1 = 0x%02X \n m_u8StereoForAudioTuner2 = 0x%02X ",\
		m_u8StationNameFixForAudioTuner1,m_u8StationNameFixForAudioTuner2,m_u8StereoForAudioTuner1,m_u8StereoForAudioTuner2));
	
	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 5 -> \n m_u8REGForAudioTuner1 = 0x%02X \n m_u8REGForAudioTuner2 = 0x%02X \n "\
		"m_u8PTY31ForAudioTuner1 = 0x%02X \n m_u8PTY31ForAudioTuner2 = 0x%02X ",\
		m_u8REGForAudioTuner1,m_u8REGForAudioTuner2,m_u8PTY31ForAudioTuner1,m_u8PTY31ForAudioTuner2));

	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 6 -> \n m_u8DDSForAudioTuner1 = 0x%02X \n m_u8DDSForAudioTuner2 = 0x%02X \n "\
		"m_u8DMQForAudioTuner1 = 0x%02X \n m_u8DMQForAudioTuner2 = 0x%02X ",\
		m_u8DDSForAudioTuner1,m_u8DDSForAudioTuner2,m_u8DMQForAudioTuner1,m_u8DMQForAudioTuner2));

	ETG_TRACE_USR2(( "clUserSettingConfiguration::vTrace() part 7 -> \n m_u8DemodulationSwitchForAudioTuner1 = 0x%02X \n m_u8DemodulationSwitchForAudioTuner2 = 0x%02X ",\
		m_u8DemodulationSwitchForAudioTuner1,m_u8DemodulationSwitchForAudioTuner2));
}