/************************************************************************
 * FILE:          clTuningBehaviourConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTuningBehaviourConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   4-Aug-2015			vnd4kor
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clTuningBehaviourConfiguration.h"

#include "tun_Config.h"

#include "kdsconfig/clConfigInterface.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTuningBehaviourConfiguration.cpp.trc.h"
#endif

#define UNUSED_BYTE 0xaa

clTuningBehaviourConfiguration::clTuningBehaviourConfiguration() :clBaseConfigSection(enTuningBehaviourConfiguration), 
m_u8MaxNumberOfSeekPeriods(0),
m_u8TimeInSecondsForScanIntervals(0),
m_u8Unused1(0),
m_u8StrategyForTPSeek(0),
m_u32PTYCodesForSeekFilter(0),
m_u16DelayInMilliSecondsBetweenTwoSeekSteps(0),
m_u16DelayInMilliSecondsBetweenTwoPermanentManualSteps(0),
m_u8Unused2(0),
m_u8TuningBehaviourSwitches(0),
m_u16MuteRamp1(0),
m_u16DemuteRamp1(0),
m_u16MuteRamp2(0),
m_u16DemuteRamp2(0)
{
}

clTuningBehaviourConfiguration::~clTuningBehaviourConfiguration()
{
}

void clTuningBehaviourConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8MaxNumberOfSeekPeriods);
	m_payload.push_back(m_u8TimeInSecondsForScanIntervals);
	m_payload.push_back(m_u8Unused1);
	m_payload.push_back(m_u8StrategyForTPSeek);
	vAddInt(m_payload , m_u32PTYCodesForSeekFilter);
	vAddShort(m_payload, m_u16DelayInMilliSecondsBetweenTwoSeekSteps);
	vAddShort(m_payload, m_u16DelayInMilliSecondsBetweenTwoPermanentManualSteps);
	m_payload.push_back(m_u8Unused2);
	m_payload.push_back(m_u8TuningBehaviourSwitches);
	vAddShort(m_payload, m_u16MuteRamp1);
	vAddShort(m_payload, m_u16DemuteRamp1);
	vAddShort(m_payload, m_u16MuteRamp2);
	vAddShort(m_payload, m_u16DemuteRamp2);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();
	vAddNumberOfBytesInSectionToPayload(m_payload);	

	vAddSectionIdToPayload(m_payload);
}

void clTuningBehaviourConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8MaxNumberOfSeekPeriods                              = (unsigned char)poclConfigInterface->u32GetConfigData("NumberOfSeekPeriods");
	m_u8TimeInSecondsForScanIntervals 					    = (unsigned char)poclConfigInterface->u32GetConfigData("ScanTime");
	m_u8Unused1											    = UNUSED_BYTE;
	m_u8StrategyForTPSeek           					    = (unsigned char)poclConfigInterface->u32GetConfigData("FMTPseekStrategy");
	m_u32PTYCodesForSeekFilter       					    = (unsigned int)poclConfigInterface->u32GetConfigData("PtyFilterForSeek");
	m_u16DelayInMilliSecondsBetweenTwoSeekSteps        		= (unsigned short)poclConfigInterface->u32GetConfigData("AutoSeekStepDelay");
	m_u16DelayInMilliSecondsBetweenTwoPermanentManualSteps  = (unsigned short)poclConfigInterface->u32GetConfigData("PermanentManualStepDelay");
	m_u8Unused2					  = UNUSED_BYTE;
	m_u8TuningBehaviourSwitches   = (unsigned char)potun_Config->u8GetTuningBehaviourSwitches();
	m_u16MuteRamp1                = (unsigned short)poclConfigInterface->u32GetConfigData("MuteRamp1");
	m_u16DemuteRamp1              = (unsigned short)poclConfigInterface->u32GetConfigData("DemuteRamp1");
	m_u16MuteRamp2                = (unsigned short)poclConfigInterface->u32GetConfigData("MuteRamp2");
	m_u16DemuteRamp2              = (unsigned short)poclConfigInterface->u32GetConfigData("DemuteRamp2");
}

tunerVector<unsigned char> clTuningBehaviourConfiguration::oGetPayload()
{
	return m_payload;
}

short clTuningBehaviourConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clTuningBehaviourConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clTuningBehaviourConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clTuningBehaviourConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));
	
	ETG_TRACE_USR2(( "clTuningBehaviourConfiguration::vTrace() part 2 -> \n m_u8MaxNumberOfSeekPeriods = %d s \n m_u8TimeInSecondsForScanIntervals = %d s \n "\
		"m_u8StrategyForTPSeek = %d \n m_u32PTYCodesForSeekFilter = 0x%08X \n m_u16DelayInMilliSecondsBetweenTwoSeekSteps = %d ms ",\
		m_u8MaxNumberOfSeekPeriods,m_u8TimeInSecondsForScanIntervals,m_u8StrategyForTPSeek,m_u32PTYCodesForSeekFilter,m_u16DelayInMilliSecondsBetweenTwoSeekSteps ));
	
	ETG_TRACE_USR2(( "clTuningBehaviourConfiguration::vTrace() part 3 -> \n m_u16DelayInMilliSecondsBetweenTwoPermanentManualSteps = %d ms \n m_u8TuningBehaviourSwitches = 0x%02x \n "\
		"m_u16MuteRamp1 = 0x%04X \n m_u16DemuteRamp1 =0x%04X \n m_u16MuteRamp2 = 0x%04X \n m_u16DemuteRamp2 = 0x%04X \n",\
		m_u16DelayInMilliSecondsBetweenTwoPermanentManualSteps,m_u8TuningBehaviourSwitches,m_u16MuteRamp1,m_u16DemuteRamp1,m_u16MuteRamp2,m_u16DemuteRamp2 ));
}