/************************************************************************
 * FILE:          clTimerConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTimerConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   4-Aug-2015			vnd4kor
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clTimerConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTimerConfiguration.cpp.trc.h"
#endif


clTimerConfiguration::clTimerConfiguration() :clBaseConfigSection(enTimerConfiguration) 
,m_u8TScanRadio(0)
,m_u8TInhibitListSortAfterSkip(0)
,m_u8TDelayTPStationSelectAfterVolZero(0)
,m_u8TDelayNoTPStationFound(0)
,m_u8TNonRDSDetect(0)
,m_u8PSDeleteAfterRDSLost(0)
,m_u8TWrongPIAccept(0)
,m_u8TScrollPSDetect(0)
,m_u8TDelayTPStationSelectAfterRDSLost(0)
,m_u8TTAEndAfterRDSLost(0)
,m_u8TAMMinTuneTime(0)
,m_u8TCursorDelayAfterStationSelect(0)
,m_u8TAFInhibitAfterManualTune(0)
,m_u8TAcceptPIAfterRecall(0)
,m_u8TPTYHold(0)
{
}

clTimerConfiguration::~clTimerConfiguration()
{
}

void clTimerConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8TScanRadio);
	m_payload.push_back(m_u8TInhibitListSortAfterSkip);
	m_payload.push_back(m_u8TDelayTPStationSelectAfterVolZero);
	m_payload.push_back(m_u8TDelayNoTPStationFound);
	m_payload.push_back(m_u8TNonRDSDetect);
	m_payload.push_back(m_u8PSDeleteAfterRDSLost);
	m_payload.push_back(m_u8TWrongPIAccept);
	m_payload.push_back(m_u8TScrollPSDetect);
	m_payload.push_back(m_u8TDelayTPStationSelectAfterRDSLost);
	m_payload.push_back(m_u8TTAEndAfterRDSLost);
	m_payload.push_back(m_u8TAMMinTuneTime);
	m_payload.push_back(m_u8TCursorDelayAfterStationSelect);
	m_payload.push_back(m_u8TAFInhibitAfterManualTune);
	m_payload.push_back(m_u8TAcceptPIAfterRecall);
	m_payload.push_back(m_u8TPTYHold);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
}

void clTimerConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8TScanRadio						  = (tU8)poclConfigInterface->u32GetConfigData("ScanTime");

	m_u8TInhibitListSortAfterSkip		  = (tU8)poclConfigInterface->u32GetConfigData("TInhibitListSortAfterSkip");
	m_u8TDelayTPStationSelectAfterVolZero = (tU8)poclConfigInterface->u32GetConfigData("TimeDelayFMTPStnAftVolZero");
	m_u8TDelayNoTPStationFound			  = (tU8)poclConfigInterface->u32GetConfigData("TimeDelayNoFMTPStnFound");
	m_u8TNonRDSDetect					  = (tU8)poclConfigInterface->u32GetConfigData("TimerNonRDSDetect");
	m_u8PSDeleteAfterRDSLost			  = (tU8)poclConfigInterface->u32GetConfigData("TimerPSDelAfterRDSLost");
	m_u8TWrongPIAccept 					  = (tU8)poclConfigInterface->u32GetConfigData("WrongPiAcceptAfterStationLost");
	m_u8TScrollPSDetect 				  = (tU8)poclConfigInterface->u32GetConfigData("TimerScrollPSDetect");
	m_u8TDelayTPStationSelectAfterRDSLost = (tU8)poclConfigInterface->u32GetConfigData("TimeDelayFMTPStnSelAftRDSLost");
	m_u8TTAEndAfterRDSLost				  = (tU8)poclConfigInterface->u32GetConfigData("TimeFMTAEndAftRDSLost");

	m_u8TAMMinTuneTime					  = (tU8)poclConfigInterface->u32GetConfigData("TimerAMMinTunTime");

	m_u8TCursorDelayAfterStationSelect    = (tU8)poclConfigInterface->u32GetConfigData("TCursorDelayAfterStationSelect");

	m_u8TAFInhibitAfterManualTune 		  = (tU8)poclConfigInterface->u32GetConfigData("AFBestDelayTimeAfterManualTuning");

	m_u8TAcceptPIAfterRecall			  = (tU8)poclConfigInterface->u32GetConfigData("WrongPiAcceptDelayAfterStationSelection");
	m_u8TPTYHold  						  = (tU8)poclConfigInterface->u32GetConfigData("TimePTYHold");
}

tunerVector<unsigned char> clTimerConfiguration::oGetPayload()
{
	return m_payload;
}

short clTimerConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clTimerConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}


void clTimerConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clTimerConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clTimerConfiguration::vTrace() part 2 -> \n m_u8TScanRadio = %d s \n m_u8TInhibitListSortAfterSkip = %d s \n "\
		"m_u8TDelayTPStationSelectAfterVolZero = %d s \n m_u8TDelayNoTPStationFound = %d s \n m_u8TNonRDSDetect = %d s ",\
		m_u8TScanRadio,m_u8TInhibitListSortAfterSkip,m_u8TDelayTPStationSelectAfterVolZero,m_u8TDelayNoTPStationFound,m_u8TNonRDSDetect ));
	
	ETG_TRACE_USR2(( "clTimerConfiguration::vTrace() part 3 -> \n m_u8PSDeleteAfterRDSLost = %d s \n m_u8TWrongPIAccept = %d s \n "\
		"m_u8TScrollPSDetect = %d s \n m_u8TDelayTPStationSelectAfterRDSLost = %d s \n m_u8TTAEndAfterRDSLost = %d s ",\
		m_u8PSDeleteAfterRDSLost,m_u8TWrongPIAccept,m_u8TScrollPSDetect,m_u8TDelayTPStationSelectAfterRDSLost,m_u8TTAEndAfterRDSLost ));
	
	ETG_TRACE_USR2(( "clTimerConfiguration::vTrace() part 4 -> \n m_u8TAMMinTuneTime = %d s \n m_u8TCursorDelayAfterStationSelect = %d s \n "\
		"m_u8TAFInhibitAfterManualTune = %d s \n m_u8TAcceptPIAfterRecall = %d s \n m_u8TPTYHold = %d s ",\
		m_u8TAMMinTuneTime,m_u8TCursorDelayAfterStationSelect,m_u8TAFInhibitAfterManualTune,m_u8TAcceptPIAfterRecall,m_u8TPTYHold ));
}