/************************************************************************
 * FILE:          clReceptionBehaviourConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clReceptionBehaviourConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/

#ifndef clReceptionBehaviourConfiguration_h
#define clReceptionBehaviourConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;



class clReceptionBehaviourConfiguration : public clBaseConfigSection 
{

private:
	unsigned char m_u8FieldStrengthSeekLevelFMRDS;
	unsigned char m_u8QualitySeekLevelFMRDS;
	unsigned char m_u8FieldStrengthSeekLevelFMNonRDS;
	unsigned char m_u8QualitySeekLevelFMNonRDS;
	unsigned char m_u8FieldStrengthSeekLevelLW;
	unsigned char m_u8QualitySeekLevelLW;
	unsigned char m_u8FieldStrengthSeekLevelMW;
	unsigned char m_u8QualitySeekLevelMW;
	unsigned char m_u8FieldStrengthSeekLevelSW;
	unsigned char m_u8QualitySeekLevelSW;
	unsigned char m_u8FieldStrengthSeekLevelTRF;
	unsigned char m_u8QualitySeekLevelTRF;
	unsigned char m_u8FieldStrengthSeekLevelWB;
	unsigned char m_u8QualitySeekLevelWB;
	unsigned char m_u8FieldStrengthListLevelFMRDS;
	unsigned char m_u8QualityListLevelFMRDS;
	unsigned char m_u8FieldStrengthListLevelFMNonRDS;
	unsigned char m_u8QualityListLevelFMNonRDS;
	unsigned char m_u8FieldStrengthListLevelLW;
	unsigned char m_u8QualityListLevelLW;
	unsigned char m_u8FieldStrengthListLevelMW;
	unsigned char m_u8QualityListLevelMW;
	unsigned char m_u8FieldStrengthListLevelSW;
	unsigned char m_u8QualityListLevelSW;
	unsigned char m_u8FieldStrengthListLevelTRF;
	unsigned char m_u8QualityListLevelTRF;
	unsigned char m_u8FieldStrengthListLevelWB;
	unsigned char m_u8QualityListLevelWB;
	unsigned char m_u8FMSharx;
	unsigned char m_u8AMSharx;
	unsigned char m_u8FMHicut;
	unsigned char m_u8AMHicut;

		
public:
	/**
	 * Constructor
	 */
	clReceptionBehaviourConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clReceptionBehaviourConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif