/************************************************************************
 * FILE:          clRDSParameterConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clRDSParameterConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/


#ifndef clRDSParameterConfiguration_h
#define clRDSParameterConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;


class clRDSParameterConfiguration : public clBaseConfigSection 
{

private:
	unsigned char m_u8ExchangeAntennaLevel;
	unsigned char m_u8PITestLevel;
	unsigned char m_u8NRDSLevel;
	unsigned char m_u8EONLevel;
	unsigned char m_u8FMMemoLevel;
	unsigned char m_u8PanicFieldstrengthLevel;
	unsigned char m_u8ParamRDSLevel;
	unsigned char m_u8RDSDataAcceptLevel;
	unsigned char m_u8PIStepLevel;
	unsigned char m_u8DDAAntennaDistLevel;
	unsigned char m_u8RDSSynDelayCnt;
	unsigned char m_u8MPMeasureLevel;
	unsigned char m_u8MPLevel2Level;
	unsigned char m_u8MPVeryBadLevel;
	unsigned char m_u8MPMediumLevel;
	unsigned char m_u8RDSBadLevel;
	unsigned char m_u8IllegalAF;
	unsigned char m_u8AFSaveLevel;
	unsigned char m_u8FirstRundum;
	unsigned char m_u8SecondRundum;
	unsigned char m_u8ThirdRundum;
	unsigned char m_u8PIStepMode;
	unsigned char m_u8AudioOffScanMode;
	unsigned char m_u8AMLearnCycle;
	unsigned char m_u8PIIgnore;
	unsigned char m_u8PISearchTime;
	unsigned char m_u8DisableSeamlessBlending;
	unsigned char m_u8SlAdjThreshold;
	unsigned char m_u8SlMPThreshold;
	unsigned char m_u8SpecialFMStartFrequency;
	unsigned char m_u8FMSharxLimit;
	unsigned char m_u8HDScanEveryFreq;
	unsigned char m_u8HWSubConfig;
	unsigned char m_u8FM2DABDelayTime;
		
public:
	/**
	 * Constructor
	 */
	clRDSParameterConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clRDSParameterConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif