/************************************************************************
 * FILE:          clPresetListConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clPresetListConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/


#ifndef clPresetListConfiguration_h
#define clPresetListConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;


class clPresetListConfiguration : public clBaseConfigSection 
{

private:
	unsigned char m_u8NumberOfFMPresetBank;
	unsigned char m_u8NumberOfFMPresetsPerBank;
	unsigned char m_u8NumberOfPresetsPerFMASTBank;
	unsigned char m_u8NumberOfMWPresetBank;
	unsigned char m_u8NumberOfMWPresetPerBank;
	unsigned char m_u8NumberOfLWPresetBank;
	unsigned char m_u8NumberOfLWPresetPerBank;
	unsigned char m_u8NumberOfMixedPresetBank;
	unsigned char m_u8NumberOfMixedPresetPerBank;
	unsigned char m_u8NumberOfDRMPresetBank;
	unsigned char m_u8NumberOfDRMPresetPerBank;
	
	tun_Config* m_potun_Config;

	clConfigInterface* m_poclConfigInterface;
		
public:
	/**
	 * Constructor
	 */
	clPresetListConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clPresetListConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);

	void vAddPresetListToPayload(unsigned char u8Band,unsigned char u8NumberOfPresetsPerBank, unsigned char u8PresetIndex);
	
	void vTracePresetList(unsigned char u8Band,unsigned char u8NumberOfPresetsPerBank, unsigned char u8PresetIndex);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif