/************************************************************************
 * FILE:          clHDParameterConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clHDParameterConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/



#ifndef clHDParameterConfiguration_h
#define clHDParameterConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;

class clHDParameterConfiguration : public clBaseConfigSection 
{

private:
  unsigned char m_u8BlendThresholdFMHybrid;
  unsigned short m_u16DigiAudioScalingFMHybrid;
  unsigned short m_u16DigiAudioDelayFMHybridPrimaryBBRate;
  unsigned char m_u8BlendRateFMHybrid;			
  unsigned char m_u8BlendThresholdAMHybrid;			
  unsigned short m_u16AM_MPSAudioScaling;					
  unsigned char m_u8AM_MPSBlendRate;						
  unsigned short m_u16DigiAudioDelayAM_MPSPrimaryBBRate;    
  unsigned char m_u8DigiAudioPhaseInversion;				
  unsigned char m_u8BlendDecision;						
  unsigned char m_u8FM_CDNO_BlendDecision;				
  unsigned char m_u8AM_CDNO_BlendDecision;	
  unsigned char m_u8FMSPSBlendThreshold;
  unsigned short m_u16FMSPSAudioScaling;
  unsigned char m_u8FMSPSBlendRate;
  unsigned char m_u8BallgameModeAudioOutput;
  unsigned char m_u8FilteredDSQMTimeConstant;
  unsigned char m_u8EZBlendEnable;
  unsigned short m_u16DSQMSeekThreshold;

public:
	/**
	 * Constructor
	 */
	clHDParameterConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clHDParameterConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif