/************************************************************************
 * FILE:           clEndOfConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clEndOfConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clEndOfConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clEndOfConfiguration.cpp.trc.h"
#endif


clEndOfConfiguration::clEndOfConfiguration() :clBaseConfigSection(enEndOfConfiguration)
{
}

clEndOfConfiguration::~clEndOfConfiguration()
{
}

void clEndOfConfiguration::vSerialize()
{	
	m_payload.clear();
	m_payload.push_back((unsigned char)m_enSectionID);
}

void clEndOfConfiguration::vSetParameters(tun_Config* /*m_potun_Config*/ , clConfigInterface* /*poclConfigInterface*/)
{
	m_u16NumberOfBytesInSection = 0;
}

tunerVector<unsigned char> clEndOfConfiguration::oGetPayload()
{
	return m_payload;
}

short clEndOfConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clEndOfConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clEndOfConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clEndOfConfiguration::vTrace() END OF CONFIGURATION -> \n************************************\n* Section Id \t\t\t\t\t= %d *"\
					 "\n************************************",m_enSectionID));
}
