/************************************************************************
 * FILE:        clBaseConfigSection.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clBaseConfigSection.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef clBaseConfigSection_h
#define clBaseConfigSection_h

class tun_Config;
class clConfigInterface;

#include "ADRMsg/clByteConverter.h"
#include "datatypes/tVector.h"

typedef enum {
	enTuningBehaviourConfiguration = 1,
	enATStationInfoConfiguration = 2,
	enTimerConfiguration = 3,
	enReceptionBehaviourConfiguration = 4,
	enBandSetupConfiguration = 5,
	enUserSettingConfiguration = 6,
	enAMFMTuningParameterConfiguration = 7,
	enRDSParameterConfiguration = 8,
	enTestmodeAndAFListConfiguration = 9,
	enStationListConfiguration = 10,
	enHDParameterConfiguration = 11,
	enDRMParameterConfiguration = 12,
	enPresetListConfiguration = 13,
	enHardwareReleatedConfiguration = 14,
	enAnnouncementConfiguration = 15,
	enEndOfConfiguration = 255

}enConfigSectionID;


class clBaseConfigSection : public clByteConverter
{

public:

	enConfigSectionID m_enSectionID;
	unsigned short m_u16NumberOfBytesInSection;
	tunerVector<unsigned char> m_payload;

	clBaseConfigSection(enConfigSectionID enSectionID):m_enSectionID(enSectionID)
	{
		m_u16NumberOfBytesInSection = 0;
	}

	virtual ~clBaseConfigSection() {}

	/**
	 * returns the size of the data stream
	 */
	virtual void vSerialize() =0;
	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize() =0;
	/**
	 * contructs the payload object using the bitstream
	 * 
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream) = 0;
	
	virtual tunerVector<unsigned char> oGetPayload() = 0;
	
	virtual void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface) = 0;

	void vAddSectionIdToPayload(tunerVector<unsigned char>& oPayload)
	{
		oPayload.insert(oPayload.begin(),(unsigned char)m_enSectionID); 
	}

	void vAddNumberOfBytesInSectionToPayload(tunerVector<unsigned char>& oPayload)
	{
		oPayload.insert(oPayload.begin(),getLSB(m_u16NumberOfBytesInSection)); 
		oPayload.insert(oPayload.begin(),getMSB(m_u16NumberOfBytesInSection)); 
	}

	virtual void vTrace() = 0;
};

#endif