/************************************************************************
 * FILE:          clAMFMParameterConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clAMFMParameterConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef clAMFMParameterConfiguration_h
#define clAMFMParameterConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;


class clAMFMParameterConfiguration : public clBaseConfigSection 
{

private:
  unsigned char m_u8FMChannelSeperation;   
  unsigned char m_u8FMLimiting;               
  unsigned char m_u8FMMultipath;              
  unsigned char m_u8FMSoftmute;               
  unsigned char m_u8AMSoftmute;               
  unsigned char m_u8FMHicutConfiguration;    
  unsigned char m_u8AMHicutConfiguration;    
  unsigned char m_u8FMDeemphasis;             
  unsigned char m_u8AMDeemphasis;             
  unsigned char m_u8FMFrequencyResponse;     
  unsigned char m_u8AMFrequencyResponse;     
  unsigned char m_u8FMMiscellaneous;          
  unsigned char m_u8AMMiscellaneous;          
  unsigned char m_u8AMAntennaAttenuation;    
  unsigned char m_u8FMAntennaAttenuation;    
  unsigned char m_u8AMFMHicutExtender;
  unsigned char m_u8FMSoftmuteTiming;
  unsigned char m_u8AMFMMiscellaneous2;
  unsigned char m_u8FMHicutExtenderFieldstrengthThreshold;
  unsigned char m_u8FMHicutExtenderFilterOffset;
  unsigned char m_u8FMChannelSeperationMaximum;
  unsigned char m_u8FMChannelSeperationTiming;
  unsigned char m_u8FMHicutFieldstrengthThreshold;
  unsigned char m_u8FMHicutTiming;
  unsigned char m_u8DMQSensitivity;
  unsigned char m_u8FMDeviationAdaptation;
  unsigned char m_u8AMNoiseBlanker228kHzSensitivity;
  unsigned char m_u8AMNoiseBlanker45_6kHzSensitivity;
  unsigned char m_u8AMHicutExtenderFieldStrengthThreshold;
  unsigned char m_u8AMHicutExtenderFilterOffset;
		
public:
	/**
	 * Constructor
	 */
	clAMFMParameterConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clAMFMParameterConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif