/************************************************************************
* FILE:         tuner_servce.cpp
* PROJECT:      Ford H/L RNS
* SW-COMPONENT: Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Tuner Server
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 17.10.04  | CM-DI/ESA2 Wersuhn           | initial version
* 14.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Configured as Tuner server.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/



//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"   



//#include "tun_Utility.h"
#include "tun_MessageQ.h"

#include "tun_main.h"
#include "tun_MsgToADR.h"

#include "tun_Manager.h"

#include "tun_MsgDispatcher.h"
#include "tun_service.h"


#include "tun_trace.h"
#include "tun_hmi_fid_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNTCLSRV
#include "trcGenProj/Header/tun_service.cpp.trc.h"
#endif


/* +++
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
+++ */
BEGIN_MSG_MAP(tuner_tclservice,              ahl_tclBaseWork)

/*--  HMI Handlers  --*/
ON_MESSAGE( FID_TUN_S_SET_STATIC_LIST,           vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_G_TUNER_DATA,                vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_G_STATION_DATA,              vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_STATIC_LIST_ELEMENT,       vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_S_ATFREQUENCY,               vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_ATSEEK,                    vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_S_SET_FEATURE,               vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_SET_FEATURE,               vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_SCAN_BAND,                 vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_S_AFLIST_V2,                 vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_AFLIST_V2,                 vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_AFLIST_V2_ELEMENT,         vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_G_GET_DATA_TESTMODE,         vHandleMessageFromHMI  ) 
ON_MESSAGE( FID_TUN_S_SET_HICUT,                 vHandleMessageFromHMI  ) 
ON_MESSAGE( FID_TUN_G_SET_HICUT,                 vHandleMessageFromHMI  ) 

ON_MESSAGE( FID_TUN_S_OPERATION,                 vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_OPERATION,                 vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_STOP_ANNOUNCEMENT,         vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_DIRECT_FREQUENCY,          vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_S_AUTOSTORE_STATIC_LIST,     vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_SEL_LIST_ELEM,             vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_SAVE_STATIC_LIST_ELEM,     vHandleMessageFromHMI  )

ON_MESSAGE( FID_TUN_S_MAKE_CONFIG_LIST,          vHandleMessageFromHMI)
ON_MESSAGE( FID_TUN_G_MAKE_CONFIG_LIST,          vHandleMessageFromHMI)

ON_MESSAGE( FID_TUN_G_CONFIG_LIST_ELEM,          vHandleMessageFromHMI)

ON_MESSAGE( FID_TUN_S_AUDIO_FG_BG_NEW,           vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_AUDIO_FG_BG_NEW,           vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_S_SET_PI,                    vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_TUNER_SEEKMODE,            vHandleMessageFromHMI  ) 
ON_MESSAGE( FID_TUN_S_SET_SHARXLEVEL,            vHandleMessageFromHMI  )
ON_MESSAGE( FID_TUN_G_SET_SHARXLEVEL,            vHandleMessageFromHMI  ) 
/*-----------------------------------------------------------------------*/

END_MSG_MAP()


/*************************************************************************
*
* FUNCTION: tuner_tclservice::tuner_tclservice(tuner_tclApp* poGWMainApp)
* 
* DESCRIPTION: constructor, creates object tuner_tclservice - object
*
* PARAMETER: tuner_tclApp* poGWMainApp: main - object of this application 
*
* RETURNVALUE: none
*
*************************************************************************/
tuner_tclservice::tuner_tclservice(tuner_tclApp* potunerMainApp)
{
 /* ---
   this constructor calls ( impicit ) the constructor of the upper class ( framework )
   so it registers the combinations of FID and message handler with the framework
   --- */
   poGWMain     = potunerMainApp;
   poNotTable   = potunerMainApp->_poNotTable;
   hNotTableSem = tuner_tclApp::_hNotTableSem;

   _oActivityLock.bInit();
}


/*************************************************************************
*
* FUNCTION: tuner_tclservice::~tuner_tclservice()
* 
* DESCRIPTION: Destructor
*
* PARAMETER: tnone 
*
* RETURNVALUE: none
*
*************************************************************************/
tuner_tclservice::~tuner_tclservice() 
{
   _oActivityLock.bDestroy();

   poGWMain = NULL;

   poNotTable = NULL;

 
}



/*************************************************************************
*
* FUNCTION:tVoid tuner_tclservice::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
* 
* DESCRIPTION: handle unkown message
*
* PARAMETER:  unkown message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclservice::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
{
  /* +++
   the frame work call this function when it receives a message with a unknown 
   FID. You can use it for error handling.
  +++ */

  /* Delete the message */
  if( poMessage != NULL )
  {
    poMessage->bDelete();
  }
  
}




/*************************************************************************
*
* FUNCTION: tVoid tuner_tclservice::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
* 
* DESCRIPTION: handles state - change messages form the spm
*
* PARAMETER: old state, new state
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclservice::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)const
{
   switch(u32AppState)
   {
   case AMT_C_U32_STATE_NORMAL:
      {
         if(u32OldAppState == AMT_C_U32_STATE_NORMAL) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tuner_tclApp )
         +++ */
         
         break;
      }
   case AMT_C_U32_STATE_DIAGNOSIS:
      {
         if(u32OldAppState == AMT_C_U32_STATE_DIAGNOSIS) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tuner_tclApp )
         +++ */
         
         break;
      }
   case AMT_C_U32_STATE_PAUSE:
      {
         if(u32OldAppState == AMT_C_U32_STATE_PAUSE) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tuner_tclApp )
         +++ */
         
         break;
      }
   case AMT_C_U32_STATE_OFF:
      {
         if(u32OldAppState == AMT_C_U32_STATE_OFF) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tuner_tclApp )
         +++ */
         
         break;
      }
   default:
      {
         /* +++
         unkown power state:
         enter error handling here ( trace or assert )
         +++ */
         break;
      }
   }
}






/*************************************************************************
*
* FUNCTION: tVoid tuner_tclservice::bSendStatus(tU16 u16FID ,tU8 Value)
* 
* DESCRIPTION: sends an status - message
*
* PARAMETER: Function - ID and data to send
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclservice::bSendStatus(tU16 u16FID ,tU8 u8Value)const
{


  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T16 _ u16FID _
                                                ET_EN_T8  _ u8Value _ ET_EN_DONE);
}





/*************************************************************************
*
* FUNCTION: tVoid tuner_tclservice::bSendAnswer
* 
* DESCRIPTION: sends an answer message
*
* PARAMETER: message to be answered, data, opcode of the answer
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclservice::bSendAnswer
(
 const amt_tclServiceData* poMessage, 
 tU8 u8Value, 
 tU8 u8Opcode
 )const
{
  /* Code kept for future use. */

  if( poMessage == NULL )
  {
    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T16 _\
                       TUN_TRACE_TCLSERVICE_INVALID_PARA _ ET_EN_DONE);

  }
  
 
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T8 _  u8Value _
                                                ET_EN_T8  _ u8Opcode _ ET_EN_DONE);

}

/*************************************************************************
*
* FUNCTION: tVoid dl_tclApp::vSendError
* 
* DESCRIPTION: sends an error - message
*
* PARAMETER: data for addressing the message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclservice::vSendError
( 
 tU16 u16AMTErrorCode,
 tU16 u16TMCErrorCode,
 tU16 u16FID,
 tU16 u16RegisterID
 ) const
{
   /* Code kept for future use. */
 
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T16 _  u16AMTErrorCode _
                                                ET_EN_T16 _  u16TMCErrorCode _
                                                ET_EN_T16 _  u16FID _
                                                ET_EN_T16 _  u16RegisterID _
                                                ET_EN_DONE);
   

   
}



/*************************************************************************
*
* FUNCTION: tBool tuner_tclservice::bUpreg
* 
* DESCRIPTION: insert the sender of the message to the NotifcationTable
*              (i.e. register this client)
*
* PARAMETER: amt_tclServiceData* poMessage: upreg request message
*
* RETURNVALUE: void
*
*************************************************************************/
tBool tuner_tclservice::bUpreg( const amt_tclServiceData* poMessage )const
{
   tBool bRegOpStatus = FALSE; 

  if( poMessage == NULL )
  {
    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T16 _\
                       TUN_TRACE_TCLSERVICE_INVALID_PARA _ ET_EN_DONE);

  }   
   

  /* Code kept for future use. */
      
   return bRegOpStatus;
}

/*************************************************************************
*
* FUNCTION: tBool tuner_tclservice::bRelUpreg
* 
* DESCRIPTION: remove the sender of the message from the NotifcationTable
*              (i.e. unregister this client)
*
* PARAMETER: amt_tclServiceData* poMessage: relupreg request message
*
* RETURNVALUE: void
*
*************************************************************************/
tBool tuner_tclservice::bRelUpreg( const amt_tclServiceData* poMessage )const
{
   tBool bRegOpStatus = FALSE;      
   
   if( poMessage == NULL )
   {
     ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T16 _\
                        TUN_TRACE_TCLSERVICE_INVALID_PARA _ ET_EN_DONE);

   }  

  /* Code kept for future use. */   

   return bRegOpStatus;
}





/*************************************************************************
*
* FUNCTION:     tuner_tclservice::vHandleMessageFromHMI()
* 
* DESCRIPTION:  All HMI requests are handeled here.
*
* PARAMETER:    amt_tclServiceData* poMessage
*
* RETURNVALUE: void
*
*************************************************************************/
#if (OSAL_CONF == OSAL_WINNT)
tVoid tuner_tclservice::vHandleMessageFromHMI( amt_tclServiceData* poMessage )
#else
tVoid tuner_tclservice::vHandleMessageFromHMI( amt_tclServiceData* poMessage ) const
#endif
{
  
   /* ---
    cast the received message to a AMT Service data message so we 
    can access the standard members
    --- */
    amt_tclServiceData oServiceData(poMessage);
  
    tU16 u16ServiceID = oServiceData.u16GetServiceID();
  
    /* ---
    one server can offer more than one service. So we analyse the ServiceID
    to know which service handler we have to call. 
    99% of all Servers only offer one service ( with a different function ID for each feature ). 
    --- */
    switch(u16ServiceID)
    {
       /* +++
       enter your Service ID here
       +++ */
    
    case CCA_C_U16_SRV_TUNERCONTROL:
      {
         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNTCLSRV, ET_EN_T16 _ 0x45 _ ET_EN_DONE);        

        
//        if( poGWMain ->m_potun_MsgFromHMI != NULL )
//        {
//          poGWMain -> m_potun_MsgFromHMI -> vDispatchMessage( &oServiceData );
//        }
          break;       
      }
    default:
       {
          /* +++
          we have received a message with an unkown service ID.
          this is an error so make a trace or assert here
          +++ */
          break;
       }
    }
}

/* *****************************************************************************

   FUNCTION:      vDeleteNoThrow

   DESCRIPTION:   Deletes memory without throwing an exception.

   PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

   RETURN TYPE:   void

   HINT:          Why this function? If delete is called inside the destructor,
                  Lint complains with warning 1551 that delete might throw an
                  execption, which is not caught.

                  But try / catch must not be used, and delete does not throw
                  an exception, anyway. To prevent a Lint warning deactivation,
                  this function guarantees that no exception is thrown.
                  Furthermore, it sets the given pointer to 0, and Lint is
                  happy.

                  It is a template, because two different memory types have to
                  be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tuner_tclservice::vDeleteNoThrow( T*& rfpArg ) throw()
{
   OSAL_DELETE rfpArg;
   rfpArg = 0;
}
