/************************************************************************
* FILE:           tun_MsgFromHMI.cpp
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages comming from HMI are handled in this file.
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:
* Date      | Author                       | Modification
* 11.03.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
*
*************************************************************************/




//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#include "tun_trace.h"
#include "tun_Utility.h"

#include "tun_Manager.h"
#include "tun_Config.h"



#include "tun_MsgDefines.h"
#include "tun_defines.h"
#include "tun_main.h"
#include "tun_MsgToADR.h"
#include "tun_DrvAdrIf.hpp"

#include "tun_HMIManager.h"
#include "tun_MsgToHMI.h"

#include "tun_ActualData.h"


#include "tun_MsgFromHMI.h"

#include "tun_MsgToHMI.h"

#include "tun_hmi_fid_if.h"

//#include "tun_hmi_if_message.h"

#include "tun_Msg_types.h"

#include "tun_Diag_defines.h"

#include "kdsconfig/clConfigInterface.h"
#include "conversionTable/midwTunerToAdr3Map.h"

#include "tun_FI_HelpFunc.h"
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#include "Aars/clAars_ATPresetListSetActive.h"
#include "AMFMTuner/clTmcTuner_Method_S_AUDIO_FG_BG_NEW.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGFROMHMI
#include "trcGenProj/Header/tun_MsgFromHMI.cpp.trc.h"
#endif

#define TUN_SCAN (u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_PI || u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_FREQUENCY || \
               u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_PRESET || \
               u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PI || \
               u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PRESET || \
               u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_FREQUENCY)

#define ERROR_NOTAVAILABLE 0x000B
#define FM_AST_AVAILABLE 		0x08000000
#define AMMW_AST_AVAILABLE		0x80000000
#define AMLW_AST_AVAILABLE		0x00080000
#define AMMWLW_AST_AVAILABLE 	0x00800000
#define DRM_AST_AVAILABLE		0x00008000
//#define MANUAL_TO_FI_CLASSES
/* +++
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
+++ */
BEGIN_MSG_MAP(tun_MsgFromHMI, ahl_tclBaseWork)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO,     vHandle_g_Station_Info)

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER, vHandle_s_AtFrequency )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY, vHandle_s_AtFrequencyWithTickInfo)
//ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FRQ_VAG,        vHandleSetBandFrq)
//ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ANTENNA,           vHandleSetAntenna)
#endif

//ON_MESSAGE( FID_TUN_CHANGE_BAND,                       vHandle_s_ChangeBand)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE,   vHandle_SetFeature)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE,   vHandle_SetFeature)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AFLIST_V2,          vHandle_AfList)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_AFLIST_V2,          vHandle_AfList)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2,      vHandle_s_Sel_Elem_From_AFLIST_V2)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_HICUT,          vHandle_SetHighCut)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_SET_HICUT,          vHandle_SetHighCut)


ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUTOSTORE, vHandle_s_Autostore)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST,            vHandle_GetConfigList)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST,            vHandle_GetConfigList)
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW,            vHandleAllMessages )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST,            vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST,            vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_ACTIVE_PRESETLIST,         vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING,            vHandleAllMessages )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_STORAGE_PS_FREEZE,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_DEVICE,               vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_DRM_RADIO_TEXT,          vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DRM_SRCACTIVITY,        vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH,    vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_DEMODULATION_SWITCH_STATUS,    vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SELECT_HD_AUDIOPRGM,        vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AUDIOPRGM,               vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_TEST_MODE_DATA,          vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_LONGNAME,                vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SIGNALLOST_TIMER,        vHandle_g_HD_SignalLostTimer)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_IMAGEFILE_UPDATE,        vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_PSD_DATA,                vHandle_g_HD_PSD_Data)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AVISORY_INFO,            vHandle_s_HD_AdvisoryInfo)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_DRM_TESTMODE,              vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DRM_TESTMODE,              vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_DRM_RESET_MUTECOUNTER, vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT,           vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_CONFIGLIST_UPDATE,          vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_UPDATELANDSCAPE_PROGRESS,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SELECT_DRM_AUDIOPRGM,    vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_AF,    vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_MUTEREQUEST,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_LIST_ELEM,          vHandleAllMessages )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_TESTMODE,    vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI,                       vHandleAllMessages       )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER, vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT,     vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY,   vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_AUDIO_SPLIT_MODE, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_SPLIT_MODE, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_HD_SECTION_PARAMETER, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_HD_RESET_TRANSITIONCOUNT, vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_CHANGE_LSM ,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_SURVIELLANCE_LISTUPDATE  ,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_LISTUPDATE_NOTIFICATION  ,      vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS   , vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE   , vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DARC_VICS_FREQUENCY_LIST   , vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DARC_DATA   , vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DISABLE_BAND   , vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SECTION_PARAMETER, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_JAPAN_SET_AREA, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_JAPAN_AREA, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_JAPAN_CHANGE_STATION_NAME, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_PRESETLIST_CONTENT_UPDATE, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_LANGUAGE_SETTING, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_ACTIVE_PRESETLISTID, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_JAPAN_STATION_NAME_LIST, vHandleAllMessages)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_JAPAN_SELECT_STATION_NAME, vHandleAllMessages)
#else
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW,            vHandle_SetAudFGBG )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST,            vHandle_s_Get_Static_List)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST,            vHandle_s_Get_Static_List)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_ACTIVE_PRESETLIST,         vHandle_s_Set_Active_PresetList )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING,            vHandle_s_Preset_Handling )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_STORAGE_PS_FREEZE,      vHandle_s_SetPresetStoragePSNameFreeze)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_STATIONLIST_EXIT,           vHandle_StationList_Exit)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_CONFIGLIST_UPDATE,          vHandle_s_ConfigListUpdate)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_UPDATELANDSCAPE_PROGRESS, vHandle_g_UpdateLandscape_Progress)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST,      vHandle_g_Mute_Request)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_MUTEREQUEST,      vHandle_s_AudioMuteRequest)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_LIST_ELEM,          vHandle_s_SelectListElem )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI,                   vHandle_SetPI           )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER, vHandle_s_AtSeek)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY,   vHandle_s_DirectFrequency)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK, vHandle_g_AtSeek)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA,      vHandle_GetCalibrationData)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS   , vHandle_g_TunerTestMode)
#endif

//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI,                   vHandle_SetPI           )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ATPISEARCH,              vHandleAllMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCY,      vHandleAllMessages)
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_FG_BG_NEW,          vHandle_SetAudFGBG )



/* This FID is added for the Cluster Display feature     */
/* to give the Tuner Seek status                         */

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_SHARXLEVEL,      vHandle_SetSharxLevel)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_SET_SHARXLEVEL,      vHandle_SetSharxLevel)

//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA,      vHandle_GetCalibrationData)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_CALIBRATION_DATA,      vHandle_GetCalibrationData)



ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_SETUP_DDADDS,              vHandle_SetupDDADDS )
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS,              vHandle_SetupDDADDS )

ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF,              vHandle_g_SetAF )
//ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_TA,              vHandle_g_SetTA )
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA,              vHandle_g_SetDDA )
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG,              vHandle_g_SetRDSREG)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_MEASUREMODE,         vHandle_g_SetMeasureMode)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDS,         vHandle_g_SetRDSSwitch)

/*    These FIDs are added for Static Lists    */
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_STATIC_LIST,        vHandle_s_Set_Static_List)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST,        vHandle_s_Get_Static_List)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT,               vHandle_g_RadioText   )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO,   vHandle_g_BandPlusStationInfo   )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_DIAG_REMOTE_CONTROL, vHandle_g_DiagRemoteControl)
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS   , vHandle_g_TunerTestMode)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_S_TUN_GET_FIELD_STRENGTH,   vHandleFieldStrength)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER,   vHandleGetActiveTuner)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_RDBID, vHandle_s_Set_RDBID )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TMC, vHandle_g_Get_Data_TMC )

//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER   , vHandle_g_Component_Status)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_RDBIDACTUALLIST, vHandle_g_RdbidActuallist)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_S_PS_FREEZE, vHandle_s_PSFreeze)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SURVEIL_TP,      vHandle_s_SurveilTP )

/** FIDs related to CM_SetEngineeringParameter */
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_ENGG_PARAMETER,      vHandle_s_Set_Engg_Param)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ENGG_PARAMETER,      vHandle_s_Set_Engg_Param)

/** FIDs related to CM_TuningActionConfiguration */
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_TUNING_ACTION_CONFIG,      vHandle_s_Set_TuningActionConfig)
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_SET_TUNING_ACTION_CONFIG,      vHandle_s_Set_TuningActionConfig)

/** Announcement related FIDs */
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH,      vHandle_s_Set_AnnouncementSwitch)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_SWITCH,      vHandle_s_Set_AnnouncementSwitch)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE,      vHandle_g_AnnouncementMessageAndInfo)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO,      vHandle_g_AnnouncementMessageAndInfo)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_ESCAPE,      vHandle_s_AnnouncementEscape)


//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PI_PS_RELATION,      vHandle_s_SetPI_PS_Relation)
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_PI_PS_RELATION,      vHandle_s_SetPI_PS_Relation)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SPEED_INFO,      vHandle_s_SetSpeedinformation)

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_AVAILABLE_BAND_RANGE,      vHandle_g_GetAvailableBandRange)




ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DEFAULT_SETTING, vHandle_s_DefaultSetting)


END_MSG_MAP()


OSAL_tSemHandle tun_MsgFromHMI::m_hMsgFromHMISem  = OSAL_C_INVALID_HANDLE;


//#define AMFMTUNER_SERVICE_ID              264 //Prio 2 Info: local macro 'AMFMTUNER_SERVICE_ID' not referenced
#define AMFMTUNER_FI_MAJOR_VERSION        3
#define AMFMTUNER_FI_MINOR_VERSION        0
/*************************************************************************
*
* FUNCTION: tun_MsgFromHMI::tun_MsgFromHMI(ccademo_tclApp* poGWMainApp)
*
* DESCRIPTION: constructor, creates object tun_MsgFromHMI - object
*
* PARAMETER: ccademo_tclApp* poGWMainApp: main - object of this application
*
* RETURNVALUE: none
*
*************************************************************************/
tun_MsgFromHMI::tun_MsgFromHMI( tuner_tclApp* potunerMainApp ):
clCCAhandler(potunerMainApp, CCA_C_U16_SRV_TUNERCONTROL, AMFMTUNER_FI_MAJOR_VERSION, AMFMTUNER_FI_MINOR_VERSION, 0, CCA_C_U16_APP_TUNER)


{
   m_hMsgFromHMISem = tuner_tclApp::_hNotTableSem;
   m_u32TestModeFeatureValue = 0;
   m_bSetActivePresetListRequested = false;
   poGWMain         = potunerMainApp;
  bUpRegDiag = FALSE;
  m_u8Band = 0xFF;
   m_bFSReqFromDiag = FALSE;
   m_bSrcInAM = FALSE;
  m_u32DirectFreq = 0;
   m_MuteHandlingRequest.enMuteAction_curr = None;
   m_MuteHandlingRequest.enMuteAction_next = None;
   m_MuteHandlingRequest.u32Frequency = 0;
   m_MuteHandlingRequest.u32Frequency_Direct = 0;
   m_MuteHandlingRequest.u8AcceptAF = 0xFF;
   m_MuteHandlingRequest.u8Direction = 0xFF;
   m_MuteHandlingRequest.u8NumberOfTicks = 0;
   m_MuteHandlingRequest.u8SeekType = 0xFF;
   m_MuteHandlingRequest.u8TunerHeader = 0xFF;
   m_MuteHandlingRequest.u16ListID = 0xFFFF;
   m_MuteHandlingRequest.u8ListElementID = 0xFF;
   m_MuteHandlingRequest.u16StationListID = 0xFFFF;
   m_MuteHandlingRequest.u8StationList_ElemID = 0xFF;
   m_MuteHandlingRequest.u32StationListElem_Frequency = 0;
   m_MuteHandlingRequest.u16StationListElem_PICode = 0;

   m_MuteHandlingRequest.u32StationListElem_HDStnID_DRMSrvID = 0;
   m_MuteHandlingRequest.u8StationListElem_ModulationType = 0;
   m_MuteHandlingRequest.u8PIStep_Direction = 0xFF;
   m_MuteHandlingRequest.u8AbsRel = 0xFF;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
m_poclAars_ATPresetListSetActive=NULL;
m_poclTmcTuner_AudioFGBGNew = NULL;
#endif
   m_potun_MsgToHMI = NULL;
   m_potu_Manager = NULL;
   m_potun_MsgToADR = NULL;
   m_potun_ActualData = NULL;
   m_potun_Utility = NULL;
   m_potun_Config = NULL;
   m_poclConfigInterface = NULL;
   m_potun_HMIManager = NULL;
   m_u8TunerMode = CUSTOMER_MODE;
   m_u8MeasurementMode = 0;
   m_u8ConfigListID = 0xFF;
}


/*************************************************************************
*
* FUNCTION: tun_MsgFromHMI::tun_MsgFromHMI(ccademo_tclApp* poGWMainApp)
*
* DESCRIPTION: Destructor.
*
* PARAMETER:
*
* RETURNVALUE: none
*
*************************************************************************/
tun_MsgFromHMI::~tun_MsgFromHMI( )
{
  m_hMsgFromHMISem  = OSAL_C_INVALID_HANDLE;

  m_potu_Manager = NULL;

  m_potun_ActualData = NULL;

  m_potun_MsgToADR = NULL;

  m_potun_MsgToHMI = NULL;

  poGWMain = NULL;

  m_potun_Utility = NULL;

  m_potun_Config = NULL;

  m_potun_HMIManager = NULL;

  m_poclConfigInterface = NULL;

  vSetAMSrcStatus(FALSE);

  m_u32DirectFreq = 0;

  m_MuteHandlingRequest.enMuteAction_curr = None;
  m_MuteHandlingRequest.enMuteAction_next = None;
  m_MuteHandlingRequest.u32Frequency = 0;
  m_MuteHandlingRequest.u32Frequency_Direct = 0;
  m_MuteHandlingRequest.u8AcceptAF = 0xFF;
  m_MuteHandlingRequest.u8Direction = 0xFF;
  m_MuteHandlingRequest.u8NumberOfTicks = 0;
  m_MuteHandlingRequest.u8SeekType = 0xFF;
  m_MuteHandlingRequest.u8TunerHeader = 0xFF;
  m_MuteHandlingRequest.u16ListID = 0xFFFF;
  m_MuteHandlingRequest.u8ListElementID = 0xFF;
  m_MuteHandlingRequest.u16StationListID = 0xFFFF;
  m_MuteHandlingRequest.u8StationList_ElemID = 0xFF;
  m_MuteHandlingRequest.u8PIStep_Direction = 0xFF;
  m_MuteHandlingRequest.u8AbsRel = 0xFF;
  m_u32TestModeFeatureValue = 0;
  m_MuteHandlingRequest.u32StationListElem_Frequency = 0;
  m_MuteHandlingRequest.u16StationListElem_PICode = 0;
   m_MuteHandlingRequest.u32StationListElem_HDStnID_DRMSrvID = 0;
   m_MuteHandlingRequest.u8StationListElem_ModulationType = 0;
  m_bSetActivePresetListRequested = false;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
m_poclAars_ATPresetListSetActive=NULL;
m_poclTmcTuner_AudioFGBGNew = NULL;
#endif
  m_u8ConfigListID = 0xFF;

}

/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tu_Manager_Ptr( )
*
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tu_Manager_Ptr( tu_Manager* potu_Manager )
{
  if( potu_Manager != NULL )
  {
    m_potu_Manager = potu_Manager;
  }
  else
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }
}
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tun_MsgFromHMI::vSet_clAars_ATPresetListSetActive_Ptr(clAars_ATPresetListSetActive* poclAars_ATPresetListSetActive)
{
   if(NULL!=poclAars_ATPresetListSetActive)
   {
      m_poclAars_ATPresetListSetActive=poclAars_ATPresetListSetActive;
   }
}

tVoid tun_MsgFromHMI::vSet_clTmcTuner_AudioFGBGNEW_Ptr(clTmcTuner_Method_S_AUDIO_FG_BG_NEW* poclTmcTuner_AudioFGBGNew)
{
   if(NULL!=poclTmcTuner_AudioFGBGNew)
   {
      m_poclTmcTuner_AudioFGBGNew=poclTmcTuner_AudioFGBGNew;
   }
}
#endif
/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_ActualData_Ptr( )
*
* DESCRIPTION:
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData )
{
  if( potun_ActualData != NULL )
  {
    m_potun_ActualData = ( tun_ActualData* )potun_ActualData;
  }
  else
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }
}





/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_MsgToADR_Ptr( )
*
* DESCRIPTION:  With this, tun_IPNInterface can send info to class tun_MsgToADR.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR )
{
  if( potun_MsgToADR != NULL )
  {
    m_potun_MsgToADR = potun_MsgToADR;
  }
  else
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }
}




/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_MsgToHMI_Ptr( )
*
* DESCRIPTION:
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI )
{
  if( potun_MsgToHMI != NULL )
  {
    m_potun_MsgToHMI = ( tun_MsgToHMI* )potun_MsgToHMI;
  }
  else
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToADR::vSet_tun_Utility_Ptr( )
*
* DESCRIPTION:
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_Utility_Ptr( tun_Utility* potun_Utility )
{
  if( potun_Utility != NULL )
  {
    m_potun_Utility = potun_Utility;
  }
  else
  {
    /* Assert to do */
  }
}


/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_Config_Ptr( )
*
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_Config_Ptr( tun_Config* potun_Config )
{
  if( potun_Config != NULL )
  {
    m_potun_Config = ( tun_Config* )potun_Config;
  }

  else
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }
}

/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_ConfigInterface_Ptr( )
*
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface )
{
  if( poclConfigInterface != NULL )
  {
	  m_poclConfigInterface = poclConfigInterface;
  }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_HMIManager_Ptr( )
*
* DESCRIPTION:   With this HMI manager data can be accessed
*
* PARAMETER:    tun_Config*
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager )
{
  if( potun_HMIManager != NULL )
  {
    m_potun_HMIManager= ( tun_HMIManager* )potun_HMIManager;
  }

  else
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }
}

/*************************************************************************
*
* FUNCTION:tVoid tun_MsgFromHMI::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
*
* DESCRIPTION: handle unknown message
*
* PARAMETER:  unkown message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vOnUnknownMessage( amt_tclBaseMessage* poMessage )
{
  /* +++
   the frame work call this function when it receives a message with a unknown
   FID. You can use it for error handling.
  +++ */

  if( poMessage == NULL )
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );
  }

}




/*************************************************************************
*
* FUNCTION: tVoid tun_MsgFromHMI::bSendAnswer
*
* DESCRIPTION: sends an answer message
*
* PARAMETER: message to be answered, data, opcode of the answer
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tun_MsgFromHMI::bSendAnswer( const amt_tclServiceData* poMessage, tU16 u16Value, tU8 u8Opcode )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_SEND_REPLY_TO_CLIENT _ ET_EN_DONE);

   /* +++
   create a message,
   use the data of given message to get the address information
   +++ */

   if( poMessage == NULL )
   {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );

     return;
   }

   gm_tclU16Message oStatusMessage = gm_tclU16Message
      (
        CCA_C_U16_APP_TUNER,
        poMessage->u16GetSourceAppID(),
        poMessage->u16GetRegisterID(),
        poMessage->u16GetCmdCounter(),
        CCA_C_U16_SRV_TUNERCONTROL,
        poMessage->u16GetFunctionID(),
        u8Opcode
       );

   //oStatusMessage.vSetTargetSubID(poMessage->u16GetSourceSubID());

   /* +++
   fill in your data
   +++ */
   oStatusMessage.vSetWord(u16Value);

   /* ---
   send it to the client
   --- */
   if( ( ( (ail_tclAppInterface*)poGWMain)->enPostMessage(&oStatusMessage) ) != AIL_EN_N_NO_ERROR )
   {
      if(!oStatusMessage.bDelete())
      {
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MSG_DEL_FAIL _ ET_EN_DONE);
      }

      /* +++
      can't send status:
      enter error handling here ( trace or assert )
      +++ */
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_POST_MSG_FAIL _ ET_EN_DONE);
   }

}






/*************************************************************************
*
* FUNCTION: tVoid dl_tclApp::vSendErrorToClientsInNotTable
*
* DESCRIPTION: sends an error - message
*
* PARAMETER: data for addressing the message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSendErrorToClientsInNotTable( const amt_tclServiceData* poMessage, tU16 u16ErrorCode  )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_SEND_ERROR_TO_CLIENT _\
                     ET_EN_DONE);


  if(( poMessage == NULL )||(m_potun_MsgToHMI == NULL))
  {

    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                        ET_EN_DONE );

    if( poMessage == NULL )
      {
        NORMAL_M_ASSERT( poMessage != NULL );
      }

      if( m_potun_MsgToHMI == NULL )
      {
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );

      }

    return;
  }

  ahl_bEnterCritical( m_hMsgFromHMISem );

  ahl_tNotification* pNot;

  if ( ( pNot =  m_potun_MsgToHMI -> m_poHMINotTable -> poGetNotificationList( poMessage->u16GetFunctionID() ) ) !=0 )
  {

    for (;pNot; pNot = pNot->pNext )
    {

      amt_tclServiceDataError poErrorMessage;


      if ( poErrorMessage.bIsValid( ) )
      {

          poErrorMessage.vSetSourceAppID( CCA_C_U16_APP_TUNER );
          poErrorMessage.vSetSourceSubID( 0 );
          poErrorMessage.vSetStreamCounter( 0 );
          poErrorMessage.vSetACT( 0 );
          poErrorMessage.vSetStreamType(  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA );
          poErrorMessage.vSetTargetAppID( CCA_C_U16_APP_UI );
          poErrorMessage.vSetRegisterID(  pNot -> u16RegisterID );
          poErrorMessage.vSetCmdCounter(  pNot -> u16CmdCounter );
          poErrorMessage.vSetFunctionID(  poMessage -> u16GetFunctionID() );
          poErrorMessage.vSetServiceID(   poMessage  ->u16GetServiceID() );
          poErrorMessage.vSetErrorData(   u16ErrorCode );


          poErrorMessage.vInitServiceData(  CCA_C_U16_APP_TUNER,                  // source app-ID
                                            CCA_C_U16_APP_UI,                     // dest. app-ID
                                            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // stream type
                                            0,                                    // StreamCounter
                                            pNot -> u16RegisterID,                // register-ID set
                                            pNot -> u16CmdCounter,                // command counter
                                            poMessage  ->u16GetServiceID(),       // service-ID
                                            poMessage -> u16GetFunctionID(),      // function-ID
                                            AMT_C_U8_CCAMSG_OPCODE_ERROR);        // OpCode



        }


        if( ( poGWMain->enPostMessage(&poErrorMessage) ) != AIL_EN_N_NO_ERROR )
        {
          if(!poErrorMessage.bDelete())
          {
            ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                                ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MSG_DEL_FAIL _\
                                ET_EN_DONE);
          }

          ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_POST_MSG_FAIL _\
                              ET_EN_DONE);
        }
        else
        {
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_POST_MSG_OK _\
                             ET_EN_DONE);
        }

    } /* if ( poErrorMessage.bIsValid( ) ) */

   } /* for (;pNot; pNot = pNot->pNext ) */


  ahl_bReleaseCritical( m_hMsgFromHMISem );


}



/*************************************************************************
*
* FUNCTION: tVoid dl_tclApp::vSendError
*
* DESCRIPTION: sends an error - message
*
* PARAMETER: data for addressing the message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSendError( const amt_tclServiceData* poMessage, tU16 u16ErrorCode  )
{

    amt_tclServiceDataError poErrorMessage;

    if( poMessage == NULL )
    {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );

      return;
    }


    if ( poErrorMessage.bIsValid() )
    {
      poErrorMessage.vSetSourceAppID( CCA_C_U16_APP_TUNER );
      poErrorMessage.vSetSourceSubID( 0 );
      poErrorMessage.vSetStreamCounter( 0 );
      poErrorMessage.vSetACT( 0 );
      poErrorMessage.vSetStreamType( AMT_C_U8_CCAMSG_STREAMTYPE_NODATA );
      poErrorMessage.vSetTargetAppID( CCA_C_U16_APP_UI );
      poErrorMessage.vSetRegisterID( poMessage->u16GetRegisterID() );
      poErrorMessage.vSetCmdCounter( poMessage->u16GetCmdCounter() );
      poErrorMessage.vSetFunctionID( poMessage->u16GetFunctionID() );
      poErrorMessage.vSetServiceID( CCA_C_U16_SRV_TUNERCONTROL );
      poErrorMessage.vSetErrorData( u16ErrorCode );


      poErrorMessage.vInitServiceData( CCA_C_U16_APP_TUNER,
                                        CCA_C_U16_SRV_TUNERCONTROL,
                                        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                                        0,                                // StreamCounter
                                        poMessage->u16GetRegisterID(),
                                        poMessage->u16GetCmdCounter(),
                                        CCA_C_U16_SRV_TUNERCONTROL,
                                        poMessage->u16GetFunctionID(),
                                        AMT_C_U8_CCAMSG_OPCODE_ERROR);


      }


      if( ( ( (ail_tclAppInterface*)poGWMain)->enPostMessage(&poErrorMessage) ) != AIL_EN_N_NO_ERROR )
      {
        if(!poErrorMessage.bDelete())
        {
            ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MSG_DEL_FAIL _ ET_EN_DONE);
        }

        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_POST_MSG_FAIL _ ET_EN_DONE);
      }
      else
      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_POST_MSG_OK _ ET_EN_DONE);
      }

}





/*************************************************************************
*  FUNCTION:    u8UpdateTunerStateInMethodResult
*
* DESCRIPTION: Prepare the respose sent to client
*
* PARAMETER:   Method Result response to be sent to client.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tU16 tun_MsgFromHMI::u16UpdateTunerStateInMethodResult( tU8 u8ClientResponse )const
{
   tU16 u16Temp = 0;

   /*-----------------------------------------*/
   /* MSB 8 bits ->  TUNER STATUS             */
   /* LSB 8 bits ->  METHODRESULT STATUS      */
   /*-----------------------------------------*/

   /*-- MSB --*/
   if( m_potu_Manager != NULL )
   {
      u16Temp = (tU16) m_potu_Manager ->u8GetTunerSystemState( );
      u16Temp = (tU16)(u16Temp << 8);
   }

   /*- LSB --*/
   u16Temp = (tU16)(u16Temp | ((tU16) u8ClientResponse) );


   return u16Temp;

}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vGetDatafromAMT
*
*DESCRIPTION: This function converts Amt message to visitor class and
*             get the data from visitor to the Fi class. Refer FI Manual.
*             Doc.
*
*PARAMETER:
*           poFiMsg   - Amt Message
*           oFIData   - Base class of Fi class
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgFromHMI::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
                                        fi_tclTypeBase&     oFIData ) const
{
   // Create Visitor message object for incoming message
   fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

   /* Get the data in FI class from Vistor class*/
   if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION))
   {
      // assert here
      NORMAL_M_ASSERT_ALWAYS ();
   }

}

/****************************************************************************
*FUNCTION:    tun_MsgFromHMI::vSendMessage
*
*DESCRIPTION: This function converts Amt message to visitor class and
*             get the data from visitor to the Fi class. Refer FI Manual.Doc.
*
*PARAMETER:
*             u16DestAppID      - Destination ID of Out Msg
*             oOutData          - Base class of out going Fi object
*             u16Fid            - Funtion id of the out going message
*             u8OpCode          - Opcode of the message
*
*RETURNVALUE: None
******************************************************************************/
tVoid tun_MsgFromHMI::vSendMessage( tU16             u16DestAppID,
                                     const fi_tclTypeBase&  oOutData,
                                     tU16             u16Fid,
                                     tU8              u8OpCode,
                                     tU16             u16CmdCtr,
                                     tU16             u16RegId)
{
   // Create the Visitor Message
   fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);

   // Set the CCA message information
   oOutVisitorMsg.vInitServiceData(
         CCA_C_U16_APP_TUNER,                      /* Source app-ID    */
         u16DestAppID,                             /* Dest. app-ID     */
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type      */
         0,                                        /* stream counter   */
         u16RegId,                                 /* Registry ID      */
         u16CmdCtr,                                /* Command counter  */
         CCA_C_U16_SRV_TUNERCONTROL,               /* Service-ID       */
         u16Fid,                                   /* Function-ID      */
         u8OpCode,                                 /* OpCode           */
         0,                                        /* ACT              */
         0,                                        /* Source sub-ID    */
         0 );                                      /* Dest. sub-ID     */

  // Send it to the client
  if( AIL_EN_N_NO_ERROR != poGWMain->enPostMessage( &oOutVisitorMsg) )
  {
     // Error in sending the message
     if (!oOutVisitorMsg.bDelete())
     {
       // Error in deleting the message
     }
  }

}

/*************************************************************************
* FUNCTION:    vHandle_s_Set_Static_List
*
* DESCRIPTION: Client requests for a new Static list.
*
* PARAMETER:   poMessage   -message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Set_Static_List( amt_tclServiceData* /*poMessage*/ )
{
#if 0
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_STATIC_LIST _\
                     ET_EN_DONE);

  /* Pointer validation  */

  if( poMessage == NULL )
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

     return;
  }



   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

          /* Object Creation */
        midw_tunerfi_tclMsgFID_TUN_S_SET_STATIC_LISTMethodStart oMsg;


          /*  Extract contents from amt based message. */
        this->vGetDatafromAMT(poMessage,oMsg);


        midw_fi_tcl_e8_Tun_TunerStaticList e8TunerStaticList;

        /*----------- Which LisID to be set--------------- */
        /*      FI_EN_TUN_TUN_STATIC_LIST_FM1 = 0UL        */
        /*      FI_EN_TUN_TUN_STATIC_LIST_FM2 = 1UL        */
        /*      FI_EN_TUN_TUN_STATIC_LIST_FM3 = 2UL        */
        /*      FI_EN_TUN_TUN_STATIC_LIST_AST = 3UL        */
        /*      FI_EN_TUN_TUN_STATIC_LIST_AM1 = 4UL        */
        /*      FI_EN_TUN_TUN_STATIC_LIST_LW1 = 5UL        */
        e8TunerStaticList.enType =oMsg.e8TunerStaticList.enType;


        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                           ET_EN_T8 _ e8TunerStaticList.enType _\
                           ET_EN_DONE);



        //------------------------
        // Response to the client
        //------------------------
        midw_tunerfi_tclMsgFID_TUN_S_SET_STATIC_LISTMethodResult oResponse;

      /** Method Result as success to the client */
      vSendMethodResult(oResponse,\
         poMessage,\
         (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);


        break;

      } /* case AMT_C_U8_CCAMSG_OPCODE_METHODSTART */
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_STATIC_LIST _\
                            ET_EN_DONE);
         break;
      }

   } /* switch (poMessage->u8GetOpCode()) */

    
#endif
} /* vHandle_s_Set_Static_List( amt_tclServiceData* poMessage ) */


/*************************************************************************
* FUNCTION:    vHandle_s_Get_Static_List
*
* DESCRIPTION: Client requests for a new Static list.
*
* PARAMETER:   poMessage   -message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Get_Static_List( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST _\
                     ET_EN_DONE);

  /* Pointer validation  */

  if( (poMessage == NULL ) ||(m_potun_MsgToADR == NULL ) ||(m_potun_MsgToHMI == NULL))
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );
    NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );


     return;
  }



   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

          /* Object Creation */
        midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart oMsg;


          /*  Extract contents from amt based message. */
        vGetDatafromAMT(poMessage,oMsg);

        tU8 u8HMIListID =  (tU8)oMsg.e8ListID.enType;

        tU16 u16ADRListID = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListID);

      if(u16ADRListID != (tU16)TUN_BANK_NONE )
      {
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR ->vGetPresetList(u16ADRListID);
#endif
      }

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ u16ADRListID _\
                             ET_EN_T8 _ TUN_BAND_CHANGE_INPROGRESS _\
                             ET_EN_DONE);

        //------------------------
        // Response to the client
        //------------------------
        midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult oResponse;

      /** Method Result as success to the client */
      vSendMethodResult(oResponse,\
         poMessage,\
         (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);


        break;

      } /* case AMT_C_U8_CCAMSG_OPCODE_METHODSTART */
   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);

         }
         else
         {
          ETG_TRACE_USR2(( " tun_MsgFromHMI::vHandle_s_Get_Static_List() : Adding to notification table:Success"));
         }
      }
      break;
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST _\
                            ET_EN_DONE);
         break;
      }

   } /* switch (poMessage->u8GetOpCode()) */

    

} /* vHandle_s_Set_Static_List( amt_tclServiceData* poMessage ) */


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_Station_Info
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_Station_Info( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO _\
                     ET_EN_DONE);


  if( ( poMessage == NULL ) || ( m_potun_ActualData == NULL ) ||
      ( m_potun_MsgToHMI == NULL ) || (m_potun_HMIManager == NULL) ||
   (m_potun_MsgToADR == NULL) )
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );


       NORMAL_M_ASSERT( poMessage != NULL );
       NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
       NORMAL_M_ASSERT( m_potun_ActualData != NULL );
       NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
       NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
     return;
  }


   switch (poMessage->u8GetOpCode())
   {


    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);

         }
       else
       {
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
             ET_EN_DONE);

          vSendStationInfoStatusMessage( poMessage );

       }
         break;
      }
     case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        {
        	vRemoveFromNotificationTable(poMessage);
        	break;
        }
     case AMT_C_U8_CCAMSG_OPCODE_GET:
     {
        vSendStationInfoStatusMessage( poMessage );
        break;
     }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO _\
                             ET_EN_DONE);
         break;
      }
   }

    
}

tVoid tun_MsgFromHMI::vSendStationInfoStatusMessage(amt_tclServiceData* poMessage)
{

   ETG_TRACE_USR4(( " tun_MsgFromHMI :: vSendStationInfoStatusMessage "));
   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus oStatusMsg;

   m_potun_ActualData->vPackStationInfoData(oStatusMsg);

   /*Send status message to clients*/
   vSendMessage( poMessage->u16GetSourceAppID(),
      oStatusMsg,
      poMessage->u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_STATUS,
      poMessage->u16GetCmdCounter(),
      poMessage->u16GetRegisterID()
      );
}
tVoid tun_MsgFromHMI::vSendStationInfoStatusMessage()
{
	ahl_bEnterCritical( m_hMsgFromHMISem );
	for(ahl_tNotification* pNot= m_potun_MsgToHMI->m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO) ; pNot != OSAL_NULL; pNot=pNot->pNext)
	{
		midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus oStatusMsg;
		m_potun_ActualData->vPackStationInfoData(oStatusMsg);\
	    vSendMessage( pNot->u16AppID,
		  oStatusMsg,
		  MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO,
		  AMT_C_U8_CCAMSG_OPCODE_STATUS,
		  pNot->u16CmdCounter,
		  pNot->u16RegisterID
		  );
	}
	ahl_bReleaseCritical( m_hMsgFromHMISem );
}
/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_s_AtFrequency
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_AtFrequency( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                   ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER _\
           ET_EN_DONE);


  if( ( poMessage == NULL ) || ( m_potun_ActualData == NULL ) )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
              ET_EN_DONE );

      return;
   }


   if( m_potun_MsgToHMI == NULL )
    {
     NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );

      return;
   }

  //tU8 u8Band = m_potun_ActualData->m_otun_Data_MainStatus.u8GetBand();

  tU32 u32Frequency = m_potun_ActualData ->m_otun_Data_Station.u32GetFrequency( );

  tU8 u8RelFreqUpOrDown = 0;


  midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart omessage;


  // Extract contents from amt based message
  vGetDatafromAMT(poMessage,omessage);

  if ( (omessage.ManualFreqAdjustment.enType) == \
    midw_fi_tcl_e8_Tun_ManualFreqAdjustment::FI_EN_TUN_SEEK_DIRECTION_UP )
  {
    u8RelFreqUpOrDown = 0x01;
  }
  else
  {
    u8RelFreqUpOrDown = 0xff;
  }



  midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;

  u8TunerHeader.enType = omessage.TunerHeader.enType;



    u32Frequency = m_potun_ActualData ->m_otun_Data_Station.u32GetBGFrequency( );
    if( 0 == u32Frequency )
    {
      u32Frequency = FM_FREQUENCY;
    }


   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

        ETG_TRACE_USR1(( " tun_MsgFromHMI ::vHandle_s_AtFrequency(), MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER, Methodstart, TunerHeader=%02x, ManualFreqAdjustment=%02x"
                         ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_TUNERHEADER_TENTYP, omessage.TunerHeader.enType)
                         ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_MANUALFREQADJUSTMENT_TENTYPE, omessage.ManualFreqAdjustment.enType)
                      ));

        /*--------------------------------------------*/
        /* Check for valid static list By HMI manager */
        /* Or else response to HMI is ERROR           */
        /*--------------------------------------------*/
        /* To do */


        /*---------------------------------------------*/
        /* Send new staticlist request to Radio Unit   */
        /*---------------------------------------------*/
        if( m_potun_MsgToADR != NULL )
        {
#ifndef GTEST_x86LINUX_BUILD
          m_potun_MsgToADR ->vSendATFrequency( enATFrequencyAbsOrRel_RelativeValue,        /* tenATFrequencyAbsOrRel enAbsOrRel    */
                                               1,                                          /* tU8 u8NSteps                         */
                                               u32Frequency,                               /* tU32 u32Frequency                    */
                                               (tenATFrequencyDirection)u8RelFreqUpOrDown, /* tenATFrequencyDirection enDirection  */
                                               (tU8)u8TunerHeader.enType);                 /* tU8 u8TunerHeader                    */

#endif

        }


        //------------------------
        // Response to the client
        //------------------------
        midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult oResponse;

        // Response -> SUCC / FAIL / BUSY
        oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
                                midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

        // Current Tuner state -> Not required for client. NORAL added as default.
        oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
                                midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

        //------------------------------
        // Send the response to client.
        //------------------------------
       vSendMessage( poMessage->u16GetSourceAppID(),
                     oResponse,
                     poMessage->u16GetFunctionID(),
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                     poMessage->u16GetCmdCounter(),
                     poMessage->u16GetRegisterID()
                   );
        break;

      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
              ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER _\
              ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_s_AtSeek
*
* DESCRIPTION: Different seek operations can be performed.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_AtSeek( amt_tclServiceData* poMessage )
{

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
      ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER _\
      ET_EN_DONE);

   if( ( poMessage == NULL ) || ( m_potun_ActualData == NULL ) || \
      ( m_potun_MsgToHMI == NULL ) ||  ( m_potun_MsgToADR == NULL ))
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
         ET_EN_DONE );

      NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      NORMAL_M_ASSERT( m_potun_ActualData != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );

      return;
   }



   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart omessage;

   // Extract contents from amt based message
   vGetDatafromAMT(poMessage,omessage);


   tU8 u8SeekType = (tU8) omessage.u8TunerSeek.enType;

   tU8 u8SeekState = m_potun_MsgToHMI->u8GetSeekMode();
   if(u8SeekState == 0 && u8SeekType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF)
   {
      /** don't forward the message to ADR */
      return;
   }

   switch (poMessage->u8GetOpCode())   /* Logiscope issue but can't be fixed due to interface value mismatch*/
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

         ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_AtSeek, Methodstart "));

         tU32 u32Frequency = omessage.u32Frequency;


         if(TUN_SCAN)
         {
            ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_AtSeek, SeekType = %d"
               , u8SeekType));

            /** Send msg to ADR */
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR->vSendSeekStart(u8SeekType, u32Frequency);
#endif

         }
         else
         {
            m_MuteHandlingRequest.u32Frequency = omessage.u32Frequency;
            tU8 u8seekType = (tU8) omessage.u8TunerSeek.enType;
            m_MuteHandlingRequest.u8SeekType = u8seekType;
#ifdef MUTE_ACTIVE

            if(m_MuteHandlingRequest.enMuteAction_curr == PresetRecall
                  || m_MuteHandlingRequest.enMuteAction_curr == StationList)
            {
               m_MuteHandlingRequest.enMuteAction_next = Seek;
            }
            else
            {
               m_MuteHandlingRequest.enMuteAction_curr = Seek;
               m_potun_MsgToHMI->vSend_MuteDemuteReq(true,false);
            }
#else
                  vSend_AtSeek();
#endif

         }

         midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult oResponse;

         /** Method Result as success to the client */
         vSendMethodResult(oResponse,\
            poMessage,\
            (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

         break;
      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER _\
            ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vSend_AtSeek
*
* DESCRIPTION: Different seek operations can be performed.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSend_AtSeek()
{
    if(m_potun_MsgToADR == NULL)
    {
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        return;
    }

   ETG_TRACE_USR4(( " tun_MsgFromHMI :: vSend_AtSeek, SeekType = %d, Freq = %d "
      , (tU8)m_MuteHandlingRequest.u8SeekType
      , m_MuteHandlingRequest.u32Frequency));

   /** Send msg to ADR */
#ifndef GTEST_x86LINUX_BUILD
   m_potun_MsgToADR->vSendSeekStart(m_MuteHandlingRequest.u8SeekType, m_MuteHandlingRequest.u32Frequency );
#endif

}


/*************************************************************************
* FUNCTION:    vHandle_s_ChangeBand
*
* DESCRIPTION: Client requests for a Source change AM/FM
*
* PARAMETER:   message to analyse
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_ChangeBand( amt_tclServiceData* /*poMessage */)
{
#if 0
   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
      ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_CHANGE_BAND _\
      ET_EN_DONE);

   if(( poMessage == NULL )||( m_potun_MsgToADR == NULL) ||(m_poclConfigInterface == NULL))
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
         ET_EN_DONE );

      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
      return;
   }



   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         midw_tunerfi_tclMsgFID_TUN_CHANGE_BANDMethodStart oMsg;

         // Extract contents from amt based message
         vGetDatafromAMT(poMessage,oMsg);


         tU8 u8Band = (tU8) oMsg.u8Band.enType;
         ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_ChangeBand, \
                      Methodstart, Band : 0x%02x" ,ETG_CENUM( tenBand, u8Band)  ));

         /** Method Result object */
         midw_tunerfi_tclMsgFID_TUN_CHANGE_BANDMethodResult oResponse;

         if(!bIsBandValid(u8Band))
         {
            ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_ChangeBand, \
                         Invalid Band : 0x%02x" , ETG_CENUM( tenBand, u8Band) ));

            /** Method Result to the client */
            vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);

            /** If band is invalid send method result as error */
            break;
         }

         /** Update the member variable */
         m_u8Band = u8Band;

         /*---------------------------------------------*/
         /* Send Source Change request to Radio Unit   */
         /*---------------------------------------------*/

#ifndef GTEST_x86LINUX_BUILD
         if(m_potun_MsgToADR -> bGetTestModeActivity() == true)
         {
            m_potun_MsgToADR -> vSendSetAtBand(m_u8Band );
         }
#endif

         /*If testmode is not active, send the band change request only if it is not already in the same source.
         * Avoids sending of CM_SystemPresets especially during startup*/

         else if(m_u8Band != (m_potun_MsgToHMI ->m_u8PrevBand))
         {
            /** Store Cmd cntr and Reg Id to send response later */
                m_potun_MsgToHMI -> vSetTunerMasterCommandCntrForBandChange(poMessage->u16GetCmdCounter());
             m_potun_MsgToHMI -> vSetTunerMasterRegIDForBandChange(poMessage->u16GetRegisterID());

           /*** in case of mixed preset list or TRF band request, instead of sending system presets for band change
           Send AtBand command to ADR*/
          if(m_poclConfigInterface->u32GetConfigData("PresetListType") || (m_u8Band== midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_TRF) || (m_u8Band== midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_WB) )
          {
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR -> vSendSetAtBand(m_u8Band);
          }
          else
          {
             m_potun_MsgToADR -> vSendSetBand(m_u8Band );
          }
#endif

            /** break the switch to prevent sending method result instantly*/
            break;
         }

         /** If above condition fails, then current band is same as requested band.
         Send Method result success.*/

         /** Method Result to the client */
         vSendMethodResult(oResponse,\
            poMessage,\
            (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);


         break;
      }//Case MethodStart

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16 _ FID_TUN_CHANGE_BAND _\
            ET_EN_DONE);
         break;
      }//Default Case
   }//switch (poMessage->u8GetOpCode())
#endif    
}

/*************************************************************************
* FUNCTION:    vHandle_ChangeBand
*
* DESCRIPTION: Band change requested along with fg_bg request
*
* PARAMETER:   message to analyse
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_ChangeBand( tU8 u8Band )
{
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   if(( m_potun_MsgToADR == NULL) ||(m_poclConfigInterface == NULL)|| (m_poclTmcTuner_AudioFGBGNew == NULL))
   {
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
	  NORMAL_M_ASSERT( m_poclTmcTuner_AudioFGBGNew != NULL );
      return;
   }

         ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_ChangeBand, \
                      Methodstart, Band : 0x%02x" ,ETG_CENUM( tenBand, u8Band)  ));

         if(!bIsBandValid(u8Band))
         {
            ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_ChangeBand, \
                         Invalid Band : 0x%02x" , ETG_CENUM( tenBand, u8Band) ));
         }
		 else
		 {
			 /** Update the member variable */
			 m_u8Band = u8Band;

			 /*---------------------------------------------*/
			 /* Send Source Change request to Radio Unit   */
			 /*---------------------------------------------*/

			 if(m_potun_MsgToADR -> bGetTestModeActivity() == true)
			 {
				m_poclTmcTuner_AudioFGBGNew->vSetBandChangeRequested(true);
				 m_potun_MsgToADR -> vSendSetAtBand(m_u8Band );
			 }


			 /*If testmode is not active, send the band change request only if it is not already in the same source.
			 * Avoids sending of CM_SystemPresets especially during startup*/

			else if(m_u8Band != (m_potun_MsgToHMI ->m_u8PrevBand))
			{
			   /*** in case of mixed preset list or TRF band request, instead of sending system presets for band change
			   Send AtBand command to ADR*/
			  if(m_poclConfigInterface->u32GetConfigData("PresetListType") || (m_u8Band== midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_TRF) || (m_u8Band== midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_WB) )
			  {
				    if(!m_poclConfigInterface->u32GetConfigData("SBR"))
					{
						m_poclTmcTuner_AudioFGBGNew->vSetBandChangeRequested(true);
						m_potun_MsgToADR -> vSendSetAtBand(m_u8Band);
					}
			  }
			  else
			  {
				 m_poclTmcTuner_AudioFGBGNew->vSetBandChangeRequested(true);
				  m_potun_MsgToADR -> vSendSetBand(m_u8Band );
			  }
			}
		 }
#endif
}


/*************************************************************************
* FUNCTION:    bIsBandValid
*
* DESCRIPTION: Check if band is configured
*
* PARAMETER:   tU8 u8ReceivedBand
*
* RETURNVALUE: tBool
*
* History:
* InitialVersion
* Vnd4kor ECV2 - 17-3-2014
*************************************************************************/
tBool tun_MsgFromHMI::bIsBandValid(tU8 u8ReceivedBand) const
{
   tU32 u32AvailableBands = m_poclConfigInterface->u32GetConfigData("AvailableBands");
   tU32 u32CombiBands = m_poclConfigInterface->u32GetConfigData("CombiBands");
   if(u32AvailableBands & (1 << u8ReceivedBand))
   {
         /** Valid Band */
         return true;
   }
   else if(u32CombiBands == PSA_COMBIBAND_VALUE)
   {
      /**available combiband*/
      return true;
   }
   else if((u8ReceivedBand == midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_CB1) && (m_poclConfigInterface->u32GetConfigData("DRMSupported")))
   {
      return true;
   }
      /** Invalid band */
   if(u8ReceivedBand==midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_TRF)
   {
	   return true;
   }
   if((u8ReceivedBand==midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_WB) && (u32AvailableBands & TUN_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL ))
   {
	   return true;
   }
   return false;

}

/*************************************************************************
* FUNCTION:    vHandle_StationList_Exit
*
* DESCRIPTION: Station List Exit
*
* PARAMETER:   message to analyse
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_StationList_Exit( amt_tclServiceData* poMessage )
{

      if( poMessage == NULL || m_potun_MsgToADR == NULL)
     {
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                            ET_EN_DONE );
       NORMAL_M_ASSERT( poMessage != NULL );
       NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        return;
     }

     switch (poMessage->u8GetOpCode())
     {
        case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
        {
             ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_StationList_Exit, Methodstart "));
             midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart oMsg;

             // Extract contents from amt based message
             vGetDatafromAMT(poMessage,oMsg);

             tU8 u8ConfigListID = (tU8)oMsg.e8ConfigListID.enType;

             if((m_MuteHandlingRequest.enMuteAction_curr == StationList) || (m_MuteHandlingRequest.enMuteAction_next == StationList))
             {
              m_u8ConfigListID = u8ConfigListID;
             }
             else
             {
                ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_StationList_Exit, Methodstart "));
#ifndef GTEST_x86LINUX_BUILD
                m_potun_MsgToADR -> vSendStationListExit(u8ConfigListID);
#endif
             }


             midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult oResponse;



             // Response -> SUCC / FAIL / BUSY
             oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
                                     midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

             // Current Tuner state -> Not required for client. NORAL added as default.
             oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
                                     midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

             //------------------------------
             // Send the response to client.
             //------------------------------
             vSendMessage( poMessage->u16GetSourceAppID(),
                           oResponse,
                           poMessage->u16GetFunctionID(),
                           AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                           poMessage->u16GetCmdCounter(),
                           poMessage->u16GetRegisterID()
                         );


             break;
        }//Case MethodStart

        default:
        {
          ETG_TRACE_USR4(( " wrong opcode "));

            break;
        }//Default Case
      }//switch (poMessage->u8GetOpCode())
       
}

/*************************************************************************
* FUNCTION:    vHandle_S_PSFreeze
*
* DESCRIPTION: Freeze/Unfreeze PS Name
*
* PARAMETER:   message to analyse
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_PSFreeze( amt_tclServiceData* poMessage )
{

      if( poMessage == NULL )
     {
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                            ET_EN_DONE );

        return;
     }
     if( m_potun_MsgToADR == NULL)
     {
       NORMAL_M_ASSERT( poMessage != NULL );
       return;
     }



     switch (poMessage->u8GetOpCode())
     {
        case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
        {
             ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_S_PSFreeze, Methodstart "));
             midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart oMsg;

             // Extract contents from amt based message
             vGetDatafromAMT(poMessage,oMsg);

             tBool bPSFix = oMsg.bPSFreeze;
#ifndef GTEST_x86LINUX_BUILD
             m_potun_MsgToADR -> vSendStationNameFix(bPSFix);
#endif

             midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult oResponse;

             // Response -> SUCC / FAIL / BUSY
             oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
                                     midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

             // Current Tuner state -> Not required for client. NORAL added as default.
             oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
                                     midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

             //------------------------------
             // Send the response to client.
             //------------------------------
             vSendMessage( poMessage->u16GetSourceAppID(),
                           oResponse,
                           poMessage->u16GetFunctionID(),
                           AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                           poMessage->u16GetCmdCounter(),
                           poMessage->u16GetRegisterID()
                         );


             break;
        }//Case MethodStart

        default:
        {
          ETG_TRACE_USR4(( " wrong opcode "));

            break;
        }//Default Case
      }//switch (poMessage->u8GetOpCode())
       
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_SetFeature
*
* DESCRIPTION: Respose TUN_R_SET_FEATURE of RU is sent to HMI.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_SetFeature( amt_tclServiceData* poMessage )
{



   if( ( poMessage == NULL ) || ( m_potun_ActualData == NULL )||\
      ( m_potun_MsgToHMI == NULL ) ||(m_potun_MsgToADR == NULL))
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
         ET_EN_DONE );

      NORMAL_M_ASSERT( poMessage != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      NORMAL_M_ASSERT( m_potun_ActualData != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
   }


   /* the opcode tells what we should do*/

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_SetFeature, Methodstart "));
         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE _\
            ET_EN_DONE);


         /*---------------------------------------------*/
         /* Send new staticlist request to Radio Unit   */
         /*---------------------------------------------*/

         midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart oMsg;

         // Extract contents from amt based message
         vGetDatafromAMT(poMessage,oMsg);


         tU32 u32NewFeatureMask = oMsg.TunerFeature.b32MaskFeatures.u32Value;
         tU32 u32NewFeature = oMsg.TunerFeature.b32Features.u32Value;

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_FEATURE _\
            ET_EN_T8 _ 0x03 _\
            ET_EN_T32 _ u32NewFeatureMask _\
            ET_EN_T32 _ u32NewFeature _\
            ET_EN_DONE);

         switch(u32NewFeatureMask)
         {
            /*Testmode*/
#ifndef GTEST_x86LINUX_BUILD
         case enTUN_FEATURE_TM_DATA_MODE:
            {
            vSetTestModeFeatureValue(u32NewFeature);
            m_potun_MsgToADR->vSendTestmode(u32NewFeature,(tU16)enMsg_CM_EnhancedTestMode);
            }
            break;
            /*AF Mode*/
         case  enTUN_FEATURE_AF_MODE:
            {
            m_potun_MsgToADR->vSendAFMode(u32NewFeature);
            }
            break;
            /*Phase Diversity*/
         case enTUN_FEATURE_DDA_MODE:
            {
            m_potun_MsgToADR->vSendSetDDASwitch(u32NewFeature);
            }
            break;

            /*PersistentStorage*/
         case enTUN_FEATURE_PERSISTENTSTORAGE_MODE:
            {
            m_potun_MsgToADR->vSendPersistentStorage(u32NewFeature);
            }
            break;
            /*Measure Mode*/
         case enTUN_FEATURE_MEASURE_MODE:
            {
            m_u8MeasurementMode = ( (u32NewFeature & (tU32)enTUN_FEATURE_MEASURE_MODE) ) ? 0x01 : 0x00;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
            m_poclTmcTuner_AudioFGBGNew->vSetMeasureMode(m_u8MeasurementMode);
#endif

            if(u32NewFeature == (tU32)enTUN_FEATURE_MEASURE_MODE)
            {
               m_potun_MsgToADR->vSendSpecialDiagnosisMode( \
                                 enCM_SpecialDiagnosisModeMode_MEASURE_MODE, enPhysicalTunerId_CurrentTuner );

            }
            else //Measure mode turned OFF, activate the previous audible tuner mode
            {
               RestoreAudibleTunerMode();
            }
            }
            break;
            /*REG Auto Mode*/
         case enTUN_FEATURE_REG_AUTO_MODE:
            {
            tU8 u8REGmode = ( ( u32NewFeature & (tU32)enTUN_FEATURE_REG_AUTO_MODE)) ? 0x01 : 0x04;
            m_potun_MsgToADR->vSendREGMode(u8REGmode);
            }
            break;
            /*AMFMSetup*/
         case enTUN_FEATURE_AMFMSETUP_MODE:
            {
            m_potun_MsgToADR->vHandleAMFMSettings(u32NewFeature);
            }
            break;
            /*RDS_AUTO*/
         case enTUN_FEATURE_RDS_AUTO_MODE:
            {
            m_potun_MsgToADR->vSendSetRDSSwitch(u32NewFeature);
            }
            break;
#endif
         default:
            {
            ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_SetFeature, INVALID FeatureMask = 0%08x"\
               , u32NewFeatureMask));
            }
            break;
         }


         ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_SetFeature, FeatureMask = 0%08x, Feature = 0%08x "
            , u32NewFeatureMask
            , u32NewFeature));


         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult oResponse;

         /** Method Result to the client */
         vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         break;

      }


   case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE _\
            ET_EN_DONE);

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
               ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
               ET_EN_DONE);

         }
         else
         {
            /*-----------------------------------------------------*/
            /* Create a message, use the data of given message to  */
            /* get the address information                         */
            /*-----------------------------------------------------*/
            midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus oStatusMsg;


            /*------------------------*/
            /* Fill in the message    */
            /*------------------------*/

            oStatusMsg.b32_Features.u32Value =
               m_potun_ActualData->m_otun_Data_MainStatus.u32GetFeatures();

            /* Post message to HMI component */
            vSendMessage( poMessage->u16GetSourceAppID(),
               oStatusMsg,
               poMessage->u16GetFunctionID(),
               AMT_C_U8_CCAMSG_OPCODE_STATUS,
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetRegisterID()
               );


            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
               ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
               ET_EN_DONE);

         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::RestoreAudibleTunerMode
*
* DESCRIPTION: Restores the audible tuner mode when Measure mode is turned OFF
*
* PARAMETER:   TunerMode
*
* RETURNVALUE: NONE
*************************************************************************/
tVoid tun_MsgFromHMI::RestoreAudibleTunerMode()
{
   if(m_potun_MsgToADR == NULL)
   {
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
   }


   switch(m_u8TunerMode)
   {
      case CUSTOMER_MODE:
      {
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR ->vSendSpecialDiagnosisMode(enCM_SpecialDiagnosisModeMode_NORMAL_MODE, enPhysicalTunerId_CurrentTuner);
         ETG_TRACE_USR4(( " tun_MsgFromHMI::RestoreAudibleTunerMode ->  AUTO"));
#endif
      }
      break;
      case DDA_MODE:
      {
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR ->vSendSetDDASwitch(0x00080000);
#endif
         ETG_TRACE_USR4(( " tun_MsgFromHMI::RestoreAudibleTunerMode ->  DDA"));

         /*Switch off DDS and DMQ*/
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR ->vSendTestTunerSwitches(0,0);
#endif
      }
      break;
      case DDS_MODE:
      {
         m_potun_MsgToADR ->vSendTestTunerSwitches(1,0); //DDS = ENABLE, DMQ = OFF

         /*Switch off DDA*/
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR ->vSendSetDDASwitch(0);
         ETG_TRACE_USR4(( " tun_MsgFromHMI::RestoreAudibleTunerMode ->  DDS"));
      }
      break;
      case SINGLE_TUNER_MODE:
      {
         m_potun_MsgToADR ->vSendSpecialDiagnosisMode(enCM_SpecialDiagnosisModeMode_SINGLE_TUNER_MODE, enPhysicalTunerId_CurrentTuner);
         ETG_TRACE_USR4(( " tun_MsgFromHMI::RestoreAudibleTunerMode ->  Single Tuner"));
#endif
      }
      break;
      default:
      {
         //Do Nothing
      }
      break;
   }

}



/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_TunerTestMode
*
* DESCRIPTION: Respose TUN_R_GET_DATA_TESTMODE of RU is sent to HMI.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_TunerTestMode( amt_tclServiceData* poMessage )
{

  if( ( poMessage == NULL ) || ( m_potun_ActualData == NULL ) || ( m_potun_MsgToHMI == NULL ) || ( m_potun_Utility == NULL)
    ||( m_potun_HMIManager == NULL ))
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
              ET_EN_DONE );


        NORMAL_M_ASSERT( poMessage != NULL );

        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );

        NORMAL_M_ASSERT( m_potun_ActualData != NULL );

        NORMAL_M_ASSERT( m_potun_Utility != NULL );

        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );


      return;
   }


 // tU16 u16ResponseToClient = TUN_RES_REQ_FAIL;

   switch (poMessage->u8GetOpCode())
   {


    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

      }
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
               ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS _\
               ET_EN_DONE);

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                ET_EN_DONE);

         }
         else
         {

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
               ET_EN_DONE);


         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                       ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
               ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS _\
               ET_EN_DONE);
         break;
      }
   }

    
}




/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_SetHighCut
*
* DESCRIPTION: Set Highcut values.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_SetHighCut( amt_tclServiceData* poMessage )
{
  if( ( poMessage == NULL ) || ( m_potun_MsgToHMI == NULL ) || (m_potun_MsgToADR == NULL) )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                          ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
   }


   switch (poMessage->u8GetOpCode())
   {


    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_HICUT _\
                            ET_EN_DONE);

         midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart oMsg;

        // Extract contents from amt based message
        vGetDatafromAMT(poMessage,oMsg);

        /*
          u8AbsValue = 0x00  -> HICUT_OFF
          u8AbsValue = 0x01  -> HICUT_LEVEL1
          u8AbsValue = 0x02  -> HICUT_LEVEL2
          u8AbsValue = 0x03  -> HICUT_LEVEL3
          u8AbsValue = 0x04  -> HICUT_LEVEL4
          u8AbsValue = 0x05  -> HICUT_LEVEL5
          u8AbsValue = 0x06  -> HICUT_LEVEL6
          u8AbsValue = 0x07  -> HICUT_LEVEL7
        */
        tU8 u8AbsValue = oMsg.u8AbsVal;

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_HICUT _\
                           ET_EN_T8 _ 0x03 _\
                           ET_EN_T8 _ u8AbsValue _\
                           ET_EN_DONE);

        /*---------------------------------------------*/
        /* Send new staticlist request to Radio Unit   */
        /*---------------------------------------------*/

#ifndef GTEST_x86LINUX_BUILD
		midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult oResponse;
		if(u8AbsValue >=TUN_HICUT_LIMIT)
		{
			vSendMethodResult(oResponse,poMessage,(tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
		}
		else
		{
			m_potun_MsgToADR -> vSendSetHiCut ( u8AbsValue );
			vSendMethodResult(oResponse,poMessage,(tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
		}
#endif
      break;
      }


    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_HICUT _\
                            ET_EN_DONE);

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);

         }
         else
         {

            /*-----------------------------------------------------*/
            /* Create a message, use the data of given message to  */
            /* get the address information                         */
            /*-----------------------------------------------------*/

          /** Send CM_ReceptionParameter Get command for latest HighCut value */
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vGetReceptionParameter((tU8)enCM_ReceptionParameterPosHighcut);
#endif

            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                              ET_EN_DONE);

         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
    	   vRemoveFromNotificationTable(poMessage);
    	   break;
       }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ FID_TUN_G_SET_HICUT _\
                             ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_GetCalibrationData
*
* DESCRIPTION: Set Highcut values.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_GetCalibrationData( amt_tclServiceData* poMessage )
{
     ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_GetCalibrationData "));
  if( ( poMessage == NULL ) || ( m_potun_MsgToHMI == NULL ) || (m_potun_MsgToADR == NULL ) )
   {
      NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );

      return;
   }


   switch (poMessage->u8GetOpCode())
   {

    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

        ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_GetCalibrationData: MethodStart "));

         midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart oMsg;

        // Extract contents from amt based message
        vGetDatafromAMT(poMessage,oMsg);

        /*---------------------------------------------*/
        /* Send new staticlist request to Radio Unit   */
        /*---------------------------------------------*/
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR -> vGetCalibrationData ();
#endif

      /** Create Method Result object to send Method result to Client */
       midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult oResponse;


      /** Method Result to the client */
      vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
      break;

      }

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);

         }
         else
         {
           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                              ET_EN_DONE);

         /** Get calibration data on Successful UPREG */
         m_potun_MsgToADR -> vGetCalibrationData ();


         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */

         break;
      }
   }

    
}



/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_AfList
*
* DESCRIPTION: Request for the AF list.
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_AfList( amt_tclServiceData* poMessage )
{
   if( ( poMessage == NULL ) || ( m_potun_MsgToHMI == NULL )|| (m_potun_MsgToADR == NULL) )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
         ET_EN_DONE );

      NORMAL_M_ASSERT( poMessage != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );

      return;
   }


   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_AFLIST_V2 _\
            ET_EN_DONE);

         midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart oMsg;

         // Extract contents from amt based message
         vGetDatafromAMT(poMessage,oMsg);

         midw_fi_tcl_e8_Tun_Notification e8Nofification;

         /*------------------------------*/
         /* Possile notification values
         Auto notification OFF        ------->     0x00
         Auto notification ON.        -------->    0x01
         Single request (No notification used)---> 0x02*/
         /*------------------------------*/
         e8Nofification.enType = oMsg.u8Notification.enType;

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_AFLIST_V2 _\
            ET_EN_T8 _ 0x03 _\
            ET_EN_T8 _ e8Nofification.enType _\
            ET_EN_DONE);

         /*---------------------------------------------*/
         /* Send new staticlist request to Radio Unit   */
         /*---------------------------------------------*/

         midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult oResponse;

         m_potun_MsgToADR -> vSendGetAFList ((tU8) e8Nofification.enType );

         // Response -> SUCC / FAIL / BUSY
         oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
            midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

         // Current Tuner state -> Not required for client. NORAL added as default.
         oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
            midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

         //------------------------------
         // Send the response to client.
         //------------------------------
         vSendMessage( poMessage->u16GetSourceAppID(),
            oResponse,
            poMessage->u16GetFunctionID(),
            AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
            poMessage->u16GetCmdCounter(),
            poMessage->u16GetRegisterID()
            );
         break;
      }


   case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_AFLIST_V2 _\
            ET_EN_DONE);

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
               ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
               ET_EN_DONE);

         }
         else
         {

            /*-----------------------------------------------------*/
            /* Create a message, use the data of given message to  */
            /* get the address information                         */
            /*-----------------------------------------------------*/
            midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status oStatusMsg;

            /* Default length of Aflist */
            oStatusMsg.u8LengthOfAFList = 0x00;

            /*-------------------------------*/
            /* Post message to HMI component */
            /*-------------------------------*/
            vSendMessage( poMessage->u16GetSourceAppID(),
               oStatusMsg,
               poMessage->u16GetFunctionID(),
               AMT_C_U8_CCAMSG_OPCODE_STATUS,
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetRegisterID()
               );



            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
               ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
               ET_EN_DONE);

         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ FID_TUN_S_AFLIST_V2 _\
            ET_EN_DONE);
         break;
      }
   }

    
}



/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_s_DirectFrequency
*
* DESCRIPTION:  Command from HMI to change frequency to the given Frequency value
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_DirectFrequency( amt_tclServiceData* poMessage )
{

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                      ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY _\
                      ET_EN_DONE);

   if(( poMessage == NULL ) ||( m_potun_Config == NULL) || ( m_potun_ActualData == NULL ) || (m_potun_MsgToADR == NULL)
         || (m_potun_MsgToHMI == NULL)|| (m_poclConfigInterface == NULL))
   {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );


        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_Config != NULL );
        NORMAL_M_ASSERT( m_potun_ActualData != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
	  NORMAL_M_ASSERT( m_poclConfigInterface != NULL );

     return;
   }


   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
        midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart oMsg;

        // Extract contents from amt based message
        vGetDatafromAMT(poMessage,oMsg);

        tU32 u32Frequency = oMsg.u32Frequency;
      tU8 u8CurrentBand = 0;
      u8CurrentBand = m_potun_ActualData->m_otun_Data_Station.u8GetBand();

        if(poMessage->u16GetSourceAppID() != CCA_C_U16_APP_TUNERMASTER)
        {
         /*---------------------------------------------*/
         ETG_TRACE_USR1(( " tun_MsgFromHMI :: vHandle_s_DirectFrequency() -> Freq:%d",oMsg.u32Frequency));

         midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult oResponse;
#ifndef GTEST_x86LINUX_BUILD
         if((m_potun_MsgToHMI->m_u32ATStationFreq != u32Frequency)
                  && (m_potun_Config->bGetFrequencyValid(u8CurrentBand,u32Frequency)))
         {

         m_MuteHandlingRequest.u32Frequency_Direct = oMsg.u32Frequency;

#ifdef MUTE_ACTIVE
         /*---------------------------------------------*/
         if(m_MuteHandlingRequest.enMuteAction_curr == PresetRecall
               || m_MuteHandlingRequest.enMuteAction_curr == StationList)
         {
            m_MuteHandlingRequest.enMuteAction_next = DirectFrequency;
         }
         else
         {
               m_MuteHandlingRequest.enMuteAction_curr = DirectFrequency;
               m_potun_MsgToHMI->vSend_MuteDemuteReq(true,false);
         }
#else
         vSend_DirectFrequency();
#endif

         // Method Result to the client
         vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         }
         else if(m_potun_MsgToHMI->m_u32ATStationFreq == u32Frequency)
         {
            // Method Result to the client
            vSendMethodResult(oResponse,\
                  poMessage,\
                  (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         }
         else
         {
            // Method Result to the client
            vSendMethodResult(oResponse,\
                  poMessage,\
                  (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);

         }
#endif
        }
        else
        {
            m_potun_MsgToHMI->vSetDirectFreqRequested(TRUE);
            m_u32DirectFreq = u32Frequency;

            m_potun_MsgToHMI -> vSetTunerMasterCommandCntrForDirectFreq(poMessage->u16GetCmdCounter());
            m_potun_MsgToHMI -> vSetTunerMasterRegIDForDirectFreq(poMessage->u16GetRegisterID());

#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR ->vSendATFrequency( enATFrequencyAbsOrRel_AbsoluteValue, /* tenATFrequencyAbsOrRel enAbsOrRel    */
                                       0,                                   /* tU8 u8NSteps                         */
                                       u32Frequency,                        /* tU32 u32Frequency                    */
                                       enATFrequencyDirection_unused,       /* tenATFrequencyDirection enDirection  */
                                       (tU8)enInstanceId_AudioSource1);          /* tU8 u8TunerHeader                    */

            /** if preset type is mixed preset then  skip the below part as there is only one preset list*/
            if(!m_poclConfigInterface->u32GetConfigData("PresetListType"))
#endif
            {
               /*If frequency is not valid for the current band, send the preset list active -- solution for NIKAI-6231*/
#ifndef GTEST_x86LINUX_BUILD
               if(!(m_potun_Config->bGetFrequencyValid(u8CurrentBand,u32Frequency)))
               {
                  ETG_TRACE_USR1(( " tun_MsgFromHMI :: vHandle_s_DirectFrequency() ->\
                               Freq requested not in valid band, u8CurrentBand : %d", \
                               ETG_CENUM( tenBand,    u8CurrentBand)));
                  #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
                  if(m_poclAars_ATPresetListSetActive  == NULL)
                  {
                     NORMAL_M_ASSERT( m_poclAars_ATPresetListSetActive != NULL );
                     return;
                  }
                        #endif
                  if(u8CurrentBand == (tU8)FI_EN_TUN_BAND_FM)
                  {
                     tU8 u8HMIListId = (tU8)oGetMidwTunerBandToPresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_MW);
                     #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
                     m_poclAars_ATPresetListSetActive->vSendATPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListId));
                     #else
                     m_potun_MsgToADR->vSetPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListId));
                     #endif
                  }
                  else if (u8CurrentBand == (tU8)FI_EN_TUN_BAND_MW)
                  {
                     tU8 u8HMIListId = (tU8)oGetMidwTunerBandToPresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_FM);
                     #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
                     m_poclAars_ATPresetListSetActive->vSendATPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListId));
                     #else

                     m_potun_MsgToADR->vSetPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListId));
                     #endif
                  }
                  else if (u8CurrentBand == (tU8)FI_EN_TUN_BAND_CB1)
                  {
                     tU8 u8HMIListId = (tU8)oGetMidwTunerBandToPresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_CB1);
                     #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
                     m_poclAars_ATPresetListSetActive->vSendATPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListId));
                     #else

                     m_potun_MsgToADR->vSetPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListId));
                     #endif
                  }

               }
#endif
            }
        }
        break;

      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY _\
                            ET_EN_DONE);
         break;
      }
   }
    
  }

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_s_DirectFrequency
*
* DESCRIPTION:  Command from HMI to change frequency to the given Frequency value
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSend_DirectFrequency()
{
    if((m_potun_MsgToADR == NULL) || (m_potun_ActualData == NULL) || (m_potun_Config == NULL))
    {
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        NORMAL_M_ASSERT( m_potun_ActualData != NULL );
        NORMAL_M_ASSERT( m_potun_Config != NULL );
        return;
    }

   ETG_TRACE_USR4(( " tun_MsgFromHMI ::vSend_DirectFrequency()"));


     ETG_TRACE_USR1(( " tun_MsgFromHMI :: vHandle_s_DirectFrequency() -> FID_TUN_S_DIRECT_FREQUENCY: Frequency valid, u32Frequency = %d kHz"
                  ,m_MuteHandlingRequest.u32Frequency_Direct));
#ifndef GTEST_x86LINUX_BUILD
     m_potun_MsgToADR ->vSendATFrequency( enATFrequencyAbsOrRel_AbsoluteValue, /* tenATFrequencyAbsOrRel enAbsOrRel    */
                                 0,                                   /* tU8 u8NSteps                         */
                                 m_MuteHandlingRequest.u32Frequency_Direct,                        /* tU32 u32Frequency                    */
                                 enATFrequencyDirection_unused,       /* tenATFrequencyDirection enDirection  */
                                 (tU8)enInstanceId_AudioSource1);          /* tU8 u8TunerHeader                    */
#endif

}


#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
/*******************************************************************************
*FUNCTION:    tun_DiagService::vHandleSetBandFrq
*
*DESCRIPTION: This function set Band and frequency
*
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgFromHMI :: vHandleSetBandFrq( amt_tclServiceData* /*poMessage*/ )
{
#if 0
  //Validatte pointers
  if(( poMessage == NULL )||( m_potun_ActualData == NULL )||( m_potun_Config == NULL )\
     ||( m_potun_MsgToADR == NULL ))
  {
    NORMAL_M_ASSERT (NULL != poMessage);
    NORMAL_M_ASSERT( m_potun_ActualData != NULL );
    NORMAL_M_ASSERT( m_potun_Config != NULL );
   NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
   return;
  }


    switch (poMessage->u8GetOpCode())
    {

      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
        {
          midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FRQ_VAGMethodStart  oMsg;

          // Extract contents from amt based message
          vGetDatafromAMT(poMessage,oMsg);

          tU8 u8TunerHeader = (tU8)oMsg.u8TunerHeader;

          tU32 u32Frequency = (tU32)oMsg.u32Frequency;

          /*-------------------------------------------------------------*
           * Get the informations of band and Frq stored in Actualdata file
           *-------------------------------------------------------------*/

          tU8 u8Band = m_potun_ActualData->m_otun_Data_MainStatus.u8GetBand();

          if( u8TunerHeader == TU_BACKGROUND )
          {
            u8Band = (tU8) FI_EN_TUN_BAND_FM;
            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI ,\
                                ET_EN_T8 _ 0xF8 _ \
                                ET_EN_T8 _ u8TunerHeader _ \
                                ET_EN_T8 _ u8Band _ \
                                ET_EN_DONE);
          }


          //Check if the Frequency is valid or not
          if (!(m_potun_Config->bGetFrequencyValid(u8Band,u32Frequency)))
          {
            //Frequency should be in the range
            // FM:87500-108000, MW : 531-1620, LW : 153-279
          ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_PARA _\
                              ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FRQ_VAG _\
                              ET_EN_T32 _ u32Frequency _\
                              ET_EN_T8 _ u8Band _\
                              ET_EN_DONE);
          }


          /****************************************************/
          /*           Send request to RU                     */
          /****************************************************/

          if(m_potun_Config->bGetFrequencyValid(u8Band,u32Frequency))
          {

              tU8 u8AbsOrRel =TU_ABS_VALUE;
              tU8 u8RelSteps =0;
              tU8 u8Direction =0;

              ETG_TRACE_USR1(( " tun_MsgFromHMI ::vHandleSetBandFrq(), MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FRQ_VAG, Methodstart, TunerHeader=%02x, u32Frequency=%d kHz"
                               ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_TUNERHEADER_TENTYP, oMsg.u8TunerHeader)
                               ,oMsg.u32Frequency
                            ));

              m_potun_MsgToADR ->vSendATFrequency( (tenATFrequencyAbsOrRel)u8AbsOrRel,         /* tenATFrequencyAbsOrRel enAbsOrRel    */
                                                   u8RelSteps,                                 /* tU8 u8NSteps                         */
                                                   u32Frequency,                               /* tU32 u32Frequency                    */
                                                   (tenATFrequencyDirection)u8Direction,       /* tenATFrequencyDirection enDirection  */
                                                   u8TunerHeader);                             /* tU8 u8TunerHeader                    */

            }


          /** Send the response(MethdResult) to client */

          midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FRQ_VAGMethodResult oResponse;

        /** Method Result to the client */
        vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI ,\
                              ET_EN_T8 _ oResponse.TunerServer_StatusResponse.u8TunerStatus.enType _\
                              ET_EN_T8 _ oResponse.TunerServer_StatusResponse.u8TunerState.enType _\
                              ET_EN_DONE);

          break;


        }

      default:
        {

          break;
        }

    }

     

#endif

}
#endif
/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandleAutostoreError
*
* DESCRIPTION:  It handles autostore error part.
*
* PARAMETER: poMessage
*
* RETURNVALUE: NONE
*
* History:
*10/09/2013  | InitialVersion | ngp1kor, pmn3kor
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandleAutostoreError(amt_tclServiceData *poMessage)
{
    ETG_TRACE_USR1(("inside vHandleAutostoreError"));

    midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult oResponse;

         // Response -> SUCC / FAIL / BUSY
    oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
                             midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;

     // Current Tuner state -> Not required for client. NORMAL added as default.
    oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
                             midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

    vSendMessage( poMessage->u16GetSourceAppID(),
                  oResponse,
                  MIDW_TUNERFI_C_U16_FID_TUN_S_AUTOSTORE,
                  AMT_C_U8_CCAMSG_OPCODE_ERROR,
                  poMessage->u16GetCmdCounter(),
                  poMessage->u16GetRegisterID()
                );
    }

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandleAutostoreMethodStart
*
* DESCRIPTION:  It handles autostore method call.
*
* PARAMETER: poMessage
*
* RETURNVALUE: NONE
*
* History:
*9/11/2013  | InitialVersion | ngp1kor, pmn3kor
*10/09/2013 | Moved the common error handler| ngp1kor, pmn3kor
*           | code to other function        |
*************************************************************************/
tVoid tun_MsgFromHMI::vHandleAutostoreMethodStart(amt_tclServiceData *poMessage)
{
    ETG_TRACE_USR1(("inside vHandleAutostoreMethodStart"));

   if(( m_potun_Config == NULL ) || ( m_potun_MsgToHMI == NULL ) || ( m_potun_MsgToADR == NULL ) || (m_poclConfigInterface == NULL))
  {
    NORMAL_M_ASSERT( m_potun_Config != NULL );
   NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
   NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
   NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
   return;
  }

    if(poMessage->u16GetSourceAppID() != CCA_C_U16_APP_TUNERMASTER)
    {
        ETG_TRACE_USR1(("AppID is not TunerMaster"));
        /**If Appid is not tunermaster then send Autostore
         *response as Error*/
        vHandleAutostoreError( poMessage );
    }

    else
    {

        /*create object of autostore method start*/
        midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart oMethodStartAutostore;

        /* Extract contents from amt based message */
        vGetDatafromAMT(poMessage,oMethodStartAutostore);

        /**store command counter for further usage*/
        m_potun_MsgToHMI -> vSetCmdCtrForAutostore(poMessage->u16GetCmdCounter());
        /*check the status of autostore*/
        if (false == oMethodStartAutostore.bStatus)
        {
            /*send the Cancel Autostore command as autostore status is false*/
         m_potun_MsgToADR->vSendCancelAutostore();

        }
        else
        {
            /*read the list ID from methodstart object*/
        	tU8 u8PresetListID = (tU8)oMethodStartAutostore.e8ListID.enType;
            /**presetlist ID is available for AMFM only.
             *so check till TUN_BANK_AM_AST*/
            /**check if FunctionId Of List is valid or
             *it is sent as 0xff(invalid) */
        	 tU16 u16FunctionIdOfList = (u8PresetListID <= (tU8)TUN_BANK_DRM_AST)?\
        	                        (U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_ListID::tenType)u8PresetListID)) \
        	                        : (tU8)TUN_BANK_NONE;

            if(u8PresetListID != (tU8)midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_NONE)
            {
                //call new function for Activating the Preset list.

                /*start the autostore*/
                /*get values for parameters of startresult optype of autostore*/
				/*get number of stations depending on the preset list ID*/
            	tU8 u8MaxNoOfStations = U8GetUserAutoSToreNoOfStations(u8PresetListID);
                tU8 u8BehaviouralSwitch = (tU8)m_poclConfigInterface->u32GetConfigData("AutostoreBehavioralSwitches");
                tenAMFMAutostore_UnUsedPreset enUnUsedPreset = (tenAMFMAutostore_UnUsedPreset)m_poclConfigInterface->u32GetConfigData("AutostoreUnusedPresetParameter");
            /*enum for sorting criteria present in KDS starts with 1 where as in Tuner SWCD it is from 0
            So inorder to match the same it is subtracted by 1*/
                tenAMFMAutostore_Sort enSortingCriteria = (tenAMFMAutostore_Sort)((m_potun_Config->u8GetSortingCriteriaForAutostore(u16FunctionIdOfList))-1);

                /**Send request to radio unit */
                m_potun_MsgToADR->vSendAutostore(u16FunctionIdOfList, u8MaxNoOfStations, enUnUsedPreset\
                    , enSortingCriteria, u8BehaviouralSwitch);


            }
            else
            {
                ETG_TRACE_USR1(("MsgFromHMI -> vHandleAutostoreMethodStart: u16PresetListID is invalid"));
                ETG_TRACE_USR1(("u8PresetListID : %u", u8PresetListID));
                ETG_TRACE_USR1(("u16FunctionIdOfList : %u", u16FunctionIdOfList));
                /**As functionId of list is 0xff(invalid)
                 *Send Autostore result as error*/
                vHandleAutostoreError( poMessage );
            }/*(u16FunctionIdOfList != TUN_BANK_NONE)*/



        }/*(false == oMethodStartAutostore.bStatus)*/

    }/**AppId == CCA_C_U16_APP_TUNERMASTER*/

}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_s_Autostore
*
* DESCRIPTION:  Command from HMI to autostore the stations in the Preset List
*
* PARAMETER: poMessage
*
* RETURNVALUE: NONE
*
* History:
*9/3/2013  | InitialVersion | ngp1kor, pmn3kor
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Autostore(amt_tclServiceData *poMessage)
{
   ETG_TRACE_USR1(("MsgFromHMI -> vHandle_s_Autostore"));


   if(( poMessage == NULL ) ||( m_potun_HMIManager == NULL ) ||
       (m_potun_Config == NULL) || (m_potun_MsgToADR == NULL) ||
       (m_potun_MsgToHMI == NULL))
   {
      ETG_TRACE_USR1(("MsgFromHMI -> vHandle_s_Autostore: poMessage NULL pointer check"));
      NORMAL_M_ASSERT( poMessage != NULL );
      NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
      NORMAL_M_ASSERT( m_potun_Config != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      return;
   }


   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
            /**Call the handler for opcode MethodStart*/
            vHandleAutostoreMethodStart(poMessage);
      }/* case AMT_C_U8_CCAMSG_OPCODE_METHODSTART: */
      break;
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ETG_TRACE_USR1(("MsgFromHMI -> vHandle_s_Autostore : wrong opcode"));

      }
      break;
   }/* switch (poMessage->u8GetOpCode()) */
    
}/*vHandle_s_Autostore*/





/*************************************************************************
* FUNCTION:     tun_MsgFromHMI::vHandle_s_SelectListElem
*
* DESCRIPTION:  Command from HMI to select the element from the Stations List.
*
* PARAMETER:    poMessage   -message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_SelectListElem( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_LIST_ELEM _\
                     ET_EN_DONE);

    /* Pointer validation.*/
  if( (poMessage == NULL ) || ( m_potun_ActualData == NULL )||( m_potun_MsgToADR == NULL ) )
   {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

       NORMAL_M_ASSERT( poMessage != NULL );
       NORMAL_M_ASSERT( m_potun_ActualData != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
     return;
   }


   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         /* Object creation */
        midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart oMsg;

        /*  Extract contents from amt based message. */
        vGetDatafromAMT(poMessage,oMsg);

        /* get the List element ID to be selected */
      m_MuteHandlingRequest.u8StationList_ElemID = oMsg.Sel_List_Elem.u8ListElementID;
      m_MuteHandlingRequest.u16StationListID = (tU16)oMsg.Sel_List_Elem.eConfigListID.enType;

      m_MuteHandlingRequest.u32StationListElem_Frequency = oMsg.Sel_List_Elem.u32Frequency;
      m_MuteHandlingRequest.u16StationListElem_PICode = oMsg.Sel_List_Elem.u16PICode;
      m_MuteHandlingRequest.u32StationListElem_HDStnID_DRMSrvID = oMsg.Sel_List_Elem.u32HDStnID_DRMSrvID;
      m_MuteHandlingRequest.u8StationListElem_ModulationType = (tU8)oMsg.Sel_List_Elem.e8ModulationType.enType;


#ifdef MUTE_ACTIVE
      if(m_MuteHandlingRequest.enMuteAction_curr == PresetRecall
            || m_MuteHandlingRequest.enMuteAction_curr == StationList)
      {
         m_MuteHandlingRequest.enMuteAction_next = StationList;
      }
      else
      {
         m_MuteHandlingRequest.enMuteAction_curr = StationList;
         m_potun_MsgToHMI->vSend_MuteDemuteReq(true,true);
      }
#else

         vSend_SelectListElem();
#endif
      /** Response to the client */
        midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult oResponse;

      /** Method Result as success to the client */
      vSendMethodResult(oResponse,\
            poMessage,\
            (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

      } /* case AMT_C_U8_CCAMSG_OPCODE_METHODSTART */

     break;

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ETG_TRACE_ERR(( " tun_MsgFromHMI ::vHandle_s_SelectListElem(), MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_LIST_ELEM, Wrong Opcode."
                      ));
         break;
      }

   } /* switch (poMessage->u8GetOpCode()) */

    

} /* vHandle_s_SelectListElem( amt_tclServiceData* poMessage ) */


/*************************************************************************
* FUNCTION:     tun_MsgFromHMI::vSend_SelectListElem
*
* DESCRIPTION:  Command from HMI to select the element from the Stations List.
*
* PARAMETER:    poMessage   -message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSend_SelectListElem()
{
    if(( m_potun_MsgToADR == NULL )|| (m_potun_ActualData == NULL))
    {
       NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
       NORMAL_M_ASSERT( m_potun_ActualData != NULL );
       return;
    }





   /** if stationlist list element from other band(not currently tuned) is selected
      then send set lsm msg instead of station list element select*/

   tU8 u8Band = u8GetBandFromStationListID();

   ETG_TRACE_USR1(( " tun_MsgFromHMI ::vSend_SelectListElem(), MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_LIST_ELEM, ListID=%d, \
                u8ListElementID=%d,u32ListElementFrequency=%d,u8ListElementPICode=0x%02x\
                ,u8Band = %d, actualband=%d"
                         ,m_MuteHandlingRequest.u16StationListID
                   ,m_MuteHandlingRequest.u8StationList_ElemID
                         ,m_MuteHandlingRequest.u32StationListElem_Frequency
                   ,m_MuteHandlingRequest.u16StationListElem_PICode
                   ,u8Band, m_potun_ActualData->m_otun_Data_Station.u8GetBand()
                      ));

   if(m_potun_ActualData->m_otun_Data_Station.u8GetBand() !=  u8Band)
   {
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
      u8Band = m_potun_MsgToADR->u8ConvertTunerbandToCombiband(u8Band);
#endif
#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR ->vSendLSMSetup(\
         u8Band,\
         m_MuteHandlingRequest.u32StationListElem_Frequency,\
         m_MuteHandlingRequest.u16StationListElem_PICode,
         m_MuteHandlingRequest.u32StationListElem_HDStnID_DRMSrvID ,
         m_MuteHandlingRequest.u8StationListElem_ModulationType
         );
#endif
   }
   else
   {
      m_potun_MsgToADR ->vSendSelListElem( m_MuteHandlingRequest.u16StationListID,
                     m_MuteHandlingRequest.u8StationList_ElemID, TUN_LIST_TYPE_CONFIG);

      if(u8GetConfigListID() != 0xFF)
      {
          ETG_TRACE_USR4(( " tun_MsgFromHMI ::vSend_SelectListElem , send Station list exit "));
          m_potun_MsgToADR -> vSendStationListExit(u8GetConfigListID());
          vSetConfigListID(0xFF);
      }

   }
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vHandle_MakeConfigList()
*
* DESCRIPTION: Command from HMI to make the config list,
*
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_GetConfigList( amt_tclServiceData* poMessage )
{
     ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _
                                         ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST _ ET_EN_DONE);

   if(( poMessage == NULL ) ||( m_potun_MsgToHMI == NULL ) ||
    (m_potun_Config == NULL) ||(m_potun_MsgToADR == NULL))
   {
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      NORMAL_M_ASSERT( m_potun_Config != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
     return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

        midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart omessage;

        vGetDatafromAMT(poMessage,omessage);

		/** Store the command counter, Reg Id and App Id */
		m_potun_MsgToHMI->m_u16StationListCommandCtr = poMessage->u16GetCmdCounter();
        m_potun_MsgToHMI->m_u16UIRegID = poMessage->u16GetRegisterID();
		m_potun_MsgToHMI->m_u16UIAppID = poMessage->u16GetSourceAppID();

        /* the List ID to be made */
        tU8 u8ConfigListID      = (tU8)omessage.TunMakeConfigList.eConfigListID.enType;

      if(u8ConfigListID == (tU8)enCM_StationListConfigListID_TMC)
        {
         m_potun_MsgToADR ->vSendGetTMCList();
         m_potun_MsgToHMI->vSetCmdCtrTMCConfigList(poMessage->u16GetCmdCounter());
        }
      else
      {
      #ifndef VARIANT_S_FTR_ENABLE_ADR_API_3_20

         /** sorting criteria for list */
         tU8 u8SortCriteria = (tU8)omessage.TunMakeConfigList.eSortingCriteria.enType;
         tU32 u32PTYFilter = omessage.TunMakeConfigList.u32PTY;

              if(u8ConfigListID == (tU8)enCM_StationListConfigListID_FM)
              {
                 vSetProperSortingCriteria(u8SortCriteria);

              /* Send request to Radio unit */
#ifndef GTEST_x86LINUX_BUILD
              m_potun_MsgToADR ->vSendMakeConfigList( u32PTYFilter, u8ConfigListID, u8SortCriteria );
#endif


              ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST _\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MS _\
                            ET_EN_T8 _ u8ConfigListID _\
                            ET_EN_T8 _ u8SortCriteria _\
                           ET_EN_DONE);
              }
              /** For TMC List */
              else if(u8ConfigListID == (tU8)enCM_StationListConfigListID_TMC)
              {
#ifndef GTEST_x86LINUX_BUILD
                 m_potun_MsgToADR ->vSendGetTMCList();
#endif
                 m_potun_MsgToHMI->vSetCmdCtrTMCConfigList(poMessage->u16GetCmdCounter());
              }
              /** For AM, MW and LW List */
              else
              {
#ifndef GTEST_x86LINUX_BUILD
                   m_potun_MsgToADR ->vSendMakeConfigList( u32PTYFilter, u8ConfigListID, u8SortCriteria );
#endif

              }
      #else
              ETG_TRACE_USR4(("Both TMC and station list"));
            vHandleAllMessages(poMessage);
              /** For TMC List */
      #endif
      }

        /** For AM, MW and LW List */



      }

      break;

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
		//register clients in both old and new way (different notification table) only TMC list update gets posted in old way, rest all list updates happens in new way
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		vHandleAllMessages(poMessage);
#endif
        if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);

         }
         else
         {
          ETG_TRACE_USR2(( " tun_MsgFromHMI::vHandle_GetConfigList() : Adding to notification table:Success"));
         }
      }
      break;
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
		//deregister the property from both old way and new way.
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		vHandleAllMessages(poMessage);
#endif
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _
                                                         ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST _ ET_EN_DONE);
         break;
      }
   }
    

 }


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vSetProperSortingCriteria()
*
* DESCRIPTION: Sets proper sorting criteria based on the current status of
*           RDS switch and PI ignoere switch
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
* Author : vnd4kor ECV2
*************************************************************************/
 tVoid tun_MsgFromHMI::vSetProperSortingCriteria( tU8& u8SortCriteria)
 {
    /** get current RDS switch value */
    tU8 u8RDS = m_potun_MsgToHMI -> u8GetRDSSwitchStatus();
    /** get configured PI Ignore switch value */
    tU8 u8GetPIIgnore     = (tU8)m_poclConfigInterface -> u32GetConfigData("PIIgnore");

    ETG_TRACE_COMP(( " tun_MsgFromHMI::vSetProperSortingCriteria() -> RDS=%d, PI_Ignore=%d , \
                 u8SortCriteria = %d"
                 ,u8RDS
                 ,u8GetPIIgnore
                 ,u8SortCriteria
               ));

    if((u8SortCriteria != (tU8)enCM_StationListConfigSorting_FREQUENCY_ASCENDING )
       &&
       (u8SortCriteria  != (tU8)enCM_StationListConfigSorting_FREQUENCY_DESCENDING)
       &&
       (u8SortCriteria  != (tU8)enCM_StationListConfigSorting_FIELDSTRENGTH_DESCENDING)
       &&
       (u8SortCriteria  != (tU8)enCM_StationListConfigSorting_FIELDSTRENGTH_ASCENDING)
       )
    {
       /** If RDS is off then any sorting criteria related
       to RDS will be replaced with default sorting criteria.
       llly if RDS ON and PI ignore is TRUE then any sorting
       criteria w.r.t PI will be replaced by defaut sorting
       criteria*/
       if(u8RDS != 0x01)
       {
          ETG_TRACE_USR2(( " tun_MsgFromHMI::vHandle_GetConfigList() : RDS OFF, Sorting = freq Ascending"));
          u8SortCriteria = (tU8)enCM_StationListConfigSorting_FREQUENCY_ASCENDING;
       }
       else if(
          (u8GetPIIgnore == 0x01)
          &&
          (
          (u8SortCriteria == (tU8)enCM_StationListConfigSorting_PI_DESCENDING)
          ||
          (u8SortCriteria == (tU8)enCM_StationListConfigSorting_PI_ASCENDING)
          )
          )
       {
          ETG_TRACE_USR2(( " tun_MsgFromHMI::vHandle_GetConfigList() : PI Ignore ON, Sorting = freq Ascending"));
          u8SortCriteria = (tU8)enCM_StationListConfigSorting_FREQUENCY_ASCENDING;
       }
    }
 }


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vHandle_UpdateConfigList()
*
* DESCRIPTION: Command from HMI to update the config list,
*              Refresh or release.
*
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
///*tVoid tun_MsgFromHMI::vHandle_UpdateConfigList( amt_tclServiceData* poMessage )
//{

//  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _
//                                         ET_EN_T16 _ FID_TUN_S_UPDATE_CONFIG_LIST _ ET_EN_DONE);

//  if( ( poMessage == NULL ) || (m_potun_MsgToHMI == NULL))
//  {
//     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );

//     NORMAL_M_ASSERT( poMessage != NULL );
//     NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );

//     return;
//  }


//  gm_tclU16Message omessage( poMessage ) ;

//   tU16 u16Message = omessage.u16GetWord ();

//   tU8 u8ConfigListID = (tU8) ( u16Message & 0x00ff );
//   tU8 u8UpdateMode  = (tU8) ( ( u16Message & 0xff00 ) >> 8 );

//  switch (poMessage->u8GetOpCode())
//   {


//   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
//      {

//        tU16 u16ResponseToClient = TUN_RES_REQ_FAIL;

        /*---------------------------------------------------------*/
        /* Send Update Config List request to Radio Unit           */
        /*---------------------------------------------------------*/
//        if( m_potun_MsgToADR != NULL )
//        {
//          m_potun_MsgToADR -> vSendUpdateConfigList(u8ConfigListID, u8UpdateMode);

//          u16ResponseToClient = u16UpdateTunerStateInMethodResult( TUN_RES_REQ_SUCCEED );

//          bSendAnswer( poMessage, u16ResponseToClient, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT );

//          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _
//                                                        ET_EN_T16 _ FID_TUN_S_UPDATE_CONFIG_LIST _
//                                                        ET_EN_T8 _ u8ConfigListID _

//

//          u16ResponseToClient = u16UpdateTunerStateInMethodResult( TUN_RES_REQ_FAIL );

//          bSendAnswer( poMessage, u16ResponseToClient, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT );



//      break;

//   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
//      {
//        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _
//                                                        ET_EN_T16 _ FID_TUN_G_UPDATE_CONFIG_LIST _ ET_EN_DONE);

//         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
//         {

//           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

//           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);







//                                           FID_TUN_G_UPDATE_CONFIG_LIST,           /*  Function ID       */
//                                           AMT_C_U8_CCAMSG_OPCODE_STATUS );        /*  OpCode            */

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/

//         oStatusMessage.vSetListID( TUN_LIST_ID_FIRST );

//         oStatusMessage.vSetNumOfElementsInList( TUN_MAKE_CONFIG_FIRST_ELEM );



        /*---------------------------------------------------------*/
        /* Send list ID and Number of   */
        /*---------------------------------------------------------*/
//           if(poGWMain->enPostMessage( &oStatusMessage ) != AIL_EN_N_NO_ERROR)
//           {
              /* +++
              can't send status:
              enter error handling here ( trace or assert )
              +++ */
//              ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ FID_TUN_G_UPDATE_CONFIG_LIST _
//                                                             ET_EN_T16 _ TUN_TRACE_MSG_POST_FAIL_ERR _ ET_EN_DONE );

              /* Release the memory */
//              oStatusMessage.bDelete();


//           }



//           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _ ET_EN_DONE);




//      break;

//     case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
//        {
//         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
//         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */

//         }
//         else
//         {
             /* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */


//        break;
//   default:
//      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
//        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _
//                                                         ET_EN_T16 _ FID_TUN_S_MAKE_CONFIG_LIST _ ET_EN_DONE);
//         break;
//      }
//   }
    

//}*/

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vHandle_SetAudFGBG()
*
* DESCRIPTION: Command from HMI to send tuner into foreground or background.
*
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* Date      | Author                       | Modification
* 30.06.06  | RBIN pus1kor                 | Initial version.
*
*************************************************************************/
tVoid tun_MsgFromHMI :: vHandle_SetAudFGBG( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW _\
                     ET_EN_DONE);

   if(( poMessage == NULL )||( m_potun_MsgToHMI == NULL) || (m_potun_HMIManager == NULL)\
      ||( m_potun_MsgToADR == NULL ))
   {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _ ET_EN_DONE );

     NORMAL_M_ASSERT( poMessage != NULL );
     NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
     NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
     return;
   }

   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
    ETG_TRACE_USR4(( " tun_MsgFromHMI ::vHandle_SetAudFGBG, Methodstart "));


          midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart oMsg;

          // Extract contents from amt based message
          vGetDatafromAMT(poMessage,oMsg);

          midw_fi_tcl_e8_Tun_TunerHeader e8_TunerHeader;
          midw_fi_tcl_e8_Tun_SubCommand e8SubCommand;
          midw_fi_tcl_e8_Tun_AudioSink e8AudioSink;
      midw_fi_tcl_e8_Tun_PhysicalTuner e8PhysicalTuner;
      tBool bTunerState;

          /* u8TunerHeader */
          e8_TunerHeader.enType = oMsg.TunAudFGBGNew.u8_TunerHeader.enType;

          /*SubCommand = 0x00   ->     FG
                       = 0x01   ->     BG*/

          e8SubCommand.enType = oMsg.TunAudFGBGNew.u8SubCommand.enType;

          /* 0x00 -> USR1   */
          /* 0x01 -> TA     */
          /* 0x02 -> TIM    */
          /* 0x03 -> PTY    */
          /* 0x04 -> News   */
      /* 0x05 -> DABTemp   */
      /* 0x06 -> TempFM   */
          e8AudioSink.enType = oMsg.TunAudFGBGNew.u8AudioSink.enType;

      e8PhysicalTuner.enType = oMsg.TunAudFGBGNew.u8_PhysicalTuner.enType;

      bTunerState = oMsg.TunAudFGBGNew.bTunerState;

      ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_SetAudFGBG ->TunerHeader = %d, SubCmnd =%d, AudioSink =%d, PhysicalTuner = %d, TunerState = %d"
              , e8_TunerHeader.enType
              , e8SubCommand.enType
              , e8AudioSink.enType
              , e8PhysicalTuner.enType
              , bTunerState));

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW _\
                             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MS _\
                             ET_EN_T8 _ e8_TunerHeader.enType _\
                             ET_EN_T8 _ e8SubCommand.enType _\
                             ET_EN_T8 _ e8AudioSink.enType _\
               ET_EN_T8 _ bTunerState _\
                             ET_EN_DONE);
    m_potun_MsgToHMI -> vSetTunerMasterCommandCntrForFGBG(poMessage->u16GetCmdCounter());
    m_potun_MsgToHMI -> vSetTunerMasterRegIDForFGBG(poMessage->u16GetRegisterID());

#ifndef GTEST_x86LINUX_BUILD
    m_potun_MsgToADR ->vSend_TUNFgBg((tU8)e8_TunerHeader.enType, (tU8)e8SubCommand.enType, (tU8)e8AudioSink.enType, bTunerState, (tU8)e8PhysicalTuner.enType);
#endif

    /*Set PWM12 duty cycle to 100%, Tuner is in Background*/
    if((tU8)e8SubCommand.enType == TU_BACKGROUND)
    {
      ETG_TRACE_USR4((" vHandle_SetAudFGBG , background request "));
#ifndef GTEST_x86LINUX_BUILD
         poGWMain->vSetPWM( 100 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
#endif
         vSetAMSrcStatus(FALSE);
    }


      //Send method result if method start is not from TunerMaster
     /** Vnd4kor: Solving Lint warnings , added brackets to oMsg.TunAudFGBGNew.u8_PhysicalTuner.enType */
      if((poMessage->u16GetSourceAppID() != CCA_C_U16_APP_TUNERMASTER) || ((tU8)(oMsg.TunAudFGBGNew.u8_PhysicalTuner.enType) != 0xFF))
      {
        midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult oResponse;

      /** Method Result as success to the client */
      vSendMethodResult(oResponse,\
            poMessage,\
            (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

      }



         break;

        }
#if 0
   case AMT_C_U8_CCAMSG_OPCODE_UPREG:

      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
               ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_FG_BG_NEW _\
               ET_EN_DONE);

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                ET_EN_DONE);

         }
         else
         {

            midw_tunerfi_tclMsgFID_TUN_G_AUDIO_FG_BG_NEWStatus oStatusMsg;
              /*-------------------------------*/
              /* Post message to HMI component */
              /*-------------------------------*/

                     /*------------------------*/
            /* Fill in the message    */
            /*------------------------*/

            oStatusMsg.TunAudioFgBgStatus.u8_TunerHeader.enType = (midw_fi_tcl_e8_Tun_TunerHeader::tenType)0xff;
            oStatusMsg.TunAudioFgBgStatus.u8AudioSink.u8Value   = 0;


/*          oStatusMessage.vSetTunerHeader(0xff);

            oStatusMessage.vSetAudioSink(0);*/


            vSendMessage( poMessage->u16GetSourceAppID(),
                          oStatusMsg,
                          poMessage->u16GetFunctionID(),
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          poMessage->u16GetCmdCounter(),
                          poMessage->u16GetRegisterID()
                        );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                              ET_EN_DONE);

         }


      }
      break;
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }

#endif 

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN(TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
               ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW _\
               ET_EN_DONE);
         break;
      }
   }

    
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vHandle_SetPI()
*
* DESCRIPTION: Command from HMI to send tuner 1/Tuner2 into foreground.
*
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* Date      | Author                       | Modification
* 30.06.06  | RBIN pus1kor                 | Initial version.
*
*************************************************************************/
tVoid tun_MsgFromHMI :: vHandle_SetPI( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _
                                                  ET_EN_T16 _ FID_TUN_S_SET_PI _ ET_EN_DONE);

   if(( poMessage == NULL )||( m_potun_MsgToHMI == NULL) ||(m_potun_ActualData ==NULL)\
      ||( m_potun_MsgToADR == NULL ))
   {

    NORMAL_M_ASSERT( poMessage != NULL );
   NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
    NORMAL_M_ASSERT (m_potun_ActualData !=NULL);
   NORMAL_M_ASSERT ( m_potun_MsgToADR != NULL );

  return;

   }

   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

           midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart omessage;

           /*  Extract contents from amt based message. */
           vGetDatafromAMT(poMessage,omessage);

           m_MuteHandlingRequest.u8PIStep_Direction = (tU8)omessage.TunSetPIPara.u8RelSteps.enType;

           m_MuteHandlingRequest.u8AbsRel = (tU8)omessage.TunSetPIPara.u8AbsOrRel.enType;



#ifdef MUTE_ACTIVE

         if(m_MuteHandlingRequest.enMuteAction_curr == PresetRecall
               || m_MuteHandlingRequest.enMuteAction_curr == StationList)
         {
            m_MuteHandlingRequest.enMuteAction_next = PISeek;
         }
         else
         {
            m_MuteHandlingRequest.enMuteAction_curr = PISeek;
            m_potun_MsgToHMI->vSend_MuteDemuteReq(true,false);
         }

#else
         vSend_AtPI();
#endif
       /** Send method result */
      midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult oResponse;

      /** Method Result to the client */
      vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

        break;

      }

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _
                                                         ET_EN_T16 _ FID_TUN_S_SET_PI _ ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vSend_AtPI
*
* DESCRIPTION: Different seek operations can be performed.
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSend_AtPI()
{
    if(m_potun_MsgToADR == NULL)
    {
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        return;
    }

    tU8 u8TunerHeader = TU_FOREGROUND ;
   ETG_TRACE_USR4(( " tun_MsgFromHMI :: vSend_AtPI, SeekDirection = %d, u8AbsRel = %d"
      , m_MuteHandlingRequest.u8PIStep_Direction
      , m_MuteHandlingRequest.u8AbsRel));

   /** Send msg to ADR */
    m_potun_MsgToADR ->vSend_SetPI(u8TunerHeader,
                           m_MuteHandlingRequest.u8AbsRel,
                           m_MuteHandlingRequest.u8PIStep_Direction);
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vHandle_SetSharxLevel()
*
* DESCRIPTION: Command from HMI to send tuner 1/Tuner2 into foreground.
*
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* Date      | Author                       | Modification
* 30.06.06  | RBIN pus1kor                 | Initial version.
*
*************************************************************************/
tVoid tun_MsgFromHMI :: vHandle_SetSharxLevel( amt_tclServiceData* poMessage )
{
   if(( poMessage == NULL )||( m_potun_MsgToHMI == NULL)||(m_potun_MsgToADR == NULL))
   {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

    NORMAL_M_ASSERT( poMessage != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
   NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
   return;
   }

   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {

         midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart oMsg;

           // Extract contents from amt based message
         vGetDatafromAMT(poMessage,oMsg);

         tU8 u8SharxStep = oMsg.u8SharxStep;


         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SET_SHARXLEVEL _\
                            ET_EN_T8 _ 0x03 _\
                            ET_EN_T8 _ u8SharxStep _\
                                                           ET_EN_DONE);
        midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult oResponse;
		if(u8SharxStep >= TUN_SHARX_LIMIT)
		{
			vSendMethodResult(oResponse,poMessage,(tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
		}
		else
		{
			m_potun_MsgToADR ->vSend_SetSharxLevel(u8SharxStep );
			vSendMethodResult(oResponse,poMessage,(tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
		}


      /** Create Method Result object to send Method result to Client */


      /** Method Result to the client */

        break;

      }

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:

      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_SHARXLEVEL _\
                           ET_EN_DONE);

         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);

         }
         else
         {
         /** Send CM_ReceptionParameter Get command for latest Sharx value */
         m_potun_MsgToADR->vGetReceptionParameter((tU8)enCM_ReceptionParameterPosSharx);

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                              ET_EN_DONE);

         }


      }
      break;

   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                                                         ET_EN_T16 _ FID_TUN_G_SET_SHARXLEVEL _ ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    vHandle_g_RadioText
*
* DESCRIPTION: Radio text response to clients..
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: NONE
*
* History:     tVoid
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_RadioText( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                     MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT _\
                     ET_EN_T16 _ FID_TUN_G_CONFIG_LIST_ELEM _\
                     ET_EN_DONE);


  //----------------------------
  // Check for pointer validity:
  //----------------------------
  if( ( poMessage == NULL ) ||\
      ( m_potun_Utility == NULL ) ||\
      (m_potun_MsgToHMI == NULL) ||\
      ( m_potun_HMIManager == NULL )||\
     ( m_potun_MsgToADR == NULL )
     )
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                         TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_Utility != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
  }

   switch (poMessage->u8GetOpCode())
   {


    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                              TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);
         }
         else
         {
          /** Send command to ADR to get radio text */
          m_potun_MsgToADR ->vSend_GetRadiotext();

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                              TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                              ET_EN_DONE);


         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
    case AMT_C_U8_CCAMSG_OPCODE_GET:
       {
       /** Send command to ADR to get radio text */
       m_potun_MsgToADR ->vSend_GetRadiotext();
         break;
      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                             TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT _
                             ET_EN_DONE);
         break;
      }
   }

    
}

/*************************************************************************
* FUNCTION:    vHandle_g_BandPlusStationInfo
*
* DESCRIPTION: Send band plus station information to clients.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: NONE
*
* History:     tVoid
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_BandPlusStationInfo( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                     MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO _\
                     ET_EN_DONE);


  //----------------------------
  // Check for pointer validity:
  //----------------------------
  if( ( poMessage == NULL ) ||\
      ( m_potun_Utility == NULL ) ||\
      (m_potun_MsgToHMI == NULL) ||\
      (m_potun_MsgToADR == NULL) ||\
      ( m_potun_HMIManager == NULL )
     )
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                         TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

    NORMAL_M_ASSERT( poMessage != NULL );
     NORMAL_M_ASSERT( m_potun_Utility != NULL );
     NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
     NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
     return;
  }

   switch (poMessage->u8GetOpCode())
   {

    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                              TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);

         }
         else
         {

          m_potun_MsgToADR -> vGetBandDetails((tU8)enBand_FM);//Request details for FM band
          m_potun_MsgToADR -> vGetBandDetails((tU8)enBand_MW);//Request details for AM band
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
         m_potun_MsgToADR -> vGetBandDetails((tU8)enBand_CB1);
#endif
           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                            MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO _\
                            ET_EN_DONE);
         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                             TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO _
                             ET_EN_DONE);
         break;
      }
   }

    

}

/*************************************************************************
* FUNCTION:    vHandle_g_DiagRemoteControl
*
* DESCRIPTION: Informss if Diag Remote Control is ON/OFF to clients.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: NONE
*
* History:     tVoid
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_DiagRemoteControl( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                     MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO _\
                     ET_EN_DONE);


  //----------------------------
  // Check for pointer validity:
  //----------------------------
  if( ( poMessage == NULL ) || (m_potun_MsgToHMI == NULL) )
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                         TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

   NORMAL_M_ASSERT( poMessage != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
     return;
  }

   switch (poMessage->u8GetOpCode())
   {

    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {

         ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_g_DiagRemoteControl - UPREG "));

         vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                              TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);

         }
         else
         {

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                            MIDW_TUNERFI_C_U16_FID_TUN_G_DIAG_REMOTE_CONTROL _\
                            ET_EN_DONE);
         }
         break;
      }
     case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        {
         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */
         }
         else
         {
             /* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
         }
         break;
      }

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                             TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_DIAG_REMOTE_CONTROL _
                             ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::   vHandle_s_AtFrequencyWithTickInfo()
*
* DESCRIPTION: Single step manual tuning with tick info. When manual tuning is done with
*              rotary encoder, with a single turn, many steps are generated, number of steps are
*              taken with tick information.
*
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* Date      | Author                       | Modification
* 15.06.07  | RBIN Dinesh Punja            | Initial version.
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_AtFrequencyWithTickInfo( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY _\
                     ET_EN_DONE);


   if(( poMessage == NULL )||\
      ( m_potun_MsgToHMI == NULL)||\
      ( m_potun_ActualData == NULL)||\
      ( m_potun_HMIManager == NULL) ||\
     (m_potun_MsgToADR == NULL)
     )
   {

      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                           TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                           ET_EN_DONE );


        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_ActualData != NULL );
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
   }

   // Get current band information
   //tU8 u8Band = m_potun_ActualData->m_otun_Data_MainStatus.u8GetBand();

   // Get current frequency information.
  // tU32 u32Frequency = m_potun_ActualData ->m_otun_Data_Station.u32GetFrequency( );


   /* ---
   the opcode tells what we should do
   --- */

   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
          TUN_TRACE(1);

        midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart oMsg;

        // Make a visitor object to get the data
        vGetDatafromAMT ( poMessage,oMsg);

        ETG_TRACE_USR1(( " tun_MsgFromHMI ::vHandle_s_AtFrequencyWithTickInfo(), \
                   MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY, \
                   Methodstart, TunerHeader=%02x, ManualFreqAdjustment=%02x, \
                   u8NumberOfTicks=%d, u8AcceptAF=%02x"\
                         ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_TUNERHEADER_TENTYP, oMsg.TunerHeader.enType)\
                         ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_MANUALFREQADJUSTMENT_TENTYPE, \
                   oMsg.TunerManualSingleStep.ManualFreqAdjustment.enType)\
                         ,oMsg.TunerManualSingleStep.u8NumberOfTicks\
                         ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_ACCEPTAF_TENTYPE ,oMsg.u8AcceptAF.enType)\
                      ));

       tU8 u8AcceptAF = (tU8)oMsg.u8AcceptAF.enType;
       if(u8AcceptAF)
       {
         m_potun_MsgToADR->vSendAcceptAF();
       }
       //else
       {
           m_MuteHandlingRequest.u8AcceptAF = u8AcceptAF;
           m_MuteHandlingRequest.u8Direction = (tU8) oMsg.TunerManualSingleStep.ManualFreqAdjustment.enType;
           m_MuteHandlingRequest.u8NumberOfTicks = (tU8) oMsg.TunerManualSingleStep.u8NumberOfTicks;
           m_MuteHandlingRequest.u8TunerHeader = (tU8)oMsg.TunerHeader.enType;
           m_potun_ActualData->m_otun_Data_MainStatus.vSetTunerHeader(m_MuteHandlingRequest.u8TunerHeader);

#ifdef MUTE_ACTIVE
         if(m_MuteHandlingRequest.enMuteAction_curr == PresetRecall
               || m_MuteHandlingRequest.enMuteAction_curr == StationList)
         {
            m_MuteHandlingRequest.enMuteAction_next = ManualTuning;
         }
         else
         {
            m_MuteHandlingRequest.enMuteAction_curr = ManualTuning;
            m_potun_MsgToHMI->vSend_MuteDemuteReq(true,false);
         }
#else
         vSend_AtFrequencyWithTickInfo();
#endif
       }

       //------------------------
       // Response to the client
       //------------------------
      /** vnd4kor: Changed as suggested by suchin */
       midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult oResponse;

      /** Method Result to the client */
      vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         break;
      }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _ \
                            ET_EN_T16 _ FID_TUN_S_ATFREQUENCY _\
                            ET_EN_DONE);
         break;
      }
   }

    
}


/*************************************************************************
* FUNCTION:    vSend_AtFrequencyWithTickInfo
*
* DESCRIPTION: Set new mixed preset list.
*
* PARAMETER:   poMessage    - message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vSend_AtFrequencyWithTickInfo()
{
    if((m_potun_MsgToADR == NULL) || (m_potun_ActualData == NULL))
    {
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        NORMAL_M_ASSERT( m_potun_ActualData != NULL );
        return;
    }

   ETG_TRACE_USR1(( " tun_MsgFromHMI ::vSend_AtFrequencyWithTickInfo(), \
                MIDW_TUNERFI_C_U16_FID_TUN_S_ATFREQUENCY, \
                Methodstart, TunerHeader=%02x, ManualFreqAdjustment=%02x, \
                u8NumberOfTicks=%d, u8AcceptAF=%02x"\
                     ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_TUNERHEADER_TENTYP, m_MuteHandlingRequest.u8TunerHeader)\
                     ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_MANUALFREQADJUSTMENT_TENTYPE \
                     ,m_MuteHandlingRequest.u8Direction)\
                     ,m_MuteHandlingRequest.u8NumberOfTicks\
                     ,ETG_ENUM( MIDW_FI_TCL_E8_TUN_ACCEPTAF_TENTYPE ,m_MuteHandlingRequest.u8AcceptAF)\
                  ));

   tU32 u32Frequency = m_potun_ActualData ->m_otun_Data_Station.u32GetFrequency( );
    tU8 u8RelFreqUpOrDown = 0x01;

    if ( m_MuteHandlingRequest.u8Direction == (tU8)midw_fi_tcl_e8_Tun_ManualFreqAdjustment::FI_EN_TUN_SEEK_DIRECTION_UP )
    {
       u8RelFreqUpOrDown = 0x01;
    }
    else
    {
      if( m_MuteHandlingRequest.u8Direction == (tU8)midw_fi_tcl_e8_Tun_ManualFreqAdjustment::FI_EN_TUN_SEEK_DIRECTION_DOWN )
      {
        u8RelFreqUpOrDown = 0xff;
      }
      else
      {
        ETG_TRACE_USR4(( " tun_MsgFromHMI::vSend_AtFrequencyWithTickInfo, parameter out of range "));
      }
    }
#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR ->vSendATFrequency( enATFrequencyAbsOrRel_RelativeValue,        /* tenATFrequencyAbsOrRel enAbsOrRel    */
                                        m_MuteHandlingRequest.u8NumberOfTicks,    /* tU8 u8NSteps                         */
                                           u32Frequency,                               /* tU32 u32Frequency                    */
                                           (tenATFrequencyDirection)u8RelFreqUpOrDown, /* tenATFrequencyDirection enDirection  */
                                           m_MuteHandlingRequest.u8TunerHeader);     /* tU8 u8TunerHeader                    */
#endif
}


/*************************************************************************
* FUNCTION:    vHandle_s_Set_Active_PresetList
*
* DESCRIPTION: Set given preset list as active preset List.
*
* PARAMETER:   poMessage    - message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Set_Active_PresetList( amt_tclServiceData* poMessage )
{

   ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_s_Set_Active_PresetList "));

   /* Pointer validation.*/
      if((poMessage == NULL ) || (m_potun_MsgToHMI == NULL) || (m_potun_Config == NULL) ||\
         ( m_potun_MsgToADR == NULL))
      {
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_Config != NULL );
       NORMAL_M_ASSERT( m_potun_MsgToADR != NULL);
        return;
      }

      switch (poMessage->u8GetOpCode())
      {
      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         {

            ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_s_Set_Active_PresetList, Method Start "));

            /* Object Creation. */
            midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart oMsg;

            /*  Extract contents from amt based message. */
            vGetDatafromAMT(poMessage,oMsg);


            tU8 u8HMIListID = (tU8)oMsg.e8ListID.enType;
            /** Get corresponding ADR list id from  HMI list id */
            tU16 u16ListID = U16GetADR3PresetListID(oMsg.e8ListID.enType) ;


            /** Save app id, reg id and command counter value to send method result later*/
            m_potun_MsgToHMI->vSetMsgDataForSetActivePresetList(\
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter());

            /** Save List ID value to get list and update HMI Later*/
            m_potun_MsgToHMI->vSaveListIDForSetActivePresetList(u16ListID);



            ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_s_Set_Active_PresetList,bank : %d ",u16ListID));

            /** vnd4kor: changes made as suggested by ngp1kor.
                     If preset list belongs to current band/source then activate it,
                     else store the list ID , activation will be done after source change*/

            if(bIsEqualPresetListBandCurrentBand(u8HMIListID))
            {
               m_potun_MsgToADR ->vSetPresetListSetActive( u16ListID);
            }
            else
            {
               /** Set m_bSetActivePresetListRequested = true, Method result for \
              command completion status will be sent after band change completes*/
               vSet_SetActivePresetListRequested(true);
                ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_s_Set_Active_PresetList, \
                            Action stored: method result will be sent after band change"));

               /** CMG3GB-903:: Method Result sent stating command execution is in Progress*/
               midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult oResponse;

               /** Method Result to the client */
               vSendMethodResult(oResponse,\
                        poMessage,\
                        (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_ACCEPTED_INPROGRESS);

            }

         }
         break;

      default:
          {
             /* +++
             unkown opcode:
             enter error handling here ( trace or assert )
             +++ */

             break;
          }
      }

       
}

/*************************************************************************
* FUNCTION:    bIsEqualPresetListBandCurrentBand
*
* DESCRIPTION: Check if preset list band matches with current band
*
* PARAMETER:   tU8 u8HMIListID
*
* RETURNVALUE: bool
*
* History:
* InitialVersion
* 03.01.2013 vnd4kor ECG4
*************************************************************************/
tBool tun_MsgFromHMI::bIsEqualPresetListBandCurrentBand(tU8 u8HMIListID)
{
   if((m_potun_Config == NULL) || (m_potun_ActualData == NULL))
   {
      NORMAL_M_ASSERT( m_potun_Config != NULL );
      NORMAL_M_ASSERT( m_potun_ActualData != NULL );
      return false;
   }

   /** Get Band to which, HMIListId belongs*/
   tenAvailableBands e8Band = (tenAvailableBands)U8GetTunerBand((midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListID);
   tU8 u8Band = m_potun_ActualData->m_otun_Data_Station.u8GetBand();
   switch (e8Band)
   {
      /** m_potun_MsgToHMI ->m_u8PrevBand gives currently tuned Band.
      This param will be updated for every AtStationInfo*/
   case enAvailBand_FM:
      return (u8Band== (tU8)enAvailBand_FM ) ? true : false;

   case enAvailBand_LW:
      return (u8Band == (tU8)enAvailBand_LW ) ? true : false;

   case enAvailBand_MW:
      return (u8Band == (tU8)enAvailBand_MW ) ? true : false;

   case enAvailBand_AM:
      return ((u8Band == (tU8)enAvailBand_MW )||(m_u8Band == (tU8)enAvailBand_LW)) ? true : false;

   /** in case of mixed preset there is only one preset list belonging to combi band */
   case enAvailBand_GetCurrent:
      return true;

   default:
      return false;
   }
}


/*************************************************************************
* FUNCTION:    vSet_SetActivePresetListRequested
*
* DESCRIPTION: Setter for  m_bSetActivePresetListRequested
*
* PARAMETER:   tBool bState
*
* RETURNVALUE: tVoid
*
* History:
* InitialVersion
* 16.09.2014 vnd4kor ECV2
*************************************************************************/
tVoid tun_MsgFromHMI::vSet_SetActivePresetListRequested(tBool bState)
{
   m_bSetActivePresetListRequested = bState;
}

/*************************************************************************
* FUNCTION:    bGet_SetActivePresetListRequested
*
* DESCRIPTION: Getter for m_bSetActivePresetListRequested
*
* PARAMETER:   tVoid
*
* RETURNVALUE: tBool
*
* History:
* InitialVersion
* 16.09.2014 vnd4kor ECV2
*************************************************************************/
tBool tun_MsgFromHMI::bGet_SetActivePresetListRequested() const
{
   return m_bSetActivePresetListRequested;
}



tVoid tun_MsgFromHMI::vHandle_s_Preset_Handling( amt_tclServiceData* poMessage )
{
   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                   ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                   ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING    _\
                   ET_EN_DONE);

      /*  Pointer Validation. */

   if(( poMessage == NULL ) || (m_potun_MsgToADR == NULL) || (m_potun_Config == NULL)
         || (m_potun_MsgToHMI == NULL))
   {
     NORMAL_M_ASSERT( poMessage != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
    NORMAL_M_ASSERT( m_potun_Config != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
     return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart  oMsg ;

         /* Extract contents from amt based message.  */
         vGetDatafromAMT(poMessage,oMsg);


            /* Action of preset handling : recall, save, delete, delete all*/
         tU8 u8Action = (tU8)oMsg.e8Action.enType;

       /** Store preset handling action to send method result later */
       PresetHandlingData data;
       data.u8Action = u8Action;
       data.u8ListElement = oMsg.u8ListElementID;
       data.u16CmdCounter = poMessage->u16GetCmdCounter();

       /** Get corresponding ADR list id from  HMI list id */
        tU16 u16ListID = U16GetADR3PresetListID(oMsg.e8ListID.enType) ;

        if(u16ListID != (tU16)TUN_BANK_NONE)
        {
           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING _\
                         ET_EN_T16 _ u16ListID _\
                         ET_EN_T8 _ oMsg.u8ListElementID _\
                         ET_EN_DONE);

           /** Save action to send method result later */
           m_potun_MsgToADR->m_listPresetAction.push_back(data);

          switch(u8Action)
          {
            /** Load the saved preset from the list */
            case RECALL_ELEMENT:
            {
               ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_s_Preset_Handling,\
                            Preset Recall "));

               m_MuteHandlingRequest.u16ListID =  u16ListID;
               m_MuteHandlingRequest.u8ListElementID = oMsg.u8ListElementID;
#ifdef MUTE_ACTIVE
               if(m_MuteHandlingRequest.enMuteAction_curr == PresetRecall
                     || m_MuteHandlingRequest.enMuteAction_curr == StationList)
               {
                  m_MuteHandlingRequest.enMuteAction_next = PresetRecall;
               }
               else
               {
                  m_MuteHandlingRequest.enMuteAction_curr = PresetRecall;
                  m_potun_MsgToHMI->vSend_MuteDemuteReq(true,true);
               }
#else
               vSend_PresetRecall();
#endif
            }
            break;
            /** Store Preset in Preset list */
            case SAVE_ELEMENT:
               {
                  m_potun_MsgToADR ->vSendSaveListElem( u16ListID,
                     oMsg.u8ListElementID);

                  /** Since preset save does not have status response
                  Send Get Preset list to update the HMI */
                  m_potun_MsgToADR ->vGetPresetList(u16ListID);


               }
            break;
             /** Delete single element in preset list */
            case DELETE_ONE_ELEMENT:
            {
               m_potun_MsgToADR ->vSendDeleteSinglePreset( u16ListID,
                                       oMsg.u8ListElementID);

               /** Since preset delete does not have status response
                  Send Get Preset list to update the HMI */
                  m_potun_MsgToADR ->vGetPresetList(u16ListID);


            }
            break;
            /** Delete all elements in preset list */
            case DELETE_ALL_ELEMENTS:
            {
               m_potun_MsgToADR ->vSendDeleteAllPreset( u16ListID);

               /** Since Delete all does not respond with entire list,
               explicitly get preset list*/
               m_potun_MsgToADR->vGetPresetList(u16ListID);

            }
            break;
            /** Special preset save of non tuned stations */
            case SPECIALSAVE_ELEMENT:
            {
#ifndef GTEST_x86LINUX_BUILD
               m_potun_MsgToADR ->vSendSpecialSaveListElem( u16ListID,
                     oMsg.u8ListElementID , oMsg.u32Frequency , oMsg.u16PI);
#endif
            }
            break;
            /** Invalid action */
            default:
            {
               /** Delete entry as no command sent to ADR ,
               and methodresult can be sent immediately */
#ifndef GTEST_x86LINUX_BUILD
               m_potun_MsgToADR->m_listPresetAction.pop_back();
#endif

               midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult  oResponse ;

               oResponse.e8Action.enType = \
                  (midw_fi_tcl_e8_Tun_PresetAction::tenType)u8Action;

               /** Method Result to the client */
               vSendMethodResult(oResponse,\
                  poMessage,\
                  (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);


               ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_s_Preset_Handling,\
                            e8Action  : Invalid Input "));
            }
            break;

          }
      }

      }  /*  case AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

     break;
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
       ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING _ \
                           ET_EN_DONE);
         break;
      }


   } /* switch (poMessage->u8GetOpCode()) */
    
}

tVoid tun_MsgFromHMI::vSend_PresetRecall()
{
    if(m_potun_MsgToADR == NULL)
    {
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        return;
    }

   ETG_TRACE_USR4(( " tun_MsgFromHMI::vSend_PresetRecall, ListID: %d, ElemID: %d", \
                  m_MuteHandlingRequest.u16ListID,m_MuteHandlingRequest.u8ListElementID));
#ifndef GTEST_x86LINUX_BUILD
   m_potun_MsgToADR ->vSendSelListElem( m_MuteHandlingRequest.u16ListID,
                           m_MuteHandlingRequest.u8ListElementID,
                           TUN_LIST_TYPE_STATIC);
#endif
}


tVoid tun_MsgFromHMI::vHandle_s_SurveilTP( amt_tclServiceData* poMessage )
{
   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                   ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                   ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SURVEIL_TP   _\
                   ET_EN_DONE);

      /*  Pointer Validation. */

   if(( poMessage == NULL ) || (m_potun_MsgToADR == NULL))
   {
     NORMAL_M_ASSERT( poMessage != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
     return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart  oMsg ;

         /* Extract contents from amt based message.  */
         vGetDatafromAMT(poMessage,oMsg);

       midw_fi_tcl_e8_Tun_PresetAction e8Action;

         tBool bSurveilTP = (tU8)oMsg.bSurveilTP;
       tU16 u16PI = 0;
       tU8 u8Strategy = 0; //Not defined yet, default value used

#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR->vSendSurveilTP(u16PI, bSurveilTP, u8Strategy);
#endif


      //------------------------
       // Response to the client
       //------------------------
       midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult oResponse;


      /** Method Result to the client */
      vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);


      }  /*  case AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

     break;
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
       ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SURVEIL_TP _ \
                           ET_EN_DONE);
         break;
      }


   } /* switch (poMessage->u8GetOpCode()) */
    
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_SetAF
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_SetAF( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF _\
                     ET_EN_DONE);

  if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL ) ||\
      ( m_potun_MsgToADR == NULL )
    )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                          TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

       NORMAL_M_ASSERT( poMessage != NULL );
       NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
       NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
       return;
  }

    switch (poMessage->u8GetOpCode())
    {
    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
    {
      ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetAF - UPREG "));
      if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
      {
         vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                  ET_EN_DONE);

      }
      else
      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                  ET_EN_DONE);

      /** get current AF switch state */
#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR->vGetAFMode();
#endif
      }
    }
    break;
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
	case AMT_C_U8_CCAMSG_OPCODE_GET:
	{
		/** get current AF switch state */
#ifndef GTEST_x86LINUX_BUILD
		m_potun_MsgToADR->vGetAFMode();
#endif
	}
	break;
    default:
    {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                         ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF _\
                         ET_EN_DONE);
        break;
    }
    }
     
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_SetMeasureMode
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SET_MEASUREMODE
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_SetMeasureMode( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_MEASUREMODE _\
                     ET_EN_DONE);

  if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL ) ||\
      ( m_potun_MsgToADR == NULL )
    )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                          TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
  }

    switch (poMessage->u8GetOpCode())
    {
    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
    {
      ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetMeasureMode - UPREG "));
      if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
      {
               vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                  ET_EN_DONE);

      }
      else
      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                  ET_EN_DONE);

      /** Update the client once upreg successful */
#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR->vGetActivePhyTunerAndMeasureMode();
#endif
      }
    }
    break;
   case AMT_C_U8_CCAMSG_OPCODE_GET:
   {
      ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_SetMeasureMode : OpType = GET"));

      /** get measure mode value */
#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR->vGetActivePhyTunerAndMeasureMode();
#endif

      break;
   }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
    default:
    {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                         ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_MEASUREMODE _\
                         ET_EN_DONE);
        break;
    }
    }
     
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_SetDDA
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_SetDDA( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA _\
                     ET_EN_DONE);

  if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL ) ||\
      ( m_potun_MsgToADR == NULL )
    )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                          TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
  }

    switch (poMessage->u8GetOpCode())
    {
    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
    {
      ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetDDA - UPREG "));
      if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
      {
               vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                  ET_EN_DONE);

      }
      else
      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                  ET_EN_DONE);

      /** Get latest DDA switch state */
#ifndef GTEST_x86LINUX_BUILD
      m_potun_MsgToADR->vSendGetDDASwitch();
#endif
      }
    }
    break;
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
	case AMT_C_U8_CCAMSG_OPCODE_GET: 
	{
		/** Get latest DDA switch state */
#ifndef GTEST_x86LINUX_BUILD
		m_potun_MsgToADR->vSendGetDDASwitch();
#endif
	}
	break;
    default:
    {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                         ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA _\
                         ET_EN_DONE);
        break;
    }
    }
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_SetTA
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_SetTA( amt_tclServiceData* /*poMessage */)
{
	#if 0
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_TA _\
                     ET_EN_DONE);

  if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL )
    )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                          TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      return;
  }

    switch (poMessage->u8GetOpCode())
    {
    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
    {
      ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetTA - UPREG "));
      if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
      {
               vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                  ET_EN_DONE);

      }
      else
      {



        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                  ET_EN_DONE);
      }
    }
    break;
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
    default:
    {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                         ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_TA _\
                         ET_EN_DONE);
        break;
    }
    }
#endif     
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_SetRDSREG
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_SetRDSREG( amt_tclServiceData* poMessage )
{
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG _\
                     ET_EN_DONE);

  if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL ) ||\
      ( m_potun_MsgToADR == NULL )
    )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                          TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
  }

    switch (poMessage->u8GetOpCode())
    {
    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
    {

      if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
      {
               vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                  ET_EN_DONE);

      }
      else
      {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                  ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                  ET_EN_DONE);
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vGetREGMode();
#endif
      }
    }
    break;
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
    default:
    {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                         ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG _\
                         ET_EN_DONE);
        break;
    }
    }
     
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_SetRDSSwitch
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDS
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 26.8.13    | ( RBEI ) vnd4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_SetRDSSwitch( amt_tclServiceData* poMessage )
{
   if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL ) ||\
      ( m_potun_MsgToADR == NULL )
      )
   {
         NORMAL_M_ASSERT( poMessage != NULL );
         NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
         NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
   }

   ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetRDS "));

   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {

         /** Adding to notification table */
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


            ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetRDS - Adding to Notification table : Error"));

         }
         else
         {
            ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetRDS - Adding to Notification table : Successful"));
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR->vGetRDSMode();
#endif
         }
      }
      break;
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDS _\
            ET_EN_DONE);
         break;
      }
   }
    
}


/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_SetupDDADDS
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_SetupDDADDS( amt_tclServiceData* poMessage )
{


  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS _\
                     ET_EN_DONE);

  if( ( poMessage == NULL ) ||\
      ( m_potun_MsgToHMI == NULL ) ||\
      ( m_potun_MsgToADR == NULL )
    )
   {
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI, ET_EN_T16 _\
                          TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      return;
   }



  switch (poMessage->u8GetOpCode())
  {


    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
        /*---------------------------------------------*/
        /* Send new staticlist request to Radio Unit   */
        /*---------------------------------------------*/
        midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart oMsg;

        // Extract contents from amt based message
        vGetDatafromAMT(poMessage,oMsg);


        midw_fi_tcl_e8_DDADDS_Mode DDADDS_Mode;

        DDADDS_Mode.enType=oMsg.DDADDS_Mode.enType;

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
                           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SETUP_DDADDS _\
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MS _\
                            ET_EN_T8 _ DDADDS_Mode.enType _
                            ET_EN_DONE);


      switch(DDADDS_Mode.enType)
      {
      case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_DDA:
         {
            m_u8TunerMode = DDA_MODE;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
            m_poclTmcTuner_AudioFGBGNew->vSetTunerMode(m_u8TunerMode);
#endif
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR ->vSendSetDDASwitch(0x00080000);
            ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetupDDADDS ->  DDA"));

            /*Switch off DDS and DMQ*/
            m_potun_MsgToADR ->vSendTestTunerSwitches(0,0);
#endif
         }

         break;

      case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_DDS:
         {
            m_u8TunerMode = DDS_MODE;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
            m_poclTmcTuner_AudioFGBGNew->vSetTunerMode(m_u8TunerMode);
#endif
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR ->vSendTestTunerSwitches(1,0); //DDS = ENABLE, DMQ = OFF

            /*Switch off DDA*/
            m_potun_MsgToADR ->vSendSetDDASwitch(0);
            ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetupDDADDS ->  DDS"));
#endif
         }
         break;

      case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_AUTO:
         {
            m_u8TunerMode = CUSTOMER_MODE;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
            m_poclTmcTuner_AudioFGBGNew->vSetTunerMode(AUTO_MODE);
#endif
            if(m_u8MeasurementMode == 0)
            {
               ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetupDDADDS ->  AUTO"));
#ifndef GTEST_x86LINUX_BUILD
               m_potun_MsgToADR ->vSendSpecialDiagnosisMode( enCM_SpecialDiagnosisModeMode_NORMAL_MODE, enPhysicalTunerId_CurrentTuner);
#endif
            }
            /**If Measurement Mode is active then the AUTO Command must be blocked.*/
            else
            {
               ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetupDDADDS ->  MeasureMent Mode is active hence reject the command"));
            }
         }
         break;

      case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_SINGLE:
         {
            /**If Measurement Mode is not active then we should treat TUNER1 and TUNER2 as normal*/
            if(m_u8MeasurementMode == 0)
            {
               m_u8TunerMode = SINGLE_TUNER_MODE;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
               m_poclTmcTuner_AudioFGBGNew->vSetTunerMode(m_u8TunerMode);
#endif
               ETG_TRACE_USR4(( " tun_MsgFromHMI::vHandle_SetupDDADDS ->  Single Tuner"));
#ifndef GTEST_x86LINUX_BUILD
               m_potun_MsgToADR ->vSendSpecialDiagnosisMode( enCM_SpecialDiagnosisModeMode_SINGLE_TUNER_MODE, enPhysicalTunerId_CurrentTuner);
#endif
            }
            /**If Measurement Mode is ACTIVE then only the physical tuner ID has to be sent to ADR3 keeping the Measure Mode as it is,
            if the Routing TUNER1 or TUNER2 is selected           */
            else
            {
               m_u8TunerMode = CUSTOMER_MODE;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
               m_poclTmcTuner_AudioFGBGNew->vSetTunerMode(m_u8TunerMode);
#endif
               ETG_TRACE_USR4(("Measurement mode cannot be switched ON in single tuner mode"));
#ifndef GTEST_x86LINUX_BUILD
               m_potun_MsgToADR ->vSendSpecialDiagnosisMode( enCM_SpecialDiagnosisModeMode_MEASURE_MODE, enPhysicalTunerId_CurrentTuner);
#endif
            }

         }
         break;
      default:
    	  break;
      }


        //------------------------
        // Response to the client
        //------------------------
        midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult oResponse;


      /** Method Result to the client */
      vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
                              ET_EN_T8 _ 0x80 _
                              ET_EN_DONE);

      break;
      }

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI, \
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _ \
                           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_SETUP_DDADDS _ \
                           ET_EN_DONE);

        if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
        {

          vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _
                              ET_EN_DONE);

         }
        else
        {
           midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus oSetupStatus;
         oSetupStatus.DDADDS_Mode.enType = midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_AUTO ;

            vSendMessage( poMessage->u16GetSourceAppID(),
                            oSetupStatus,
                            poMessage->u16GetFunctionID(),
                            AMT_C_U8_CCAMSG_OPCODE_STATUS,
                            poMessage->u16GetCmdCounter(),
                            poMessage->u16GetRegisterID()
                         );

             ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _
                           ET_EN_DONE);


        }
      } // case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      break;


    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
    default:
      {
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                         ET_EN_T32  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SETUP_DDADDS _\
                         ET_EN_DONE);
        break;
      }
  }

    
}

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandleSetAntenna
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ANTENNA
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* HISTORY:
* Date      | Author
* 20.8.07    | ( RBIN ) she4kor
*************************************************************************/
tVoid tun_MsgFromHMI::vHandleSetAntenna(amt_tclServiceData* /*poMessage*/)
{
#if 0
      ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                          ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                          ET_EN_DONE );

      if(( poMessage == NULL )||(m_potun_MsgToHMI == NULL))
      {
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( poMessage != NULL );

        return;

      }

     switch (poMessage->u8GetOpCode())
   {

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {


         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                              ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                              ET_EN_DONE);
         }

         else
         {
           midw_tunerfi_tclMsgFID_TUN_G_SET_ANTENNAStatus oStatus;

           oStatus.b8_Antenna.u8Value = midw_fi_tcl_b8_Tun_Antenna::FI_C_U8_BIT_TUNER_ANTENNA1;

           vSendMessage( poMessage->u16GetSourceAppID(),
                          oStatus,
                          poMessage->u16GetFunctionID(),
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          poMessage->u16GetCmdCounter(),
                          poMessage->u16GetRegisterID()
                         );

         }

      }
      break;
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
    	   vRemoveFromNotificationTable(poMessage);
    	   break;
       }

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ANTENNA _\
                             ET_EN_DONE);

      }
      break;

  }

#endif
    
}

#endif

/*************************************************************************
* FUNCTION: tun_MsgFromHMI::vHandle_s_Set_RDBID( amt_tclServiceData* poMessage )
*
* DESCRIPTION: Command from HMI to set RDBID parametres.
*
* PARAMETER:   poMessage     - message to analyse.
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Set_RDBID( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ FID_TUN_S_SET_RDBID _\
                     ET_EN_DONE);

    /* Pointer Validation */
   if(( poMessage == NULL ) ||( m_potun_MsgToADR == NULL ) || (m_potun_MsgToHMI == NULL))
   {
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
     return;
   }



   switch (poMessage->u8GetOpCode())
   {


   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
        //Create object to store the parameters from HMI
        midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart oMessage;

        //Extract data from the AMT message in to the FI class
        vGetDatafromAMT( poMessage, oMessage );
        tU8  u8Index = 0, u8ListIndex = 0;

        ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_s_Set_RDBID oMessage.u8NumOfRDBID=%d",oMessage.u8NumOfRDBID));


              tU8  pu8RDBIDList[TUN_RDBID_LIST_ARRAY_MAX_SIZE] = {0};
                 for(u8Index = 0; u8Index < oMessage.u8NumOfRDBID; u8Index++)
                 {
                  pu8RDBIDList[u8ListIndex++] = TMC_SELECTIONFILTER_MASK;
                   pu8RDBIDList[u8ListIndex++] = oMessage.TunRDBID_Value[u8Index].u8RdbidCC;
                  pu8RDBIDList[u8ListIndex++] = oMessage.TunRDBID_Value[u8Index].u8RdbidLTN;
                   pu8RDBIDList[u8ListIndex++] = oMessage.TunRDBID_Value[u8Index].u8RdbidSID;
                   pu8RDBIDList[u8ListIndex++] = 0;
                   pu8RDBIDList[u8ListIndex++] = 0;
                   pu8RDBIDList[u8ListIndex++] = 0;
                   pu8RDBIDList[u8ListIndex++] = oMessage.TunRDBID_Value[u8Index].bEncFlag;
                 }
#ifndef GTEST_x86LINUX_BUILD
                 m_potun_MsgToADR->vSendSetRDBID(pu8RDBIDList, u8ListIndex);
#endif
                 m_potun_MsgToHMI->vSetTPEGCommandCntrForSetRdbid(poMessage->u16GetCmdCounter());
                 m_potun_MsgToHMI->vSetTPEGRegIDForSetRdbid(poMessage->u16GetRegisterID());

                 ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                                     ET_EN_T16 _ FID_TUN_S_SET_RDBID _\
                                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_MS _\
                                     ET_EN_T8 _ oMessage.u8NumOfRDBID _\
                                     ET_EN_T8 _ pu8RDBIDList[0] _\
                                     ET_EN_T8 _ pu8RDBIDList[1] _\
                                     ET_EN_T8 _ pu8RDBIDList[2] _\
                                     ET_EN_T8 _ pu8RDBIDList[3] _\
                                     ET_EN_DONE);


        break;

      } /* case AMT_C_U8_CCAMSG_OPCODE_METHODSTART: */

   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                            ET_EN_T16 _ FID_TUN_S_SET_RDBID _\
                            ET_EN_DONE);
         break;
      }

  } /* switch (poMessage->u8GetOpCode()) */

   

} /* tVoid tun_MsgFromHMI::vHandle_s_Set_RDBID( amt_tclServiceData* poMessage ) */



/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_Get_Data_TMC
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion
*
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_Get_Data_TMC( amt_tclServiceData* poMessage )
{

  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
                     ET_EN_T16 _ FID_TUN_G_GET_DATA_TMC _\
                     ET_EN_DONE);


  if( ( poMessage == NULL ) ||  ( m_potun_MsgToHMI == NULL ))
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
                         ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      return;
  }


   switch (poMessage->u8GetOpCode())
   {

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_g_Get_Data_TMC Upreg Failed "));

         }
         else
         {

           ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_g_Get_Data_TMC Upreg Success "));

         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
   default:
      {
         /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                             ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                             ET_EN_T16  _ FID_TUN_G_GET_DATA_TMC _\
                             ET_EN_DONE);
         break;
      }
   }

    
}

/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::bGetDiagUpRegStatus
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: Returns the status of vHandle_g_Station_Data upreg
*
* History:
* InitialVersion
*
*************************************************************************/
tBool tun_MsgFromHMI::bGetDiagUpRegStatus() const
{
  return bUpRegDiag;
}

/*************************************************************************
* FUNCTION:    vHandle_Monitor_Station
*
* DESCRIPTION: Command from HMI to Monitor the station
*
* PARAMETER:   amt_tclServiceData* poMessage
*
* RETURNVALUE: NONE
*
* History:
* InitialVersion:rrb1kor
*
*************************************************************************/

tVoid tun_MsgFromHMI::vHandle_g_Component_Status( amt_tclServiceData* /*poMessage*/ )
{
#if 0
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                   ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
           ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER _\
           ET_EN_DONE);


  if( ( poMessage == NULL ) || (m_potun_MsgToHMI == NULL) )
  {
     ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_NULL_POINTER _\
             ET_EN_DONE );

        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
     return;
  }


   switch (poMessage->u8GetOpCode())
   {


    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {


           vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );


           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
                ET_EN_DONE);

         }
         else
         {

           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
                  ET_EN_DONE);


         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
    default:
       {
          /* +++
          unkown opcode:
          enter error handling here ( trace or assert )
         +++ */
          ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER _\
                ET_EN_DONE);
       break;
       }
   }
  #endif  
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandleFieldStrength
*
*DESCRIPTION: This function performs a Method start to get the received Field
*             Strength and gives it to FC_Diagnosis
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgFromHMI :: vHandleFieldStrength (amt_tclServiceData* poMessage )
{
    if( (NULL == poMessage) || (m_potun_MsgToHMI == NULL) || (m_potun_MsgToADR == NULL))
    {
        NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      NORMAL_M_ASSERT ( m_potun_MsgToADR != NULL );
      return;
    }

    switch (poMessage->u8GetOpCode())
        {

        case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
          {
         m_potun_MsgToHMI->vSetDiagCommandCntr(poMessage->u16GetCmdCounter());
         m_potun_MsgToHMI->vSetDiagRegID(poMessage->u16GetRegisterID());

         m_bFSReqFromDiag = TRUE;

            /*---------------------------------------------*/
            /* Request AtStationInfo to ADR   */
            /*---------------------------------------------*/
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR->vSendGetAtStationInfo();
#endif
          }
          break;
          default:
          {
             /* +++
             unkown opcode:
             enter error handling here ( trace or assert )
             +++ */
             break;
          }
       }
        
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandleFieldStrength
*
*DESCRIPTION: This function performs a Method start to get the received Field
*             Strength and gives it to FC_Diagnosis
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgFromHMI :: vHandleGetActiveTuner (amt_tclServiceData* poMessage )
{
   if( (NULL == poMessage )|| (m_potun_MsgToHMI == NULL) || ( m_potun_MsgToADR == NULL ))
    {
        NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      NORMAL_M_ASSERT ( m_potun_MsgToADR != NULL );
      return;
    }

   switch (poMessage->u8GetOpCode())
    {

        case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
          {
         m_potun_MsgToHMI->vSetTunerMasterCommandCntrForActiveTuner(poMessage->u16GetCmdCounter());
         m_potun_MsgToHMI->vSetTunerMasterRegID(poMessage->u16GetRegisterID());


            /*---------------------------------------------*/
            /* Request ActiveTuner info from ADR   */
            /*---------------------------------------------*/
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR->vGetActivePhyTunerAndMeasureMode();
#endif


          }
          break;
          default:
          {
             /* +++
             unkown opcode:
             enter error handling here ( trace or assert )
             +++ */
             break;
          }
    }
     
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandleFieldStrength
*
*DESCRIPTION: This function performs a Method start to get the received Field
*             Strength and gives it to FC_Diagnosis
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgFromHMI :: vHandle_g_RdbidActuallist(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || m_potun_MsgToHMI == NULL)
    {
        NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
    }

   switch (poMessage->u8GetOpCode())
   {

    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      break;

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
           ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_g_RdbidActuallist Upreg Failed "));

         }
         else
         {
          ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_g_RdbidActuallist Upreg successful "));
         }
         break;
      }
    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
       {
       	vRemoveFromNotificationTable(poMessage);
       	break;
       }
    default:
       {
          /* +++
          unkown opcode:
          enter error handling here ( trace or assert )
         +++ */
          ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                        ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_RDBIDACTUALLIST _\
                ET_EN_DONE);
       break;
       }
   }
    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_AtSeek
*
*DESCRIPTION: Indicates if the FieldStrength was requested by Diagnosis
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_AtSeek(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || m_potun_MsgToHMI == NULL)
       {
           NORMAL_M_ASSERT (NULL != poMessage);
         NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
         return;
       }

      switch (poMessage->u8GetOpCode())
      {

       case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         break;

       case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
            {
               vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
              ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_g_AtSeek Upreg Failed "));

            }
            else
            {
             ETG_TRACE_USR4(( " tun_MsgFromHMI :: vHandle_g_AtSeek Upreg successful "));

             midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/
          oStatusMsg.e8SeekState.enType = (midw_fi_tcl_e8_Tun_TunerSeek::tenType)m_potun_MsgToHMI -> u8GetSeekMode();



         if(oStatusMsg.e8SeekState.enType <= \
            midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_SORTED_PS)

            /*Send status message to clients*/
          vSendMessage ( poMessage->u16GetSourceAppID(),
                          oStatusMsg,
                          poMessage->u16GetFunctionID(),
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          poMessage->u16GetCmdCounter(),
                    poMessage->u16GetRegisterID()
             );




         ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_ATSeek() -> Status sent to HMI, seek mode = %d ",\
            oStatusMsg.e8SeekState.enType));



            }
            break;
         }
       case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
          {
          	vRemoveFromNotificationTable(poMessage);
          	break;
          }
       default:
          {
             /* +++
             unkown opcode:
             enter error handling here ( trace or assert )
            +++ */
             ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
                           ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
                   ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK _\
                   ET_EN_DONE);
          break;
          }
      }
       
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_Set_Engg_Param
*
*DESCRIPTION: Allows to modify chosen Engineering Parameter
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 4.10.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Set_Engg_Param(amt_tclServiceData* poMessage)
{

   if( NULL == poMessage || NULL == m_potun_MsgToADR || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8ParameterId = (tU8)oMessage.e8ParameterID.enType;
         tU32 u32ParameterValue = oMessage.u32ParameterValue;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_Engg_Param() -> u8ParameterId = %d, u32ParameterValue = %d\n"\
            ,u8ParameterId,(tS32)u32ParameterValue));

         //Create Method Result object to send Method result to Client
         midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult oResponse;

         if(u8ParameterId <= (tU8)midw_fi_tcl_e8_Tun_Engg_Param_ID::FI_EN_BACKGROUND_SCAN_ACTIVITY)
         {
            // Send command to ADR
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR->vSendSetEnggParam(u8ParameterId,u32ParameterValue);
#endif

            // Method Result to the client
            vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_Engg_Param() -> Invalid u8ParameterId = %d,\n"\
            ,u8ParameterId));

            // Method Result to the client
            vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
         }

         break;
      }

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_Engg_Param Upreg Failed"));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_Engg_Param Upreg successful"));
         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet oMsg;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMsg );

         /** Extract the parameters from the msg */
         tU8 u8ParameterId = (tU8)oMsg.e8ParameterID.enType;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_Get_Engg_Param : OpType = GET, \
                     u8ParameterId = %d",u8ParameterId));
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vGetEngineeringParameter(u8ParameterId);
#endif

         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

    
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig
*
*DESCRIPTION: Allows to Set Various TuningActionConfig Parameter Values
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 8.10.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig(amt_tclServiceData* /*poMessage*/)
{
#if 0
   if( NULL == poMessage || NULL == m_potun_MsgToADR || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_SET_TUNING_ACTION_CONFIGMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8ConfigParamType = (tU8)oMessage.e8ConfigParamType.enType;
         tU32 u32ConfigParamValue = oMessage.u32ConfigParamValue;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig() -> \
                              u8ConfigParamType = %d,u32ConfigParamValue = %d\n",\
                              u8ConfigParamType,u32ConfigParamValue));

         //Create Method Result object to send Method result to Client
         midw_tunerfi_tclMsgFID_TUN_S_SET_TUNING_ACTION_CONFIGMethodResult oResponse;

         /** Commented out as implementation form ADR is not available
         Will be enabled once implementation available */

         /*
         if(u8ConfigParamType <= TAC_ScrollingPSDetectionTimer)
         {
            // Send command to ADR


            m_potun_MsgToADR->vSendSetTuningActionConfig(u8ConfigParamType,u32ConfigParamValue);
            // Method Result to the client
            vSendMethodResult(oResponse,\
               poMessage,\
               midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig() -> \
                        Invalid u8ConfigParamType = %d,\n",u8ConfigParamType));

            // Method Result to the client
            vSendMethodResult(oResponse,\
               poMessage,\
               midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
         }

         */
         /** To be removed once implementation available */
         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig() -> ADR implementation Not available "));

         vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED);

         break;
      }

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig Upreg Failed"));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_TuningActionConfig Upreg successful"));

         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Get_TuningActionConfig : OpType = GET"));

         midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet oMsg;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMsg );


         /** Currently ADR implementation ot available */
         /** Extract the parameters from the msg */
         //tU8 u8ConfigParamType = oMsg.e8ConfigParamType.enType;

         //m_potun_MsgToADR->vGetTuningActionConfigValues(u8ConfigParamType);

         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

#endif    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_Sel_Elem_From_AFLIST_V2
*
*DESCRIPTION: Select element from AF list
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 8.10.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Sel_Elem_From_AFLIST_V2(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToADR )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8PhysicalTunerId = (tU8)oMessage.u8PhysicalTunerId.enType;
         tU8 u8Mode = (tU8)oMessage.u8Mode.enType;
         tU32 u32Frequency = oMessage.u32Frequency;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Sel_Elem_From_AFLIST_V2() -> \
                              u8PhysicalTunerId = %d, u8Mode = %d , u32Frequency = %d\n",\
                              u8PhysicalTunerId,u8Mode,u32Frequency));

         /** Send ADR message */
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vSendTestTuneFrequency(u8PhysicalTunerId,u8Mode,u32Frequency);
#endif
         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult oResponse;


         /** Method Result to the client */
         vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);


         break;
      }

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2 _\
            ET_EN_DONE);
         break;
      }
   }

    
}



/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch
*
*DESCRIPTION: Set TA/PTY Announcement switch
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 28.10.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToADR || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         /*Create object to store the parameters from HMI*/
         midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart oMessage;

         /* Extract data from the AMT message in to the FI class*/
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8AnnouncementType = oMessage.b8AnnoType.u8Value;


         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch() ->\
                     u8AnnouncementType = %d",
                     u8AnnouncementType));

         /** Send ADR message */
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vSendSetAnnouncementSwitch(u8AnnouncementType);
#endif

         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult oResponse;


         /** Method Result to the client */
         vSendMethodResult(oResponse,
               poMessage,
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);




         break;
      }

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch Upreg Failed"));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch Upreg successful"));
            /** Send GET Announcement switch to update the HMI with  */
             /*-----------------------------------------------------*/
             /* Create status message to send to client             */
             /*-----------------------------------------------------*/

             midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus oAnnoSwitch;


            /** extract TP switch status from the m_u8AnnoSwitchState */
            oAnnoSwitch.bTPState = ((m_potun_MsgToHMI->m_u8AnnoSwitchState & (tU8)enAnnoSwitchTPMask) && (tU8)enAnnoSwitchTPMask);

            /** extract PTY switch status from the m_u8AnnoSwitchState */
            oAnnoSwitch.bPTYState = ((m_potun_MsgToHMI->m_u8AnnoSwitchState & (tU8)enAnnoSwitchPTY31Mask) && (tU8)enAnnoSwitchPTY31Mask);

            ETG_TRACE_USR2(("tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch() , bTPState = %d "\
               "bPTYState = %d\n",oAnnoSwitch.bTPState,oAnnoSwitch.bPTYState));


               /*Send status message to clients*/
             vSendMessage ( poMessage->u16GetSourceAppID(),
                       oAnnoSwitch,
                       poMessage->u16GetFunctionID(),
                       AMT_C_U8_CCAMSG_OPCODE_STATUS,
                       poMessage->u16GetCmdCounter(),
                       poMessage->u16GetRegisterID());
         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_Set_AnnouncementSwitch : OpType = GET"));

         midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet oMsg;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMsg );

#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vSendGetAnnouncementSwitch();
#endif

         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

    
}




/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_AnnouncementMessageAndInfo
*
*DESCRIPTION: Handles upreg for FID_TUN_G_ANNOUNCEMENT_MESSAGE and
*                       FID_TUN_G_ANNOUNCEMENT_INFO
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 28.10.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_AnnouncementMessageAndInfo(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_AnnouncementMessageAndInfo Upreg Failed\
                        for FID = %04x", poMessage->u16GetFunctionID()));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_AnnouncementMessageAndInfo Upreg successful\
                        for FID = %04x", poMessage->u16GetFunctionID()));

            if(poMessage->u16GetFunctionID() == MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO)
            {
                midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus oAnnoInfo;

               /** Fill msg data  */
               oAnnoInfo.AnnoInfoStatus.u32Frequency = m_potun_MsgToHMI->u32GetAnnoInfoFreq();
               oAnnoInfo.AnnoInfoStatus.u16PI = m_potun_MsgToHMI->u16GetAnnoInfoPI();

                oAnnoInfo.AnnoInfoStatus.sAnnoStationName.bSet( m_potun_MsgToHMI->utf8GetAnnoInfoPSName() ,
                                         midw_fi_tclString::FI_EN_UTF8);

               oAnnoInfo.b8AnnoTypes.u8Value = m_potun_MsgToHMI->u8GetAnnoInfoType();

               ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementInfo(), u32Frequency = %d,\
                           u16PI= %04x, AnnoType = %d",\
                           oAnnoInfo.AnnoInfoStatus.u32Frequency,\
                           oAnnoInfo.AnnoInfoStatus.u16PI,\
                           oAnnoInfo.b8AnnoTypes.u8Value));

                vSendMessage ( poMessage->u16GetSourceAppID(),
                               oAnnoInfo,
                               MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO,
                               AMT_C_U8_CCAMSG_OPCODE_STATUS,
                               poMessage->u16GetCmdCounter(),
                               poMessage->u16GetRegisterID() );
            }
            else
            {
               midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus oAnnoMsg;
               /** Fill msg data  */
               oAnnoMsg.e8AnnoMessage = m_potun_MsgToHMI->enGetAnnouncementMessage(m_potun_MsgToHMI->u8GetAnnoMessageType());


               ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage(), e8AnnoMessage = %d"
                           ,oAnnoMsg.e8AnnoMessage.enType));

               vSendMessage ( poMessage->u16GetSourceAppID(),
                           oAnnoMsg,
                           MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE,
                           AMT_C_U8_CCAMSG_OPCODE_STATUS,
                           poMessage->u16GetCmdCounter(),
                           poMessage->u16GetRegisterID() );

            }

         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_Mute_Request
*
*DESCRIPTION: Handles upreg for FID_TUN_G_MUTE_REQUEST
*
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR:
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_Mute_Request(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_Mute_Request Upreg Failed\
                        for FID = %04x", poMessage->u16GetFunctionID()));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_AnnouncementMessageAndInfo Upreg successful\
                        for FID = %04x", poMessage->u16GetFunctionID()));

         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }
    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_AtPISearch
*
*DESCRIPTION: Handles upreg for FID_TUN_G_ATPISEARCH
*
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR:
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_AtPISearch(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_AtPISearch Upreg Failed\
                        for FID = %04x", poMessage->u16GetFunctionID()));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_AtPISearch Upreg successful\
                        for FID = %04x", poMessage->u16GetFunctionID()));

         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */

         }
         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
/*************************************************************************
* FUNCTION:    tun_MsgFromHMI::vHandle_g_HD_PSD_Data
*
* DESCRIPTION: Handler for MIDW_TUNERFI_C_U16_FID_TUN_G_HD_PSD_DATA
*
* PARAMETER:   amt_tclServiceData message
*
* RETURNVALUE: NONE
* AUTHOR :  vnd4kor ECV2
* Date : 10.10.2014
*************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_HD_PSD_Data( amt_tclServiceData* poMessage )
{
   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
      ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_FID_HANDLER _\
      ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_HD_PSD_DATA _\
      ET_EN_DONE);



   if(( poMessage == NULL ) || ( m_potun_MsgToHMI == NULL ))
   {
      NORMAL_M_ASSERT( poMessage != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
      return;
   }

   switch (poMessage->u8GetOpCode())
   {
   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
    	  if((m_poclConfigInterface->u32GetConfigData("HDSupported")))
    	  {
			 if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			 {
				vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
				   ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _\
				   ET_EN_DONE);

			 }
			 else
			 {
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
				   ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _\
				   ET_EN_DONE);
				/*send update to clients on successful upreg*/
				ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_HD_PSD_Data Upreg successful\
							for FID = %04x", poMessage->u16GetFunctionID()));
				m_potun_MsgToHMI->vSendPSDStatus(m_potun_MsgToHMI->u8GetActiveAudioProgram());
			 }
    	  }
    	  else
    	  {
     		 vTpegSendErrorMessage(poMessage->u16GetSourceAppID(),\
     				 	 	 	   poMessage->u16GetCmdCounter(),\
     				 	 	 	   poMessage->u16GetRegisterID(),\
     				 	 	 	   poMessage->u16GetFunctionID(),\
     				 	 	 	   ERROR_NOTAVAILABLE);
    	  }
         break;
      }

   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */

         }
         else
         {
            /* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
         }

      }
      break;

   default:
      {
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T32 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T32  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }
    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_HD_AdvisoryInfo
*
*DESCRIPTION: Handles Upreg for FID_TUN_G_HD_AVISORY_INFO
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor ECV2 03.02.2015
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_HD_AdvisoryInfo(amt_tclServiceData* poMessage)
{

   if( (NULL == poMessage )||( NULL == m_potun_MsgToHMI ))
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
    	 if((m_poclConfigInterface->u32GetConfigData("HDSupported")))
    	 {
			 if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			 {
				vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
				ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_HD_AdvisoryInfo Upreg Failed\
							for FID = %04x", poMessage->u16GetFunctionID()));

			 }
			 else
			 {
				ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_HD_AdvisoryInfo Upreg successful\
							for FID = %04x", poMessage->u16GetFunctionID()));

			 }
    	 }
    	 else
    	 {
    		 vTpegSendErrorMessage(poMessage->u16GetSourceAppID(),\
    				 	 	 	   poMessage->u16GetCmdCounter(),\
    				 	 	 	   poMessage->u16GetRegisterID(),\
    				 	 	 	   poMessage->u16GetFunctionID(),\
    				 	 	 	   ERROR_NOTAVAILABLE);
    	 }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */

         }
         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }
}
/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_HD_SignalLostTimer
*DESCRIPTION: Handles Upreg for FID_TUN_G_HD_SIGNALLOST_TIMER
*PARAMETER:   amt_tclServiceData*
*RETURNVALUE: tVoid
*AUTHOR: gds5kor ECV01 17.03.2017
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_HD_SignalLostTimer(amt_tclServiceData* poMessage)
{
	if( (NULL == poMessage )||( NULL == m_potun_MsgToHMI ))
	{
		NORMAL_M_ASSERT (NULL != poMessage);
		NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
		return;
	}
	
	switch (poMessage->u8GetOpCode())
	{

	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
    	 if((m_poclConfigInterface->u32GetConfigData("HDSupported")))
    	 {
			 if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			 {
				vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
				ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_HD_SignalLostTimer Upreg Failed\
							for FID = %04x", poMessage->u16GetFunctionID()));

			 }
			 else
			 {
				ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_HD_SignalLostTimer Upreg successful\
							for FID = %04x", poMessage->u16GetFunctionID()));
				m_potun_MsgToHMI->vSend_HD_SignalLostTimer(false);
			 }
    	 }
    	 else
    	 {
    		 vTpegSendErrorMessage(poMessage->u16GetSourceAppID(),\
    				 	 	 	   poMessage->u16GetCmdCounter(),\
    				 	 	 	   poMessage->u16GetRegisterID(),\
    				 	 	 	   poMessage->u16GetFunctionID(),\
    				 	 	 	   ERROR_NOTAVAILABLE);
    	 }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */

         }
         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
	}
}

#endif
/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_UpdateLandscape_Progress
*
*DESCRIPTION: Handles upreg for FID_TUN_G_UPDATELANDSCAPE_PROGRESS
*
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR:
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_UpdateLandscape_Progress(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_UpdateLandscape_Progress Upreg Failed\
                        for FID = %04x", poMessage->u16GetFunctionID()));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_g_UpdateLandscape_Progress Upreg successful\
                        for FID = %04x", poMessage->u16GetFunctionID()));

             midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus oStatusMsg;

            /** Fill msg data  */
            oStatusMsg.u8FreqPerc = 0x00;

            /*Send status message to clients*/
             vSendMessage ( poMessage->u16GetSourceAppID(),
                      oStatusMsg,
                      poMessage->u16GetFunctionID(),
                      AMT_C_U8_CCAMSG_OPCODE_STATUS,
                      poMessage->u16GetCmdCounter(),
                       poMessage->u16GetRegisterID()
                );


         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
         if( !( m_potun_MsgToHMI ->bRemoveNotification( poMessage ) ) )
         {
            /* --- relupreg failt: send an error message --- */
            /* +++ use you own error codes  +++ */

         }
         break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }
    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_AnnouncementEscape
*
*DESCRIPTION: Cancel TA/PTY Announcement
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 29.10.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_AnnouncementEscape(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToADR )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      return;
   }

   /** Create Method Result object to send Method result to Client */
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult oResponse;


   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8AnnoEscType = (tU8)oMessage.e8AnnoType.enType;

         if(u8AnnoEscType <= enAnnoSwitchTypePTY31)
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_AnnouncementEscape() -> \
                              u8AnnoEscType = %d\n",\
                              u8AnnoEscType));

            /** Send ADR message */
#ifndef GTEST_x86LINUX_BUILD
            m_potun_MsgToADR->vSendAnnouncementEscape(u8AnnoEscType);
#endif

                     /** Method Result to the client */
            vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_AnnouncementEscape() ->\
                        Invalid Anno Type\n"));

               vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
         }


         break;
      }

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_ESCAPE _\
            ET_EN_DONE);
         break;
      }
   }
    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_SetPI_PS_Relation
*
*DESCRIPTION: Sets PI PS relation.PS is attached to PI for all tuning actions
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 11.11.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_SetPI_PS_Relation(amt_tclServiceData* /*poMessage*/)
{
#if 0
   if( NULL == poMessage || NULL == m_potun_MsgToADR || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_PI_PS_RELATIONMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU16 u16PI = oMessage.u16PI;

         tU8* sPSName = (tU8*)oMessage.sPSName.szGet(midw_fi_tclString::FI_EN_UTF8);

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_SetPI_PS_Relation() -> \
                              u16PI = %04x\n",\
                              u16PI));

          ETG_TRACE_USR2((" PSName = %8s"\
              , (const tChar*)sPSName\
           ));


         /** Send ADR message */
         /** Msg not sent as ADR implementation for the feature still not available */
         //m_potun_MsgToADR->vSendSetPiPsRelation(u16PI,sPSName);

         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_PI_PS_RELATIONMethodResult oResponse;


         /** Method Result to the client */
         /** Currently updated as FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED
         as ADR implementation for the feature not available */
         /*vSendMethodResult(oResponse,\
               poMessage,\
               midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);*/


         vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED);


         break;
      }

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_SetPI_PS_Relation Upreg Failed"));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_SetPI_PS_Relation Upreg successful"));
         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }

#endif    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_SetPresetStoragePSNameFreeze
*
*DESCRIPTION: Set PS Freeze before storing preset to avoid short PS.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 11.11.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_SetPresetStoragePSNameFreeze(amt_tclServiceData* poMessage)
{
   if( NULL == poMessage || NULL == m_potun_MsgToADR)
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8Mode = (tU8)oMessage.e8Mode.enType;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_SetPresetStoragePSNameFreeze() -> \
                              u8Mode = %d\n",\
                              u8Mode));

         /** Send ADR message */
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vSendSetPreparePresetStorage(u8Mode);
#endif

         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult oResponse;


         /** Method Result to the client */
         vSendMethodResult(oResponse,\
               poMessage,\
               midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);




         break;
      }

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_STORAGE_PS_FREEZE _\
            ET_EN_DONE);
         break;
      }
   }

    
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_SetSpeedinformation
*
*DESCRIPTION: Send Speed Info to ADR.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 26.11.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_SetSpeedinformation(amt_tclServiceData* poMessage)
{

   if( NULL == poMessage || NULL == m_potun_MsgToADR)
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8Speed = oMessage.u8Speed;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_SetSpeedinformation() -> \
                              u8Speed = %d\n",\
                              u8Speed));

         /** Send ADR message */
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vSendSpeedInfo(u8Speed);
#endif

         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult oResponse;


         /** Method Result to the client */
         vSendMethodResult(oResponse,\
               poMessage,\
               (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         break;
      }

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_SPEED_INFO _\
            ET_EN_DONE);
         break;
      }
   }

    
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_g_GetAvailableBandRange
*
*DESCRIPTION: Get available band range.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 6.1.2014
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_g_GetAvailableBandRange(amt_tclServiceData* poMessage)
{

   if( NULL == poMessage || NULL == m_potun_MsgToHMI )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_GetAvailableBandRange : OpType = GET"));

         m_potun_MsgToHMI->vHandle_g_AvailableBandRange();

         break;
      }

   case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         if( !( m_potun_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
         {
            vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_GetAvailableBandRange Upreg Failed"));

         }
         else
         {
            ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_GetAvailableBandRange Upreg successful"));
         }
         break;
      }
   case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {
      	vRemoveFromNotificationTable(poMessage);
      	break;
      }
   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ poMessage->u16GetFunctionID() _\
            ET_EN_DONE);
         break;
      }
   }
    
}
/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_AudioMuteRequest
*
*DESCRIPTION: Handle Mute request.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 26.11.13
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_AudioMuteRequest(amt_tclServiceData* poMessage)
{

   if( NULL == poMessage || NULL == m_potun_MsgToADR)
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_AudioMuteRequest"));
#ifdef MUTE_ACTIVE
         vHandleMuteRequest(m_MuteHandlingRequest.enMuteAction_curr);
#endif
         break;
      }

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_MUTEREQUEST _\
            ET_EN_DONE);
         break;
      }
   }

    

}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandleMuteRequest
*
*DESCRIPTION: Handle Mute request.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR:
********************************************************************************/
tVoid tun_MsgFromHMI::vHandleMuteRequest(enMuteAction enMute_Action)
{
   ETG_TRACE_USR4(("tun_MsgFromHMI::vHandleMuteRequest, MuteAction: %d",m_MuteHandlingRequest.enMuteAction_curr));

   switch(enMute_Action)
   {
      case DirectFrequency:
      {
         vSend_DirectFrequency();
         break;
      }
      case ManualTuning:
      {
         vSend_AtFrequencyWithTickInfo();
         break;
      }
      case Seek:
      {
         vSend_AtSeek();
         break;
      }
      case PresetRecall:
      {
         vSend_PresetRecall();
         break;
      }
      case StationList:
      {
         vSend_SelectListElem();
         break;
      }
      case PISeek:
      {
         vSend_AtPI();
         break;
      }
      default:
      {
         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_AudioMuteRequest(), Mute action None"));
         break;
      }
   }
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_ConfigListUpdate
*
*DESCRIPTION: Send Config List update command to ADR.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECG4) 19.02.14
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_ConfigListUpdate(amt_tclServiceData* poMessage)
{

   if( NULL == poMessage || NULL == m_potun_MsgToADR || NULL == m_potun_MsgToHMI)
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         tU32 u32Band = 0;
         /** Extract the parameters from the msg */
         tU8 u8ConfigListID = (tU8)oMessage.e8ConfigListID.enType;

         tBool bStatus = oMessage.bStatus;

         if(bStatus == TRUE)
         {
#ifndef GTEST_x86LINUX_BUILD
            u32Band = m_potun_MsgToADR->u32GetBandFromConfigListID(u8ConfigListID);
#endif
         }

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_ConfigListUpdate() -> \
                              u8ConfigListID = %d, u32Band = %08x\n , bStatus = %d",\
                              u8ConfigListID, u32Band , bStatus));

#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToHMI ->vSetMsgDataForConfigListUpdate(\
            poMessage->u16GetSourceAppID(),
            poMessage->u16GetRegisterID(),
            poMessage->u16GetCmdCounter());

         /** Send ADR message */
         m_potun_MsgToADR->vUpdateLandscape(u32Band);

#endif
      }
      break;

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_CONFIGLIST_UPDATE _\
            ET_EN_DONE);
         break;
      }
   }

    

}



/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vHandle_s_DefaultSetting
*
*DESCRIPTION: Send Default setting command to ADR.
*
*PARAMETER:   amt_tclServiceData*
*
*RETURNVALUE: tVoid
*
*AUTHOR: vnd4kor (ECV4) 28.05.14
********************************************************************************/
tVoid tun_MsgFromHMI::vHandle_s_DefaultSetting(amt_tclServiceData* poMessage)
{

   if( NULL == poMessage || NULL == m_potun_MsgToADR )
   {
      NORMAL_M_ASSERT (NULL != poMessage);
      NORMAL_M_ASSERT (NULL != m_potun_MsgToADR);
      return;
   }

   switch (poMessage->u8GetOpCode())
   {

   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         //Create object to store the parameters from HMI
         midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart oMessage;

         //Extract data from the AMT message in to the FI class
         vGetDatafromAMT( poMessage, oMessage );

         /** Extract the parameters from the msg */
         tU8 u8DefaultSettingOption = (tU8)oMessage.e8DefaultSettingOption.enType;

         ETG_TRACE_USR4(("tun_MsgFromHMI::vHandle_s_DefaultSetting() -> \
                              u8DefaultSettingOption = %d",\
                              u8DefaultSettingOption));

         /** Create Method Result object to send Method result to Client */
         midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult oResponse;

         /** Method Result to the client */
         if(u8DefaultSettingOption == enINVALID_TYPE)
         {

        	 vSendMethodResult(oResponse,\
        	 poMessage,\
			 (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL);
         }
         else
         {

         /** Send ADR message */
#ifndef GTEST_x86LINUX_BUILD
         m_potun_MsgToADR->vSendDefaultSetting(u8DefaultSettingOption);
#endif
         	 vSendMethodResult(oResponse,\
         	 poMessage,\
			 (tU8)midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED);
         }
      }
      break;

   default:
      {
         /**   unkown opcode: error handling trace here ***/
         ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGFROMHMI,\
            ET_EN_T16 _ TUN_TRACE_MSGFROMHMI_WRONG_OPCODE _\
            ET_EN_T16  _ MIDW_TUNERFI_C_U16_FID_TUN_S_DEFAULT_SETTING _\
            ET_EN_DONE);
         break;
      }
   }

    
}
/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::u8GetBandFromStationListID
*
*DESCRIPTION: Returns the band of the station list
*
*PARAMETER:   tU16 u16StationList
*
*RETURNVALUE: tU8
********************************************************************************/
tU8 tun_MsgFromHMI::u8GetBandFromStationListID()
{
   tU8 u8Band = enBand_GetCurrent;
   tU16 u16StationList = m_MuteHandlingRequest.u16StationListID;
   switch(u16StationList)
   {
   case enTUN_TUN_CONFIG_LIST_FM:
   {
      u8Band = enBand_FM;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_MW:
   {
      u8Band = enBand_MW;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_LW:
   {
      u8Band = enBand_LW;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_DRM:
   {
      u8Band = enBand_CB1;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_AM:
   {
      u8Band = u8GetBandFromFrequency();
      break;
   }
   default:
   {
      ETG_TRACE_USR4(("tun_MsgFromHMI::u8GetBandFromStationList() invalid stationListID = %d", u16StationList));
      break;
   }
   }


   return u8Band;
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::u8GetBandFromFrequency
*
*DESCRIPTION: Returns the band of the given frequency
*
*PARAMETER:   tU32Frequency
*
*RETURNVALUE: tU8
********************************************************************************/
tU8 tun_MsgFromHMI::u8GetBandFromFrequency()
{
   tU8 u8Band = enBand_GetCurrent;
   tU32 u32Frequency = m_MuteHandlingRequest.u32StationListElem_Frequency;
   if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighFM") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowFM") <= u32Frequency))
   {
      u8Band = enBand_FM;
   }
   else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighLW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowLW") <= u32Frequency))
   {
      u8Band = enBand_LW;
   }
   else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") <= u32Frequency))
   {
      u8Band = enBand_MW;
   }

   return u8Band;
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::bGetFSRequestStatus
*
*DESCRIPTION: Indicates if the FieldStrength was requested by Diagnosis
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tBool
********************************************************************************/
tBool tun_MsgFromHMI::bGetFSRequestStatus() const
{
   return m_bFSReqFromDiag;
}



/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::bGetFSRequestStatus
*
*DESCRIPTION: Indicates if the FieldStrength was requested by Diagnosis
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tBool
********************************************************************************/
tVoid tun_MsgFromHMI::vSetFSRequestStatus(tBool bFSStatus)
{
   m_bFSReqFromDiag = bFSStatus;
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::bGetAMSrcStatus
*
*DESCRIPTION: Indicates if the source is in AM
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tBool
********************************************************************************/
tBool tun_MsgFromHMI::bGetAMSrcStatus() const
{
   return m_bSrcInAM;
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vSetAMSrcStatus
*
*DESCRIPTION: Sets if Src is in AM
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tBool
********************************************************************************/
tVoid tun_MsgFromHMI::vSetAMSrcStatus(tBool bAMStatus)
{
   m_bSrcInAM = bAMStatus;
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::u32GetDirectFreqRequested
*
*DESCRIPTION: Returns the direct frequency requested via SDS input
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tBool
********************************************************************************/
tU32 tun_MsgFromHMI::u32GetDirectFreqRequested()const
{
   return m_u32DirectFreq;
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vSendMethodResult
*
*DESCRIPTION: Template function which helps to Send Method Result to Client*
*PARAMETER:   METHODRESULT oResponse, amt_tclServiceData* poMessage, tU8 u8MethodResult
*
*RETURNVALUE: tVoid
*
*Author : vnd4kor(ECG4) 7.10.2013
********************************************************************************/
template <class METHODRESULT>
tVoid tun_MsgFromHMI::vSendMethodResult(METHODRESULT &oResponse, \
                              amt_tclServiceData* poMessage, tU8 u8MethodResult)
{
   /** Assign Method Result to response message */
   if(u8MethodResult <= midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_ACCEPTED_INPROGRESS)
   {
      oResponse.TunerServer_StatusResponse.u8TunerStatus.enType = \
         (midw_fi_tcl_e8_Tun_ResponseStatus::tenType)u8MethodResult;
   }
   else
   {
      /** Assign Method result as FAIL if u8MethodResult is invalid */
      oResponse.TunerServer_StatusResponse.u8TunerStatus.enType = \
         midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
   }


   // Current Tuner state -> Not required for client. NORAL added as default.
   oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
      midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGFROMHMI,
      ET_EN_T8 _ poMessage->u16GetFunctionID() _
      ET_EN_DONE);
   //------------------------------
   // Send the response to client.
   //------------------------------
   vSendMessage( poMessage->u16GetSourceAppID(),
      oResponse,
      poMessage->u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
      poMessage->u16GetCmdCounter(),
      poMessage->u16GetRegisterID()
      );
}


tVoid tun_MsgFromHMI::vSetTestModeFeatureValue(tU32 u32NewFeature)
{
   m_u32TestModeFeatureValue = u32NewFeature;
}

tU32 tun_MsgFromHMI::u32GetTestModeFeatureValue() const
{
   return m_u32TestModeFeatureValue;
}
tVoid tun_MsgFromHMI::vHandleAllMessages(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vHandleAllMessages() entered"));
   clCCAhandler::vHandleMessage(poMessage);
}



/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::vSetConfigListID
*
*DESCRIPTION: sets the config list ID of statin list exit
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tU8
********************************************************************************/
tVoid tun_MsgFromHMI::vSetConfigListID(tU8 u8ConfigListID)
{
   m_u8ConfigListID = u8ConfigListID;
}


/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::u8GetConfigListID
*
*DESCRIPTION: Returns the config list ID of statin list exit
*
*PARAMETER:   tVoid
*
*RETURNVALUE: tU8
********************************************************************************/
tU8 tun_MsgFromHMI::u8GetConfigListID()const
{
   return m_u8ConfigListID;
}
tVoid tun_MsgFromHMI::vSetTunerBand(tU8 u8Band)
{
	ETG_TRACE_USR4(("m_u8Band=%d",u8Band));
	m_u8Band=0xff;
}
tU8 tun_MsgFromHMI::u8GetCurrentBand()
{
	ETG_TRACE_USR4(("u8GetCurrentBand=%d",m_u8Band));
	return m_u8Band;
}
tVoid tun_MsgFromHMI::vRemoveFromNotificationTable(amt_tclServiceData* poInMessage)
{
	   if ((poInMessage != NULL) && (m_potun_MsgToHMI != NULL))
	   {
	      (tVoid)m_potun_MsgToHMI->bRemoveNotification(poInMessage);
	      ETG_TRACE_USR1((
	         "RELUPREG INFO - FunctionID %x, AppID %x CommandCounter %d",
	         poInMessage->u16GetFunctionID(),
	         poInMessage->u16GetSourceAppID(),
	         poInMessage->u16GetCmdCounter()));
	   }
}

/*******************************************************************************
*FUNCTION:    tun_MsgFromHMI::U8GetMaxNoOfStations
*
*DESCRIPTION:
*
*PARAMETER:   midw_fi_tcl_e8_Tun_ListID::tenType
*
*RETURNVALUE: tU8
********************************************************************************/
tU8 tun_MsgFromHMI::U8GetUserAutoSToreNoOfStations(tU8 u8PresetListID)
{
	tU8 u8MaxNoOfStations = 0;

	if((u8PresetListID == (tU8)midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_FM_AST) &&
			(m_poclConfigInterface->u32GetConfigData("PresetListMapping") & FM_AST_AVAILABLE) == FM_AST_AVAILABLE)
	{
		if(0 == m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations"))
		{
		u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankFM");
		}
		else
		{
			u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
		}
	}

	if(((u8PresetListID == (tU8)midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_MWAST)  || (u8PresetListID == (tU8)midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_AST)) &&
			(((m_poclConfigInterface->u32GetConfigData("PresetListMapping") & AMMW_AST_AVAILABLE) == AMMW_AST_AVAILABLE) || (m_poclConfigInterface->u32GetConfigData("PresetListMapping") & AMMWLW_AST_AVAILABLE) == AMMWLW_AST_AVAILABLE))
	{
		if(0 == m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations"))
		{
		u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankMW");
	}
		else
		{
			u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
		}
	}

	if((u8PresetListID == (tU8)midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_LWAST) &&
			((m_poclConfigInterface->u32GetConfigData("PresetListMapping") & AMLW_AST_AVAILABLE) == AMLW_AST_AVAILABLE))
	{
		if(0 == m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations"))
		{
			u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankLW");
		}
		else
		{
			u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
		}
	}

	if((u8PresetListID == (tU8)midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_DRM_AST) &&
			((m_poclConfigInterface->u32GetConfigData("PresetListMapping") & DRM_AST_AVAILABLE) == DRM_AST_AVAILABLE))
	{
		if(0 == m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations"))
		{
		u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankDRM");
		}
		else
		{
			u8MaxNoOfStations = (tU8)m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
		}
	}

	return u8MaxNoOfStations;
}
