/************************************************************************
* FILE:           tun_Manager.cpp
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Main control of the tuner component.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:      
* Date      | Author                       | Modification
* 20.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "tun_Utility.h"

#include "tun_MsgToADR.h"

#include "tun_main.h"
#include "tun_Manager.h"

#include "tun_ActualData.h"

#include "tun_MsgDefines.h"

#include "tun_Manager.h"
#include "tun_defines.h"

#include "tun_PrjConfig.h"
#include "tun_Config.h"



#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#include "tun_DrvAdrIf.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MGR
#include "trcGenProj/Header/tun_Manager.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION:     tu_Manager::tu_Manager( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tu_Manager::tu_Manager(tVoid):
    poGWMain   ( NULL ),
    m_potun_MsgToADR( NULL ),
    m_potun_ActualData( NULL ),
    m_potun_Config(NULL),
    m_u8TunerSysState ( AMT_C_U32_STATE_OFF ),
    m_u8TunerState    ( TUNER_STATE_NOT_READY )                                                     

{
  m_u8TunLastListElementID =TUN_STATIC_LIST_FIRST_ELEMENT;

  m_u8TunLastListID = TUN_LIST_ID_FIRST;

  /* This is used to set the Last Element ID in the preset list*/
  vSetLastListElementID();

}




/*************************************************************************
*
* FUNCTION:     tu_Manager::~tu_Manager( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tu_Manager::~tu_Manager( )
{
  m_potun_MsgToADR = NULL;

  m_potun_ActualData = NULL;

  m_potun_Config = NULL;

  poGWMain = NULL;


}





/*************************************************************************
*
* FUNCTION:     tun_IPNInterface::vSet_tun_MsgToADR_Ptr( )
* 
* DESCRIPTION:  With this, tun_IPNInterface can send info to class tun_MsgToADR.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tu_Manager::vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR )
{
  if( potun_MsgToADR != NULL )
  {  
    m_potun_MsgToADR = potun_MsgToADR;
  }
  else
  {
    /* Assert to do */
  }
}


/*************************************************************************
*
* FUNCTION:     tu_Manager::vSet_tun_ActualData_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tu_Manager::vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData )
{
  if( potun_ActualData != NULL )
  {
    m_potun_ActualData = ( tun_ActualData* )potun_ActualData;
  }
}

/*************************************************************************
*
* FUNCTION:     tu_Manager::vSet_tun_config_Ptr( )
* 
* DESCRIPTION:  The access of config class pointer.
*
* PARAMETER:    tun_Config*
*
* RETURNVALUE:  tVoid
*
*************************************************************************/
tVoid tu_Manager::vSet_tun_config_Ptr( tun_Config* potun_Config )
{
  if( potun_Config != NULL )
  {
    m_potun_Config = ( tun_Config* )potun_Config;
  }
}




/*************************************************************************
*
* FUNCTION:     tu_Manager::vSet_tuner_tclApp_Ptr( )
* 
* DESCRIPTION:  The access of config class pointer.
*
* PARAMETER:    poGWMain*
*
* RETURNVALUE:  tVoid
*
*************************************************************************/
tVoid tu_Manager::vSet_tuner_tclApp_Ptr( tuner_tclApp* potunerMainApp)
{
  if( potunerMainApp != NULL )
  {
    poGWMain = ( tuner_tclApp* )potunerMainApp;
  }
}




/*************************************************************************
*
* FUNCTION:     tun_IPNInterface::vUpdateTunerState( )
* 
* DESCRIPTION:  Update Component status from the Radio unit. Set the tuner
                status as READY.
*
* PARAMETER:    tU8 u8Status
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tu_Manager::vUpdateComponentStatus()
{
  
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MGR,\
                     ET_EN_T16 _ TUN_TRACE_UPDATE_TUNER_STATE _\
                     ET_EN_DONE);

  
	if( m_potun_ActualData == NULL )
  {
    NORMAL_M_ASSERT ( m_potun_ActualData != NULL );

    return;
  }
  else if( m_potun_MsgToADR == NULL )
  {
    NORMAL_M_ASSERT ( m_potun_MsgToADR != NULL );

    return;
  }
  else
  {  
      //-------------------------------------------------------------------------------
      // After successful communication established, Inform all the fc_TmcTuner clients
      // of service availability.
      //-------------------------------------------------------------------------------
        if( poGWMain != NULL )
        {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MGR,\
                           ET_EN_T16 _ 0x2211 _\
                           ET_EN_T8 _ 0x33 _\
                           ET_EN_DONE);
       
            m_potun_ActualData->m_bIsTunerShutdown = FALSE;
#endif
            poGWMain->vTunerStartUpProcess();
          
        }
        else
        {
          NORMAL_M_ASSERT( poGWMain != NULL );
        }

     


      if( m_u8TunerSysState == AMT_C_U32_STATE_NORMAL)
      {
    
        vSetTunerState( TUNER_STATE_READY );
    
      }
      else if(( m_u8TunerSysState == AMT_C_U32_STATE_PAUSE ) || \
              ( m_u8TunerSysState == AMT_C_U32_STATE_OFF   ))
      {
    
        vSetTunerState( TUNER_STATE_NOT_READY );

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MGR,\
                           ET_EN_T16 _ TUN_TRACE_TUNER_STATE_NOT_READY _\
                           ET_EN_DONE);

      }

  } /* else */
 
}








/*************************************************************************
*
* FUNCTION:     tun_IPNInterface::vSetTunerSystemState( )
* 
* DESCRIPTION:  
*
* PARAMETER:   u8TunerSysState: new tuner system state. 
*
* RETURNVALUE:  tU8 u8Status
*
*************************************************************************/
tVoid tu_Manager::vSetTunerSystemState( tU8 u8TunerSysState )
{  
   m_u8TunerSysState = u8TunerSysState;
 
}



/*************************************************************************
*
* FUNCTION:     tun_IPNInterface::vSetTunerState( )
* 
* DESCRIPTION:  
*
* PARAMETER:   u8TunerSysState: new tuner state. 
*
* RETURNVALUE:  tU8 u8Status
*
*************************************************************************/
tVoid tu_Manager::vSetTunerState( tU8 u8TunerState )
{  
   m_u8TunerState = u8TunerState;
 
}





 
 
/*************************************************************************
*
* FUNCTION:     tun_IPNInterface::u8GetTunerSystemState( )
* 
* DESCRIPTION:  
*
* PARAMETER:    
*
* RETURNVALUE:  tU8 u8Status
*
*************************************************************************/
tU8 tu_Manager::u8GetTunerSystemState( )const
{  
    return m_u8TunerSysState; 
 
}


/*************************************************************************
*
* FUNCTION:     tun_IPNInterface::vSet_tun_MsgToADR_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    
*
* RETURNVALUE:  
*
*************************************************************************/
tU8 tu_Manager::u8GetTunerState( )const
{
  return m_u8TunerState;
 
}


/*************************************************************************
*
* FUNCTION:     tu_Manager::u8GetLastListElementID( )
* 
* DESCRIPTION:  This is used to get the Last element ID of the list
*
* PARAMETER:    void
*
* RETURNVALUE:  tU8
*
*************************************************************************/
tU8 tu_Manager::u8GetLastListElementID(  )const
{
  return m_u8TunLastListElementID;
 
}


/*************************************************************************
*
* FUNCTION:     tu_Manager::u8GetLastListID( )
* 
* DESCRIPTION:  This is used to get the Last List ID.
*
* PARAMETER:    void
*
* RETURNVALUE:  tU8
*
*************************************************************************/
tU8 tu_Manager::u8GetLastListID(  )const
{
  return m_u8TunLastListID;
 
}

/*************************************************************************
*
* FUNCTION:     tu_Manager::vSetLastListElementID( )
* 
* DESCRIPTION:  This is used to Set the Last element ID
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
*************************************************************************/
tVoid tu_Manager::vSetLastListElementID(  )
{
     /* last list element  */
    m_u8TunLastListElementID= TUN_STATIC_LIST_LAST_ELEMENT_10; 

  

}





