/************************************************************************
* FILE:           tun_HMIManager.cpp
* PROJECT:        Ford H/L RNS
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All dicesions related to HMI are done here.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 11.03.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

/*****************************************************************************
 * ETG trace
 * 0x2613:    TUN_TRACE_CLASS_HMI_MGR
 ****************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_HMI_MGR
#include "trcGenProj/Header/tun_HMIManager.cpp.trc.h"
#endif

#include "tun_trace.h"
#include "tun_Config.h"

#include "tun_Utility.h"
#include "tun_ActualData.h"
#include "tun_MsgToADR.h"
#include "tun_main.h"
#include "tun_Manager.h"
#include "tun_defines.h"

#include "tun_HMIManager.h"
#include "tun_MsgDefines.h"
#include "tun_Msg_types.h"

#include "kdsconfig/clConfigInterface.h"

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
//
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_HMI_MGR
#include "trcGenProj/Header/tun_HMIManager.cpp.trc.h"
#endif

#include "dbus/dbus.h"
/*************************************************************************
*
* FUNCTION:     tun_HMIManager::tun_HMIManager( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_HMIManager::tun_HMIManager( tuner_tclApp* potunerMainApp  ): bCheckLandscapeFlag (FALSE),m_potu_Manager( NULL ),\
m_potun_ActualData( NULL ),\
m_potun_Utility(NULL),\
m_potun_Config (NULL)
{
   // Tuner main application pointer.
   poGWMain     = potunerMainApp;
   m_poclConfigInterface = NULL;
   m_potun_MsgToADR = NULL;
}

/*************************************************************************
*
* FUNCTION:     tun_HMIManager::~tun_HMIManager( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_HMIManager::~tun_HMIManager( )
{
   m_potu_Manager = NULL;

   m_potun_ActualData = NULL;

   m_potun_Utility = NULL ;

   m_potun_Config = NULL;

   poGWMain = NULL;

   m_potun_MsgToADR = NULL;

   m_poclConfigInterface = NULL;

}



/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vSet_tu_Manager_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_HMIManager::vSet_tu_Manager_Ptr( tu_Manager* potu_Manager )
{
   if( potu_Manager != NULL )
   {
      m_potu_Manager = potu_Manager;
   }
}



/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vSet_tun_ActualData_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_HMIManager::vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData )
{
   if( potun_ActualData != NULL )
   {
      m_potun_ActualData = ( tun_ActualData* )potun_ActualData;
   }
}


/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vSet_tun_Utility_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_HMIManager::vSet_tun_Utility_Ptr( tun_Utility* potun_Utility )
{
   if( potun_Utility != NULL )
   {  
      m_potun_Utility = potun_Utility;
   }
   else
   {
      /* Assert to do */
   }
}


/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vSet_tun_Config_Ptr( )
* 
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_HMIManager::vSet_tun_Config_Ptr( tun_Config* potun_Config )
{
   if( potun_Config != NULL )
   {
      m_potun_Config = ( tun_Config* )potun_Config;
   }

}

/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vSet_tun_ConfigInterface_Ptr( )
*
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_HMIManager::vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface )
{
  if( poclConfigInterface != NULL )
  {
	  m_poclConfigInterface = poclConfigInterface;
  }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_tun_MsgToADR_Ptr( )
* 
* DESCRIPTION:  Get pointer to class tun_MsgToADR
*
* PARAMETER:    tun_MsgToADR pointer.
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_HMIManager::vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR )
{
   if( potun_MsgToADR != NULL )
   {  
      m_potun_MsgToADR = potun_MsgToADR;
   }
   else
   {
      NORMAL_M_ASSERT( potun_MsgToADR != NULL ); 
   }
}


/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vConvertRDSPSNametotString(  )
* 
* DESCRIPTION:  This function converts the RDS PSname to the UTF8string
*
* PARAMETER:    tU8* aPSName, tString &sUTF8String
*
* RETURNVALUE:   tVoid
*
*06.1.07 pus1kor
*         Initial version
*
*************************************************************************/
tVoid tun_HMIManager::vConvertRDSPSNametotString( const tU8 *aPSName, midw_fi_tclString *sUTF8String )const
{

   if( m_potun_Utility == NULL )
   {
      NORMAL_M_ASSERT( m_potun_Utility != NULL );
      return;
   } 



   tU32 u32UTFChar = '\0';

   tU16 u16Temp =0;   
   tU8 u8Count = 0;

   // Buffer to get the PS string. ( 4 * 8 = 32, 4bytes per character )
   tS8 s8abuffer[33];

   // Initialize the buffer with '\0'
   ::memset(s8abuffer, '\0', 33);


   if(aPSName ==NULL)
   {
      return;
   }

   ETG_TRACE_USR1(("  tun_HMIManager::vConvertRDSPSNametotString () -> Start"));

   tU8 u8LeadingSpaceCount = 0;
   tU8 u8TrailingSpaceCount = 8;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
   while( (aPSName[u8LeadingSpaceCount] == ' ' ||
      aPSName[u8LeadingSpaceCount] == '\0') && (u8LeadingSpaceCount < (TUN_PS_NAME_MAX_SIZE - 1 )))
   {
	   ETG_TRACE_USR1(("  tun_HMIManager::Entering into  u8LeadingSpaceCount()"));

      u8LeadingSpaceCount++;
   }
   while( (aPSName[u8TrailingSpaceCount - 1] == ' ' ||
      aPSName[u8TrailingSpaceCount - 1] == '\0') && (u8TrailingSpaceCount > 0) )
   {
	   ETG_TRACE_USR1(("  tun_HMIManager::Entering into  u8TrailingSpaceCount()"));

      u8TrailingSpaceCount--;
   }

#endif
   for(tU8 u8Index = u8LeadingSpaceCount; u8Index < u8TrailingSpaceCount; u8Index++)
   {
      u32UTFChar = m_potun_Utility->u32ConvertFromRdsEBU2UTF8(aPSName[u8Index]);

      ETG_TRACE_USR1(( " tun_HMIManager::vConvertRDSPSNametotString () -> u32UTFChar=%04x"
                      ,u32UTFChar ));
      
      // if single byte character MSB starts with 0   


      // Single character 
      if ( u32UTFChar < 0x80 )
      {     
         s8abuffer[u8Count] = (tS8) u32UTFChar;
         u8Count++;

         ETG_TRACE_USR1(( " tun_HMIManager::vConvertRDSPSNametotString () -> Single character" ));
      }
      else if(u32UTFChar < TUN_CHAR_INVALID)
         // Value is 2Byte long
      {   

         //Extract 2nd Byte MSB from the word
         u16Temp = ( (u32UTFChar) & (0xff00) );

         u16Temp = (tU16)(u16Temp >> 8);

         s8abuffer[u8Count] = (tS8) u16Temp;

         u8Count++;

         // Extract the LSB byte.
         s8abuffer[u8Count] = (tS8) ( (u32UTFChar) & (0x00ff) );

         u8Count++;

         ETG_TRACE_USR1(( " tun_HMIManager::vConvertRDSPSNametotString () -> Value is 2Byte long" ));
      }
      else if(u32UTFChar == TUN_CHAR_INVALID)
      {
    	  s8abuffer[u8Count] = (tS8) 0x20;
         u8Count++;

         ETG_TRACE_USR1(( " tun_HMIManager::vConvertRDSPSNametotString () -> Single character" ));

      }
      else
      { //UTF8 character is 3 byte long. extract the third byte into the array.
         tU32 u32Temp = ((u32UTFChar) & (0xff0000));

         //Extract the 3rd byte of UTF8 character into the array.
         u32Temp = u32Temp >> 16;
         s8abuffer[u8Count] = (tS8) u32Temp;
         //Character count increased to indicate addition of a byte
         u8Count++;

         //Extract the 2nd byte of UTF8 character into the array
         u32Temp = ((u32UTFChar) & (0x00ff00));
         u32Temp = u32Temp >> 8;
         s8abuffer[u8Count] = (tS8) u32Temp;
         //Character count increased to
         u8Count++;

         //Extrace the 1st byte of UTF8 character into the array.
         u32Temp = ((u32UTFChar) & (0x0000ff));
         s8abuffer[u8Count] = (tS8) u32Temp;
         //Character count increased to
         u8Count++;
      }

   }

   // Null character at the End of the PSName extraction
   s8abuffer[u8Count] = '\0';
   
   if(!dbus_validate_utf8((const char*)s8abuffer,0))
	{
		sUTF8String->bSet("", midw_fi_tclString::FI_EN_UTF8);
	}
	else
	{
		// Copy the buffer contents.
		sUTF8String->bSet((tCString)s8abuffer, midw_fi_tclString::FI_EN_UTF8); 
	}


}

/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vConvertRTextTotString(  )
* 
* DESCRIPTION:  This function converts the RDS Text to the UTF8string
*
* PARAMETER:    tU8* apRText         - R-Text array pointer
*               tString &sUTF8String - Converted UTF8 string to be copie
*
* RETURNVALUE:   tVoid
*
*
*         Initial version
*
*************************************************************************/
tVoid tun_HMIManager::vConvertRTextTotString( const tU8 *apRText,
                                             midw_fi_tclString *sUTF8String,
                                             tU8 u8Len
                                             )const
{

   if( m_potun_Utility == NULL )
   {
      NORMAL_M_ASSERT( m_potun_Utility != NULL );

      return;
   } 

   if( apRText == NULL )
   {
      NORMAL_M_ASSERT( apRText != NULL );

      return;
   } 

   if( sUTF8String == NULL )
   {
      NORMAL_M_ASSERT( sUTF8String != NULL );

      return;
   } 


   tU32 u32UTFChar = '\0';
   tU8  u8Count     = 0;
   tU16 u16Temp     = 0;


   // Buffer to get the PS string. ( 4 * 64 = 256, 4bytes per character )
   tS8 s8abuffer[257];

   // Initialize the buffer with '\0'
   ::memset(s8abuffer, '\0', 257);



   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_HMI_MGR,\
      ET_EN_T16 _ 0x9999 _\
      ET_EN_DONE);

   tU8 u8LeadingSpaceCount = 0;
   tU8 u8TrailingSpaceCount = u8Len;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
   while( (apRText[u8LeadingSpaceCount] == ' ' ||
      apRText[u8LeadingSpaceCount] == '\0') &&
      (u8LeadingSpaceCount < u8Len))
   {

      u8LeadingSpaceCount++;
   }
   while( (apRText[u8TrailingSpaceCount - 1] == ' ' ||
      apRText[u8TrailingSpaceCount - 1] == '\0') &&
      (u8TrailingSpaceCount > 0x00))
   {

      u8TrailingSpaceCount--;

   }

#endif


   for(tU8 u8Index = u8LeadingSpaceCount; u8Index < u8TrailingSpaceCount; u8Index++)
   {
      u32UTFChar = m_potun_Utility->u32ConvertFromRdsEBU2UTF8(apRText[u8Index]);

      ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_HMI_MGR,\
         ET_EN_T16 _ u32UTFChar _\
         ET_EN_DONE);


      // if single byte character MSB starts with 0 

      // Single character 
      if ( u32UTFChar < 0x80 )
      {     
         s8abuffer[u8Count] = (tS8) u32UTFChar;
         u8Count++;


      }
      else if(u32UTFChar < TUN_CHAR_INVALID)
         // Value is 2Byte long
      {   

         //Extract 2nd Byte MSB from the word
         u16Temp = ( (u32UTFChar) & (0xff00) );

         u16Temp = (tU16)(u16Temp >> 8);

         s8abuffer[u8Count] = (tS8) u16Temp;

         u8Count++;

         // Extract the LSB byte.
         s8abuffer[u8Count] = (tS8) ( (u32UTFChar) & (0x00ff) );

         u8Count++;

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_HMI_MGR, ET_EN_T16 _ 0xfffc _\
            ET_EN_DONE);
      }
      else if(u32UTFChar == TUN_CHAR_INVALID)
      {
		   s8abuffer[u8Count] = (tS8) 0x20;
         u8Count++;

    	  ETG_TRACE_USR1(( " tun_HMIManager::vConvertRTextTotString () -> ignore" ));
      }
      else
      { //UTF8 character is 3 byte long. extract the third byte into the array.
         tU32 u32Temp = ((u32UTFChar) & (0xff0000));

         //Extract the 3rd byte of UTF8 character into the array.
         u32Temp = u32Temp >> 16;
         s8abuffer[u8Count] = (tS8) u32Temp;
         //Character count increased to indicate addition of a byte
         u8Count++;

         //Extract the 2nd byte of UTF8 character into the array
         u32Temp = ((u32UTFChar) & (0x00ff00));
         u32Temp = u32Temp >> 8;
         s8abuffer[u8Count] = (tS8) u32Temp;
         //Character count increased to
         u8Count++;

         //Extrace the 1st byte of UTF8 character into the array.
         u32Temp = ((u32UTFChar) & (0x0000ff));
         s8abuffer[u8Count] = (tS8) u32Temp;
         //Character count increased to
         u8Count++;
      }
   }

   // Null character at the End of the PSName extraction
   s8abuffer[u8Count] = '\0';

   //trace for testing leading and trailing space

   ET_TRACE_INFO_BIN ( TUN_TRACE_CLASS_HMI_MGR,\
      ET_EN_T8 _ s8abuffer[0] _\
      ET_EN_T8 _ s8abuffer[1] _\
      ET_EN_T8 _ s8abuffer[2] _\
      ET_EN_T8 _ s8abuffer[3] _\

      ET_EN_T8 _ s8abuffer[4] _\
      ET_EN_T8 _ s8abuffer[5] _\
      ET_EN_T8 _ s8abuffer[6] _\
      ET_EN_T8 _ s8abuffer[7] _\
      ET_EN_T8 _ s8abuffer[8] _\

      ET_EN_T8 _ s8abuffer[9] _\
      ET_EN_T8 _ s8abuffer[10] _\
      ET_EN_T8 _ s8abuffer[11] _\
      ET_EN_T8 _ s8abuffer[12] _\

      ET_EN_T8 _ s8abuffer[13] _\
      ET_EN_T8 _ s8abuffer[14] _\
      ET_EN_T8 _ s8abuffer[15] _\
      ET_EN_T8 _ s8abuffer[16] _\

      ET_EN_T8 _ s8abuffer[17] _\
      ET_EN_T8 _ s8abuffer[18] _\
      ET_EN_T8 _ s8abuffer[19] _\
      ET_EN_T8 _ s8abuffer[20] _\

      ET_EN_T8 _ s8abuffer[21] _\
      ET_EN_T8 _ s8abuffer[22] _\
      ET_EN_T8 _ s8abuffer[23] _\
      ET_EN_T8 _ s8abuffer[24] _\

      ET_EN_T8 _ s8abuffer[25] _\
      ET_EN_T8 _ s8abuffer[26] _\
      ET_EN_T8 _ s8abuffer[27] _\
      ET_EN_T8 _ s8abuffer[28] _\

      ET_EN_T8 _ s8abuffer[29] _\
      ET_EN_T8 _ s8abuffer[30] _\
      ET_EN_T8 _ s8abuffer[31] _\

      ET_EN_T8 _ s8abuffer[32] _\
      ET_EN_T8 _ s8abuffer[33] _\
      ET_EN_T8 _ s8abuffer[34] _\

      ET_EN_T8 _ s8abuffer[35] _\
      ET_EN_T8 _ s8abuffer[36] _\
      ET_EN_T8 _ s8abuffer[37] _\

      ET_EN_T8 _ s8abuffer[38] _\
      ET_EN_T8 _ s8abuffer[39] _\
      ET_EN_T8 _ s8abuffer[40] _\
      ET_EN_T8 _ s8abuffer[41] _\

      ET_EN_T8 _ s8abuffer[42] _\
      ET_EN_T8 _ s8abuffer[43] _\
      ET_EN_T8 _ s8abuffer[44] _\
      ET_EN_T8 _ s8abuffer[45] _\

      ET_EN_T8 _ s8abuffer[46] _\
      ET_EN_T8 _ s8abuffer[47] _\
      ET_EN_T8 _ s8abuffer[48] _\
      ET_EN_T8 _ s8abuffer[49] _\

      ET_EN_T8 _ s8abuffer[50] _\
      ET_EN_T8 _ s8abuffer[51] _\
      ET_EN_T8 _ s8abuffer[52] _\
      ET_EN_T8 _ s8abuffer[53] _\
      ET_EN_T8 _ s8abuffer[54] _\
      ET_EN_T8 _ s8abuffer[55] _\
      ET_EN_T8 _ s8abuffer[56] _\
      ET_EN_T8 _ s8abuffer[57] _\
      ET_EN_T8 _ s8abuffer[58] _\

      ET_EN_T8 _ s8abuffer[59] _\
      ET_EN_T8 _ s8abuffer[60] _\
      ET_EN_T8 _ s8abuffer[61] _\
      ET_EN_T8 _ s8abuffer[62] _\

      ET_EN_T8 _ s8abuffer[63] _\
      ET_EN_DONE);
	/*dbus validation for UTF8 characters */
	if(!dbus_validate_utf8((const char*)s8abuffer,0))
	{
		sUTF8String->bSet("", midw_fi_tclString::FI_EN_UTF8);
	}
	else
	{
		// Copy the buffer contents.
		sUTF8String->bSet((tCString)s8abuffer, midw_fi_tclString::FI_EN_UTF8); 
	} 


}

/*************************************************************************
*
* FUNCTION:     tun_HMIManager::vSetLandscapeFlag( )
* 
* DESCRIPTION:  Set bCheckLandscapeFlag flag.
*
* PARAMETER:    tBool 
*
* RETURNVALUE:   tVoid
*
*************************************************************************/
tVoid tun_HMIManager::vSetLandscapeFlag( tBool bTunerCheckLandscapeFlag )
{
   bCheckLandscapeFlag = bTunerCheckLandscapeFlag;
}

/*************************************************************************
*
* FUNCTION:     tun_HMIManager::bGetLandscapeFlag( )
* 
* DESCRIPTION:  Get the bCheckLandscapeFlag flag Value.
*
* PARAMETER:    tVoid 
*
* RETURNVALUE:   tBool
*
*************************************************************************/
tBool tun_HMIManager::bGetLandscapeFlag() const
{
   return bCheckLandscapeFlag;
}

