/************************************************************************
* FILE:         tun_DrvAdrIf.cpp
* PROJECT:      
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: SSI interface
*
* TRACE      : TUN_TRACE_CLASS_DRVADRIF     : messages in plain text
*              TUN_TRACE_CLASS_DRVADRIF_LOW : low level message traces
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date       | Author                 | Modification
* --.--.2012 | CM-AI/PJ-VW34 Loss     | initial version
*
*************************************************************************/


/****************************************************************************/
/*                                                                          */
/* INCLUDES                                                                 */
/*                                                                          */
/****************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
/**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR
#include "ssi_if.h"
#else
#ifdef __cplusplus
extern "C"
{
#include "inc.h"
}
#endif
#include "../../ai_osal_linux/components/devices/dev_adr3ctrl/include/dev_adr3ctrl.h"
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
#include "AarsDBusProxy/tuner_gio_dbus_handler.h"
#endif

#include <dgram_service.h>

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/poll.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/tcp.h>
#include "inc_ports.h"
#include <errno.h>
#include <sstream>
#include "kdsconfig/clConfigInterface.h"

#define BUFFER_SIZE 25000
//#define INCERRORHANDLING_ITERATIONS 3
#endif


#include "tun_trace.h"
#include "tun_MsgToADR.h"
#include "tun_DrvAdrIf.hpp"
#include "tun_defines.h"
#include "tun_MsgDispatcher.h"
#include "tun_Utility.h"

#include "tun_MsgToHMI.h"
#include "tun_Diaglog.h"

/*****************************************************************************
 * ETG trace
 * 0x2619:    TUN_TRACE_CLASS_DRVADRIF
 ****************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_DRVADRIF 
#include "trcGenProj/Header/tun_DrvAdrIf.cpp.trc.h"
#endif


/*****************************************************************************
 * static variables
 ****************************************************************************/
tPU8 tun_DrvAdrIf::pu8RxDataBuffer = OSAL_NULL;
tU32 tun_DrvAdrIf::u32RxDataLength = 0;

tPU8 tun_DrvAdrIf::u8CopyRxDataBuffer = OSAL_NULL;
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
tuner_tclApp* tun_INCComm::m_potunMain = NULL;
#endif

queue<tun_DrvAdrIf::rxDataFromAdr> tun_DrvAdrIf::m_ReceiverQueue;

tun_tenADRState tun_DrvAdrIf::m_enADRState = enADRState_ALIVE;
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
int tun_INCComm::m_nADRSocketFd = -1;
sk_dgram *dgram = NULL;
#endif
tU32 tun_DrvAdrIf::m_u32CommunicationLostCounter = 0;
#if defined  (VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC) || defined (VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI) || defined (VARIANT_S_FTR_ENABLE_FEATURE_INF4CV)
tU8  tun_DrvAdrIf::m_u8ADR3ResetCounter=0;
tU8  tun_DrvAdrIf::m_blClearSystemFailureErrorLog=0;
#endif
tuner_tclApp* tun_DrvAdrIf::m_potunMain = NULL;
tun_tclSPMClient* tun_DrvAdrIf::m_potunSPMClient = NULL;
tun_MsgToHMI* tun_DrvAdrIf::m_potun_MsgToHMI = NULL;
tun_DiaglogHandler* tun_DrvAdrIf::m_potun_DiaglogHandler= NULL;

OSAL_tSemHandle tun_DrvAdrIf::m_hMsgDrvAdrIfSem  = OSAL_C_INVALID_HANDLE;



/*****************************************************************************
 * 
 ****************************************************************************/
tun_DrvAdrIf::tun_DrvAdrIf( ) :
  m_pvHandle( 0),
  m_enCommunicationState( enComState_Run),
  m_u8PingCounter( 0),
  m_hAdr3CtrlDevice( OSAL_ERROR),
  m_hTimerPingTimer( OSAL_C_INVALID_HANDLE)
{
  ETG_TRACE_COMP(( " tun_DrvAdrIf::tun_DrvAdrIf() -> Constructor" ));
  m_poclConfigInterface = nullptr;
  m_hMsgDrvAdrIfSem = tuner_tclApp::_hADRDataUpdateSem;
  m_u8Dgram_SendFailurCount=0;
  /* create ADR supervision timer */
  tS32 s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vPingTimerCallback,
                                           ( tPVoid )this, &m_hTimerPingTimer );

  TUN_ASSERT_RETURN( s32OsalError == OSAL_OK);
  vSubscribe< trMsg_CM_Startup_Status>();        // -> vMessage( trMsg_CM_Startup_Status* prMsg)


}


/*****************************************************************************
 * 
 ****************************************************************************/
tun_DrvAdrIf::~tun_DrvAdrIf( tVoid)
{
  ETG_TRACE_COMP(( " tun_DrvAdrIf::~tun_DrvAdrIf() -> Destructor" ));
  
  if( m_hTimerPingTimer != OSAL_C_INVALID_HANDLE)
  {
	if(OSAL_OK != OSAL_s32TimerDelete( m_hTimerPingTimer))
	{
	   NORMAL_M_ASSERT_ALWAYS ();
	}
   
    m_hTimerPingTimer = OSAL_C_INVALID_HANDLE;
  }
/**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR
  tS32 s32RetVal = SSI_s32CloseChannel( &m_pvHandle);
  s32RetVal = 0;
#endif
  m_potunMain = NULL;
  m_potunSPMClient = NULL;
  m_pvHandle = 0;
  #ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
  dgram = NULL;
  #endif
}


/*****************************************************************************
 * 
 ****************************************************************************/
tVoid tun_DrvAdrIf::vStartCommunication( tVoid)
{
  tS32 s32RetVal;

  pu8RxDataBuffer = OSAL_NULL;
  u32RxDataLength = 0;
  m_enADRState    = enADRState_ALIVE;

  ETG_TRACE_COMP((" tun_DrvAdrIf::vStartCommunication(): " ));
  /*==========================================================================
   * open ADR control driver
   *------------------------------------------------------------------------*/
  m_hAdr3CtrlDevice = OSAL_IOOpen( TUN_DRVADRIF_CONF_ADR_CONTROL_DRIVER_NAME, OSAL_EN_READWRITE);
  if ( OSAL_ERROR != m_hAdr3CtrlDevice )
  {
    tU32 u32ErrorCode = OSAL_s32IOControl( m_hAdr3CtrlDevice,
                               OSAL_C_S32_IOCTRL_ADR3CTRL_REGISTER_RESET_CALLBACK,
                               (intptr_t) vCallBackADRState);

	if(OSAL_OK != u32ErrorCode)
	{
		NORMAL_M_ASSERT_ALWAYS();
	}
    
  }
   /**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR

  /*========================================================================*/

  /*==========================================================================
   * channel configuration
   *------------------------------------------------------------------------*/
  ssi_tChannelConfig rChannelConfig = 
  {
    SSI_INSTANCE_ADR3,                                 // Instance
    TUN_DRVADRIF_CONF_AMFM_TUNER_LUN,                  // LUN
    SsiDataConfirmationCallbackFunction,               // data confirmation callback
    SsiDataIndicationCallbackFunction,                 // data indication callback
    TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_TX_BUFFER_SIZE,   // transmit buffer size
    TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_RX_BUFFER_SIZE,   // receive buffer size
    TRUE                                               // TRUE-> After SSI_s32OpenChannel() the channel is in Xoff state
  };
  /*========================================================================*/

  /*==========================================================================
   * open channel
   *------------------------------------------------------------------------*/
  s32RetVal = SSI_s32OpenChannel( &m_pvHandle, &rChannelConfig);
  if( s32RetVal == SSI_C_NO_ERROR)
  {
    m_enCommunicationState = enComState_WaitForStartup;

    SSI_s32SetReceiverState( m_pvHandle, SSI_C_RECEIVE_READY);

  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
    return;
  }
  /*========================================================================*/

#endif
  /*==========================================================================
   * start Ping timer
   *------------------------------------------------------------------------*/
  s32RetVal = OSAL_s32TimerSetTime( m_hTimerPingTimer, (tU32) TUN_DRVADRIF_CONF_PING_TIMEOUT_MS, 0 );

  TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
  /*========================================================================*/

	ETG_TRACE_USR1((" tun_DrvAdrIf::vStartCommunication(): -> ADR communication established and Ping timer started." ));
}


/*****************************************************************************
 * 
 ****************************************************************************/
tVoid tun_DrvAdrIf::vStopCommunication( tVoid)
{
  ETG_TRACE_COMP((" tun_DrvAdrIf::vStopCommunication()"));

  if( m_enCommunicationState != enComState_Off)
  {
    /*========================================================================
     * close channel
     *----------------------------------------------------------------------*/
	  /**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR
	tS32 s32RetVal;
    s32RetVal = SSI_s32CloseChannel( &m_pvHandle);
    TUN_ASSERT_RETURN( s32RetVal == SSI_C_NO_ERROR);
#endif
		m_enCommunicationState = enComState_Off;
    /*======================================================================*/
  }

  pu8RxDataBuffer = OSAL_NULL;
  u32RxDataLength = 0;
  m_enADRState    = enADRState_Unknown;
}

/**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR
/*****************************************************************************
 * Call back function for SSI driver, it indicates the end of send message.
 ****************************************************************************/
tVoid tun_DrvAdrIf::SsiDataConfirmationCallbackFunction( tVoid *pvHandle, enSsiConfState enState)
{
  (tVoid)pvHandle;     /* unused paremeter */
  
  if( enState == SSI_C_CONF_FAULT)
  {
    ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_CONF _ ET_EN_T8 _ enState _ ET_EN_DONE);
    // assert !!!
  }
  else
  {
    ET_TRACE_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, TR_LEVEL_USER_2, ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_CONF _ ET_EN_T8 _ enState _ ET_EN_DONE);
  }

  /*------------------*/
  /* set event handle */
  /*------------------*/
  OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
  {
	  if(OSAL_s32EventPost( hRxSSI, EVENT_SPI_TX_READY, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
	  {
		  NORMAL_M_ASSERT_ALWAYS();
	  }
	
    (tVoid)OSAL_s32EventClose( hRxSSI);

     ETG_TRACE_USR2(( " tun_DrvAdrIf::SsiDataConfirmationCallbackFunction() -> EVENT_SPI_TX_READY Thread event posted" ));
   }
   else
   {
     ETG_TRACE_ERR(( " tun_DrvAdrIf::SsiDataConfirmationCallbackFunction() -> EVENT_SPI_RX_READY Post event fail" ));
   }
}

/*****************************************************************************
 * Call back function for SSI driver for incomming messages.
 ****************************************************************************/
tVoid tun_DrvAdrIf::SsiDataIndicationCallbackFunction( tVoid *pvHandle, tU8 *pu8Data, tU32 u32Length)
{
  (tVoid)pvHandle;     /* unused paremeter */

  pu8RxDataBuffer = pu8Data;
  u32RxDataLength = u32Length;
  
  //tU16 u16ClientID = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Data[ enAdrMsgOffset_CLIENT_ID]);
  
  tU16 u16FBBlockID;

  u16FBBlockID  = ( tU16 ) ( ( (tU16)  pu8Data[2]  ) << 8  ) ;
  u16FBBlockID |= ( tU16 ) (   (tU16)  pu8Data[3]  );
  
  ETG_TRACE_USR1(( " tun_DrvAdrIf::SsiDataIndicationCallbackFunction() -> u16FBBlockID=%x"
                  ,u16FBBlockID ));
 
  if(u16FBBlockID == enFBlockId_AmFmTuner)
  {
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
	  ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_RX_IND _ 
	  ET_EN_T32LIST _ u32Length _ pu8Data _ 
	  ET_EN_DONE);
  }
  else if(u16FBBlockID == enFBlockId_TMCTuner)
  {
	  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TMC_RX_IND _ ET_EN_T8LIST _ u32Length _ pu8Data _ ET_EN_DONE); 
  }
  else
  {
	  // do nothing
  }

  /*------------------*/
  /* set event handle */
  /*------------------*/
  OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
  {
	  if(OSAL_s32EventPost( hRxSSI, EVENT_SPI_RX_READY, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
	  {
		  NORMAL_M_ASSERT_ALWAYS();
	  }
    (tVoid)OSAL_s32EventClose( hRxSSI);

     ETG_TRACE_USR2(( " tun_DrvAdrIf::SsiDataIndicationCallbackFunction() -> EVENT_SPI_RX_READY Thread event posted" ));
   }
   else
   {
     ETG_TRACE_ERR(( " tun_DrvAdrIf::SsiDataIndicationCallbackFunction() -> EVENT_SPI_RX_READY Post event fail" ));
   }
}
#endif

/*****************************************************************************
 * Call back function for ADR control driver for.
 ****************************************************************************/
tVoid tun_DrvAdrIf::vCallBackADRState( tU32 u32State)
{
  ETG_TRACE_USR1(( " tun_DrvAdrIf::vCallBackADRState() -> u32State=%x"
                  ,ETG_ENUM( TUN_DRVADRIF_ADR3_STATE, u32State)
                ));
  tU32 u32SPMState=m_potunSPMClient->u32GetActualCoproState();
  ETG_TRACE_USR1(( " tun_DrvAdrIf::vCallBackADRState() -> SPMState=%d m_LowvoltState=%d",u32SPMState,m_potunSPMClient->m_LowvoltState));
  m_enADRState = (tun_tenADRState)u32State;

  /*------------------*/
  /* set event handle */
  /*------------------*/
  OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
  {
	  if(OSAL_s32EventPost( hRxSSI, EVENT_NEW_ADR_STATE, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
	  {
		  NORMAL_M_ASSERT_ALWAYS();
	  }
    (tVoid)OSAL_s32EventClose( hRxSSI);

    ETG_TRACE_USR2(( " tun_DrvAdrIf::vCallBackADRState() -> EVENT_NEW_ADR_STATE Thread event posted" ));
  }
  else
  {
     ETG_TRACE_ERR(( " tun_DrvAdrIf::vCallBackADRState() -> EVENT_NEW_ADR_STATE Post event fail" ));
  }

}


/*****************************************************************************
 * New ADR state.
 ****************************************************************************/
tVoid tun_DrvAdrIf::vNewADRState( tVoid)
{
	 if((NULL==m_potun_MsgToHMI)||(NULL==m_potunMain))
	 {
		return;
	 }
	/*Send Service Unavailability when ADR state is Dead. Will handle use case when some other module would reset ADR*/
	ETG_TRACE_USR1(( "vNewADRState() -> ADR3tate=%x"
        ,ETG_ENUM( TUN_DRVADRIF_ADR3_STATE, m_enADRState)));
    if(m_enADRState == enADRState_DEAD)
    {
    	ETG_TRACE_USR1(( " tun_DrvAdrIf::vNewADRState() -> ADR is dead"));
		//Clear the Communication lost counter and update the Communicationation state as WaitForStartup
		tS32 s32RetVal = OSAL_s32TimerSetTime( tun_DrvAdrIf::instance()->m_hTimerPingTimer, 0, 0 );
	   ETG_TRACE_USR1((" vNewADRState()->Ping timer is stopped"));	    		  
  	   TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
		m_u32CommunicationLostCounter = 0;
		m_u8PingCounter=0;
		m_enCommunicationState        = enComState_WaitForStartup;
		tun_MsgToADR::instance()->vSetAdrCommunication( FALSE);
		tun_MsgToADR::instance()->vClearMessageQueue();
		//Send service unavailability to clients
		if(m_potunMain->m_bTunerSrvStatus == true)
		{
			ETG_TRACE_USR1(("vNewADRState -> Send service unavailability"));
			m_potunMain->vTunerShutDownProcess();
		}
	    else
	    {
			ETG_TRACE_USR1(( "vNewADRState() -> Don't send service unavailability"));
	    }
		//Clear tuning state and seek state 
		m_potun_MsgToHMI->vClear_TunerStates(); 
  	}
	if(enADRState_ALIVE==m_enADRState)
	{
		//start Ping timer only on alive msg from SSI
		tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerPingTimer, (tU32) TUN_DRVADRIF_CONF_PING_TIMEOUT_MS, 0 );
		TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
	}
}
/*****************************************************************************
 * ADR supervision timer
 ****************************************************************************/
tVoid tun_DrvAdrIf::vPingTimerCallback( tVoid* pArg)
{
  (tVoid)pArg;    /* unused parameter */
  
  /*------------------*/
  /* set event handle */
  /*------------------*/
  OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
  {
	  if(OSAL_s32EventPost( hRxSSI, EVENT_PING_TIMER, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
	  {
		  NORMAL_M_ASSERT_ALWAYS();
	  }
    (tVoid)OSAL_s32EventClose( hRxSSI);

    ETG_TRACE_USR2(( " tun_DrvAdrIf::vPingTimerCallback() -> EVENT_PING_TIMER Thread event posted" ));
  }
  else
  {
     ETG_TRACE_ERR(( " tun_DrvAdrIf::vPingTimerCallback() -> EVENT_PING_TIMER Post event fail" ));
  }
}


/*****************************************************************************
 * handle ADR supervision timer
 ****************************************************************************/
tVoid tun_DrvAdrIf::vPingTimerExpired( tVoid)
{
  if( m_enCommunicationState != enComState_DiagnoseSession )      /* do nothing during diagnose session */
  {
		if(    ( m_u32CommunicationLostCounter > 0)
			&& ( m_enCommunicationState == enComState_Run)
		  )
		{
		  #if ( defined( LSIM) )
			/* in the LSim is the information ony importand for TUN developer, */
			/* because noboddy else will contact the ADR3 by USB cable to ADR3 */
			ETG_TRACE_USR1(( " tun_DrvAdrIf::vPingTimerCallback() -> Ping timer expired, m_u32CommunicationLostCounter=%d, m_enCommunicationState=%d"
							,m_u32CommunicationLostCounter
							,ETG_ENUM( TUN_DRVADRIF_COM_STATE, m_enCommunicationState)
						  ));
		  #else
			/* on comunication lost, trace alwais */
			ETG_TRACE_ERR(( " tun_DrvAdrIf::vPingTimerCallback() -> Ping timer expired, m_u32CommunicationLostCounter=%d, m_enCommunicationState=%d"
							,m_u32CommunicationLostCounter
							,ETG_ENUM( TUN_DRVADRIF_COM_STATE, m_enCommunicationState)
						  ));
		  #endif
		}
		else
		{
		  ETG_TRACE_USR1(( " tun_DrvAdrIf::vPingTimerCallback() -> Ping timer expired, m_u32CommunicationLostCounter=%d, m_enCommunicationState=%d"
						  ,m_u32CommunicationLostCounter
						  ,ETG_ENUM( TUN_DRVADRIF_COM_STATE, m_enCommunicationState)
						));
		}

    if( m_enCommunicationState != enComState_Off)
    {
    	if( m_u32CommunicationLostCounter < TUN_DRVADRIF_CONF_PING_COUNTER_FOR_ADR_RESET)
    	{
    		m_u32CommunicationLostCounter++;

    		if( m_enCommunicationState == enComState_Run)
    		{
    			m_u8PingCounter++;

				vPrintADRVersionAtDefinedPingCount();
				vPrintCurrentTunerStateUpdates();
				
			  /*====================================================================
			   * send Ping, the timer is restarted during send message
			   *------------------------------------------------------------------*/
			  trMsg_CM_Ping_SetGet oMsg_CM_Ping_SetGet( m_u8PingCounter);
			  tun_MsgToADR::instance()->vSend( &oMsg_CM_Ping_SetGet);
			  /*==================================================================*/
    		}
    		else
    		{
			  /*====================================================================
			   * restart Ping timer, send no Ping
			   *------------------------------------------------------------------*/
			  tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerPingTimer, (tU32) TUN_DRVADRIF_CONF_PING_TIMEOUT_MS, 0 );

			  TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
			  /*==================================================================*/
    		}
    	}
    	else
    	{
			/*======================================================================
			 * Reset the ADR
			 *--------------------------------------------------------------------*/
			 if(tun_MsgToADR::instance()->bGetResetADR())
			 {
					vResetAdr();
					/*Send service unavailabilty*/

					if(m_potunMain != NULL)
					{
						m_potunMain->vTunerShutDownProcess();
					}
			 }
			 else
			 {
				//don't reset ADR
			 }
        
			/*--------------------------------------------------------------------
			 * restart Ping timer but send no Ping
			 *------------------------------------------------------------------*/
			tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerPingTimer, (tU32) TUN_DRVADRIF_CONF_PING_TIMEOUT_MS, 0 );

			TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
			/*==================================================================*/
    	}
    }
  }
}

tVoid tun_DrvAdrIf::vPrintADRVersionAtDefinedPingCount()
{
	if(m_u8PingCounter % TUN_DRVADRIF_CONF_PING_COUNT_FOR_ADR_VERSION_PRINT == 0)
	{
		if(tun_MsgToADR::instance() != NULL)
		{
			tun_MsgToADR::instance()->vPrintADRVersionInformation();
		}
	}
}

tVoid tun_DrvAdrIf::vPrintCurrentTunerStateUpdates()
{
   if(m_u8PingCounter % TUN_DRVADRIF_CONF_PING_COUNT_FOR_ADR_VERSION_PRINT == 0)
   {
      if(m_potun_MsgToHMI != NULL)
      {
         m_potun_MsgToHMI->vGetCurrentStateUpdates();
      }
   }
}

/*****************************************************************************
 * Avoid ADR communication and Reset the ADR
 ****************************************************************************/
tVoid tun_DrvAdrIf::vResetAdr( tVoid)
{
  m_u32CommunicationLostCounter = 0;
  m_enCommunicationState        = enComState_WaitForStartup;
  tun_MsgToADR::instance()->vSetAdrCommunication( FALSE);
  if(m_poclConfigInterface->u32GetConfigData("SBR"))
  {
     if (m_potunSPMClient != NULL)
     {
        ETG_TRACE_ERRMEM(( "tun_DrvAdrIf::RestartSBR() ->CommState=%d,SBRState=%d PingCounter=%d CommLostCounter=%d",
                 ETG_CENUM(tun_tenComState,m_enCommunicationState),
                 ETG_CENUM(tun_tenADRState,m_enADRState),m_u8PingCounter,m_u32CommunicationLostCounter));
        m_potunSPMClient->vRestartSBRProcess();
#if defined  (VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC) || defined (VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI) || defined (VARIANT_S_FTR_ENABLE_FEATURE_INF4CV)
        vUpdateTunerDTC();
#endif
        return;
     }
  }
  else if( OSAL_ERROR != m_hAdr3CtrlDevice )
  {

     ETG_TRACE_ERRMEM(( "tun_DrvAdrIf::vResetAdr() ->CommState=%d,ADRState=%d PingCounter=%d CommLostCounter=%d",
              ETG_CENUM(tun_tenComState,m_enCommunicationState),
              ETG_CENUM(tun_tenADRState,m_enADRState),m_u8PingCounter,m_u32CommunicationLostCounter));
     tU32 u32ErrorCode = OSAL_s32IOControl( m_hAdr3CtrlDevice,
                                            OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3,
                                            (tS32) NULL );
#if defined  (VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC) || defined (VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI) || defined (VARIANT_S_FTR_ENABLE_FEATURE_INF4CV)
     vUpdateTunerDTC();
#endif
	if(OSAL_OK != u32ErrorCode)
	{
		NORMAL_M_ASSERT_ALWAYS();
	}
    

    /* inform the HMI, that the ADT is not availabel any more */
    //tun_MsgToHMI::instance()->vSend_G_Audio_Fg_Bg( TU_FOREGROUND, 0);

    #if ( defined( LSIM) )
      /* in the LSim is the information ony importand for TUN developer, */
      /* because noboddy else will contact the ADR3 by USB cable to ADR3 */
      ETG_TRACE_USR1(( " tun_DrvAdrIf::vResetAdr() -> ADR communication has lost: reset the ADR." ));
    #else
#ifndef GEN3X86
      //ETG_TRACE_ERRMEM(( " tun_DrvAdrIf::vPingTimerCallback() -> ADR communication has lost: reset the ADR." ));
       ETG_TRACE_FATAL(( " tun_DrvAdrIf::vResetAdr() -> ADR communication has lost.\n"
                        " ****************************************************************************************\n"
                        " * A D R    R E S E T\n"
                        " ****************************************************************************************"
                      ));
#else
      ETG_TRACE_ERR(( " tun_DrvAdrIf::vResetAdr() -> ADR communication has lost.\n"
                        " ****************************************************************************************\n"
                        " * A D R    R E S E T\n"
                        " ****************************************************************************************"
                      ));

#endif
    #endif
  }
}


/*****************************************************************************
 * 
 ****************************************************************************/
tU32 tun_DrvAdrIf::u32GetRxDataBuffer( tPU8* ppu8RxData)
{
	/** Check if queue is empty */
	if(!(m_ReceiverQueue.empty()))
	{
		/** Copy the first element in the queue */
		m_structPopMessage = m_ReceiverQueue.front();
		/** Remove first element from queue as the msg data will be processed*/
		m_ReceiverQueue.pop();

		ETG_TRACE_USR1(( " tun_DrvAdrIf::u32GetRxDataBuffer() Message length = %d bytes"
			,m_structPopMessage.u32GetDataLength()
			));

		//*ppu8RxData = pu8RxDataBuffer;
		/** Copy data from the element */
		*ppu8RxData = m_structPopMessage.up8GetDataPointer();
		return m_structPopMessage.u32GetDataLength();
	}
	else
	{
		/** No msgs in the queue */
		return 0;
	}
}

/*****************************************************************************
 * Check if receiver queue is empty
 ****************************************************************************/
/**check if the queue is empty else */
tBool tun_DrvAdrIf::bCheckIfQueueEmpty()const
{
	return (m_ReceiverQueue.empty());
}

/*****************************************************************************
 * 
 ****************************************************************************/
tVoid tun_DrvAdrIf::vFreeRxDataBuffer( tVoid)
{
  ETG_TRACE_USR1(( " tun_DrvAdrIf::vFreeRxDataBuffer() -> release Rx SSI buffer" ));

  u32RxDataLength = 0;
  //pu8RxDataBuffer = OSAL_NULL;


 /** free the memory allocated to array present in poped element of queue*/
  //vic5kor : changed to overcome memory leak
 //delete m_structPopMessage.up8GetDataPointer();
 tPU8 rxBuffer = m_structPopMessage.up8GetDataPointer();
 delete[] rxBuffer;
 m_structPopMessage.vSetDataPointer(OSAL_NULL);
 m_structPopMessage.vSetDataLength(0);

  /**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_SSI_COMMUNICATION_ENABLE
  tS32 s32ErrorCode = SSI_s32DataIndProcessed( m_pvHandle);
  TUN_ASSERT_RETURN( s32ErrorCode == SSI_C_NO_ERROR);
#endif

  m_u32CommunicationLostCounter = 0;  // a message is successfully received -> clear counter
  /**If this statement is rechead then the communication from ADR is happenening, check for the CommunicationState if it is 
  WaitForStartup then change it to RUN, so that we will establish the communication with ADR3 again.
  When this is made RUN then the PING Command will be sent and we start from the begining. Similar to receiving the startup message*/
  
  if(m_enCommunicationState == enComState_WaitForStartup)
  {
	ETG_TRACE_USR4(( " tun_DrvAdrIf::vFreeRxDataBuffer() : Start up msg missed, ADR is up and communication is established, Changing m_enCommunicationState = %d",ETG_CENUM( tun_tenComState, m_enCommunicationState)));

  	m_enCommunicationState = enComState_Run;
  }
  
  
}


/*****************************************************************************
 * Sends a message to the SSI interface
 ****************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
tVoid tun_INCComm::vCloseAdr3Communication()
{
	if(dgram!= 0)
	{
		if (dgram_exit(dgram) < 0)
		{
			tInt errsv = errno;
			ETG_TRACE_ERR(("AMFMADR3::dgram_exit failed with error:%d", errsv));
			ETG_TRACE_ERR(("AMFMADR3: dgram_exit failed and error msg : %s\n", strerror(errsv)));
		}
		else
		{
			dgram = NULL;
		}
	}
	if(m_nADRSocketFd > 0)
	{
		if (close(m_nADRSocketFd) < 0)
		{
			tInt errsv = errno;
			ETG_TRACE_ERR(("AMFMADR3::close adr socket failed with error:%d", errsv));
			ETG_TRACE_ERR(("AMFMADR3: close adr socket failed and error msg : %s\n", strerror(errsv)));
		}
		else
		{
			m_nADRSocketFd = -1;
		}
	}
	ETG_TRACE_USR4(("Successfully closed"));
}
#endif
tVoid tun_DrvAdrIf::vSendMessage( tU8* pu8TxMessage, tU32 u32StreamMsgLen )
{
	if ((pu8TxMessage != NULL) && (u32StreamMsgLen != 0) && (m_potunMain != NULL))
  {
    ETG_TRACE_USR4(( " tun_DrvAdrIf::vSendMessage() ->\n"
                     " u32StreamMsgLen : %d bytes\n"
                     " payload         : %d bytes\n"
                    ,u32StreamMsgLen
                    ,TUN_DRVADRIF_GET_U16( &pu8TxMessage[ enAdrMsgOffset_DATA_LEN])
                  ));
    
    //tU16 u16ClientID = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8TxMessage[ enAdrMsgOffset_CLIENT_ID]);
    
    tU16 u16ClientID;

    u16ClientID  = ( tU16 ) ( ( (tU16)  pu8TxMessage[0]  ) << 8  ) ;
    u16ClientID = ( tU16 ) (u16ClientID |( (   (tU16)  pu8TxMessage[1]  )));
    
    if(u16ClientID == (tU16)enClientId_AmFmTuner)
	{
		/*if(u32StreamMsgLen <= NO_OF_BYTES_PER_LINE)
		{
			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_REQ _ 
				ET_EN_T8 _ (0xff) _ 
				ET_EN_T8LIST _ u32StreamMsgLen _ pu8TxMessage _ 
				ET_EN_DONE); 
		}
		else
		{
			tU8 u8ByteCnt = 0;
			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_REQ _ 
				ET_EN_T8 _ (u8ByteCnt) _ 
				ET_EN_T8LIST _ u32StreamMsgLen _ pu8TxMessage _ 
				ET_EN_DONE);
			for(; u8ByteCnt < (u32StreamMsgLen/NO_OF_BYTES_PER_LINE); u8ByteCnt++)
			{
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
					ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_REQ _ 
					ET_EN_T8 _ (u8ByteCnt+1) _ 
					ET_EN_T8LIST _ (NO_OF_BYTES_PER_LINE) _ (pu8TxMessage+(u8ByteCnt*NO_OF_BYTES_PER_LINE)) _ 
					ET_EN_DONE);
			}
			if(u32StreamMsgLen % NO_OF_BYTES_PER_LINE)
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_REQ _ 
				ET_EN_T8 _ (u8ByteCnt+1) _ 
				ET_EN_T8LIST _ (u32StreamMsgLen % NO_OF_BYTES_PER_LINE) _ (pu8TxMessage+(u8ByteCnt*NO_OF_BYTES_PER_LINE)) _ 
				ET_EN_DONE);
		}*/
		 vPrintTrace(u32StreamMsgLen,pu8TxMessage,TUN_TRACE_ADRIF_LOW_TX_REQ);
		//vPrintTrace(pu8TxMessage, u32StreamMsgLen, 0 );
    }
    else if(u16ClientID == (tU16)enClientId_TMCTuner)
    {
        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TX_TMC_REQ _ ET_EN_T8LIST _ u32StreamMsgLen _ pu8TxMessage _ ET_EN_DONE);	
    }
    else
    {
    	// do nothing
    }


    
    /*======================================================================
     * wrong message length !!!  (10 bytes + payload)
     *--------------------------------------------------------------------*/
	if(u32StreamMsgLen != ((tU32)enAdrMsgOffset_HEADER_LEN + TUN_DRVADRIF_GET_U16( &pu8TxMessage[ enAdrMsgOffset_DATA_LEN])))
	{
		NORMAL_M_ASSERT_ALWAYS();
	}
	if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
		if(m_potunMain->poDBus())
		 {
  			tU8 u8LunId = LUNID; 
  			m_potunMain->poDBus()->vPostMessage(u8LunId, pu8TxMessage, (tU32)u32StreamMsgLen);
			INCDataConfirmation();
		 }
#endif
	}
	else
	{
    /*====================================================================*/
/**Ngp1kor: Currently commented for migration to G3 Platform.*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR

    tS32 s32RetVal = SSI_s32DataReq( m_pvHandle, pu8TxMessage,  u32StreamMsgLen);

#if ( defined( LSIM) )  // there is currently a bug in LSim: it comes always an error.
    if( s32RetVal != SSI_C_NO_ERROR)
    {
      ETG_TRACE_COMP(( " tun_DrvAdrIf::vSendMessage() -> in LSim responsed SSI_s32DataReq() always SSI_C_GENERAL_ERROR" ));
    }
#else
    ETG_TRACE_COMP(( " tun_DrvAdrIf::vSendMessage() -> SSI_s32DataReq() responded with SSI_C_NO_ERROR" ));
#endif
#elif VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI

		if(dgram!= 0)
		{
		ssize_t iNumberOfBytes =0;
		iNumberOfBytes = dgram_send(dgram,\
			pu8TxMessage,\
			u32StreamMsgLen);
		ET_TRACE_INFO_BIN( 
			TUN_TRACE_CLASS_DRVADRIF_LOW, 
			ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_WRITE_STATUS _ 
			ET_EN_T32 _ u32StreamMsgLen _ 
			ET_EN_T32 _ iNumberOfBytes _
			ET_EN_DONE);
		if(iNumberOfBytes == u32StreamMsgLen )
		{
			m_u8Dgram_SendFailurCount=0;
			INCDataConfirmation();
		}
		else
		{
			tS32 s32ErrorNumber = errno;
			ETG_TRACE_ERR(("AMFMADR3: dgram_send failed with error msg : %s\n", strerror(s32ErrorNumber)));
			ETG_TRACE_ERR(("AMFMADR3: dgram_send failed with error no : %d", s32ErrorNumber));
			ETG_TRACE_ERR(("AMFMADR3: dgram_send failed count : %d", m_u8Dgram_SendFailurCount));
			m_u8Dgram_SendFailurCount++;
			if(m_u8Dgram_SendFailurCount<4)
			{
				m_potunMain->vSetRestartTimeValue(enDgramSendError);
			}
			else
			{
				m_potunMain->m_potun_tclINCComm->vCloseAdr3Communication();
				m_potunMain->vSetRestartTimeValue(enSocketOrPollFailure);
				m_u8Dgram_SendFailurCount=0;
				}
			}
		}
#endif
    /*======================================================================
     * restart Ping timer
     *--------------------------------------------------------------------*/
	}
	if(OSAL_s32TimerSetTime( m_hTimerPingTimer, (tU32) TUN_DRVADRIF_CONF_PING_TIMEOUT_MS, 0 )!= OSAL_OK)
	{
		NORMAL_M_ASSERT_ALWAYS();
	}
	
    /*====================================================================*/
  }
}


/*****************************************************************************
 * Incomming message from TTFis
 ****************************************************************************/
tVoid tun_DrvAdrIf::vTraceCommand( tPU8 pu8Msg, tU32 u32Len )
{
  (tVoid)u32Len;    /* unused parameter */

  switch( pu8Msg[0])
  {
    /*----------------------------------------------------------------------*/

    case TUN_TRACE_TUN_DRVADRIF_GET_INFO:
      {
        ETG_TRACE_FATAL(( " tun_DrvAdrIf::vTraceCommand() -> TTFis command: DRVADRIF_GET_INFO.\n"
                          "=> m_enADRState                  : %02x\n"
                          "=> m_enCommunicationState        : %02x\n"
                          "=> m_u32CommunicationLostCounter : %u\n"
                          "=> m_u8PingCounter               : %u\n"
                         ,ETG_ENUM( TUN_DRVADRIF_ADR3_STATE,        m_enADRState)
                         ,ETG_ENUM( TUN_DRVADRIF_COM_STATE,         m_enCommunicationState)
                         ,m_u32CommunicationLostCounter
                         ,m_u8PingCounter
                       ));
      }
      break;

    /*----------------------------------------------------------------------*/

    case TUN_TRACE_TUN_DRVADRIF_RESET_ADR:
      {
        ETG_TRACE_FATAL(( " tun_DrvAdrIf::vTraceCommand() -> TTFis command: TUN_TRACE_TUN_DRVADRIF_RESET_ADR.\n"
                       ));
        vResetAdr();
      }
      break;

    /*----------------------------------------------------------------------*/

    default:
      ETG_TRACE_FATAL(( " tun_DrvAdrIf::vTraceCommand() -> Error: unknown command."
                     ));
      break;

    /*----------------------------------------------------------------------*/
  }
}


/*****************************************************************************
 * Incomming message CM_Startus from ADR
 ****************************************************************************/
tVoid tun_DrvAdrIf::vMessage( trMsg_CM_Startup_Status* prMsg)
{
	( tVoid)prMsg;   // unused parameter
	if(m_poclConfigInterface == nullptr)
	{
		return;
	}

	if( m_enCommunicationState == enComState_WaitForStartup)
	{
		ETG_TRACE_COMP(( " tun_DrvAdrIf::vMessage( trMsg_CM_Startup_Status) -> ADR communication established." ));

		/* send the first message from Queue */
		tun_MsgToADR::instance()->vSetAdrCommunication( TRUE);
	}
	else if( m_enCommunicationState == enComState_DiagnoseSession)
	{
		ETG_TRACE_COMP(( "   tun_DrvAdrIf::vMessage( trMsg_CM_Startup_Status) -> ADR reset after diagnose session detected, ADR communication is established again.\n"
				" ****************************************************************************************\n"
				" * E N D        ADR diagnose session.\n"
				" ****************************************************************************************"
		));
	}
	else
	{
		ETG_TRACE_ERR(( " tun_DrvAdrIf::vMessage( trMsg_CM_Startup_Status) -> ADR has been spontaniously reset." ));
	}

	m_enCommunicationState = enComState_Run;

	/*==========================================================================
	 * start Ping timer
	 *------------------------------------------------------------------------*/
	tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerPingTimer, (tU32) TUN_DRVADRIF_CONF_PING_TIMEOUT_MS, 0 );

	TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
	/*========================================================================*/
#if defined  (VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC) || defined (VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI) || defined (VARIANT_S_FTR_ENABLE_FEATURE_INF4CV)
	if((NULL!=m_potun_DiaglogHandler) && (m_blClearSystemFailureErrorLog))
	{
		m_potun_DiaglogHandler->vUpdateTunerSystemFailureErrorLog(FALSE);
		m_blClearSystemFailureErrorLog =FALSE;
	}

#endif
}
/*****************************************************************************
 * Incomming message CM_Ping from ADR
 ****************************************************************************/
tVoid tun_DrvAdrIf::vHandle_r_Ping(  const tU8* pu8Message, tU32 u32MessageLen)
{
  (tVoid)u32MessageLen;   /* unused parameter */

  if( pu8Message[ enAdrMsgOffset_OP_TYPE] == (tU8)enOpType_ERROR)
  {

    if(    ( m_enCommunicationState != enComState_DiagnoseSession)
/* when the ADR3 diagose is properly defined, comes here a special error code for 'diagnose session active' */
//        && ( pu8Message[ enErrorCodes_idx_ErrorCode] == )
      )
    {
      /*======================================================================
       * ADR3 diagnose session is active
       *--------------------------------------------------------------------*/
      ETG_TRACE_COMP(( "  tun_DrvAdrIf::vHandle_r_Ping() ->\n"
                       " ****************************************************************************************\n"
                       " * B E G I N    ADR diagnose session.\n"
                       " ****************************************************************************************"
                     ));
      m_enCommunicationState = enComState_DiagnoseSession;
      tun_MsgToADR::instance()->vSetAdrCommunication( FALSE);
      /*====================================================================*/

      /*====================================================================
       * stop Ping timer
       *------------------------------------------------------------------*/
      tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerPingTimer, 0, 0 );

      TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
      /*==================================================================*/
    }
  }
}

/**vnd4kor : to solve prio 2 warning*/
tVoid tun_DrvAdrIf::vSet_tunMain_Ptr(tuner_tclApp* ptunMain) const
{
	m_potunMain = ptunMain;
}

tVoid tun_DrvAdrIf::vSet_tun_tclSPMClient_Ptr(tun_tclSPMClient* ptunSPMClient)const
{
	m_potunSPMClient = ptunSPMClient;
}
tVoid tun_DrvAdrIf::vSet_tun_MsgToHMI_Ptr(tun_MsgToHMI* ptun_MsgToHMI) const
{
	m_potun_MsgToHMI = ptun_MsgToHMI;
}
tVoid tun_DrvAdrIf::vSet_tun_DiaglogHandler_Ptr(tun_DiaglogHandler* potun_DiaglogHandler)const
{
	m_potun_DiaglogHandler =potun_DiaglogHandler;
}
tVoid tun_DrvAdrIf::vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface )
{
  if( poclConfigInterface != NULL )
  {
	  m_poclConfigInterface = poclConfigInterface;
  }

}

tun_tenADRState tun_DrvAdrIf::enGetADRState()const
{
	return m_enADRState;
}


tVoid tun_DrvAdrIf::vSetADRCommnState(tun_tenComState enComState)
{
	m_enCommunicationState = enComState;
}

#if defined VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI || defined  VARIANT_S_FTR_ENABLE_AARSPROXY
/*******************************************************************************
* FUNCTION : INCDataIndication
*
* DESCRIPTION : posts event EVENT_INC_RX_READY to indicate incoming data
*
* PARAMETER : tU8 *pu8Data, tU32 u32Length
*
* RETURNVALUE : bool
*
* HISTORY : 16.04.2013
* Initial version
*********************************************************************************/
tVoid tun_DrvAdrIf::INCDataIndication(tU8 *pu8Data, tU32 u32Length)
{
	(tVoid)OSAL_s32SemaphoreWait(m_hMsgDrvAdrIfSem, OSAL_C_U32_INFINITE);
	
	u8CopyRxDataBuffer = new tU8[BUFFER_SIZE];

	for(tU32 i= 0; i < u32Length; i++)
	{
		u8CopyRxDataBuffer[i] = pu8Data[i];
	}


	/** push the message pointer to the Queue.*/
	rxDataFromAdr StructVariableDatafromADR;

	/** Set data pointer of queue element to incomming Data from ADR*/
	StructVariableDatafromADR.vSetDataPointer(u8CopyRxDataBuffer);
	/** Set size of data received */
	StructVariableDatafromADR.vSetDataLength(u32Length);
	/** Push element in queue */
	m_ReceiverQueue.push(StructVariableDatafromADR);

	if(m_ReceiverQueue.size() > 50 )
	{
		ETG_TRACE_COMP(( " tun_DrvAdrIf::INCDataIndication() -> Queue size crossed 50" ));
	}
	else if (m_ReceiverQueue.size() > 100 )
	{
		ETG_TRACE_ERR(( " tun_DrvAdrIf::INCDataIndication() -> Queue size crossed 100" ));
	}
	//pu8RxDataBuffer = pu8Data;

	//u32RxDataLength = u32Length;

	tU16 u16ClientID;

	u16ClientID  = ( tU16 ) ( ( (tU16)  pu8Data[0]  ) << 8  ) ;
	u16ClientID  =   (tU16) ( pu8Data[1] | u16ClientID);

	ETG_TRACE_COMP(( " tun_DrvAdrIf::INCDataIndication() -> u16ClientID=%d"
		,u16ClientID ));

	if(u16ClientID == (tU16)enClientId_AmFmTuner)
	{
	/*	if(u32Length <= NO_OF_BYTES_PER_LINE)
		{
			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_RX_IND _ 
				ET_EN_T8 _ (0xff) _ 
				ET_EN_T8LIST _ u32Length _ pu8Data _ 
				ET_EN_DONE);
		}
		else
		{
			tU8 u8ByteCnt = 0;
			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_RX_IND _ 
				ET_EN_T8 _ (u8ByteCnt) _ 
				ET_EN_T8LIST _ u32Length _ pu8Data _ 
				ET_EN_DONE);
			for(; u8ByteCnt < (u32Length/NO_OF_BYTES_PER_LINE); u8ByteCnt++)
			{
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
					ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_RX_IND _ 
					ET_EN_T8 _ (u8ByteCnt+1) _ 
					ET_EN_T8LIST _ (NO_OF_BYTES_PER_LINE) _ (pu8Data+(u8ByteCnt*NO_OF_BYTES_PER_LINE)) _ 
					ET_EN_DONE);
			}
			if(u32Length % NO_OF_BYTES_PER_LINE)
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_RX_IND _ 
				ET_EN_T8 _ (u8ByteCnt+1) _ 
				ET_EN_T8LIST _ (u32Length % NO_OF_BYTES_PER_LINE) _ (pu8Data+(u8ByteCnt*NO_OF_BYTES_PER_LINE)) _ 
				ET_EN_DONE);
		}*/
     	vPrintTrace(u32Length,pu8Data,TUN_TRACE_ADRIF_LOW_RX_IND);

		//vPrintTrace(pu8Data, u32Length, 1);
	}
	else if(u16ClientID == (tU16)enClientId_TMCTuner)
	{
		ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_TMC_RX_IND _ ET_EN_T8LIST _ u32Length _ pu8Data _ ET_EN_DONE); 
	}
	else
	{
		// do nothing
	}

	/*------------------*/
	/* set event handle */
	/*------------------*/
	OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

	if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
	{
		if(OSAL_s32EventPost( hRxSSI, EVENT_INC_RX_READY, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
		{
			NORMAL_M_ASSERT_ALWAYS();
		}
		(tVoid)OSAL_s32EventClose( hRxSSI);

		ETG_TRACE_COMP(( " tun_DrvAdrIf::INCDataIndication() -> EVENT_INC_RX_READY Thread event posted" ));
	}
	else
	{
		ETG_TRACE_COMP(( " tun_DrvAdrIf::INCDataIndication() -> EVENT_INC_RX_READY Post event fail" ));
	}

	(tVoid)OSAL_s32SemaphorePost(m_hMsgDrvAdrIfSem );

}
/*******************************************************************************
* FUNCTION : INCDataConfirmation
*
* DESCRIPTION : posts event EVENT_INC_TX_READY to indicate message is 
*				sent to INC
*
* PARAMETER : 
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013
* Initial version
*********************************************************************************/
tVoid tun_DrvAdrIf::INCDataConfirmation() const
{
	/*------------------*/
	/* set event handle */
	/*------------------*/
	OSAL_tEventHandle hRxINC = OSAL_C_INVALID_HANDLE;

	if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxINC) == OSAL_OK)
	{
		if(OSAL_s32EventPost( hRxINC, EVENT_INC_TX_READY, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
		{
			NORMAL_M_ASSERT_ALWAYS();
		}
		(tVoid)OSAL_s32EventClose( hRxINC);

		ETG_TRACE_COMP(( " tun_DrvAdrIf::INCDataConfirmation() -> EVENT_INC_TX_READY Thread event posted" ));
	}
	else
	{
		ETG_TRACE_COMP(( " tun_DrvAdrIf::INCDataConfirmation() -> EVENT_INC_RX_READY Post event fail" ));
	}
}
#endif
tun_tenComState tun_DrvAdrIf::vGetADRCommnState()const
{
	return m_enCommunicationState;
}

/*tVoid vSetPingTimer(OSAL_tTimerHandle  PingTimer)
{
	 m_hTimerPingTimer = PingTimer;
}*/

/*****************************************************************************
 *
 *  #   # ### #   #  ### ### #   #
 *  #   #  #  ##  # #     #  #   #
 *  #   #  #  # # # #     #  ## ##
 *  #   #  #  # # #  ##   #  # # #
 *  # # #  #  #  ##    #  #  #   #
 *  # # #  #  #  ##    #  #  #   #
 *   # #  ### #   # ###  ### #   #
 *
 * used for Osal Bench only
 ****************************************************************************/

#if (OSAL_CONF == OSAL_WINNT)


#define TUN_SSIADAPTER_SEM_NAME "SSIADAPTER_RX_SEM"

static OSAL_tIODescriptor     m_hDeviceAdrAmFmTuner = OSAL_ERROR;
static ssi_tChannelConfig     m_rChannelConfig;
static OSAL_tSemHandle        m_hRxSemaphore = OSAL_C_INVALID_HANDLE;
static tU8                    m_aubRxBuffer[ TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_RX_BUFFER_SIZE];



/****************************************************************************/
/*****************************************************************************
 * 
 ****************************************************************************/
tS32 SSI_s32DataIndProcessed( void *pvHandle)
{
  //tS32 s32RetVal = SSI_C_NO_ERROR;
	tS32 s32RetVal = 0;
  
  (tVoid)OSAL_s32SemaphorePost( m_hRxSemaphore);

  return s32RetVal;
}
/*****************************************************************************
 * 
 ****************************************************************************/


/*****************************************************************************
 * 
 ****************************************************************************/
tVoid vCallbackDataInd( tVoid)
{
  tU32 u32Length;

  u32Length = OSAL_s32IORead( m_hDeviceAdrAmFmTuner, (tPS8)m_aubRxBuffer, (tU32)TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_RX_BUFFER_SIZE );

  if( u32Length > 0)
  {
    m_rChannelConfig.pvfnCallbackDataInd( &m_hDeviceAdrAmFmTuner, m_aubRxBuffer, u32Length);

    // wait until buffer has been read. Then allow the next indication.
    (tVoid)OSAL_s32SemaphoreWait( m_hRxSemaphore, OSAL_C_U32_INFINITE );
  }
}


/*****************************************************************************
 * 
 ****************************************************************************/
tS32 SSI_s32OpenChannel( void **pvHandle, ssi_tChannelConfig *prChannelConfig)
{
  tS32 s32RetVal = SSI_C_GENERAL_ERROR;

   /* ---
   create semaphore for protecting NotificationTable
   --- */
   (tVoid)OSAL_s32SemaphoreCreate(TUN_SSIADAPTER_SEM_NAME, &m_hRxSemaphore, 0);


  // Open device
  if( m_hDeviceAdrAmFmTuner == OSAL_ERROR)
  {
    m_hDeviceAdrAmFmTuner = OSAL_IOOpen( TUN_DRVADRIF_CONF_DEVICE_AMFM_TUNER, OSAL_EN_READWRITE);
  }
  
  if( m_hDeviceAdrAmFmTuner != OSAL_ERROR)
  {
    OSAL_pvMemoryCopy( &m_rChannelConfig, prChannelConfig, sizeof( m_rChannelConfig));
    
    //after the device has been opend use IOControl to hand over call back pointer. 
    OSAL_s32IOControl( m_hDeviceAdrAmFmTuner, OSAL_C_S32_IOCTRL_CALLBACK_REG, (tS32)vCallbackDataInd);
    *pvHandle = &m_hDeviceAdrAmFmTuner;

    s32RetVal = SSI_C_NO_ERROR;
  }

  return s32RetVal;
}



/*****************************************************************************
 * 
 ****************************************************************************/
tS32 SSI_s32CloseChannel( void **pvHandle)
{
  tS32 s32RetVal = SSI_C_GENERAL_ERROR;


   (tVoid)OSAL_s32SemaphoreClose( m_hRxSemaphore );   
   (tVoid)OSAL_s32SemaphoreDelete( TUN_SSIADAPTER_SEM_NAME);
   m_hRxSemaphore = OSAL_C_INVALID_HANDLE;


  if( *pvHandle == &m_hDeviceAdrAmFmTuner)
  {
    // close device
    if( m_hDeviceAdrAmFmTuner != OSAL_ERROR)
    {
      OSAL_s32IOClose( m_hDeviceAdrAmFmTuner);
      m_hDeviceAdrAmFmTuner = OSAL_ERROR;
      *pvHandle = 0;
      s32RetVal = SSI_C_NO_ERROR;
    }
  }
  return s32RetVal;
}


/*****************************************************************************
 * 
 ****************************************************************************/
tS32 SSI_s32DataReq( void *pvHandle, tU8 *pu8Data, tU32 u32Length)
{
  tS32 s32RetVal = SSI_C_GENERAL_ERROR;

  if( m_hDeviceAdrAmFmTuner != OSAL_ERROR)
  {
    ( tVoid)OSAL_s32IOWrite( m_hDeviceAdrAmFmTuner, (tPCS8)pu8Data, u32Length);

    m_rChannelConfig.pvfnCallbackDataCon( &m_hDeviceAdrAmFmTuner, SSI_C_CONF_OKAY);

    s32RetVal = SSI_C_NO_ERROR;
  }
  
  return s32RetVal;
} 
#endif /* #if (OSAL_CONF == OSAL_WINNT) */


tVoid tun_DrvAdrIf::vSetCommunicationState(tun_tenComState enCommunicationState)
{
	m_enCommunicationState = enCommunicationState;
}

#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI

/*******************************************************************************
* FUNCTION : tun_INCComm
*
* DESCRIPTION : constructor creates the INC communication channel with the
*			INC Socket which interacts with the ADR3 or V850.
*
* PARAMETER : 
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013 NGP1kor
* Initial version
*********************************************************************************/
tun_INCComm::tun_INCComm()
{
	_hRxThreadId = OSAL_ERROR;
}
/*******************************************************************************
* FUNCTION : ~tun_INCComm
*
* DESCRIPTION : destructor, kills the thread created for receiving the messages from the 
				ADR3 via INC Sopcket and close the SOCKET..
*
* PARAMETER : 
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013 NGP1kor
* Initial version
*********************************************************************************/
tun_INCComm::~tun_INCComm()
{
	/**Closes the socket at the time of Shutdown.*/
	if (close(m_nADRSocketFd) < 0)
	{
		int errsv = errno;
		ETG_TRACE_ERR(("AMFMADR3::close adr socket failed with error:%d", errsv));
		ETG_TRACE_ERR(("AMFMADR3: close adr socket failed and error msg : %s\n", strerror(errsv)));
	}
	m_nADRSocketFd = -1;
	/**deleting the thread at the time of Shutdown.*/
	OSAL_s32ThreadDelete(_hRxThreadId);
	/**to remove the lint warnings..*/
}
/*******************************************************************************
* FUNCTION : vGetThreadPrioandStacksize
*
* DESCRIPTION : gets the Thread Prio and Stack size from the registry.
*
* PARAMETER : (tU32 &u32ThreadPrio,tU32 &u32StackSize)
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013 NGP1kor
* Initial version
*********************************************************************************/
tVoid tun_INCComm::vGetThreadPrioandStacksize(tU32 &u32ThreadPrio,tU32 &u32StackSize) const
{
	
    // Read thread priority from registry
    if ( FALSE == scd_bGetAppConfigurationValue 
                                      ( 
                                         // CCA App ID
                                         CCA_C_U16_APP_TUNER,

                                         // Registry path
                                         TUN_REGPATH_THREAD,

                                         // Registry entry for thread priority
                                         TUN_REGVALUE_TMCTHREAD_PRIO_NAME,

                                         // Read priority value
                                         &u32ThreadPrio 
                                       ) 
          )
    {
      // Assign default value.
      u32ThreadPrio = TUN_WAITINGTHREAD_DEFAULT_PRIO;
    
      // Indicate that the thread is running on default priority
      ETG_TRACE_ERR(( " tun_RUIF_WaitingThread::bThreadSetup() ->  the thread is running on default priority (=%d)."
                      ,u32ThreadPrio
                    ));
    }
    else
    {
      ETG_TRACE_USR1(( " tun_RUIF_WaitingThread::bThreadSetup() ->  the thread is running on Registry priority=%d."
                      ,u32ThreadPrio
                    ));
    }


    // Read thread stack size from registry
  if ( FALSE == scd_bGetAppConfigurationValue 
                                    ( 
                                       // CCA App ID
                                       CCA_C_U16_APP_TUNER,

                                       // Registry path
                                       TUN_REGPATH_THREAD,

                                       // Registry entry for stack size
                                       TUN_REGVALUE_TMCTHREAD_STACK_SIZE_NAME,

                                       // Read stack size value
                                       &u32StackSize 
                                     )
     )
  {
    u32StackSize  = TUN_WAITINGTHREAD_DEFAULT_STACKSIZE;

    // Indicate that the thread is running on default priority
    ETG_TRACE_ERR(( " tun_RUIF_WaitingThread::bThreadSetup() ->  the thread is running with default stack size (=%d)."
                    ,u32StackSize
                  ));
  }
  else
  {
    ETG_TRACE_USR1(( " tun_RUIF_WaitingThread::bThreadSetup() ->  the thread is running with Registry stack size =%d."
                    ,u32StackSize
                  ));
  }
}
/*******************************************************************************
* FUNCTION : vOpenINCCommunication
*
* DESCRIPTION : Open the SOCKET and creates the Receiving thread for POLLING on INC socket.
*
* PARAMETER : 
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013 NGP1kor
* Initial version
*********************************************************************************/
tVoid tun_INCComm::vSet_tuner_tclApp(tuner_tclApp* potunMain)
{
	m_potunMain=potunMain;
}
tVoid tun_INCComm::vOpenINCCommunication()
{
	tBool bSuccess = false;
		bSuccess = bOpenADRSocket((uint8_t)AF_BOSCH_INC_ADR,\
			(uint16_t)SOCK_STREAM,\
			(int)LUNID);
		if(bSuccess == true)
		{
			vRxThreadSetup();
		}
		else
		{
			tS32 s32ErrorNumber = errno;
			ETG_TRACE_COMP(( " tun_DrvAdrIf::vOpenINCCommunication() -> Error number : %d, Error Message : %s ", s32ErrorNumber, strerror(s32ErrorNumber)));
		m_potunMain->vSetRestartTimeValue(enSocketOrPollFailure);

	}
}
/*******************************************************************************
* FUNCTION : vRxThreadSetup
*
* DESCRIPTION : Creats the Receving Thread called TUN_RX and waits for the Messages from ADR3.
*
* PARAMETER : 
*
* RETURNVALUE : tVoid
*
* HISTORY : 16.04.2013 NGP1kor
* Initial version
*********************************************************************************/
tVoid tun_INCComm::vRxThreadSetup()
{
	OSAL_trThreadAttribute  rAttr;
    tC8                     szThreadName[OSAL_C_U32_MAX_NAMELENGTH] = "\0";

    // Note:Maximum size of thread name limited to 8
    OSAL_szStringCopy( szThreadName, "TUN_RX");
	// to remove lint warning.

	
	// Local variables to store data read from registry
    tU32 u32ThreadPrio = 0;
    tU32 u32StackSize  = 0;     

	vGetThreadPrioandStacksize(u32ThreadPrio, u32StackSize);

	ET_TRACE_INFO_BIN( 
		TUN_TRACE_CLASS_DRVADRIF_LOW, 
		ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_THREAD_DETAILS _ 
		ET_EN_T32 _ u32ThreadPrio _ 
		ET_EN_T32 _ u32StackSize _ 
		ET_EN_DONE);

   // Initialize thread parameters
    rAttr.szName       = szThreadName;
    rAttr.s32StackSize = (tS32)u32StackSize; 
    rAttr.u32Priority  = u32ThreadPrio; 
	rAttr.pfEntry      = (OSAL_tpfThreadEntry)&tun_INCComm::vWaitForADRMessage;
    rAttr.pvArg        = (tPVoid)dgram;

	_hRxThreadId = OSAL_ThreadSpawn(&rAttr);
	//_hRxThreadId = OSAL_ThreadCreate(&rAttr);

	tS32 ThreadActive = 0;//OSAL_s32ThreadActivate(_hRxThreadId);

	if ( _hRxThreadId == OSAL_ERROR )
      {
         tS32 s32OsalError = (tS32)OSAL_u32ErrorCode(  );
        ETG_TRACE_COMP(( " tun_DrvAdrIf::vWaitForADRMessage() -> Thread spawn failed errorcode=%x"
                        ,s32OsalError
                      ));

		//ETG_TRACE_COMP(( " tun_DrvAdrIf::THREAD not Created \n"));
				ET_TRACE_INFO_BIN( 
		TUN_TRACE_CLASS_DRVADRIF_LOW, 
		ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_THREAD_NOTCREATED _ 
		ET_EN_T32 _ s32OsalError _ 
		ET_EN_T32 _ ThreadActive _ 
		ET_EN_DONE);

      }
    else
    {
        //ETG_TRACE_COMP(( " tun_DrvAdrIf::vWaitForADRMessage() -> Thread creation successful."));
				ET_TRACE_INFO_BIN( 
		TUN_TRACE_CLASS_DRVADRIF_LOW, 
		ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_THREAD_CREATED _ 
		ET_EN_T32 _ _hRxThreadId _
		ET_EN_T32 _ ThreadActive _
		ET_EN_DONE);
    }
}

/*************************************************************************************
* FUNCTION : vWaitForADRMessage
*
* DESCRIPTION : this is a blocking call which waits for a Message from ADR INC socket
*
* PARAMETER : pvArg
*
* RETURNVALUE : void
*
* HISTORY : 16.04.2013
* Initial version
***************************************************************************************/
tVoid tun_INCComm::vWaitForADRMessage(tVoid* dgram1)
{

    sk_dgram* pdgram = (static_cast<sk_dgram*>(dgram1));

    int pfd = pdgram->sk;

	/** Field to hold the return value of POLL() */
	int rc = -1;

	/* The set of file descriptors to be monitored is specified in the fds argument **/
	struct pollfd fds[1];

	/** The field fd contains a file descriptor for an open file */
	fds[0].fd = pfd;

	/* The field events is an input parameter, a bit mask specifying the 
	events the application is interested in for the file descriptor fd.
	POLLIN  =  There is data to read from file descriptor */
	fds[0].events = POLLIN; 
	
	/* The timeout argument specifies the minimum number of milliseconds 
	that poll() will block.
	Specifying a timeout of zero causes poll() to return immediately, 
	even if no file descriptors are ready.*/
	int timeout = 200;

	ETG_TRACE_COMP(( " tun_INCComm::vWaitForADRMessage \n"));

	ET_TRACE_INFO_BIN( 
		TUN_TRACE_CLASS_DRVADRIF_LOW, 
		ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_THREAD_ENTRY _ 
		ET_EN_DONE);

	/** Buffer to hold the data received from dgram */
	tU8 au8RecvBuffer[BUFFER_SIZE];
	/** Initialise Buffer to all 0 */
	memset(au8RecvBuffer,0, BUFFER_SIZE);
	tSize iNumberOfBytesReceived =0;

	tBool bTerminate = false;
	/**Polling on the INC Socket for ever to receive the messages from ADR3.*/
	while (bTerminate == FALSE)
	{
		/**  Poll waits for one of a set of file descriptors to become ready to 
		perform I/O.*/
		rc = poll(fds, 1, timeout);
		if(rc < 0)
		{
			/** Polling Error */
			tInt errsv = errno;
			ETG_TRACE_ERR(("AMFMADR3: poll failed with error msg : %s\n", strerror(errsv)));
			ETG_TRACE_ERR(("AMFMADR3: poll failed with error no : %d", errsv));
			m_potunMain->m_potun_tclINCComm->vCloseAdr3Communication();
			m_potunMain->vSetRestartTimeValue(enSocketOrPollFailure);
			break;
		}
		if(rc == 0)
		{
			/** A value of 0 indicates that the call timed out and no file descriptors were ready */
			//ETG_TRACE_ERR(("AMFMADR3: poll Time out"));
			continue;
		}
		/** Check if the file descriptor has some data to be read */
		if((fds[0].revents & POLLIN)|| (fds[0].revents & POLLPRI))
		{
			/*receive datagram*/
			iNumberOfBytesReceived = dgram_recv(
				pdgram,\
				au8RecvBuffer,\
				sizeof(au8RecvBuffer)
				);
		/** To print the error trace if failed */

		ET_TRACE_INFO_BIN( 
		TUN_TRACE_CLASS_DRVADRIF_LOW, 
		ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_THREAD_ENTRY _ 
		ET_EN_T8 _ TUN_TRACE_ADRIF_LOW_RX_STATUS _ 
		ET_EN_T32 _ iNumberOfBytesReceived _ 
		ET_EN_DONE);
			ETG_TRACE_USR4(("File desp no=%d",pdgram->sk));
	/** in order to avoid reading, when 0 bytes are received*/
		if ((iNumberOfBytesReceived > 0) && (iNumberOfBytesReceived <= BUFFER_SIZE))
		{
			tun_DrvAdrIf::instance()->INCDataIndication(au8RecvBuffer,(tU32)iNumberOfBytesReceived);
			iNumberOfBytesReceived = 0;
			/** Set buffer to all 0 */
			memset(au8RecvBuffer,0, BUFFER_SIZE);
		
		}
		else
		{
			/*DLT_LOG_STRING(INC_SOCKET_IF,
			DLT_LOG_INFO,
			("Receiving  failed \n"));*/
				tInt errsv = errno;
				ETG_TRACE_ERR(("AMFMADR3: dgram_recv Failed with error msg : %s\n", strerror(errsv)));
				ETG_TRACE_ERR(("AMFMADR3: dgram_recv with error no:%d and number no byte: : %d", errsv,iNumberOfBytesReceived));
				m_potunMain->m_potun_tclINCComm->vCloseAdr3Communication();
				m_potunMain->vSetRestartTimeValue(enSocketOrPollFailure);
				break;

			}
		}
		else
		{
			ETG_TRACE_COMP(( "AMFMADR3:No data to be read in file descriptor\n"));
			sleep(1);
		}
	} 

}


/*******************************************************************************
* FUNCTION : vPrintTrace
*
* DESCRIPTION : printtrace
*
* PARAMETER : StreamData, datalength
*
* RETURNVALUE : tVoid
*
* Initial version: 07/03/2014: ngp1kor
*********************************************************************************/






/*******************************************************************************
* FUNCTION : bOpenADRSocket
*
* DESCRIPTION : Opens the INC socket and sets local variable to store socket fd
*
* PARAMETER : channel - channel number
*			  port  - port
*             protocol - protocol number
*
* RETURNVALUE : bool
*
* HISTORY : 16.04.2013
* Initial version
*********************************************************************************/
bool tun_INCComm::bOpenADRSocket(uint8_t u8Domain, \
	uint16_t u16Type, \
							   int iChannel) const
{
	int iLunID = (uint16_t)PORT_OFFSET | (uint16_t)iChannel;
	bool bSetupfail = true;
	/*
		Domain:		AF_BOSCH_INC_ADR
		Type:		SOCK_STREAM
		Protocol:	Set to 0, to choose the proper protocol for the give type
		*/
	m_nADRSocketFd = socket(
		u8Domain, \
		u16Type, \
		0);
	if (0 > m_nADRSocketFd)
	{
		tInt errsv = errno;
		ETG_TRACE_ERR(("AMFMADR3: socket creation failed with error:%d and return value:%d", errsv,m_nADRSocketFd));
		ETG_TRACE_ERR(("AMFMADR3: socket creation failed with error msg : %s\n", strerror(errsv)));
		bSetupfail = false;
		return bSetupfail;
	}
	/** SUZUKI-22835 : Setting time out for dgram_send  calls to 1.3 second
	As suggested by ADR team. ADR may stay in XOFF state for max */
	
	struct timeval SendTimeOut;
	SendTimeOut.tv_sec = 1;
	SendTimeOut.tv_usec = 333000;
	/*making the dgram_send return after a timeout*/
	if (setsockopt(m_nADRSocketFd, SOL_SOCKET, SO_SNDTIMEO, (char *)&SendTimeOut, sizeof SendTimeOut) < 0)
	{
		ETG_TRACE_ERR(("AMFMADR3: setsockopt Failed. Time out not set "));
	}
	 /** init datagram servive on given socket */
	dgram = dgram_init(m_nADRSocketFd, DGRAM_MAX, NULL);
	if (dgram == NULL)
	{
		tInt errsv = errno;
		ETG_TRACE_ERR(("AMFMADR3: Dgram Init failed with error: %d", errsv));
		ETG_TRACE_ERR(("AMFMADR3: Dgram Init failed with error msg : %s\n", strerror(errsv)));
		bSetupfail = false;
	}

	// Doing setup using ADDR info method
		struct addrinfo hints, *res;
		res=NULL;

		// first, load up address structs with getaddrinfo():
	memset(&hints, 0, sizeof(hints)); //to make sure the struct is empty
		hints.ai_family = AF_INET;
		hints.ai_socktype = SOCK_STREAM;

		//Port number to String
		stringstream sport;
		sport << iLunID;

		string rhostname("adr3-local");
	/*
		Node:		adr3-local
		Service:	LunID
		*/
	int ret;
	if (((ret = getaddrinfo(rhostname.c_str(), (sport.str()).c_str(), &hints, &res)) != 0))
	{
		ETG_TRACE_ERR(("AMFMADR3: getaddrinfo for ADR3-Local error: %s\n", gai_strerror(ret)));
		ETG_TRACE_ERR(("AMFMADR3: getaddrinfo for ADR3-Local error no: %d", ret));
		bSetupfail = false;
	}
	else
	{

		if(res==NULL)
		{
			bSetupfail = false;
		}
		else
		{
			ETG_TRACE_USR4((" AMFMADR3: getaddrinfo: adr3-local address %s", res->ai_addr->sa_data));
			ret = bind(m_nADRSocketFd, res->ai_addr, res->ai_addrlen);
			if (ret != 0)
			{
				tInt errsv = errno;
				ETG_TRACE_ERR(("AMFMADR3: Bind to socket failed errno:%d with return value:%d", errsv, ret));
				ETG_TRACE_ERR(("AMFMADR3: Bind to socket failed with error msg : %s\n", strerror(errsv)));
				bSetupfail = false;
			}
			freeaddrinfo(res);
		}
	}
	// Doing setup using ADDR info method
		struct addrinfo hints1, *res1;

		// first, load up address structs with getaddrinfo():
	memset(&hints1, 0, sizeof(hints1)); //to make sure the struct is empty
	res1=NULL;

		//Port number to String
		stringstream sport1;
		sport1 << iLunID;

		string rhostname1("adr3");
	/*
	Node:		adr3
	Service:	LunID
	*/
	if (((ret = getaddrinfo(rhostname1.c_str(), (sport1.str()).c_str(), &hints1, &res1)) != 0))
	{
		ETG_TRACE_ERR(("AMFMADR3: getaddrinfo for node with return value:%d ADR3 error: %s\n", ret,gai_strerror(ret)));
		ETG_TRACE_ERR(("AMFMADR3: getaddrinfo for node with return value:%d ADR3 error no: %d", ret,ret));
		bSetupfail = false;
	}
	else
	{
		if(res1==NULL)
		{
			bSetupfail = false;
		}
		else
		{
			ret = connect(m_nADRSocketFd, res1->ai_addr, res1->ai_addrlen);
			if (ret != 0)
			{
				tInt errsv = errno;
				ETG_TRACE_ERR(("AMFMADR3: Connect failed errno:%d and return value:%d", errsv, ret));
				ETG_TRACE_ERR(("AMFMADR3: Connect failed  with error msg : %s\n", strerror(errsv)));
				bSetupfail = false;
			}
			else
			{
				int on = 1;
				/*Set socket to nonblocking*/
				ret = ioctl(m_nADRSocketFd, FIONBIO, (char *)&on);
				if (ret != 0)
				{
					int errsv = errno;
					ETG_TRACE_ERR(("AMFMADR3: ioctl() failed with error:%d and return value:%d", errsv, ret));
					ETG_TRACE_ERR(("AMFMADR3: ioctl() failed with error msg : %s\n", strerror(errsv)));
					bSetupfail = false;
				}
			}
			freeaddrinfo(res1);
		}
	}

	/**If the binding or connecting to ADR3 via INC socket fails then returns false to exist the loop.*/
	if (false == bSetupfail)
	{
		m_potunMain->m_potun_tclINCComm->vCloseAdr3Communication();
	}
	else
	{
		tun_DrvAdrIf::instance()->vSetCommunicationState(enComState_WaitForStartup);
	}

	return bSetupfail;
}
#endif
tVoid tun_DrvAdrIf::vPrintTrace(tU32 u32StreamMsgLen, const tU8* pu8TxMessage , tU8 u8TraceType)
{
	   if(u32StreamMsgLen <= NO_OF_BYTES_PER_LINE)
		{
			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ u8TraceType _ 
				ET_EN_T8 _ (0xff) _ 
				ET_EN_T8LIST _ u32StreamMsgLen _ pu8TxMessage _ 
				ET_EN_DONE); 
		}
		else
		{
			tU8 u8ByteCnt = 0;
			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ u8TraceType _ 
				ET_EN_T8 _ (u8ByteCnt) _ 
				ET_EN_T8LIST _ u32StreamMsgLen _ pu8TxMessage _ 
				ET_EN_DONE);
			tU32 u32FrameBytes = u32StreamMsgLen - enAdrMsgOffset_HEADER_LEN ;
			for(; u8ByteCnt < (u32FrameBytes/NO_OF_BYTES_PER_LINE); u8ByteCnt++)
			{
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
					ET_EN_T8 _ u8TraceType _ 
					ET_EN_T8 _ (u8ByteCnt+1) _ 
					ET_EN_T8LIST _ (NO_OF_BYTES_PER_LINE) _ (pu8TxMessage+enAdrMsgOffset_HEADER_LEN+(u8ByteCnt*NO_OF_BYTES_PER_LINE)) _ 
					ET_EN_DONE);
			}
			if(u32FrameBytes % NO_OF_BYTES_PER_LINE)
				ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DRVADRIF_LOW, 
				ET_EN_T8 _ u8TraceType _ 
				ET_EN_T8 _ (u8ByteCnt+1) _ 
				ET_EN_T8LIST _ (u32FrameBytes % NO_OF_BYTES_PER_LINE) _ (pu8TxMessage+enAdrMsgOffset_HEADER_LEN+(u8ByteCnt*NO_OF_BYTES_PER_LINE)) _ 
				ET_EN_DONE);
		}
}
#if defined  (VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC) || defined (VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI) || defined (VARIANT_S_FTR_ENABLE_FEATURE_INF4CV)
tVoid tun_DrvAdrIf::vUpdateTunerDTC()
{
	m_u8ADR3ResetCounter++;
	if(TUN_DRVADRIF_CONF_ADR3_MAXRESET_COUNTER==m_u8ADR3ResetCounter)
	{
		if(NULL!=m_potun_DiaglogHandler)
		{
			m_potun_DiaglogHandler->vUpdateTunerSystemFailureErrorLog(TRUE);
			m_u8ADR3ResetCounter=0;
			m_blClearSystemFailureErrorLog=TRUE;
		}
	}
}
#endif

		
/*** END OF FILE *************************************************************/
