/************************************************************************
* FILE:         tun_service.h
* PROJECT:      g3g
* SW-COMPONENT: Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Tuner Server
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 17.10.04  | CM-DI/ESA2 Wersuhn           | initial version
* 14.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Configured as Tuner server.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUNER_SERVICE_H
#define TUNER_SERVICE_H

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "tun_Class_ForwardDecl.h"



//class tuner_tclApp;



//--------------------
// class definition
//--------------------
class tuner_tclservice : public ahl_tclBaseWork
{
private:
   tuner_tclApp*              poGWMain;
   OSAL_tSemHandle            hNotTableSem;
   ahl_tclNotificationTable*  poNotTable;  //gets NotifactionTable from parent
   template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
   

   /* +++
   Enter your private Data and functions here
   +++ */
   
   
public:
   
   /* +++
   Enter your public Data and functions here
   +++ */

   ahl_tclLock _oActivityLock;

   

   /*---------------------------------------------------------------------*/
      
   /*-- constructor --*/
   tuner_tclservice( tuner_tclApp* poMain ); 
   tuner_tclservice();//default constructor added to remove lint warning
   
   /*---------------------------------------------------------------------*/
   /*-- Destructor --*/
   virtual ~tuner_tclservice(); 

    /*---------------------------------------------------------------------*/
   
   tVoid bSendStatus( tU16 u16FID, tU8 Value )const;
   
   /*---------------------------------------------------------------------*/
   
   tVoid bSendAnswer( const amt_tclServiceData* poMessage, tU8 Value, tU8 u8Opcode )const;
   
   /*---------------------------------------------------------------------*/
   
   tBool bRelUpreg( const amt_tclServiceData* poMessage )const ;
   
   /*---------------------------------------------------------------------*/
   
   virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );
   
   /*---------------------------------------------------------------------*/
   
   tVoid vOnNewAppState( tU32 u32OldAppState, tU32 u32AppState )const;

   /*---------------------------------------------------------------------*/
   
   tVoid vSendError( tU16 u16AMTErrorCode, tU16 u16TMCErrorCode, tU16 u16FID, tU16 u16RegisterID )const ;
   
   /*---------------------------------------------------------------------*/
   
   tBool bUpreg(const amt_tclServiceData* poMessage )const ;
   
   /*---------------------------------------------------------------------*/

   /*-- Handler for HMI messages --*/

#if (OSAL_CONF == OSAL_WINNT)
   tVoid vHandleMessageFromHMI( amt_tclServiceData* poMessage );
#else
   tVoid vHandleMessageFromHMI( amt_tclServiceData* poMessage ) const;
#endif

   /*---------------------------------------------------------------------*/
   
   DECLARE_MSG_MAP( tuner_tclservice )

};

#endif //_tuner_service_h
