/************************************************************************
* FILE:         tun_main.h
* PROJECT:      g3g
* SW-COMPONENT: Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Tuner Server
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 17.10.04  | CM-DI/ESA2 Wersuhn           | initial version
* 14.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Configured as Tuner server.
*
*************************************************************************/

#ifndef _TUNER_MAIN_H_
#define _TUNER_MAIN_H_

#define TUNER_FUNCARRAY_SIZE      10
//#define TUNER_NOTARRAY_SIZE       20



/*---------------------*/
/* Includes            */
/*---------------------*/

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif


#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "tun_Class_ForwardDecl.h"

#define TUNER_NOTTABLE_SEM_NAME      "TUNER_NOTTABLESEM"

#include <exception>

/*-------------------------------*/
/* class tuner_tclApp definition */
/*-------------------------------*/
class dp_tclTunerImpl;
enum tun_tenRestartTimeValue
{
  enIntialTimerValue            = 500,
  enSocketOrPollFailure         = 200,
  enDgramSendError				=100,
  enNoError						=0
};

class clHDStationLogoManagement;

class tuner_tclApp : public ail_tclAppInterface
{
private:
   
   //ahl_tFunction            _aFuncArray[TUNER_FUNCARRAY_SIZE];     // for notification storage
   //ahl_tNotification        _aNotArray[TUNER_NOTARRAY_SIZE];       // for notification storage
   
   static tBool _bAppClosed;

   /* Variable required for incomming trace */ 
   OSAL_tIODescriptor   _fdTrace;

   tS32       m_hPWMDutyCycle;
   tS32       m_hPWMPeriod;
   
   tS32       m_hPWMSync1DutyCycle;
   tS32       m_hPWMSync1Period;
   
   tS32       m_hPWMSync3DutyCycle;
   tS32       m_hPWMSync3Period;

   tU16 m_u16TPEGRegID;
   tU16 m_u16TMRegID;
   tU16 m_u16UIRegID;
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
   tuner_gio_dbus_handler*	m_pGioDbusHandler;
#endif
   /* this function must not be used, therefore it is private */
   tuner_tclApp& operator=(const tuner_tclApp& c);
   
   /* +++
   Enter your private Data and functions here   
   +++ */ 

   tVoid vInitializeTunerComponent( );
   
   tVoid vCreateClassInstances();
   /************ Fix for Logiscope issue Start ********/
   tVoid vCreateTuningActionsClassInstances();
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   tVoid vCreateFunctionBlockInterfaceClassInstances();
   tVoid vCreateCurrentStateClassInstances();
   tVoid vCreatePresetListClassInstances();
   tVoid vCreateStationListClassInstances();
   tVoid vCreateDRMClassInstances();
   tVoid vCreateHDClassInstances();
   tVoid vCreateDiagnosisAdjustmentTestFeaturesClassInstances();
   tVoid vCreateGeneralConfigurationClassInstances();
   tVoid vHandleTunerVariableStatesOnShutdown();

#endif
   /************ Fix for Logiscope issue End ********/

   tVoid vCreateClassPointers();
   
   tVoid vCreateDiagnosisClassPointers();
   tVoid vCreateHMIClassPointers();
   
   tVoid vCreateHMIClassInstances();
   /************ Fix for Logiscope issue Start ********/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   tVoid vCreateHMICurrentStateClassInstances();
   tVoid vCreateHMIPresetListClassInstances();
   tVoid vCreateHMIStationListClassInstances();
#ifdef VARIANT_S_FTR_ENABLE_DRM
   tVoid vCreateHMIDRMClassInstances();
#endif
   tVoid vCreateHMIHDClassInstances();
   tVoid vCreateHMIDiagnosisAdjustmentTestFeaturesClassInstances();
   tVoid vCreateHMITuningActionClassInstances();
   tVoid vSetDARCClassPointers();
   tVoid vCreateHMIJapanStationNameClassInstances();
#endif
   /************ Fix for Logiscope issue End ********/

   tVoid vCreateTraceClassInstances();
   tVoid vCreateTraceClassPointers();
   tVoid vCreateDiagnosisClassInstances();
   
   tVoid vDeleteClassInstances();
   tVoid vDeleteDiagnosisClassInstances();
   tVoid vDeleteHMIClassInstances();
   
   tBool fInitializationComplete;
   static tuner_tclApp* _theServer;
   static OSAL_tpfCallback VTimeoutCallback(tVoid* pArg);
   static OSAL_tpfCallback VTimeoutCallback_ForDoNotfication_1secTimer(tVoid* pArg);
 
   tVoid vOpenPWMChannel(std::string sPeriod , std::string sDutyCycle , tU8 u8Sync_Signal = 0);
   tVoid vclosePWMChannel(tS32 s32PWMDutyCycle , tS32 s32PWMPeriod , tU8 u8Sync_Signal = 0);
   
   template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
   
protected:
    virtual tBool bGetServiceVersion( tU16 u16ServiceID,         tU16& rfu16MajorVersion, 
                                      tU16& rfu16MinorVersion,   tU16& rfu16PatchVersion );

public:

    static tVoid VSetTime_ForDoNotfication_1secTimer(tU32 u32MsTimeout );
   /* +++
   Enter your public Data and functions here
   +++ */
    
    tBool m_bTunerSrvStatus;
    
    tU32 m_u32Freq;
    
    tU16 m_u16PWMValue;
	
	tU32 m_u32Sync1Freq;
    tU16 m_u16Sync1PWMValue;
	
	tU32 m_u32Sync3Freq;
    tU16 m_u16Sync3PWMValue;
   
   tuner_tclservice*          _tuner_poCCAService;
   
   static OSAL_tSemHandle     _hNotTableSem;
   static OSAL_tTimerHandle    _hTimerHandler;

   static OSAL_tSemHandle     _hADRDataUpdateSem;

   static OSAL_tTimerHandle    m_hDoNotfication_1secTimer;

   ahl_tclNotificationTable*  _poNotTable;

   /*----------------*/
   /* Tuner Manager  */
   /*----------------*/   
   tu_Manager* m_potu_Manager;

   /*-------------------------------------*/
   /* Tuner RU message Dispatcher class   */
   /*-------------------------------------*/
   tun_MsgDispatcher* m_potun_MsgDispatcher;

   /*-------------------------------*/
   /* Class Sends Messages to RU    */
   /*-------------------------------*/
   tun_MsgToADR*      m_ptun_MsgToADR;

   /*----------------------------------------------*/
   /* Waiting thread for incomming message from RU */
   /*----------------------------------------------*/
   tun_RUIF_WaitingThread* m_ptun_RUIF_WaitingThread;
   /*-------------------------------------------------*/
   /* class handles messages comming from RU for HMI  */
   /*-------------------------------------------------*/
   tun_MsgToHMI* m_potun_MsgToHMI;

   tun_MsgFromHMI* m_potun_MsgFromHMI;
   /*-------------------------------------------------*/
   /* class handles messages coming from Radiolib for TunerMaster  */
   /*-------------------------------------------------*/
   tun_MsgToTunMaster* m_potun_MsgToTunMaster;

   /*------------------------------------------------------*/
   /* class makes decision, on Messages to be sent to HMI  */
   /*------------------------------------------------------*/
   tun_HMIManager* m_potun_HMIManager;


   /*------------------------------------*/
   /* Tuner Data is sored in this class  */
   /*------------------------------------*/
   tun_ActualData* m_potun_ActualData;

   /*------------------------------------*/
   /* Tuner utility tasks are done here  */
   /*------------------------------------*/
   tun_Utility* m_potun_Utility;

   /*--------------------------------------*/
   /* Tuner config settings are done here  */
   /*--------------------------------------*/
   tun_Config* m_potun_Config;

   clConfigMain* m_poclConfigMain;


   /*-----------------------------*/
   /* TMC manager creation        */
   /*-----------------------------*/
   tun_TMCManager* m_potun_TMCManager;
   tU32 m_enRestartTimeValue;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20

   clAars_MTCAudioSource* m_poclAars_MTCAudioSource;
   clAars_AudioSource* m_poclAars_AudioSource;

   clAars_SpecialDiagnosisMode* m_poclAars_SpecialDiagnosisMode;
   clTmcTuner_Method_S_AUDIO_FG_BG_NEW * m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW;
   clAars_DemodulationSwitch* m_poclAars_DemodulationSwitch;
   clTmcTuner_Method_SetDemodulationSwitch* m_poclTmcTuner_Method_SetDemodulationSwitch;
   clAars_ATPresetList_XX* 	m_poclAars_ATPresetList_XX;
   clTmcTuner_Method_S_GET_STATIC_LIST*	m_poclTmcTuner_Method_S_GET_STATIC_LIST;
   clAars_ATPresetListSetActive* m_poclAars_ATPresetListSetActive;
   clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
   clTmcTuner_Method_S_PRESET_HANDLING* m_poclTmcTuner_Method_S_PRESET_HANDLING;
   clAars_ATPresetSave* m_poclAars_ATPresetSave;
   clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE* m_poclTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE;
   clAars_ATPreparePresetStorage* m_poclAars_ATPreparePresetStorage;
   clTmcTuner_Property_G_GET_STATIC_LIST* m_poclTmcTuner_Property_G_GET_STATIC_LIST;
   clTmcTuner_Property_DemodulationSwitchStatus* m_poclTmcTuner_Property_DemodulationSwitchStatus;
   clTmcTuner_Property_G_HD_AUDIOPRGM* m_poclTmcTuner_Property_G_HD_AUDIOPRGM;
   clAars_ATHDAudioProgram* m_poclAars_ATHDAudioProgram;
   clTmcTuner_Property_G_HD_LONGNAME* m_poclTmcTuner_Property_G_HD_LONGNAME;
   clAars_ATHDLongName* m_poclAars_ATHDLongName;
#ifdef VARIANT_S_FTR_ENABLE_DRM
	clAars_DRMAudioStreamDecoderStatus *m_poclAars_DRMAudioStreamDecoderStatus;
   clAars_CM_DRMCurrentRadiotext* m_poclAars_CM_DRMCurrentRadiotext;
   clTmcTuner_Property_DrmRadioText* m_poclTmcTuner_Property_DrmRadioText;
	clTmcTuner_Method_DRM_TestMode *m_poclTmcTuner_Method_DRM_TestMode;
	clAars_DRMTestMode *m_poclAars_DRMTestMode;
	clTmcTuner_Property_DRM_TestMode *m_poclTmcTuner_Property_DRM_TestMode;
	clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER *m_poclTmcTuner_Method_DRM_ResetMuteCounter;
#endif
   clAars_ATHDImageFileUpdate* m_poclAars_ATHDImageFileUpdate;
   clHDStationLogoManagement* m_poclHDStationLogoManagement;
   clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE* m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE;
   clAars_HDTestMode* m_poclAars_HDTestMode;
   clTmcTuner_Property_G_HD_TEST_MODE_DATA* m_poclTmcTuner_Property_G_HD_TEST_MODE_DATA;
   clAars_CM_StationsList* m_poclAars_CM_StationsList;
   clAars_CM_StationListConfig*	m_poclAars_CM_StationListConfig;
   clTmcTuner_Method_S_GET_CONFIG_LIST*   m_poclTmcTuner_Method_S_GET_CONFIG_LIST;
   clTmcTuner_Property_G_GET_CONFIG_LIST* m_poclTmcTuner_Property_G_GET_CONFIG_LIST;
   clAars_CM_StationListRelease* m_poclAars_CM_StationListRelease;
   clTmcTuner_Method_S_STATIONLIST_EXIT* m_poclTmcTuner_Method_S_STATIONLIST_EXIT;
   clAars_CM_UpdateLandscape* m_poclAars_CM_UpdateLandscape;
   clTmcTuner_Method_S_CONFIGLIST_UPDATE* m_poclTmcTuner_Method_S_CONFIGLIST_UPDATE;
   clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS* m_poclTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS;
   clAars_CM_UpdateLandscapeProgress* m_poclAars_CM_UpdateLandscapeProgress;
   clAars_CM_Commit* m_poclAars_CM_Commit;
   clAars_SetConfigSections* m_poclAars_SetConfigSections;
   clTmcTuner_SetConfigSections* m_poclTmcTuner_SetConfigSections;
#ifdef VARIANT_S_FTR_ENABLE_DRM
   clAars_CM_ATDRM_AudioServiceDirect* m_poclAars_CM_ATDRM_AudioServiceDirect;
   clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM* m_poclTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM;
#endif
	clAars_AFBestSwitch* m_poclAars_AFBestSwitch;
	clTmcTuner_Method_S_Set_AF* m_poclTmcTuner_Method_S_Set_AF;
	clTmcTuner_Method_S_AudioMuteRequest* m_poclTmcTuner_Method_S_AudioMuteRequest;
   clTmcTuner_Property_G_Mute_Request*   m_poclTmcTuner_Property_G_Mute_Request;
   clAars_ATTunerState*                  m_poclAars_ATTunerState;
   clTmcTuner_Method_S_SEL_LIST_ELEM*    m_poclTmcTuner_Method_S_SEL_LIST_ELEM;
   clTmcTuner_Method_G_SEL_LIST_ELEM*    m_poclTmcTuner_Method_G_SEL_LIST_ELEM;
   clAars_ATPI*                       m_poclAars_ATPI;
   clTmcTuner_Method_S_SET_PI*  m_poclTmcTuner_Method_S_SET_PI;
   clTmcTuner_Property_G_SET_PI*    m_poclTmcTuner_Property_G_SET_PI;
   clAars_ATHDAudioProgramDirect* m_poclAars_ATHDAudioProgramDirect;
   clTmcTuner_Property_G_DIRECT_FREQUENCY*    m_poclTmcTuner_Property_G_DIRECT_FREQUENCY;
   
   clTmcTuner_Method_S_SEEK*   m_poclTmcTuner_Method_S_SEEK;
   clAars_ATSeek*  m_poclAars_ATSeek;
   clTmcTuner_Property_G_SEEK*  m_poclTmcTuner_Property_G_SEEK;
   clTmcTuner_Method_S_DIRECT_FREQUENCY*   m_poclTmcTuner_Method_S_DIRECT_FREQUENCY;
   clAars_ATFrequency*  m_poclAars_ATFrequency;
   clAars_CM_EvaluationParameter* m_poclAars_EvaluationParameter;
   clAars_CM_CalibrationData* m_poclclAars_CM_CalibrationData;
   clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE* m_poclTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE;
   clTmcTuner_Property_G_AUDIO_SPLIT_MODE* m_poclTmcTuner_Property_G_AUDIO_SPLIT_MODE;
   clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER* m_poclTmcTuner_Method_S_SET_HD_SECTION_PARAMETER;
   clTmcTuner_Property_G_HD_SECTION_PARAMETER* m_poclTmcTuner_Property_G_HD_SECTION_PARAMETER;
   clTmcTuner_Property_G_CALIBRATION_DATA* m_poclTmcTuner_Property_G_CALIBRATION_DATA;
   clTmcTuner_Method_S_CHANGE_LSM* m_poclTmcTuner_Method_S_CHANGE_LSM;
   clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE* m_poclTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE;

   clAars_CM_ChangeOfSurveilledStations* m_poclAars_CM_ChangeOfSurveilledStations;
   clAars_CM_ChangeLsm* m_poclAars_CM_ChangeLsm;
   clTmcTuner_Property_G_LISTUPDATE_NOTIFICATION* m_poclTmcTuner_Property_G_LISTUPDATE_NOTIFICATION;
   clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS* m_poclTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS;
   clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE* m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE;
   clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST* m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST;
   clTmcTuner_Property_G_GET_DARC_DATA* m_poclTmcTuner_Property_G_GET_DARC_DATA;
   clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID* m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID;

   clAars_CM_DARC_SetFrequency* m_poclAars_CM_DARC_SetFrequency;
   clAars_CM_DARCGetData* m_poclAars_CM_DARCGetData;
   clTmcTuner_Method_S_DISABLE_BAND* m_poclTmcTuner_Method_S_DISABLE_BAND;
   tun_tclVdClockClient* m_potun_tclVdClockClient;

   clJapanStationName* m_poclJapanStationName;
   clTmcTuner_Method_S_JAPAN_SET_AREA* m_poclTmcTuner_Method_S_JAPAN_SET_AREA;
   clTmcTuner_Property_G_JAPAN_AREA* m_poclTmcTuner_Property_G_JAPAN_AREA;
   clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME* m_poclTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME;
   clTmcTuner_Method_S_LANGUAGE_SETTING* m_poclTmcTuner_Method_S_LANGUAGE_SETTING;
   clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST* m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST;
   clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME* m_poclTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME;

   clAars_CM_SetUserOptions* m_poclAars_CM_SetUserOptions;
   clAars_CM_CopyUserContent* m_poclAars_CM_CopyUserContent;
   clTmcTuner_Method_S_USER_PROFILE_UPDATE* m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE;
   clAars_GetConfigurationInfo* m_poclAars_GetConfigurationInfo;
   clAars_CM_PresetListContentUpdate* m_poclAars_CM_PresetListContentUpdate;
   clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE* m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE;
#endif
   HandleTTFISCommands* m_poHandleTTFISCommands;
   clTmcTuner_GetConfigurationInfoStatus* m_poclTmcTuner_GetConfigurationInfoStatus;
   clAars_CM_AdditionalVersionInfo* m_poclAars_AdditionalVersionInfo;
   clTmcTuner_AdditionalVersionInfo_Update* m_poclTmcTuner_AdditionalVersionInfo_Update;
   clAars_EnhancedTestMode*           m_poclAars_EnhancedTestMode;
   
   clTmcTuner_stationLogo_map* m_poclTmcTuner_stationLogo_map;
   tun_tclSensorClient* m_potun_tclSensorClient;
   clAars_AtPiSearch* m_poclAars_AtPiSearch;
   clTmcTuner_Property_AtPiSearch* m_poclTmcTuner_Property_AtPiSearch;
   clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY;

   /*-----------------------------------------------*/
   /* Class creates thread to manage TMC messages   */
   /*-----------------------------------------------*/
   tun_DiagService*     m_potun_MsgFromDiag;

   tun_DiagManager*     m_potun_DiagManager;

   tun_DiaglogHandler*  m_potun_DiaglogHandler;
   dp_tclTunerImpl* m_podp_tclTunerImpl;

   /*--------------------------------------------------------*/
   /* Class SPM client to handle COPRO, LOW VOLTAGE states   */
   /*--------------------------------------------------------*/
   tun_tclSPMClient* m_potun_tclSPMClient;
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
   tun_INCComm* m_potun_tclINCComm;
#endif



   /*------------------------------------------------------------*/
   /* class tun_tun_tclDiagHandler -  */
   /*------------------------------------------------------------*/
   tun_tclDiagHandler* m_potun_tclDiagHandler;

   /*------------------------------------*/
   /* Class KDS config constructor      */
   /*------------------------------------*/
   //tun_KDSConfiguration* m_potun_KdsConfig;

   ahl_tclServerPortMngr* m_poPortMngr;

   /* Needed for access from static functions */
   static tuner_tclApp* _poExemplar;

   // method to create server object - called by SPM
   static tuner_tclApp* theServer();
   
   /*-------------*/
   /* constructor */
   /*-------------*/
   tuner_tclApp(); 

   /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
   tuner_tclApp(const tuner_tclApp& c);

   /*------------*/
   /* destructor */
   /*------------*/
   tU32 u32GetRestartTimeValue();
   virtual ~tuner_tclApp(); 


   
    virtual tBool bOnInit();

    /* To be used by client */
    virtual tVoid vOnServiceState( tU16 u16ServiceId,  tU16 u16ServerId, 
                                   tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId );
	virtual tVoid vOnAsyncRegisterConf( tU16 u16RegisterId,  tU16 u16ServerAppId, 
                                   tU16 u16ServiceId, tU16 u16SourceSubID );
   
    virtual tVoid vOnNewAppState( tU32 u32OldAppState, tU32 u32AppState );
   /**pmn3kor:
    * created new function to solve logiscope issues
    * Handler for Updating new app state to the clients*/
   tVoid vUpdateMessageHandler(tU32 u32OldAppState, tU32 u32AppState);
 
    virtual tVoid vOnNewMessage ( amt_tclBaseMessage* poMessage );
   
    virtual tBool bOnWatchdog( );
   
    virtual tVoid vOnApplicationClose( );
	
	virtual tVoid vOnUnregister(tU16 u16ServiceId,  tU16 u16RegisterId);
   
    /*--------------------------------------*/
    /* help function to send error messages */
    /*--------------------------------------*/
    tVoid vSendError( tU16 u16SourceID,   tU16 u16TargetID,
                      tU16 u16RegisterID, tU16 u16CmdCounter,
                      tU16 u16Sid,        tU16 u16Fid  )const;
   

    /*-------------------------*/
    /* TTfis command functions */
    /*-------------------------*/
	
	//To read project configuration
	/** Vnd4kor: Made function const to avoid lint */
   tVoid vReadProjectConfiguration( ) ;


    /*-------------------------------------*/
    /* Trigger to stop RU communication    */
    /*-------------------------------------*/
    tBool fDestroyADRComm ();

    /*-----------------------------------------*/
    /* Tuner shut down after PAUSE, OFF state. */
    /*-----------------------------------------*/
    tVoid vTunerShutDownProcess( );

    /*-------------------------------------*/
    /* Tuner activities during start up    */
    /*-------------------------------------*/
    tVoid vTunerStartUpProcess( );

    tVoid vSetPWM(tU16 u16PWMValue, tU32 u32Freq, tU8 u8Sync_Signal = 0x00);
	/**vnd4kor : to solve prio 2 warning*/
    tU32 vGetPWMFrequency(tU8 u8Sync_Signal = 0x00)const;
	/**vnd4kor : to solve prio 2 warning*/
    tU16 vGetPWMValue(tU8 u8Sync_Signal = 0x00)const;
	tBool bCheckAIVI_SBRVariant();
	tU16 u16GetRegID_UI()const;
	tU16 u16GetRegID_TM()const;
	tU16 u16GetRegID_TPEG()const;
	tVoid vSetRestartTimeValue(tU32 tenRestartTimeValue);

	/** Added to solve logiscope issue */
	tVoid vAssignRegID(tU16 u16RegisterID, tU16 u16AppID);
  
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
	tuner_gio_dbus_handler*	poDBus() {return m_pGioDbusHandler;}
#endif

}; 

#endif //_TUNER_MAIN_H_
