/************************************************************************
* FILE:         tun_hmi_fid_if.h
* PROJECT:     g3g
* SW-COMPONENT: Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Tuner Server HMI Functional IDs.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 17.03.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Tuner Functional IDs .
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#ifndef  TUN_HMI_FID_IF_H
#define  TUN_HMI_FID_IF_H



/*----------------------------------------------------------*/
/*  Service ID Tuner <-> HMI,  CCA_C_U16_SRV_TUNERCONTROL   */
/*----------------------------------------------------------*/


/*-------------------*/
/*  Function IDS     */
/*-------------------*/

#define  FID_TUN_G_TUNER_DATA                 0x41

#define  FID_TUN_S_SCAN_BAND                  0x46

#define  FID_TUN_CHANGE_BAND                  0x4e

#define  FID_TUN_G_STATION_DATA               0x51

#define  FID_TUN_G_GET_DATA_TESTMODE          0x59

#define FID_TUN_S_AFLIST_V2                   0x5c

#define FID_TUN_G_AFLIST_V2                   0x5d

#define FID_TUN_G_AFLIST_V2_ELEMENT           0x5f

#define  FID_TUN_S_SET_STATIC_LIST            0x80

#define  FID_TUN_G_STATIC_LIST_ELEMENT        0x99

#define  FID_TUN_S_ATFREQUENCY                0x30      // should be changed later

#define  FID_TUN_S_ATSEEK                     0x31      // should be changed later

#define  FID_TUN_S_SET_FEATURE                0x76

#define  FID_TUN_G_SET_FEATURE                0x77

#define  FID_TUN_S_SET_HICUT                  0x7a

#define  FID_TUN_G_SET_HICUT                  0x7b

#define  FID_TUN_S_OPERATION                  0x78

#define  FID_TUN_G_OPERATION                  0x79

#define  FID_TUN_S_STOP_ANNOUNCEMENT          0x4A

#define  FID_TUN_S_DIRECT_FREQUENCY           0x32

#define  FID_TUN_S_AUTOSTORE_STATIC_LIST      0x82

#define  FID_TUN_S_SEL_LIST_ELEM              0x86

#define  FID_TUN_S_SAVE_STATIC_LIST_ELEM      0x8A

#define  FID_TUN_S_ACT_LIST_ELEM              0x88

#define  FID_TUN_S_SET_SEEK_LEVEL             0x70

#define  FID_TUN_S_MAKE_CONFIG_LIST           0x8C

#define  FID_TUN_G_MAKE_CONFIG_LIST           0x8D

#define  FID_TUN_G_CONFIG_LIST_ELEM           0x95

#define  FID_TUN_S_UPDATE_CONFIG_LIST         0x8E

#define  FID_TUN_G_UPDATE_CONFIG_LIST         0x8F

#define  FID_TUN_S_AUDIO_FG_BG_NEW            0xF0

#define  FID_TUN_G_AUDIO_FG_BG_NEW            0xF1

#define  FID_TUN_S_SET_PI                     0x42

#define FID_TUN_G_TUNER_SEEKMODE              0xF2

#define FID_TUN_S_SET_SHARXLEVEL              0xA6

#define FID_TUN_G_SET_SHARXLEVEL              0xA7

#define  FID_TUN_S_GET_STATIC_LIST            0x96

#define  FID_TUN_G_GET_STATIC_LIST            0x97

#define  FID_TUN_G_RADIO_TEXT                 0x57

#define  FID_TUN_S_SET_RDBID                  0x9C

#define  FID_TUN_G_GET_DATA_TMC               0x53

#define  FID_TUN_G_COMPONENT_STATUS_TUNER     0x25


/*-----------------------------*/
/* Status / Responce messages  */
/*-----------------------------*/

#define TUN_RES_REQ_SUCCEED                  0x0000
#define TUN_RES_REQ_FAIL                     0x0001
#define TUN_RES_PREV_REQ_INPROCESS           0x0002

#endif /* TUN_HMI_FID_IF_H */

